# satstream_python_sdk
Satstream API

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0
- Package version: 1.0.26
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen
For more information, please visit [https://satstream.io](https://satstream.io)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import satstream_python_sdk 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import satstream_python_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import satstream_python_sdk
from satstream_python_sdk.rest import ApiException
from pprint import pprint

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.AddressesApi(satstream_python_sdk.ApiClient(configuration))
address = 'address_example' # str | Address

try:
    # Get address info
    api_response = api_instance.get_address(address)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AddressesApi->get_address: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.AddressesApi(satstream_python_sdk.ApiClient(configuration))
address = 'address_example' # str | Address
page_size = 56 # int | Number of results per page (default: 100, max: 1000) (optional)
start_height = 56 # int | Start block height (optional)
end_height = 56 # int | End block height (optional)
cursor = 'cursor_example' # str | Base64 encoded cursor for pagination (optional)

try:
    # Get address deltas
    api_response = api_instance.get_address_deltas(address, page_size=page_size, start_height=start_height, end_height=end_height, cursor=cursor)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AddressesApi->get_address_deltas: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.AddressesApi(satstream_python_sdk.ApiClient(configuration))
address = 'address_example' # str | Address
page_size = 56 # int | Number of results per page (default: 100, max: 1000) (optional)
start_height = 56 # int | Start block height (optional)
end_height = 56 # int | End block height (optional)
cursor = 'cursor_example' # str | Cursor for pagination (optional)

try:
    # Get address rune deltas
    api_response = api_instance.get_address_rune_deltas(address, page_size=page_size, start_height=start_height, end_height=end_height, cursor=cursor)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AddressesApi->get_address_rune_deltas: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.AddressesApi(satstream_python_sdk.ApiClient(configuration))
address = 'address_example' # str | Address
type = 'type_example' # str | UTXO Type (optional)

try:
    # Get UTXOs for an address
    api_response = api_instance.get_address_utxos(address, type=type)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AddressesApi->get_address_utxos: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.AddressesApi(satstream_python_sdk.ApiClient(configuration))
address = 'address_example' # str | Bitcoin address to validate

try:
    # Validate address
    api_response = api_instance.validate_address(address)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AddressesApi->validate_address: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.satstream.io/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AddressesApi* | [**get_address**](docs/AddressesApi.md#get_address) | **GET** /address/{address} | Get address info
*AddressesApi* | [**get_address_deltas**](docs/AddressesApi.md#get_address_deltas) | **GET** /address/{address}/deltas | Get address deltas
*AddressesApi* | [**get_address_rune_deltas**](docs/AddressesApi.md#get_address_rune_deltas) | **GET** /address/{address}/deltas/runes | Get address rune deltas
*AddressesApi* | [**get_address_utxos**](docs/AddressesApi.md#get_address_utxos) | **GET** /address/{address}/outputs | Get UTXOs for an address
*AddressesApi* | [**validate_address**](docs/AddressesApi.md#validate_address) | **GET** /address/{address}/validate | Validate address
*BlocksApi* | [**get_block_count**](docs/BlocksApi.md#get_block_count) | **GET** /blockcount | Get the height of the latest block
*BlocksApi* | [**get_block_decoded**](docs/BlocksApi.md#get_block_decoded) | **GET** /block/raw/{identifier}/decoded | Get block by hash or height (verbosity 2)
*BlocksApi* | [**get_block_hash_by_height**](docs/BlocksApi.md#get_block_hash_by_height) | **GET** /blockhash/{block_height} | Returns blockhash of specified block.
*BlocksApi* | [**get_block_hex**](docs/BlocksApi.md#get_block_hex) | **GET** /block/raw/{identifier}/hex | Get block by hash or height (verbosity 0)
*BlocksApi* | [**get_block_info**](docs/BlocksApi.md#get_block_info) | **GET** /block/{identifier} | Get block info by hash or height
*BlocksApi* | [**get_block_prevout**](docs/BlocksApi.md#get_block_prevout) | **GET** /block/raw/{identifier}/prevout | Get block by hash or height (verbosity 3)
*BlocksApi* | [**get_block_stats**](docs/BlocksApi.md#get_block_stats) | **POST** /block/stats | Get block stats
*BlocksApi* | [**get_block_summary**](docs/BlocksApi.md#get_block_summary) | **GET** /block/raw/{identifier}/summary | Get block by hash or height (verbosity 1)
*BlocksApi* | [**get_blockchain_info**](docs/BlocksApi.md#get_blockchain_info) | **GET** /blockchain/info | Get blockchain information
*BlocksApi* | [**get_blocks**](docs/BlocksApi.md#get_blocks) | **GET** /blocks | Returns the latest block height, last 100 block hashes, and featured inscriptions
*BlocksApi* | [**get_latest_block_height**](docs/BlocksApi.md#get_latest_block_height) | **GET** /blockheight | Returns the height of the latest block.
*BlocksApi* | [**get_latest_blockhash**](docs/BlocksApi.md#get_latest_blockhash) | **GET** /blockhash | Returns blockhash for the latest block.
*BlocksApi* | [**get_latest_blocktime**](docs/BlocksApi.md#get_latest_blocktime) | **GET** /blocktime | Get the timestamp of the latest block
*FeesApi* | [**estimate_raw_fee**](docs/FeesApi.md#estimate_raw_fee) | **POST** /fee/estimate-raw | Estimate Raw Fee
*FeesApi* | [**estimate_smart_fee**](docs/FeesApi.md#estimate_smart_fee) | **POST** /fee/estimate-smart | Estimate smart fee
*InscriptionsApi* | [**fetch_inscription_child**](docs/InscriptionsApi.md#fetch_inscription_child) | **GET** /inscription/{inscription_id}/{child_index} | Get inscription child info
*InscriptionsApi* | [**fetch_inscriptions**](docs/InscriptionsApi.md#fetch_inscriptions) | **POST** /inscriptions | Fetch multiple inscriptions
*InscriptionsApi* | [**get_block_inscriptions**](docs/InscriptionsApi.md#get_block_inscriptions) | **GET** /inscriptions/block/{block_height} | Get inscriptions in a specific block
*InscriptionsApi* | [**get_block_inscriptions_page**](docs/InscriptionsApi.md#get_block_inscriptions_page) | **GET** /inscriptions/block/{block_height}/{page} | Get paginated inscriptions in a specific block
*InscriptionsApi* | [**get_inscription**](docs/InscriptionsApi.md#get_inscription) | **GET** /inscription/{inscription_id} | Get inscription info
*InscriptionsApi* | [**get_latest_inscriptions**](docs/InscriptionsApi.md#get_latest_inscriptions) | **GET** /inscriptions | Get latest inscriptions
*InscriptionsApi* | [**get_latest_inscriptions_page**](docs/InscriptionsApi.md#get_latest_inscriptions_page) | **GET** /inscriptions/{page} | Get latest inscriptions page
*MempoolApi* | [**get_mempool_ancestors**](docs/MempoolApi.md#get_mempool_ancestors) | **POST** /mempool/ancestors | Get mempool ancestors
*MempoolApi* | [**get_mempool_descendants**](docs/MempoolApi.md#get_mempool_descendants) | **POST** /mempool/descendants | Get mempool descendants
*MempoolApi* | [**get_mempool_info**](docs/MempoolApi.md#get_mempool_info) | **GET** /mempool/info | Get mempool information
*MempoolApi* | [**get_raw_mempool**](docs/MempoolApi.md#get_raw_mempool) | **POST** /mempool/raw | Get raw mempool
*MempoolApi* | [**test_mempool_accept**](docs/MempoolApi.md#test_mempool_accept) | **POST** /mempool/test-accept | Test mempool accept
*MiningApi* | [**get_mining_info**](docs/MiningApi.md#get_mining_info) | **GET** /mining/info | Get mining information
*MiningApi* | [**get_network_hashps**](docs/MiningApi.md#get_network_hashps) | **POST** /mining/networkhashps | Get network hash per second
*NetworkApi* | [**get_chain_tx_stats**](docs/NetworkApi.md#get_chain_tx_stats) | **POST** /chain/txstats | Get chain tx stats
*NetworkApi* | [**get_difficulty**](docs/NetworkApi.md#get_difficulty) | **GET** /chain/difficulty | Get difficulty
*OutputsApi* | [**get_output_by_outpoint**](docs/OutputsApi.md#get_output_by_outpoint) | **GET** /output/{outpoint} | Get output info by outpoint
*OutputsApi* | [**get_outputs**](docs/OutputsApi.md#get_outputs) | **POST** /outputs | Get multiple outputs
*PSBTsApi* | [**analyze_psbt**](docs/PSBTsApi.md#analyze_psbt) | **POST** /psbt/analyze | Analyze PSBT
*PSBTsApi* | [**combine_psbt**](docs/PSBTsApi.md#combine_psbt) | **POST** /psbt/combine | Combine PSBTs
*PSBTsApi* | [**create_psbt**](docs/PSBTsApi.md#create_psbt) | **POST** /psbt/create | Create PSBT
*PSBTsApi* | [**decode_psbt**](docs/PSBTsApi.md#decode_psbt) | **POST** /psbt/decode | Decode PSBT
*PSBTsApi* | [**join_psbts**](docs/PSBTsApi.md#join_psbts) | **POST** /psbt/join | Join PSBTs
*RunesApi* | [**get_latest_runes**](docs/RunesApi.md#get_latest_runes) | **GET** /runes | Get latest runes
*RunesApi* | [**get_latest_runes_page**](docs/RunesApi.md#get_latest_runes_page) | **GET** /runes/{page} | Get latest runes page
*RunesApi* | [**get_rune**](docs/RunesApi.md#get_rune) | **GET** /rune/{identifier} | Get rune info
*SatoshisApi* | [**get_satoshi**](docs/SatoshisApi.md#get_satoshi) | **GET** /sat/{number} | Get satoshi info
*ScriptsApi* | [**decode_script**](docs/ScriptsApi.md#decode_script) | **POST** /script/decode | Decode Script
*StatusApi* | [**get_status**](docs/StatusApi.md#get_status) | **GET** /status | Get server status
*TransactionsApi* | [**combine_raw_transaction**](docs/TransactionsApi.md#combine_raw_transaction) | **POST** /tx/combine | Combine Raw Transactions
*TransactionsApi* | [**convert_to_psbt**](docs/TransactionsApi.md#convert_to_psbt) | **POST** /tx/convert-to-psbt | Convert Raw Transaction to PSBT
*TransactionsApi* | [**create_raw_transaction**](docs/TransactionsApi.md#create_raw_transaction) | **POST** /tx/create | Create Raw Transaction
*TransactionsApi* | [**decode_tx_inscriptions**](docs/TransactionsApi.md#decode_tx_inscriptions) | **GET** /tx/{txid}/inscriptions | Decode transaction inscriptions
*TransactionsApi* | [**get_raw_transaction**](docs/TransactionsApi.md#get_raw_transaction) | **GET** /tx/{txid}/raw/decode | Get raw transaction (verbosity 1)
*TransactionsApi* | [**get_raw_transaction_hex**](docs/TransactionsApi.md#get_raw_transaction_hex) | **GET** /tx/{txid}/hex | Get raw transaction (verbosity 0)
*TransactionsApi* | [**get_raw_transaction_prevout**](docs/TransactionsApi.md#get_raw_transaction_prevout) | **GET** /tx/{txid}/raw/prevout | Get raw transaction with prevouts (verbosity 2)
*TransactionsApi* | [**get_tx_out**](docs/TransactionsApi.md#get_tx_out) | **POST** /tx/out | Get transaction output
*TransactionsApi* | [**get_tx_out_proof**](docs/TransactionsApi.md#get_tx_out_proof) | **POST** /tx/outproof | Get transaction output proof
*TransactionsApi* | [**get_tx_out_set_info**](docs/TransactionsApi.md#get_tx_out_set_info) | **POST** /tx/out/set/info | Get transaction output set information
*TransactionsApi* | [**get_tx_spending_prevout**](docs/TransactionsApi.md#get_tx_spending_prevout) | **POST** /tx/spending-prevout | Get transaction spending prevout
*TransactionsApi* | [**send_raw_transaction**](docs/TransactionsApi.md#send_raw_transaction) | **POST** /tx/send | Send raw transaction
*TransactionsApi* | [**verify_tx_out_proof**](docs/TransactionsApi.md#verify_tx_out_proof) | **POST** /tx/outproof/verify | Verify transaction output proof

## Documentation For Models

 - [AddressResponse](docs/AddressResponse.md)
 - [AddressRuneDelta](docs/AddressRuneDelta.md)
 - [AllOfBlockVin2ScriptSig](docs/AllOfBlockVin2ScriptSig.md)
 - [AllOfBlockVin3Prevout](docs/AllOfBlockVin3Prevout.md)
 - [AllOfDecodedPSBTInputFinalScriptsig](docs/AllOfDecodedPSBTInputFinalScriptsig.md)
 - [AllOfDecodedPSBTInputNonWitnessUtxo](docs/AllOfDecodedPSBTInputNonWitnessUtxo.md)
 - [AllOfDecodedPSBTInputRedeemScript](docs/AllOfDecodedPSBTInputRedeemScript.md)
 - [AllOfDecodedPSBTInputUnknown](docs/AllOfDecodedPSBTInputUnknown.md)
 - [AllOfDecodedPSBTInputWitnessScript](docs/AllOfDecodedPSBTInputWitnessScript.md)
 - [AllOfDecodedPSBTInputWitnessUtxo](docs/AllOfDecodedPSBTInputWitnessUtxo.md)
 - [AllOfDecodedPSBTOutputRedeemScript](docs/AllOfDecodedPSBTOutputRedeemScript.md)
 - [AllOfDecodedPSBTOutputUnknown](docs/AllOfDecodedPSBTOutputUnknown.md)
 - [AllOfDecodedPSBTOutputWitnessScript](docs/AllOfDecodedPSBTOutputWitnessScript.md)
 - [AllOfDecodedPSBTTx](docs/AllOfDecodedPSBTTx.md)
 - [AllOfDecodedPSBTUnknown](docs/AllOfDecodedPSBTUnknown.md)
 - [AllOfDecodedScriptSegwit](docs/AllOfDecodedScriptSegwit.md)
 - [AllOfFeeHorizonEstimateFail](docs/AllOfFeeHorizonEstimateFail.md)
 - [AllOfFeeHorizonEstimatePass](docs/AllOfFeeHorizonEstimatePass.md)
 - [AllOfMempoolEntryFees](docs/AllOfMempoolEntryFees.md)
 - [AllOfPSBTWitnessUtxoScriptPubKey](docs/AllOfPSBTWitnessUtxoScriptPubKey.md)
 - [AllOfRawFeeEstimateLong](docs/AllOfRawFeeEstimateLong.md)
 - [AllOfRawFeeEstimateMedium](docs/AllOfRawFeeEstimateMedium.md)
 - [AllOfRawFeeEstimateShort](docs/AllOfRawFeeEstimateShort.md)
 - [AllOfRawMempoolDataSequence](docs/AllOfRawMempoolDataSequence.md)
 - [AllOfTestMempoolAcceptResultFees](docs/AllOfTestMempoolAcceptResultFees.md)
 - [AllOfTxOutScriptPubKey](docs/AllOfTxOutScriptPubKey.md)
 - [AllOfUTXOBlockInfoUnspendables](docs/AllOfUTXOBlockInfoUnspendables.md)
 - [AllOfUTXOSetInfoBlockInfo](docs/AllOfUTXOSetInfoBlockInfo.md)
 - [AnalyzePSBTRequest](docs/AnalyzePSBTRequest.md)
 - [AnalyzePSBTResponse](docs/AnalyzePSBTResponse.md)
 - [BigInt](docs/BigInt.md)
 - [Bip32Deriv](docs/Bip32Deriv.md)
 - [Block1](docs/Block1.md)
 - [Block2](docs/Block2.md)
 - [Block3](docs/Block3.md)
 - [BlockResponse](docs/BlockResponse.md)
 - [BlockStats](docs/BlockStats.md)
 - [BlockVin2](docs/BlockVin2.md)
 - [BlockVin3](docs/BlockVin3.md)
 - [BlockchainInfo](docs/BlockchainInfo.md)
 - [BlocksResponse](docs/BlocksResponse.md)
 - [BtcTx2](docs/BtcTx2.md)
 - [BtcTx3](docs/BtcTx3.md)
 - [ChainTxStats](docs/ChainTxStats.md)
 - [CombinePSBTRequest](docs/CombinePSBTRequest.md)
 - [CombinePSBTResponse](docs/CombinePSBTResponse.md)
 - [CombineRawTransactionResponse](docs/CombineRawTransactionResponse.md)
 - [ConvertToPSBTResponse](docs/ConvertToPSBTResponse.md)
 - [CreatePSBTInput](docs/CreatePSBTInput.md)
 - [CreatePSBTRequest](docs/CreatePSBTRequest.md)
 - [CreatePSBTResponse](docs/CreatePSBTResponse.md)
 - [CreateRawTransactionResponse](docs/CreateRawTransactionResponse.md)
 - [DecodePSBTRequest](docs/DecodePSBTRequest.md)
 - [DecodePSBTResponse](docs/DecodePSBTResponse.md)
 - [DecodeResponse](docs/DecodeResponse.md)
 - [DecodeScriptRequest](docs/DecodeScriptRequest.md)
 - [DecodeScriptResponse](docs/DecodeScriptResponse.md)
 - [DecodeTransactionResponse](docs/DecodeTransactionResponse.md)
 - [DecodedInscription](docs/DecodedInscription.md)
 - [DecodedPSBT](docs/DecodedPSBT.md)
 - [DecodedPSBTInput](docs/DecodedPSBTInput.md)
 - [DecodedPSBTOutput](docs/DecodedPSBTOutput.md)
 - [DecodedScript](docs/DecodedScript.md)
 - [EstimateRawFeeRequest](docs/EstimateRawFeeRequest.md)
 - [EstimateRawFeeResponse](docs/EstimateRawFeeResponse.md)
 - [EstimateSmartFeeRequest](docs/EstimateSmartFeeRequest.md)
 - [EstimateSmartFeeResponse](docs/EstimateSmartFeeResponse.md)
 - [FeeHorizonEstimate](docs/FeeHorizonEstimate.md)
 - [FeeRange](docs/FeeRange.md)
 - [FetchInscriptionsResponse](docs/FetchInscriptionsResponse.md)
 - [GetAddressDeltasResponse](docs/GetAddressDeltasResponse.md)
 - [GetAddressResponse](docs/GetAddressResponse.md)
 - [GetAddressRuneDeltasResponse](docs/GetAddressRuneDeltasResponse.md)
 - [GetAddressUTXOsResponse](docs/GetAddressUTXOsResponse.md)
 - [GetBlockCountResponse](docs/GetBlockCountResponse.md)
 - [GetBlockDecodedResponse](docs/GetBlockDecodedResponse.md)
 - [GetBlockHashByHeightResponse](docs/GetBlockHashByHeightResponse.md)
 - [GetBlockHexResponse](docs/GetBlockHexResponse.md)
 - [GetBlockInscriptionsResponse](docs/GetBlockInscriptionsResponse.md)
 - [GetBlockPrevoutResponse](docs/GetBlockPrevoutResponse.md)
 - [GetBlockResponse](docs/GetBlockResponse.md)
 - [GetBlockStatsRequest](docs/GetBlockStatsRequest.md)
 - [GetBlockStatsResponse](docs/GetBlockStatsResponse.md)
 - [GetBlockSummaryResponse](docs/GetBlockSummaryResponse.md)
 - [GetBlockchainInfoResponse](docs/GetBlockchainInfoResponse.md)
 - [GetBlocksResponse](docs/GetBlocksResponse.md)
 - [GetChainTxStatsRequest](docs/GetChainTxStatsRequest.md)
 - [GetChainTxStatsResponse](docs/GetChainTxStatsResponse.md)
 - [GetDifficultyResponse](docs/GetDifficultyResponse.md)
 - [GetInscriptionChildResponse](docs/GetInscriptionChildResponse.md)
 - [GetInscriptionResponse](docs/GetInscriptionResponse.md)
 - [GetLatestBlockHashResponse](docs/GetLatestBlockHashResponse.md)
 - [GetLatestBlockHeightResponse](docs/GetLatestBlockHeightResponse.md)
 - [GetLatestBlockTimeResponse](docs/GetLatestBlockTimeResponse.md)
 - [GetLatestInscriptionsResponse](docs/GetLatestInscriptionsResponse.md)
 - [GetLatestRunesResponse](docs/GetLatestRunesResponse.md)
 - [GetMempoolAncestorsRequest](docs/GetMempoolAncestorsRequest.md)
 - [GetMempoolAncestorsResponse](docs/GetMempoolAncestorsResponse.md)
 - [GetMempoolDescendantsRequest](docs/GetMempoolDescendantsRequest.md)
 - [GetMempoolDescendantsResponse](docs/GetMempoolDescendantsResponse.md)
 - [GetMempoolInfoResponse](docs/GetMempoolInfoResponse.md)
 - [GetMiningInfoResponse](docs/GetMiningInfoResponse.md)
 - [GetNetworkHashPSRequest](docs/GetNetworkHashPSRequest.md)
 - [GetNetworkHashPSResponse](docs/GetNetworkHashPSResponse.md)
 - [GetRawMempoolRequest](docs/GetRawMempoolRequest.md)
 - [GetRawMempoolResponse](docs/GetRawMempoolResponse.md)
 - [GetRawTransactionDecodeResponse](docs/GetRawTransactionDecodeResponse.md)
 - [GetRawTransactionHexResponse](docs/GetRawTransactionHexResponse.md)
 - [GetRawTransactionPrevoutResponse](docs/GetRawTransactionPrevoutResponse.md)
 - [GetRuneResponse](docs/GetRuneResponse.md)
 - [GetSatoshiResponse](docs/GetSatoshiResponse.md)
 - [GetStatusResponse](docs/GetStatusResponse.md)
 - [GetTxOutProofResponse](docs/GetTxOutProofResponse.md)
 - [GetTxOutResponse](docs/GetTxOutResponse.md)
 - [GetTxSpendingPrevoutResponse](docs/GetTxSpendingPrevoutResponse.md)
 - [GithubComSatstreamSsUtilsDatabaseAddressDelta](docs/GithubComSatstreamSsUtilsDatabaseAddressDelta.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesRuneDetails](docs/GithubComSatstreamSsUtilsOrdServerResponsesRuneDetails.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesRuneListEntry](docs/GithubComSatstreamSsUtilsOrdServerResponsesRuneListEntry.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesRunesListResponse](docs/GithubComSatstreamSsUtilsOrdServerResponsesRunesListResponse.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [Input](docs/Input.md)
 - [InscriptionData](docs/InscriptionData.md)
 - [InscriptionResponse](docs/InscriptionResponse.md)
 - [JoinPSBTsRequest](docs/JoinPSBTsRequest.md)
 - [JoinPSBTsResponse](docs/JoinPSBTsResponse.md)
 - [LatestInscriptionsResponse](docs/LatestInscriptionsResponse.md)
 - [MempoolAncestorsData](docs/MempoolAncestorsData.md)
 - [MempoolDescendantsData](docs/MempoolDescendantsData.md)
 - [MempoolEntry](docs/MempoolEntry.md)
 - [MempoolFees](docs/MempoolFees.md)
 - [MempoolInfo](docs/MempoolInfo.md)
 - [MempoolSequence](docs/MempoolSequence.md)
 - [MiningInfo](docs/MiningInfo.md)
 - [Output](docs/Output.md)
 - [OutputResponse](docs/OutputResponse.md)
 - [PSBTAnalysis](docs/PSBTAnalysis.md)
 - [PSBTBip32Deriv](docs/PSBTBip32Deriv.md)
 - [PSBTInputAnalysis](docs/PSBTInputAnalysis.md)
 - [PSBTMissingData](docs/PSBTMissingData.md)
 - [PSBTWitnessUtxo](docs/PSBTWitnessUtxo.md)
 - [PrevOut](docs/PrevOut.md)
 - [RawFeeEstimate](docs/RawFeeEstimate.md)
 - [RawMempoolData](docs/RawMempoolData.md)
 - [RawTx1](docs/RawTx1.md)
 - [RawTx2](docs/RawTx2.md)
 - [RuneResponse](docs/RuneResponse.md)
 - [RuneTerms](docs/RuneTerms.md)
 - [RunesBalance](docs/RunesBalance.md)
 - [RunestoneData](docs/RunestoneData.md)
 - [SatoshiResponse](docs/SatoshiResponse.md)
 - [Script](docs/Script.md)
 - [ScriptPubKey](docs/ScriptPubKey.md)
 - [ScriptSig](docs/ScriptSig.md)
 - [SegwitDetails](docs/SegwitDetails.md)
 - [SendRawTransactionResponse](docs/SendRawTransactionResponse.md)
 - [SmartFeeEstimate](docs/SmartFeeEstimate.md)
 - [StatusResponse](docs/StatusResponse.md)
 - [TestMempoolAcceptRequest](docs/TestMempoolAcceptRequest.md)
 - [TestMempoolAcceptResponse](docs/TestMempoolAcceptResponse.md)
 - [TestMempoolAcceptResult](docs/TestMempoolAcceptResult.md)
 - [TestMempoolFees](docs/TestMempoolFees.md)
 - [Transaction](docs/Transaction.md)
 - [TransactionCombineRawTransactionRequest](docs/TransactionCombineRawTransactionRequest.md)
 - [TransactionConvertToPSBTRequest](docs/TransactionConvertToPSBTRequest.md)
 - [TransactionCreateRawTxInput](docs/TransactionCreateRawTxInput.md)
 - [TransactionCreateRawTxRequest](docs/TransactionCreateRawTxRequest.md)
 - [TransactionGetTxOutProofRequest](docs/TransactionGetTxOutProofRequest.md)
 - [TransactionGetTxOutRequest](docs/TransactionGetTxOutRequest.md)
 - [TransactionGetTxOutSetInfoRequest](docs/TransactionGetTxOutSetInfoRequest.md)
 - [TransactionGetTxSpendingPrevoutRequest](docs/TransactionGetTxSpendingPrevoutRequest.md)
 - [TransactionSendRawTransactionRequest](docs/TransactionSendRawTransactionRequest.md)
 - [TransactionVerifyTxOutProofRequest](docs/TransactionVerifyTxOutProofRequest.md)
 - [TxOut](docs/TxOut.md)
 - [TxSpendingPrevoutInput](docs/TxSpendingPrevoutInput.md)
 - [TxSpendingPrevoutResult](docs/TxSpendingPrevoutResult.md)
 - [TxVin1](docs/TxVin1.md)
 - [TxVin2](docs/TxVin2.md)
 - [UTXOBlockInfo](docs/UTXOBlockInfo.md)
 - [UTXOSetInfo](docs/UTXOSetInfo.md)
 - [UTXOUnspendables](docs/UTXOUnspendables.md)
 - [UnknownFields](docs/UnknownFields.md)
 - [UtilsResponseEnvelope](docs/UtilsResponseEnvelope.md)
 - [ValidateAddressResponse](docs/ValidateAddressResponse.md)
 - [ValidateAddressResult](docs/ValidateAddressResult.md)
 - [VerifyTxOutProofResponse](docs/VerifyTxOutProofResponse.md)
 - [Vout](docs/Vout.md)

## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: X-API-KEY
- **Location**: HTTP header


## Author

team@satstream.io
