# coding: utf-8

"""
    Satstream API

    Satstream API  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: team@satstream.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from satstream_python_sdk.api_client import ApiClient


class MempoolApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_address_mempool_transactions(self, address, **kwargs):  # noqa: E501
        """Get address mempool transactions  # noqa: E501

        Get all mempool transactions for a specific address  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_address_mempool_transactions(address, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address: Bitcoin address (required)
        :return: ResponsesGetAddressMempoolTxs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_address_mempool_transactions_with_http_info(address, **kwargs)  # noqa: E501
        else:
            (data) = self.get_address_mempool_transactions_with_http_info(address, **kwargs)  # noqa: E501
            return data

    def get_address_mempool_transactions_with_http_info(self, address, **kwargs):  # noqa: E501
        """Get address mempool transactions  # noqa: E501

        Get all mempool transactions for a specific address  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_address_mempool_transactions_with_http_info(address, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address: Bitcoin address (required)
        :return: ResponsesGetAddressMempoolTxs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_address_mempool_transactions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address' is set
        if ('address' not in params or
                params['address'] is None):
            raise ValueError("Missing the required parameter `address` when calling `get_address_mempool_transactions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address' in params:
            path_params['address'] = params['address']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mempool/addresses/{address}/transactions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetAddressMempoolTxs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mempool_transaction_info(self, txid, **kwargs):  # noqa: E501
        """Get mempool transaction info  # noqa: E501

        Get information about a specific transaction in the mempool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mempool_transaction_info(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: ResponsesGetMempoolTxInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mempool_transaction_info_with_http_info(txid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_mempool_transaction_info_with_http_info(txid, **kwargs)  # noqa: E501
            return data

    def get_mempool_transaction_info_with_http_info(self, txid, **kwargs):  # noqa: E501
        """Get mempool transaction info  # noqa: E501

        Get information about a specific transaction in the mempool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mempool_transaction_info_with_http_info(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: ResponsesGetMempoolTxInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['txid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mempool_transaction_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'txid' is set
        if ('txid' not in params or
                params['txid'] is None):
            raise ValueError("Missing the required parameter `txid` when calling `get_mempool_transaction_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'txid' in params:
            path_params['txid'] = params['txid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mempool/transactions/{txid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetMempoolTxInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mempool_transactions(self, **kwargs):  # noqa: E501
        """Get mempool transactions  # noqa: E501

        Get all transactions currently in the mempool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mempool_transactions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ResponsesGetMempoolTransactions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mempool_transactions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_mempool_transactions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_mempool_transactions_with_http_info(self, **kwargs):  # noqa: E501
        """Get mempool transactions  # noqa: E501

        Get all transactions currently in the mempool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mempool_transactions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ResponsesGetMempoolTransactions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mempool_transactions" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/mempool/transactions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetMempoolTransactions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
