from hashlib import sha256
from typing import List, Union, Optional
from dataclasses import dataclass, field
from itertools import chain, starmap
from enum import Enum

class ContextType(Enum):
	ACCELERATION = "ACCELERATION"
	ACCELERATION_ELECTRIC = "ACCELERATION_ELECTRIC"
	ACCESSORIES = "ACCESSORIES"
	AIRBAGS = "AIRBAGS"
	AUDIO = "AUDIO"
	AUDIO_EQUIPMENT = "AUDIO_EQUIPMENT"
	AUDIO_SYSTEMS = "AUDIO_SYSTEMS"
	BATTERY_NOMINAL_ENERGY = "BATTERY_NOMINAL_ENERGY"
	BATTERY_USABLE_ENERGY = "BATTERY_USABLE_ENERGY"
	BRAKING_DISTANCE = "BRAKING_DISTANCE"
	BICYCLE_HOLDERS = "BICYCLE_HOLDERS"
	BODY = "BODY"
	BODY_HOLDERS = "BODY_HOLDERS"
	CARGO_CAPACITY = "CARGO_CAPACITY"
	CHARGING = "CHARGING"
	CHARGING_EQUIPMENT = "CHARGING_EQUIPMENT",
	CHASSIS_AND_STEERING = "CHASSIS_AND_STEERING",
	CHARGING_DURATION_10A = "CHARGING_DURATION_10A"
	CHARGING_DURATION_16A = "CHARGING_DURATION_16A"
	CHARGING_DURATION_2_PHASE_10A = "CHARGING_DURATION_2_PHASE_10A"
	CHARGING_DURATION_2_PHASE_16A = "CHARGING_DURATION_2_PHASE_16A"
	CHARGING_DURATION_2_PHASE_6A = "CHARGING_DURATION_2_PHASE_6A"
	CHARGING_DURATION_32A = "CHARGING_DURATION_32A"
	CHARGING_DURATION_3_PHASE_10A = "CHARGING_DURATION_3_PHASE_10A"
	CHARGING_DURATION_3_PHASE_16A = "CHARGING_DURATION_3_PHASE_16A"
	CHARGING_DURATION_3_PHASE_6A = "CHARGING_DURATION_3_PHASE_6A"
	CHARGING_DURATION_3_PHASE_8A = "CHARGING_DURATION_3_PHASE_8A"
	CHARGING_DURATION_6A = "CHARGING_DURATION_6A"
	CHARGING_DURATION_8A = "CHARGING_DURATION_8A"
	CHARGING_DURATION_DC_150KW = "CHARGING_DURATION_DC_150KW"
	CHARGING_DURATION_DC_200KW = "CHARGING_DURATION_DC_200KW"
	CHARGING_DURATION_DC_250KW = "CHARGING_DURATION_DC_250KW"
	CHARGING_DURATION_DC_50KW = "CHARGING_DURATION_DC_50KW"
	CO2_EMISSION = "CO2_EMISSION"
	CO2_EMISSION_SECONDARY = "CO2_EMISSION_SECONDARY"
	CYLINDERS = "CYLINDERS"
	DESCRIPTION = "DESCRIPTION"
	DISPLAY_NAME = "DISPLAY_NAME"
	ENGINE = "ENGINE"
	ENGINES = "ENGINES"
	ELECTRIC_RANGE = "ELECTRIC_RANGE"
	ENERGY_EFFICIENCY_CLASS = "ENERGY_EFFICIENCY_CLASS"
	ENGINE_BORE = "ENGINE_BORE"
	ENGINE_CODE = "ENGINE_CODE"
	ENGINE_DISPLACEMENT = "ENGINE_DISPLACEMENT"
	ENGINE_NAME = "ENGINE_NAME"
	ENGINE_STROKE = "ENGINE_STROKE"
	ENGINE_TYPE_DESCRIPTION = "ENGINE_TYPE_DESCRIPTION"
	ENVIRONMENTAL_CLASSIFICATION = "ENVIRONMENTAL_CLASSIFICATION"
	EXTERIOR_STYLING = "EXTERIOR_STYLING"
	EXTERIOR_COLOURS = "EXTERIOR_COLOURS"
	FEATURES_AND_EQUIPMENT = "FEATURES_AND_EQUIPMENT"
	FEATURES_OPTIONS = "FEATURES_OPTIONS"
	FRONT_CARGO_CAPACITY = "FRONT_CARGO_CAPACITY"
	FUEL_CAPACITY = "FUEL_CAPACITY"
	FUEL_CONSUMPTION_CITY = "FUEL_CONSUMPTION_CITY"
	FUEL_CONSUMPTION_CITY_SECONDARY = "FUEL_CONSUMPTION_CITY_SECONDARY"
	FUEL_CONSUMPTION_HIGHWAY = "FUEL_CONSUMPTION_HIGHWAY"
	FUEL_CONSUMPTION_HIGHWAY_SECONDARY = "FUEL_CONSUMPTION_HIGHWAY_SECONDARY"
	FUEL_CONSUMPTION_MIXED = "FUEL_CONSUMPTION_MIXED"
	FUEL_CONSUMPTION_MIXED_SECONDARY = "FUEL_CONSUMPTION_MIXED_SECONDARY"
	FUEL_TYPE = "FUEL_TYPE"
	GEARBOX = "GEARBOX"
	HEAD_ROOM_FRONT = "HEAD_ROOM_FRONT"
	HEAD_ROOM_REAR = "HEAD_ROOM_REAR"
	HEAD_ROOM_THIRD_ROW = "HEAD_ROOM_THIRD_ROW"
	HEIGHT = "HEIGHT"
	HIGHLIGHTED_ITEMS = "HIGHLIGHTED_ITEMS"
	HIP_ROOM_FRONT = "HIP_ROOM_FRONT"
	HIP_ROOM_REAR = "HIP_ROOM_REAR"
	HIP_ROOM_THIRD_ROW = "HIP_ROOM_THIRD_ROW"
	HORSEPOWER_AMOUNT_ELECTRIC = "HORSEPOWER_AMOUNT_ELECTRIC"
	HORSEPOWER_AMOUNT_ELECTRIC_PLUS_FUEL = "HORSEPOWER_AMOUNT_ELECTRIC_PLUS_FUEL"
	HORSEPOWER_AMOUNT_FUEL = "HORSEPOWER_AMOUNT_FUEL"
	HORSEPOWER_REV_MAX_ELECTRIC = "HORSEPOWER_REV_MAX_ELECTRIC"
	HORSEPOWER_REV_MAX_ELECTRIC_PLUS_FUEL = "HORSEPOWER_REV_MAX_ELECTRIC_PLUS_FUEL"
	HORSEPOWER_REV_MAX_FUEL = "HORSEPOWER_REV_MAX_FUEL"
	HORSEPOWER_REV_MIN_ELECTRIC = "HORSEPOWER_REV_MIN_ELECTRIC"
	HORSEPOWER_REV_MIN_FUEL = "HORSEPOWER_REV_MIN_FUEL"
	INTERNAL_ITEMS = "INTERNAL_ITEMS"
	INTERIOR_STYLING = "INTERIOR_STYLING"
	KILOWATTS_ELECTRIC = "KILOWATTS_ELECTRIC"
	KILOWATTS_ELECTRIC_PLUS_FUEL = "KILOWATTS_ELECTRIC_PLUS_FUEL"
	KILOWATTS_FUEL = "KILOWATTS_FUEL"
	LEG_ROOM_FRONT = "LEG_ROOM_FRONT"
	LEG_ROOM_REAR = "LEG_ROOM_REAR"
	LEG_ROOM_THIRD_ROW = "LEG_ROOM_THIRD_ROW"
	LENGTH = "LENGTH"
	MAX_SPEED = "MAX_SPEED"
	MAX_SPEED_ELECTRIC = "MAX_SPEED_ELECTRIC"
	MODEL = "MODEL"
	MSRP = "MSRP"
	NAME = "NAME"
	NOX_EMISSION = "NOX_EMISSION"
	NOX_EMISSION_SECONDARY = "NOX_EMISSION_SECONDARY"
	PACKAGES = "PACKAGES"
	PERFORMANCE = "PERFORMANCE"
	POWERTRAIN_TYPE = "POWERTRAIN_TYPE"
	PROCESSED_DESCRIPTION = "PROCESSED_DESCRIPTION"
	PROCESSED_SHORT_DESCRIPTION = "PROCESSED_SHORT_DESCRIPTION"
	PROCESSED_DISPLAY_NAME = "PROCESSED_DISPLAY_NAME"
	ROOF_WEIGHT = "ROOF_WEIGHT"
	SEAT_CAPACITY = "SEAT_CAPACITY"
	SERVING_WEIGHT = "SERVING_WEIGHT"
	SHORT_DESCRIPTION = "SHORT_DESCRIPTION"
	SHORT_DISPLAY_NAME = "SHORT_DISPLAY_NAME"
	SHOULDER_ROOM_FRONT = "SHOULDER_ROOM_FRONT"
	SHOULDER_ROOM_REAR = "SHOULDER_ROOM_REAR"
	SHOULDER_ROOM_THIRD_ROW = "SHOULDER_ROOM_THIRD_ROW"
	SOFT_LEATHER_UPHOLSTERIES="SOFT_LEATHER_UPHOLSTERIES",
	SOFT_OFFERS="SOFT_OFFERS",
	SPORT_EQUIPMENT_HOLDERS="SPORT_EQUIPMENT_HOLDERS",
	STEERING_WHEELS="STEERING_WHEELS",
	STORAGE="STORAGE",
	STYLING = "STYLING"
	TECH_DATA = "TECH_DATA"
	TEXTILE_LEATHER_UPHOLSTERY = "TEXTILE_LEATHER_UPHOLSTERY"
	TORQUE_AMOUNT_ELECTRIC = "TORQUE_AMOUNT_ELECTRIC"
	TORQUE_AMOUNT_ELECTRIC_PLUS_FUEL = "TORQUE_AMOUNT_ELECTRIC_PLUS_FUEL"
	TORQUE_AMOUNT_FUEL = "TORQUE_AMOUNT_FUEL"
	TORQUE_REV_MAX_ELECTRIC = "TORQUE_REV_MAX_ELECTRIC"
	TORQUE_REV_MAX_ELECTRIC_PLUS_FUEL = "TORQUE_REV_MAX_ELECTRIC_PLUS_FUEL"
	TORQUE_REV_MAX_FUEL = "TORQUE_REV_MAX_FUEL"
	TORQUE_REV_MIN_ELECTRIC = "TORQUE_REV_MIN_ELECTRIC"
	TORQUE_REV_MIN_ELECTRIC_PLUS_FUEL = "TORQUE_REV_MIN_ELECTRIC_PLUS_FUEL"
	TORQUE_REV_MIN_FUEL = "TORQUE_REV_MIN_FUEL"
	TOTAL_MSRP = "TOTAL_MSRP"
	TOTAL_WEIGHT = "TOTAL_WEIGHT"
	TOTAL_WEIGHT_WITH_TRANSMISSION = "TOTAL_WEIGHT_WITH_TRANSMISSION"
	TOWING_CAPACITY = "TOWING_CAPACITY"
	TRACK_FRONT = "TRACK_FRONT"
	TRACK_REAR = "TRACK_REAR"
	TRANSMISSION_CODE = "TRANSMISSION_CODE"
	TRANSMISSION_DISPLAY_NAME = "TRANSMISSION_DISPLAY_NAME"
	TRANSMISSION_MSRP_ADJUSTMENT = "TRANSMISSION_MSRP_ADJUSTMENT"
	TRANSMISSION_TYPE = "TRANSMISSION_TYPE"
	TRANSMISSION_WEIGHT_ADJUSTMENT = "TRANSMISSION_WEIGHT_ADJUSTMENT"
	TURNING_CIRCLE = "TURNING_CIRCLE"
	WHEEL_BASE = "WHEEL_BASE"
	WIDTH = "WIDTH"
	WIDTH_MIRRORS = "WIDTH_MIRRORS"
	WLTP_ELECTRIC_ENERGY_CONSUMPTION_COMBINED_MAX = "WLTP_ELECTRIC_ENERGY_CONSUMPTION_COMBINED_MAX"
	WLTP_ELECTRIC_ENERGY_CONSUMPTION_COMBINED_MIN = "WLTP_ELECTRIC_ENERGY_CONSUMPTION_COMBINED_MIN"
	WLTP_ELECTRIC_RANGE_CITY_MAX = "WLTP_ELECTRIC_RANGE_CITY_MAX"
	WLTP_ELECTRIC_RANGE_CITY_MIN = "WLTP_ELECTRIC_RANGE_CITY_MIN"
	WLTP_ELECTRIC_RANGE_COMBINED_MAX = "WLTP_ELECTRIC_RANGE_COMBINED_MAX"
	WLTP_ELECTRIC_RANGE_COMBINED_MIN = "WLTP_ELECTRIC_RANGE_COMBINED_MIN"
	WLTP_EMISSIONS_COMBINED_MAX = "WLTP_EMISSIONS_COMBINED_MAX"
	WLTP_EMISSIONS_COMBINED_MIN = "WLTP_EMISSIONS_COMBINED_MIN"
	WLTP_EMISSIONS_EXTRA_HIGH_MAX = "WLTP_EMISSIONS_EXTRA_HIGH_MAX"
	WLTP_EMISSIONS_EXTRA_HIGH_MIN = "WLTP_EMISSIONS_EXTRA_HIGH_MIN"
	WLTP_EMISSIONS_HIGH_MAX = "WLTP_EMISSIONS_HIGH_MAX"
	WLTP_EMISSIONS_HIGH_MIN = "WLTP_EMISSIONS_HIGH_MIN"
	WLTP_EMISSIONS_LOW_MAX = "WLTP_EMISSIONS_LOW_MAX"
	WLTP_EMISSIONS_LOW_MIN = "WLTP_EMISSIONS_LOW_MIN"
	WLTP_EMISSIONS_MEDIUM_MAX = "WLTP_EMISSIONS_MEDIUM_MAX"
	WLTP_EMISSIONS_MEDIUM_MIN = "WLTP_EMISSIONS_MEDIUM_MIN"
	WLTP_FUEL_CONSUMPTION_COMBINED_MAX = "WLTP_FUEL_CONSUMPTION_COMBINED_MAX"
	WLTP_FUEL_CONSUMPTION_COMBINED_MIN = "WLTP_FUEL_CONSUMPTION_COMBINED_MIN"
	WLTP_FUEL_CONSUMPTION_EXTRA_HIGH_MAX = "WLTP_FUEL_CONSUMPTION_EXTRA_HIGH_MAX"
	WLTP_FUEL_CONSUMPTION_EXTRA_HIGH_MIN = "WLTP_FUEL_CONSUMPTION_EXTRA_HIGH_MIN"
	WLTP_FUEL_CONSUMPTION_HIGH_MAX = "WLTP_FUEL_CONSUMPTION_HIGH_MAX"
	WLTP_FUEL_CONSUMPTION_HIGH_MIN = "WLTP_FUEL_CONSUMPTION_HIGH_MIN"
	WLTP_FUEL_CONSUMPTION_LOW_MAX = "WLTP_FUEL_CONSUMPTION_LOW_MAX"
	WLTP_FUEL_CONSUMPTION_LOW_MIN = "WLTP_FUEL_CONSUMPTION_LOW_MIN"
	WLTP_FUEL_CONSUMPTION_MEDIUM_MAX = "WLTP_FUEL_CONSUMPTION_MEDIUM_MAX"
	WLTP_FUEL_CONSUMPTION_MEDIUM_MIN = "WLTP_FUEL_CONSUMPTION_MEDIUM_MIN"
	WLTP_SERVING_WEIGHT_MAX = "WLTP_SERVING_WEIGHT_MAX"
	WLTP_SERVING_WEIGHT_MIN = "WLTP_SERVING_WEIGHT_MIN"
	WLTP_TOTAL_WEIGHT_MAX = "WLTP_TOTAL_WEIGHT_MAX"
	WLTP_TOTAL_WEIGHT_MIN = "WLTP_TOTAL_WEIGHT_MIN"


@dataclass(frozen=True, eq=True)
class BitVal:
    context:    List[str]
    value:      Union[str, float]
    reason: 	List[str] = field(default_factory=list)
        
    def __hash__(self):
        return hash(self.as_string())
    
    def __eq__(self, other) -> bool:
        return self.__hash__() == other.__hash__()
    
    def sha256(self) -> str:
        return sha256(self.as_string().encode('utf8')).hexdigest()
    
    def as_string(self) -> str:
        return "".join(self.context)+str(self.value)

    @staticmethod
    def from_dict(d: dict) -> "BitVal":
        return BitVal(
            context=d["context"],
            value=d["value"],
        )

    def to_dict(self) -> dict:
        return {
            "context": self.context,
            "value": self.value,
        }

    def to_string(self, join_on: str = " ", simple: bool = False) -> str:
        ctx_str = " ".join(
			map(
				lambda ctx: " ".join(ctx.lower().split("_")), 
				self.context,
			)
		)
        return f"{ctx_str}{join_on}{self.value}" if not simple else f"{self.value}"

class ContextRelation(Enum):
    ALL = "ALL"
    ANY = "ANY"

@dataclass
class SubContextFilter:

    contexts: List[ContextType]
    relation: ContextRelation
    _not: bool = field(default=False)

    def validate(self, values: List[str]) -> bool:
        if self.relation == ContextRelation.ALL:
            res = all(
                map(
                    lambda context: context.value in values,
                    self.contexts,
                )
            )
        else:
            res = any(
                map(
                    lambda context: context.value in values,
                    self.contexts,
                )
            )

        return bool((self._not * 1) - (res * 1))

    def to_dict(self) -> dict:
        return {
            "contexts": [context.value for context in self.contexts],
            "relation": self.relation.value,
            "Not": self._not,
        }

@dataclass
class ContextFilter:

    relation: ContextRelation
    subContextFilters: List[SubContextFilter]
    _not: bool = field(default=False)

    @staticmethod
    def empty() -> "ContextFilter":
        return ContextFilter(
            _not=False,
            relation=ContextRelation.ALL,
            subContextFilters=[],
        )

    def validate(self, values: List[str]) -> bool:
        if not self.subContextFilters:
            return True

        if self.relation == ContextRelation.ALL:
            res = all(
                map(
                    lambda sub: sub.validate(values),
                    self.subContextFilters,
                )
            )
        else:
            res = any(
                map(
                    lambda sub: sub.validate(values),
                    self.subContextFilters,
                )
            )

        return bool((self._not * 1) - (res * 1))

    def to_dict(self) -> dict:
        return {
            "relation": self.relation.value,
            "subContextFilters": [sub.to_dict() for sub in self.subContextFilters],
            "Not": self._not,
        }