"""Plot the electric field generated by three point charges in a plane."""

import numpy as np
import pylab as plt

from scikits import vectorplot as vp

dpi = 100
size = 700
video = False

# Charges : (q, x, y)
charges=[(10,+0.5,+0.5),(-10,-0.5,-0.5),(4,+0.2,-0.2)]

xs = np.linspace(-1,1,size).astype(np.float32)[None,:]
ys = np.linspace(-1,1,size).astype(np.float32)[:,None]

u = np.zeros((size,size),dtype=np.float32)
v = np.zeros((size,size),dtype=np.float32)

for (q,x,y) in charges:
    rsq = ((xs-x)**2+(ys-y)**2)**1.5
    v +=  -q * (ys-y)/rsq
    u +=  -q * (xs-x)/rsq
    
texture = np.random.rand(size,size).astype(np.float32)

plt.bone()
frame=0

if video:
    kernellen = 62
    for t in np.linspace(0,1,16*10):
        kernel = np.sin(np.arange(kernellen)*np.pi/kernellen)*(1+np.sin(2*np.pi*5*(np.arange(kernellen)/float(kernellen)+t)))

        kernel = kernel.astype(np.float32)

        image = vp.line_integral_convolution(u, v, texture, kernel)

        plt.clf()
        plt.axis('off')
        plt.figimage(image)
        plt.gcf().set_size_inches((size/float(dpi),size/float(dpi)))
        plt.savefig("efield-%04d.png"%frame,dpi=dpi)
        frame += 1
else:
    kernellen=31
    kernel = np.sin(np.arange(kernellen)*np.pi/kernellen)
    kernel = kernel.astype(np.float32)

    image = vp.line_integral_convolution(u, v, texture, kernel)

    plt.clf()
    plt.axis('off')
    plt.figimage(image)
    plt.gcf().set_size_inches((size/float(dpi),size/float(dpi)))
    plt.savefig("efield-image.png",dpi=dpi)


