Makefiles
=========

Here is an exmaple makefile for a directory organized in this way::

    .
    ├── data
    │   ├── hal000.ncsa.illinois.edu-NUMAUM_Prefetch_GPUToHost-0-0.json
    │   ├── hal000.ncsa.illinois.edu-NUMAUM_Prefetch_GPUToHost-0-2.json
    │   ├── hal000.ncsa.illinois.edu-NUMAUM_Prefetch_HostToGPU-0-0.json
    │   └── hal000.ncsa.illinois.edu-NUMAUM_Prefetch_HostToGPU-0-2.json
    ├── deps
    │   └── ac922_prefetch_cpu-gpu.d
    ├── generated
    ├── Makefile
    └── specs
        └── ac922_prefetch_cpu-gpu.yml

The `data` directory contains Google Benchmark data files.
The `deps` directory will contain dependence files generated by ScopePlot
The `spec` directory contains specs to describe each generated figure
The `generated` directory will contain one generated figure for each spec files

```makefile
# Don't generated deps for these targets
NODEPS:=clean

# These are the spec files that describe the figures
SOURCES:=$(shell find specs/ -name "*.yml")

#These are the dependency files, which make will clean up after it creates them
DEPFILES:=$(patsubst specs/%.yml,deps/%.d,$(SOURCES))

# These are the figures generated
FIGURES:=$(patsubst specs/%.yml,generated/%.pdf,$(SOURCES))

ifeq (0, $(words $(findstring $(MAKECMDGOALS), $(NODEPS))))
    #Chances are, these files don't exist.  GMake will create them and
    #clean up automatically afterwards
    -include $(DEPFILES)
endif

TARGETS=$(FIGURES)

$(info SOURCES:  $(SOURCES))
$(info DEPFILES: $(DEPFILES))
$(info FIGURES:  $(FIGURES))
$(info TARGETS:  $(TARGETS))

MICROBENCH_ARGS= -I data

# Since all may not be the first target (because of included deps)
.DEFAULT_GOAL := all
all: $(TARGETS)

# This is the rule for creating the dependency files
deps/%.d: specs/%.yml
    python -m microbench_plot $(MICROBENCH_ARGS) -s $^ -t '$(patsubst specs/%.yml,generated/%.pdf,$^)' -o $@ --deps

# This is the rule for creating the figure
generated/%.pdf : specs/%.yml deps/%.d
    python -m microbench_plot $(MICROBENCH_ARGS) -s $< -o $@

clean:
    rm -f $(TARGETS) $(DEPFILES)
```