// Scripted Forms -- Making GUIs easy for everyone on your team.
// Copyright (C) 2017 Simon Biggs

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published
// by the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version (the "AGPL-3.0+").

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Affero General Public License and the additional terms for more
// details.

// You should have received a copy of the GNU Affero General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

// ADDITIONAL TERMS are also included as allowed by Section 7 of the GNU
// Affrero General Public License. These aditional terms are Sections 1, 5,
// 6, 7, 8, and 9 from the Apache License, Version 2.0 (the "Apache-2.0")
// where all references to the definition "License" are instead defined to
// mean the AGPL-3.0+.

// You should have received a copy of the Apache-2.0 along with this
// program. If not, see <http://www.apache.org/licenses/LICENSE-2.0>.

/*
Creates the [start] section.

A section that runs all code within it whenever a kernel is connected to a new
session.

Eventually this section should be set to also rerun if the code within it
differs from the previous iteration. That way a kernel restart would not be
required if new code is added into the [start] section.
*/


import {
  Component, ContentChildren, QueryList, Input
} from '@angular/core';

import { CodeComponent } from '../code-module/code.component';
// import { LiveComponent } from '../sections-module/live.component';
// import { ButtonComponent } from '../sections-module/button.component';

@Component({
  selector: 'section-start',
  template: `<ng-content></ng-content>`
// <div align="right" *ngIf="(!hasStartRun)">
//   <button
//   mat-mini-fab
//   (click)="runCode()">
//     <mat-icon>autorenew</mat-icon>
//   </button>
// </div>`
})
export class StartComponent {
  // liveComponents: QueryList<LiveComponent>;
  // buttonComponents: QueryList<ButtonComponent>;
  @Input() always?: string;

  startId: number;
  hasStartRun = false;

  @ContentChildren(CodeComponent) codeComponents: QueryList<CodeComponent>;

  // provideSections(liveComponents: QueryList<LiveComponent>, buttonComponents: QueryList<ButtonComponent>) {
  //   this.liveComponents = liveComponents;
  //   this.buttonComponents = buttonComponents;
  // }

  set sessionId(theSessionId: string) {
    this.initialiseCodeSessionId(theSessionId);
  }

  runCode() {
    this.codeComponents.toArray().forEach(codeComponent => {
      codeComponent.runCode();
    });
    this.hasStartRun = true;
  }

  setId(id: number) {
    this.startId = id;
    this.codeComponents.toArray().forEach((codeComponent, index) => {
      codeComponent.name = '"start"_' + String(this.startId) + '_' + String(index);
    });
  }

  initialiseCodeSessionId(sessionId: string) {
    this.codeComponents.toArray().forEach((codeComponent, index) => {
      codeComponent.sessionId = sessionId;
    });
  }
}
