#!/usr/bin/env python
#
# setup.py
# Package "selectionfunctiontoolbox" for pip.
#
# Copyright (C) 2021  Douglas Boubert & Andrew Everall
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

import pathlib
from setuptools import setup, find_packages

HERE = pathlib.Path(__file__).parent

VERSION = '1.0.0'
PACKAGE_NAME = 'selectionfunctiontoolbox'
AUTHOR = 'Douglas Boubert & Andrew Everall'
AUTHOR_EMAIL = 'ask@gaiaverse.space'
URL = 'https://github.com/gaiaverse/selectionfunctiontoolbox'

LICENSE = 'GPLv2'
DESCRIPTION = 'A set of tools for estimating the selection function of a scientific sample drawn from an astronomical catalogue.'
LONG_DESCRIPTION = (HERE / "README.md").read_text()
LONG_DESC_TYPE = "text/markdown"

INSTALL_REQUIRES = [
        'numpy',
        'scipy',
        'astropy',
        'h5py',
        'healpy',
]

setup(name=PACKAGE_NAME,
      version=VERSION,
      description=DESCRIPTION,
      long_description=LONG_DESCRIPTION,
      long_description_content_type=LONG_DESC_TYPE,
      author=AUTHOR,
      license=LICENSE,
      author_email=AUTHOR_EMAIL,
      url=URL,
      download_url = 'https://github.com/gaiaverse/selectionfunctiontoolbox/archive/v1.0.0.tar.gz',
      install_requires=INSTALL_REQUIRES,
      packages=find_packages()
      )