### Задача 4
Ты работаешь в компании, занимающейся электронной коммерцией, и она сталкивается с проблемой ручного создания чеков для покупателей. Каждый раз, когда покупатель делает заказ, менеджер компании вручную составляет отчёт по каждому заказу, что тратит время и приводит к ошибкам.

Решение этой задачи заключается в автоматизации процесса генерации чеков. Потребуется создать Python-пакет, который автоматически будет генерировать чек на основе информации о заказе и сохранять его в текстовом файле.

**Функциональность пакета**

Напиши пакет, который:

- Принимает данные о заказе в виде JSON-файла со следующей структурой:
```json
{
  'customer_name': 'Иван Иванов',
  'items': [
    {'name': 'Телефон', 'quantity': 1, 'price': 20000},
    {'name': 'Наушники', 'quantity': 2, 'price': 1500}
  ]
}
```
- Создаёт текстовый файл с чеком, который содержит:
  - имя клиента,
  - список товаров (название товара, количество, цена за единицу),
  - общую сумма заказа.
- Поддерживает запуск через командную строку с опциями:
  - `--input-file` для указания входного файла `.json`,
  - `--output-file` для указания выходного файла `.txt`.

Используй следующие имена переменных:
- `customer_name` — имя клиента,
- `items` — список товаров, где каждый товар содержит:
  - `name` — название товара,
  - `quantity` — количество единиц товара,
  - `price` — цена за единицу товара.

**Сборка пакета и публикация**

Когда код написан и проверен, подготовь его к публикации.

- Используй `Egg` для сборки пакета. Для этого нужно создать файл `setup.py`, в котором будут указаны все метаданные и параметры сборки проекта.

- Собери пакет и опубликуй его на PyPI с помощью соответствующих утилит.

**Проверка работоспособности**

Установи пакет с PyPI в другой проект и проверь его работоспособность.


