# coding: utf-8

"""
    SensorPush Public API

    This is a swagger definition for the SensorPush public REST API. Download the definition file [here](https://api.sensorpush.com/api/v1/support/swagger/swagger-v1.json).

    The version of the OpenAPI document: v1.0.20240803
    Contact: support@sensorpush.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional

try:
    from pydantic.v1 import BaseModel, Field, StrictStr
except ImportError:
    from pydantic import BaseModel, Field, StrictStr

class TokenRequest(BaseModel):
    """
    Request object for an oAuth accesstoken code.  # noqa: E501
    """
    client_id: Optional[StrictStr] = Field(default=None, description="Client Id assigned to 3rd party applications. Contact support@sensorpush.com to register you app.")
    client_secret: Optional[StrictStr] = Field(default=None, description="Password associated with the client_id")
    code: Optional[StrictStr] = Field(default=None, description="This can be an authorization, access, or refresh token. Depending on which grant_type you are using.")
    grant_type: Optional[StrictStr] = Field(default=None, description="Accepted values are password, refresh_token, and access_token")
    password: Optional[StrictStr] = Field(default=None, description="User's password")
    redirect_uri: Optional[StrictStr] = Field(default=None, description="Redirection url to the 3rd party application once the user has signed into the sensorpush logon. This value should be URL encoded.")
    refresh_token: Optional[StrictStr] = Field(default=None, description="Refresh token used to request new access tokens.")
    username: Optional[StrictStr] = Field(default=None, description="Email of the user to sign in.")
    __properties = ["client_id", "client_secret", "code", "grant_type", "password", "redirect_uri", "refresh_token", "username"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TokenRequest:
        """Create an instance of TokenRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TokenRequest:
        """Create an instance of TokenRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TokenRequest.parse_obj(obj)

        _obj = TokenRequest.parse_obj({
            "client_id": obj.get("client_id"),
            "client_secret": obj.get("client_secret"),
            "code": obj.get("code"),
            "grant_type": obj.get("grant_type"),
            "password": obj.get("password"),
            "redirect_uri": obj.get("redirect_uri"),
            "refresh_token": obj.get("refresh_token"),
            "username": obj.get("username")
        })
        return _obj


