# coding: utf-8

"""
    SensorPush Public API

    This is a swagger definition for the SensorPush public REST API. Download the definition file [here](https://api.sensorpush.com/api/v1/support/swagger/swagger-v1.json).

    The version of the OpenAPI document: v1.0.20240803
    Contact: support@sensorpush.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional

try:
    from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
except ImportError:
    from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist

class SamplesRequest(BaseModel):
    """
    Request object for samples.  # noqa: E501
    """
    active: Optional[StrictBool] = Field(default=None, description="Filters sensors by active = (true|false). Defaults to true.")
    bulk: Optional[StrictBool] = Field(default=None, description="Queries that return large results are truncated (see comments on Samples endpoint). Set this flag to true for large reports. The report request will be queued and processed within 24 hours. Upon completion, the primary account holder will recieve an email with a link for download.")
    format: Optional[StrictStr] = Field(default=None, description="Returns the results as the specified format (csv|json). Defaults to json")
    limit: Optional[StrictInt] = Field(default=None, description="Number of samples to return.")
    measures: Optional[conlist(StrictStr)] = Field(default=None, description="Specifies which measures to include (\"temperature\"|\"humidity\"|\"vpd\"|\"barometric_pressure\"|\"dewpoint\"). Note some measures are not available on older devices.")
    sensors: Optional[conlist(StrictStr)] = Field(default=None, description="Filters samples by sensor id. This will be the same id returned in the sensors api call. The parameter value must be a list of strings. Example: sensors: [\"123.56789\"].")
    start_time: Optional[StrictStr] = Field(default=None, alias="startTime", description="Start time to find samples (example: 2019-04-07T00:00:00-0400). Leave blank or zero to get the most recent samples.")
    stop_time: Optional[StrictStr] = Field(default=None, alias="stopTime", description="Stop time to find samples (example: 2019-04-07T10:30:00-0400). Leave blank or zero to get the most recent samples.")
    tags: Optional[conlist(StrictStr)] = Field(default=None, description="Filters samples by associated tags.")
    __properties = ["active", "bulk", "format", "limit", "measures", "sensors", "startTime", "stopTime", "tags"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SamplesRequest:
        """Create an instance of SamplesRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SamplesRequest:
        """Create an instance of SamplesRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SamplesRequest.parse_obj(obj)

        _obj = SamplesRequest.parse_obj({
            "active": obj.get("active"),
            "bulk": obj.get("bulk"),
            "format": obj.get("format"),
            "limit": obj.get("limit"),
            "measures": obj.get("measures"),
            "sensors": obj.get("sensors"),
            "start_time": obj.get("startTime"),
            "stop_time": obj.get("stopTime"),
            "tags": obj.get("tags")
        })
        return _obj


