# Sentinel Analytics Realm - Python SDK

Thin Python client for tracking events in the Sentinel Analytics Realm.

## Installation

### From PyPI (Public Channel)

```bash
pip install sentinel-analytics-realm-python
```

### From Source (Local Development)

```bash
git clone https://github.com/savant-realms/sentinel-analytics-realm-python.git
cd sentinel-analytics-realm-python
pip install -e .
```

## Usage

```python
from sdk.sdk import SentinelAnalyticsRealmPlugin

# Initialize the plugin
sentinelAnalyticsRealm = SentinelAnalyticsRealmPlugin(
    project_id="YOUR_PROJECT_ID",
    app_id="YOUR_APP_ID",
    ingest_token="YOUR_INGEST_TOKEN"
)

# Track an event
sentinelAnalyticsRealm.track("page_view", visitor_id="v_123")

# Identity linking
sentinelAnalyticsRealm.identify(user_id="u_456", visitor_id="v_123", traits={"email": "user@example.com"})

# Batch tracking
sentinelAnalyticsRealm.track_batch([
    {"name": "click", "visitor_id": "v_123", "properties": {"button": "buy"}},
    {"name": "hover", "visitor_id": "v_123"}
])
```

## Configuration fallback

The SDK will automatically attempt to read configuration from environment variables if not provided in the constructor:

- `SENTINEL_ANALYTICS_REALM_PROJECT_ID`
- `SENTINEL_ANALYTICS_REALM_APP_ID`
- `SENTINEL_ANALYTICS_REALM_ENV`
- `SENTINEL_ANALYTICS_REALM_INGEST_TOKEN`
- `SENTINEL_ANALYTICS_REALM_URL` (Defaults to `https://api.sentinelanalyticsrealm.com`)

## Local release (maintainers)

- Prepare `.env` at repo root with at least:
  - `PYPI_TOKEN=pypi-...` (Upload scope)
  - Optional GitLab upload:
    - `GITLAB_PROJECT_ID=...`
    - `GITLAB_USERNAME=...`
    - `GITLAB_TOKEN=...` (PAT with api scope or Deploy Token)
- Run:
  - `scripts/deploy.sh` to build, validate, and upload.
  - `DRY_RUN=true scripts/deploy.sh` to build + check only.
