# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src/python'}

packages = \
['serenity_sdk',
 'serenity_sdk.api',
 'serenity_sdk.client',
 'serenity_sdk.renderers',
 'serenity_sdk.renderers.asset_search',
 'serenity_sdk.renderers.derivatives',
 'serenity_sdk.renderers.risk_measures',
 'serenity_sdk.renderers.shared',
 'serenity_sdk.types']

package_data = \
{'': ['*']}

install_requires = \
['azure-identity>=1.10.0,<2.0.0',
 'bidict>=0.22.0,<0.23.0',
 'fire>=0.4.0,<0.5.0',
 'humps>=0.2.2,<0.3.0',
 'pandas>=1.4.2,<2.0.0',
 'plotly>=5.11.0,<6.0.0',
 'poetry-bumpversion==0.3.0',
 'pydantic>=1.9.1,<2.0.0',
 'requests>=2.18.4,<3.0.0',
 'scipy>=1.7.3,<2.0.0',
 'seaborn>=0.11.2,<0.12.0',
 'typing-extensions==4.5.0']

setup_kwargs = {
    'name': 'serenity.sdk.python',
    'version': '0.8.44',
    'description': 'Python SDK for the Serenity digital asset risk API',
    'long_description': "## Serenity SDK - Python\n\n### Introduction\n\nThe Serenity digital asset risk platform exposes all functionality via an API -- currently REST only.\n\nAlthough it's possible to call the API with simple HTTP client code in most any modern language, there are conventions that need to be followed -- especially for authentication and authorization -- and to make it easier we have provided this lightweight SDK.\n\n### Installation\n\nInstallation for Python 3.x users is very simple using pip:\n\n```plain\npip install serenity.sdk.python\n```\n\nIf you have already installed the SDK and want to upgrade to latest:\n\n```plain\npip install -U serenity.sdk.python\n```\n\n### API documentation\n\nThe latest API documentation is always available at [ReadTheDocs](https://serenitysdkpython.readthedocs.io/en/stable/).\n\n### Maintainer setup\n\nIf you are checking in code for ```serenity.sdk.python``` you may wish to run ```setup.sh``` to install appropriate pre-commit and pre-push git hooks in your local repo. Once you run setup you will also get a Python virtual environment in ```.venv``` generated by Poetry; if using VSCode, you should select this as your IDE's virtual environment.\n\n### Learning more\n\nIf you want to learn more about the Serenity digital asset risk platform, book a demo or get in touch, you can reach out to us at [https://cloudwall.tech](https://cloudwall.tech).",
    'author': 'Cloudwall Support',
    'author_email': 'support@cloudwall.tech',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4',
}


setup(**setup_kwargs)
