# Sharedcloud-cli

Sharedcloud CLI is a client to interact with Sharedcloud.
 
It allows both to schedule functions and to rent out computers to other users without the need
to change your home network. For a more detailed insight please go [here](https://sharedcloud.io)

### 1. Installation

`pip install -U sharedcloud-cli`

### 2. Sharedcloud CLI documentation

You can find it [here](https://docs.sharedcloud.io/sharedcloud-cli)!

### 3. Commands

* cli
    * [version](https://docs.sharedcloud.io/sharedcloud-cli/version)
* auth
    * [login](https://docs.sharedcloud.io/sharedcloud-cli/login)
    * [logout](https://docs.sharedcloud.io/sharedcloud-cli/logout)
* account
    * [create](https://docs.sharedcloud.io/sharedcloud-cli/create-account)
    * [update](https://docs.sharedcloud.io/sharedcloud-cli/update-account)
    * [change password](https://docs.sharedcloud.io/sharedcloud-cli/change-password)
    * [delete](https://docs.sharedcloud.io/sharedcloud-cli/delete-account)
    * [list](https://docs.sharedcloud.io/sharedcloud-cli/list-account)
* function
    * [create](https://docs.sharedcloud.io/sharedcloud-cli/create-function)
    * [update](https://docs.sharedcloud.io/sharedcloud-cli/update-function)
    * [delete](https://docs.sharedcloud.io/sharedcloud-cli/delete-function)
    * [list](https://docs.sharedcloud.io/sharedcloud-cli/list-functions)
    * [show code](https://docs.sharedcloud.io/sharedcloud-cli/show-function-code)
* run
    * [create](https://docs.sharedcloud.io/sharedcloud-cli/create-run)
    * [delete](https://docs.sharedcloud.io/sharedcloud-cli/delete-run)
    * [list](https://docs.sharedcloud.io/sharedcloud-cli/list-runs)
* image
    * [download](https://docs.sharedcloud.io/sharedcloud-cli/download-image)
    * [clean](https://docs.sharedcloud.io/sharedcloud-cli/clean-image)
    * [update all](https://docs.sharedcloud.io/sharedcloud-cli/update-all-images)
* instance
    * [create](https://docs.sharedcloud.io/sharedcloud-cli/create-instance)
    * [update](https://docs.sharedcloud.io/sharedcloud-cli/update-instance)
    * [delete](https://docs.sharedcloud.io/sharedcloud-cli/delete-instance)
    * [list](https://docs.sharedcloud.io/sharedcloud-cli/list-instances)
* job
    * [list](https://docs.sharedcloud.io/sharedcloud-cli/list-jobs)
    * [show stdout](https://docs.sharedcloud.io/sharedcloud-cli/show-job-stdout)
    * [show stderr](https://docs.sharedcloud.io/sharedcloud-cli/show-job-stderr)
    * [show result](https://docs.sharedcloud.io/sharedcloud-cli/show-job-result)
    * [show logs](https://docs.sharedcloud.io/sharedcloud-cli/show-job-logs)
* offer
    * [list](https://docs.sharedcloud.io/sharedcloud-cli/list-offers)
* gpu
    * [list](https://docs.sharedcloud.io/sharedcloud-cli/list-gpus)

### 2. Reporting issues

Sharedcloud has probably many issues and bugs, a great way to contribute to the project is to send a detailed report when you encounter an issue. We always appreciate a well-written, thorough bug report, and will thank you for it!

Sometimes Sharedcloud is missing a feature you need, and we encourage our users to create and contribute such features.

Check the current issues if doesn't already include that problem or suggestion before submitting an issue. If you find a match, add a quick "+1", Doing this helps prioritize the most common problems and requests.

When reporting issues, please include your host OS (Ubuntu 14.04, CentOS 7, etc), and the version of the libraries you are using.

Please also include the steps required to reproduce the problem if possible and applicable. This information will help us review and fix your issue faster.


### 3. Questions

If you need help with how to use this library, please check the list of examples, if it is still unclear you can also open an issue.
