
# Contributing to Shimoku API Python

Thank you for considering contributing to Shimoku API Python! This project is open to contributions from anyone interested in helping to improve it.

## How to contribute

The following are some ways in which you can contribute to the project:

1. Report bugs: If you find any bugs or issues in the code, please open an issue in the GitHub repository.

2. Suggest features: If you have any ideas for new features or improvements, please open an issue in the GitHub repository.

3. Write code: If you have experience with Python and would like to contribute to the codebase, please open a pull request.

## Pull Request Guidelines

Before submitting a pull request, please make sure to follow these guidelines:

1. Fork the repository: Please make a fork of the repository and make your changes in a separate branch.

2. Write tests: Please write tests to cover your changes and ensure that they pass.

3. Follow the coding style: Please make sure that your code adheres to the coding style used in the repository.

4. Update the documentation: Please update the documentation to reflect any changes you have made.

5. Squash your commits: Please squash your commits into a single commit before submitting the pull request.


## Code of Conduct

All contributors are expected to follow the [Code of Conduct](https://github.com/shimoku-tech/shimoku-api-python/blob/master/CODE_OF_CONDUCT.md) when contributing to the project.

## License

By contributing to the Shimoku API Python repository, you agree to license your contributions under the [MIT License](https://github.com/shimoku-tech/shimoku-api-python/blob/master/LICENSE.txt).
