""""""
from os import getenv
from typing import Dict, List
from time import perf_counter
import unittest
import requests

import datetime as dt
import pandas as pd
import numpy as np
import random
from copy import deepcopy

from utils import initiate_shimoku

s = initiate_shimoku()
s.reuse_data_sets()
workspace_id: str = getenv('BUSINESS_ID')

s.set_workspace(uuid=workspace_id)
# for menu_path in s.workspaces.get_workspace_menu_paths(uuid=workspace_id):
#     s.menu_paths.delete_all_menu_path_activities(uuid=menu_path['id'])
# s.workspaces.delete_all_workspace_menu_paths(uuid=workspace_id)
# s.workspaces.delete_all_workspace_boards(uuid=workspace_id)
# s.disable_caching()

delete_paths: bool = False

noise_data = pd.DataFrame({
    'x': range(100),
    'y': [
        0.62, 0.66, 0.66, 0.63, 0.61, 0.62, 0.61, 0.49, 0.4, 0.46, 0.62, 0.76, 0.72, 0.58, 0.52, 0.62, 0.78, 0.89,
        0.84, 0.71, 0.62, 0.58, 0.54, 0.56, 0.6, 0.62, 0.63, 0.63, 0.61, 0.61, 0.62, 0.65, 0.67, 0.66, 0.64, 0.62,
        0.63, 0.69, 0.73, 0.7, 0.62, 0.54, 0.5, 0.54, 0.6, 0.62, 0.66, 0.77, 0.84, 0.77, 0.62, 0.49, 0.48, 0.57,
        0.66, 0.62, 0.56, 0.55, 0.6, 0.64, 0.62, 0.56, 0.43, 0.37, 0.47, 0.62, 0.78, 0.86, 0.8, 0.68, 0.62, 0.63,
        0.68, 0.73, 0.7, 0.62, 0.57, 0.61, 0.7, 0.71, 0.62, 0.54, 0.57, 0.67, 0.71, 0.62, 0.49, 0.37, 0.38, 0.5,
        0.62, 0.75, 0.89, 0.91, 0.78, 0.62, 0.46, 0.3, 0.29, 0.45
    ]
})

horizontal_bar_data = [
    {'name': 'Financiado', 'value': 1321},
    {'name': 'Product name 2', 'value': 1400},
    {'name': 'Product name 3', 'value': 1499},
    {'name': 'Policy tenure', 'value': 1550},
    {'name': 'Family size', 'value': 1663},
    {'name': 'Acquisitive power', 'value': 1995},
    {'name': 'Geo', 'value': 2712},
    {'name': 'Modelo', 'value': 3521},
    {'name': 'Año', 'value': 4643},
    {'name': 'Offer', 'value': 5426}
]

data = [
    {'date': dt.date(2021, 1, 1), 'x': 5, 'y': 5},
    {'date': dt.date(2021, 1, 2), 'x': 6, 'y': 5},
    {'date': dt.date(2021, 1, 3), 'x': 4, 'y': 5},
    {'date': dt.date(2021, 1, 4), 'x': 7, 'y': 5},
    {'date': dt.date(2021, 1, 5), 'x': 3, 'y': 5},
]

zero_centered_data = [
    {'Name': 'a', 'y': 5, 'z': -3, 'a': 0.01},
    {'Name': 'b', 'y': -7, 'z': 4, 'a': 0.1},
    {'Name': 'c', 'y': 3, 'z': -5, 'a': 0.1},
    {'Name': 'd', 'y': -5, 'z': 6, 'a': 0.01},
]

heatmap_data = [
    {
        "xAxis": "Lunes",
        "yAxis": "12 a.m",
        "value": 9
    },
    {
        "xAxis": "Lunes",
        "yAxis": "6 p.m",
        "value": 10
    },
    {
        "xAxis": "Lunes",
        "yAxis": "12 p.m",
        "value": 9
    },
    {
        "xAxis": "Lunes",
        "yAxis": "6 a.m",
        "value": 10
    },
    {
        "xAxis": "Martes",
        "yAxis": "12 a.m",
        "value": 9
    },
    {
        "xAxis": "Martes",
        "yAxis": "6 p.m",
        "value": 9
    },
    {
        "xAxis": "Martes",
        "yAxis": "12 p.m",
        "value": 8
    },
    {
        "xAxis": "Martes",
        "yAxis": "6 a.m",
        "value": 0
    },
    {
        "xAxis": "Miercoles",
        "yAxis": "12 a.m",
        "value": 2
    },
    {
        "xAxis": "Miercoles",
        "yAxis": "6 p.m",
        "value": 7
    },
    {
        "xAxis": "Miercoles",
        "yAxis": "12 p.m",
        "value": 0
    },
    {
        "xAxis": "Miercoles",
        "yAxis": "6 a.m",
        "value": 2
    },
    {
        "xAxis": "Jueves",
        "yAxis": "12 a.m",
        "value": 4
    },
    {
        "xAxis": "Jueves",
        "yAxis": "6 p.m",
        "value": 0
    },
    {
        "xAxis": "Jueves",
        "yAxis": "12 p.m",
        "value": 1
    },
    {
        "xAxis": "Jueves",
        "yAxis": "6 a.m",
        "value": 6
    }
]

funnel_data = [
    {
        "value": 60,
        "name": "Third"
    },
    {
        "value": 40,
        "name": "Fourth"
    },
    {
        "value": 20,
        "name": "Fifth"
    },
    {
        "value": 80,
        "name": "Second"
    },
    {
        "value": 100,
        "name": "First"
    }
]

table_data = [
    {'date': dt.date(2021, 1, 1), 'x': 5, 'y': 5, 'filtA': 'A', 'filtB': 'Z', 'name': 'Ana'},
    {'date': dt.date(2021, 1, 2), 'x': 6, 'y': 5, 'filtA': 'B', 'filtB': 'Z', 'name': 'Laura'},
    {'date': dt.date(2021, 1, 3), 'x': 4, 'y': 5, 'filtA': 'A', 'filtB': 'W', 'name': 'Audrey'},
    {'date': dt.date(2021, 1, 4), 'x': 7, 'y': 5, 'filtA': 'B', 'filtB': 'W', 'name': 'Jose'},
    {'date': dt.date(2021, 1, 5), 'x': 3, 'y': 5, 'filtA': 'A', 'filtB': 'Z', 'name': 'Jorge'},
]

input_form_data = {
    'fields': [
        {
            'title': 'Personal information',
            'fields': [
                {
                    'mapping': 'name',
                    'fieldName': 'name',
                    'inputType': 'text',
                },
                {
                    'mapping': 'surname',
                    'fieldName': 'surname',
                    'inputType': 'text',
                },
                {
                    'mapping': 'age',
                    'fieldName': 'age',
                    'inputType': 'number',
                },
                {
                    'mapping': 'tel',
                    'fieldName': 'phone',
                    'inputType': 'tel',
                },
                {
                    'mapping': 'gender',
                    'fieldName': 'Gender',
                    'inputType': 'radio',
                    'options': ['Male', 'Female', 'No-binary', 'Undefined'],
                },
                {
                    'mapping': 'email',
                    'fieldName': 'email',
                    'inputType': 'email',
                },

            ],
        },
        {
            'title': 'Other data',
            'fields': [
                {
                    'mapping': 'skills',
                    'fieldName': 'Skills',
                    'options': ['Backend', 'Frontend', 'UX/UI', 'Api Builder', 'DevOps'],
                    'inputType': 'checkbox',
                },
                {
                    'mapping': 'birthDay',
                    'fieldName': 'Birthday',
                    'inputType': 'date',
                },
                {
                    'mapping': 'onCompany',
                    'fieldName': 'time on Shimoku',
                    'inputType': 'dateRange',
                },
                {
                    'mapping': 'hobbies',
                    'fieldName': 'Hobbies',
                    'inputType': 'select',
                    'options': ['Make Strong Api', 'Sailing to Canarias', 'Send Abracitos'],
                },
                {
                    'mapping': 'textField2',
                    'fieldName': 'Test Text',
                    'inputType': 'text',
                },
            ],
        },
    ],
}


flow = [0.97, 0.96, 0.96, 0.95, 0.95, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.93, 0.92, 0.91, 0.9, 0.89, 0.88, 0.87, 0.87, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.87, 0.88, 0.9, 0.93, 0.96, 0.99, 1.03, 1.06, 1.1, 1.14, 1.17, 1.2, 1.23, 1.26, 1.29, 1.33, 1.36, 1.4, 1.43, 1.45, 1.48, 1.49, 1.51, 1.51, 1.5, 1.49, 1.47, 1.44, 1.41, 1.37, 1.34, 1.3, 1.27, 1.24, 1.22, 1.2, 1.19, 1.18, 1.16, 1.15, 1.14, 1.13, 1.12, 1.11, 1.11, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.09, 1.09, 1.08, 1.07, 1.06, 1.05, 1.04, 1.03, 1.03, 1.02, 1.01, 1.01, 1, 0.99, 0.98, 0.97, 0.96, 0.96, 0.95, 0.95, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.93, 0.92, 0.91, 0.9, 0.89, 0.88, 0.87, 0.87, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.85, 0.84, 0.83, 0.82, 0.81, 0.8, 0.8, 0.79, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.77, 0.75, 0.73, 0.71, 0.68, 0.65, 0.63, 0.61, 0.59, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.57, 0.57, 0.57, 0.56, 0.55, 0.55, 0.54, 0.54, 0.53, 0.52, 0.52, 0.51, 0.51, 0.5, 0.5, 0.49, 0.48, 0.48, 0.47, 0.47, 0.47, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.46, 0.52, 0.67, 0.9, 1.19, 1.52, 1.87, 2.22, 2.55, 2.84, 3.07, 3.22, 3.28, 3.28, 3.28, 3.28, 3.28, 3.28, 3.28, 3.28, 3.28, 3.28, 3.28, 3.28, 3.28, 3.24, 3.13, 2.97, 2.77, 2.54, 2.3, 2.05, 1.82, 1.62, 1.46, 1.35, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.31, 1.3, 1.26, 1.21, 1.14, 1.06, 0.97, 0.89, 0.81, 0.74, 0.69, 0.65, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.63, 0.63, 0.62, 0.62, 0.61, 0.6, 0.59, 0.59, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.59, 0.61, 0.63, 0.65, 0.68, 0.71, 0.73, 0.75, 0.77, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.77, 0.75, 0.73, 0.71, 0.68, 0.65, 0.63, 0.61, 0.59, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.58, 0.59, 0.59, 0.6, 0.61, 0.62, 0.62, 0.63, 0.63, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.65, 0.66, 0.68, 0.69, 0.71, 0.73, 0.74, 0.76, 0.77, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.79, 0.81, 0.82, 0.84, 0.86, 0.88, 0.9, 0.92, 0.93, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.94, 0.93, 0.92, 0.91, 0.9, 0.89, 0.88, 0.87, 0.87, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.86, 0.85, 0.84, 0.82, 0.8, 0.78, 0.76, 0.75, 0.73, 0.72, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.72, 0.73, 0.74, 0.76, 0.78, 0.79, 0.82, 0.84, 0.86, 0.89, 0.91, 0.94, 0.97, 1, 1.02, 1.05, 1.08, 1.11, 1.14, 1.17, 1.19, 1.22, 1.25, 1.27, 1.29, 1.31, 1.33, 1.35, 1.36, 1.38, 1.39, 1.39, 1.4, 1.4, 1.4, 1.39, 1.37, 1.35, 1.32, 1.29, 1.26, 1.22, 1.18, 1.14, 1.1, 1.05, 1.01, 0.97, 0.93, 0.89, 0.85, 0.82, 0.78, 0.76, 0.74, 0.72, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.72, 0.73, 0.74, 0.75, 0.77, 0.78, 0.8, 0.82, 0.84, 0.87, 0.89, 0.92, 0.94, 0.97, 0.99, 1.02, 1.05, 1.08, 1.1, 1.13, 1.16, 1.18, 1.21, 1.23, 1.26, 1.28, 1.3, 1.32, 1.34, 1.35, 1.37, 1.38, 1.39, 1.4, 1.41, 1.41, 1.42, 1.42, 1.43, 1.43, 1.43, 1.44, 1.44, 1.44, 1.44, 1.45, 1.45, 1.45, 1.46, 1.46, 1.46, 1.47, 1.47, 1.48, 1.48, 1.49, 1.5, 1.51, 1.54, 1.62, 1.73, 1.88, 2.05, 2.24, 2.45, 2.67, 2.89, 3.11, 3.31, 3.51, 3.69, 3.86, 4.03, 4.18, 4.33, 4.48, 4.62, 4.76, 4.89, 5.02, 5.16, 5.29, 5.43, 5.57, 5.71, 5.86, 6.02, 6.18, 6.36, 6.54, 6.73, 6.93, 7.15, 7.38, 7.62, 7.88, 8.16, 8.46, 8.77, 9.11, 9.46, 9.84, 10.24, 10.67, 11.12, 11.6, 12.3, 13.66, 16, 38.43, 82.21, 146.6, 218.7, 226, 225.23, 223.08, 219.78, 212, 199.82, 184.6, 168, 151.65, 137.21, 126.31, 119.94, 115.52, 112.06, 108.92, 105.44, 101, 94.56, 86.36, 77.67, 69.76, 63.9, 60.38, 57.41, 54.84, 52.57, 50.56, 48.71, 46.97, 45.25, 43.48, 41.6, 39.5, 37.19, 34.81, 32.46, 30.27, 28.36, 26.85, 25.86, 25.5, 25.5, 25.5, 25.5, 25.5, 25.5, 25.5, 25.5, 25.5, 25.5, 25.5, 25.5, 25.5, 25.27, 24.65, 23.7, 22.52, 21.17, 19.75, 18.33, 16.98, 15.8, 14.85, 14.23, 14, 14.02, 14.08, 14.17, 14.29, 14.44, 14.61, 14.8, 15.01, 15.23, 15.47, 15.71, 15.95, 16.19, 16.43, 16.67, 16.89, 17.1, 17.29, 17.46, 17.61, 17.73, 17.82, 17.88, 17.9, 17.63, 16.88, 15.75, 14.33, 12.71, 10.98, 9.23, 7.56, 6.05, 4.81, 3.92, 3.47, 3.28, 3.1, 2.93, 2.76, 2.61, 2.46, 2.32, 2.19, 2.07, 1.96, 1.85, 1.75, 1.66, 1.58, 1.51, 1.44, 1.39, 1.34, 1.29, 1.26, 1.23, 1.22, 1.2, 1.2, 1.2, 1.2, 1.2, 1.2, 1.21, 1.21, 1.21, 1.21, 1.22, 1.22, 1.22, 1.23, 1.23, 1.23, 1.24, 1.24, 1.25, 1.25, 1.25, 1.26, 1.26, 1.27, 1.27, 1.27, 1.28, 1.28, 1.28, 1.29, 1.29, 1.29, 1.29, 1.3, 1.3, 1.3, 1.3, 1.3, 1.3, 1.3, 1.3, 1.3, 1.3, 1.3, 1.29, 1.29, 1.29, 1.29, 1.28, 1.28, 1.28, 1.27, 1.27, 1.26, 1.25, 1.25, 1.24, 1.23, 1.23, 1.22, 1.21, 1.2, 1.16, 1.06, 0.95, 0.83, 0.74, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.7, 0.7, 0.7, 0.7, 0.7, 0.7, 0.7, 0.7, 0.7, 0.7, 0.7, 0.69, 0.69, 0.69, 0.69, 0.69, 0.69, 0.69, 0.69, 0.68, 0.68, 0.68, 0.68, 0.68, 0.68, 0.67, 0.67, 0.67, 0.67, 0.67, 0.67, 0.67, 0.66, 0.66, 0.66, 0.66, 0.66, 0.66, 0.66, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.65, 0.66, 0.68, 0.69, 0.71, 0.73, 0.74, 0.76, 0.77, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.78, 0.8, 0.86, 0.95, 1.08, 1.25, 1.46, 1.7, 1.97, 2.28, 2.63, 3.01, 3.42, 3.87, 4.35, 4.86, 5.4, 5.98, 6.59, 7.92, 10.49, 14.04, 18.31, 23.04, 27.98, 32.87, 37.45, 41.46, 44.64, 46.74, 47.5, 46.86, 45.16, 42.77, 40.04, 37.33, 35, 32.74, 30.21, 27.7, 25.5, 23.9, 23.2, 23.06, 22.94, 22.84, 22.77, 22.72, 22.7, 22.8, 23.23, 23.95, 24.91, 26.04, 27.3, 28.76, 30.7, 33.39, 37.12, 42.15, 48.77, 65.22, 252.1, 257, 237.32, 221.19, 212, 208.67, 206.89, 205.2, 202.15, 189.82, 172, 165.3, 160.49, 156.8, 153.44, 149.62, 144.6, 138.27, 131, 123.11, 114.9, 106.69, 98.79, 91.5, 85.13, 80, 75.53, 71.03, 66.65, 62.54, 58.85, 55.73, 53.31, 51.75, 51.2, 56.53, 68.25, 80, 91.01, 102.03, 109, 112.37, 115.29, 117.68, 119.48, 120.61, 121, 119.45, 115.57, 110.52, 105.47, 101.58, 100, 99.97, 99.94, 99.92, 99.9, 99.88, 99.86, 99.85, 99.84, 99.83, 99.82, 99.81, 99.81, 99.8, 99.8, 99.8, 122.15, 163.65, 186, 182.96, 175.15, 164.56, 153.18, 143, 136, 131.37, 126.98, 122.81, 118.85, 115.09, 111.52, 108.13, 104.9, 101.83, 98.9, 96.11, 93.44, 90.87, 88.41, 86.04, 83.74, 81.51, 79.33, 77.2, 75.1, 73.02, 70.95, 68.88, 66.8, 64.87, 63.14, 61.4, 59.53, 57.67, 56, 54.6, 53.36, 52.2, 51.05, 49.85, 48.5, 46.87, 44.92, 42.74, 40.42, 38.04, 35.69, 33.46, 31.44, 29.72, 28.38, 27.51, 27.2, 27.2, 27.2, 27.2, 27.2, 27.2, 27.2, 27.2, 27.2, 27.2, 27.2, 27.2, 27.2, 27.14, 26.97, 26.7, 26.35, 25.95, 25.49, 25.02, 24.53, 24.04, 23.58, 23.16, 22.8, 22.46, 22.11, 21.75, 21.39, 21.03, 20.69, 20.36, 20.05, 19.78, 19.54, 19.35, 19.2, 19.09, 19, 18.92, 18.85, 18.79, 18.74, 18.68, 18.62, 18.56, 18.49, 18.4, 18.3, 18.17, 18.02, 17.83, 17.63, 17.41, 17.18, 16.93, 16.68, 16.43, 16.18, 15.93, 15.7, 15.47, 15.22, 14.97, 14.71, 14.45, 14.18, 13.93, 13.68, 13.44, 13.21, 13, 12.8, 12.62, 12.46, 12.31, 12.16, 12.03, 11.89, 11.76, 11.62, 11.48, 11.33, 11.17, 11, 10.81, 10.59, 10.36, 10.12, 9.86, 9.61, 9.36, 9.12, 8.89, 8.68, 8.5, 8.35, 8.21, 8.08, 7.94, 7.81, 7.68, 7.56, 7.46, 7.36, 7.29, 7.23, 7.19, 7.18, 7.51, 8.42, 9.81, 11.58, 13.63, 15.86, 18.16, 20.44, 22.58, 24.49, 26.06, 27.2, 28.08, 28.95, 29.81, 30.65, 31.48, 32.28, 33.07, 33.82, 34.55, 35.25, 35.92, 36.56, 37.15, 37.71, 38.23, 38.7, 39.13, 39.5, 39.83, 40.1, 40.31, 40.47, 40.57, 40.6, 40.49, 40.16, 39.64, 38.94, 38.09, 37.1, 36, 34.79, 33.51, 32.17, 30.79, 29.39, 27.99, 26.6, 25.25, 23.96, 22.75, 21.63, 20.63, 19.76, 19.04, 18.49, 18.14, 18, 17.97, 17.95, 17.94, 17.92, 17.91, 17.9, 17.89, 17.88, 17.87, 17.85, 17.83, 17.8, 17.7, 17.46, 17.13, 16.7, 16.21, 15.68, 15.13, 14.57, 14.04, 13.56, 13.14, 12.8, 12.52, 12.27, 12.02, 11.79, 11.57, 11.37, 11.16, 10.97, 10.78, 10.59, 10.39, 10.2, 10.01, 9.81, 9.63, 9.44, 9.26, 9.08, 8.9, 8.73, 8.56, 8.39, 8.22, 8.06, 7.9, 7.73, 7.57, 7.41, 7.25, 7.09, 6.94, 6.79, 6.65, 6.52, 6.4, 6.28, 6.17, 6.08, 5.98, 5.9, 5.81, 5.73, 5.65, 5.57, 5.49, 5.41, 5.32, 5.23, 5.14, 5.04, 4.94, 4.84, 4.74, 4.63, 4.53, 4.43, 4.33, 4.23, 4.13, 4.03, 3.93, 3.81, 3.69, 3.57, 3.45, 3.33, 3.22, 3.12, 3.04, 2.98, 2.93, 2.92, 2.92, 2.92, 2.92, 2.92, 2.92, 2.92, 2.92, 2.92, 2.92, 2.92, 2.92, 2.92, 2.9, 2.86, 2.8, 2.71, 2.62, 2.52, 2.42, 2.33, 2.24, 2.18, 2.14, 2.12, 2.12, 2.12, 2.12, 2.12, 2.12, 2.12, 2.12, 2.12, 2.12, 2.12, 2.12, 2.12, 2.1, 2.06, 2, 1.91, 1.82, 1.71, 1.61, 1.5, 1.4, 1.32, 1.25, 1.2, 1.16, 1.13, 1.1, 1.06, 1.03, 1, 0.97, 0.93, 0.9, 0.87, 0.85, 0.82, 0.79, 0.77, 0.74, 0.72, 0.69, 0.67, 0.65, 0.63, 0.61, 0.59, 0.58, 0.56, 0.54, 0.53, 0.52, 0.51, 0.5, 0.49, 0.48, 0.48, 0.47, 0.47, 0.46, 0.46, 0.47, 0.48, 0.5, 0.53, 0.56, 0.59, 0.62, 0.64, 0.67, 0.69, 0.7, 0.71, 0.71, 0.71, 0.71, 0.7, 0.7, 0.7, 0.69, 0.69, 0.69, 0.68, 0.68, 0.67, 0.67, 0.67, 0.66, 0.66, 0.65, 0.65, 0.65, 0.65, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.64, 0.65, 0.65, 0.65, 0.66, 0.66, 0.67, 0.68, 0.69, 0.69, 0.7, 0.71, 0.73, 0.74, 0.75, 0.76, 0.78, 0.8, 0.81, 0.83, 0.85, 0.87, 0.89, 0.92, 0.94, 0.97, 0.99, 1.02, 1.05, 1.08, 1.11, 1.15, 1.18, 1.32, 1.66, 2.21, 2.97, 3.94, 5.11, 6.5, 8.1, 9.9, 11.92, 14.15, 16.6, 22.3, 22.8, 24.48, 30.38, 35.74, 42.4, 57.14, 94.04, 112.9, 123.4, 130.4, 130, 119.4, 120.7, 116.8, 118.1, 119.4, 124.8, 143.5, 204, 294, 319.2, 328.4, 365, 350.8, 347.6, 347.6, 325, 331.6, 319.2, 308, 308, 308, 308, 296.8, 300, 281, 278.4, 270.6, 271, 253.6, 233.5, 219.2, 207.8, 205.9, 204, 189.6, 178.8, 173.4, 160, 154.4, 146, 145, 140.5, 130.4, 126.2, 116.8, 112.9, 106.5, 101.6, 98.51, 82.67, 67.3, 80.05, 76.12, 72.3, 71.02, 69.78, 67.3, 67.3, 68.54, 57.6, 71.02, 66.06, 59.12, 57.14, 55.16, 55.16, 52.19, 52.19, 51.2, 48.56, 44.16, 43, 45.92, 49.44, 44.16, 36.48, 35.74, 35, 32.36, 37.22, 32.36, 32.36, 32.36, 33.68, 32.36, 31.7, 35.74, 29.72, 32.36, 30.38, 29.72, 28.4, 28.4, 28.4, 27.28, 25.6, 25.04, 23.92, 22.3, 21.8, 21.8, 21.8, 22.8, 21.8, 25.6, 22.8, 22.8, 17.8, 16.04, 16.04, 16.04, 16.04, 16.04, 16.04, 16.04, 16.04, 16.04, 16.04, 15.02, 14, 14.03, 14.11, 14.25, 14.45, 14.72, 15.06, 15.46, 15.95, 16.51, 17.15, 17.87, 18.69, 19.59, 20.59, 21.69, 22.88, 24.18, 25.59, 27.1, 28.73, 30.48, 32.34, 34.33, 36.44, 38.69, 41.06, 43.57, 46.22, 49.01, 51.95, 55.04, 58.27, 61.66, 65.21, 68.92, 72.8, 88.09, 104.9, 105.7, 110.3, 111.6, 110.3, 106.5, 105.7, 103.3, 100, 97.02, 98.8, 91.07, 83.98, 88.09, 81.36, 78.74, 77.43, 77.43, 73.5, 74.81, 72.63, 68.58, 66.4, 68.54, 69.78, 67.3, 64.82, 61.1, 59.12, 56.15, 53.18, 50.32, 49.44, 44.16, 36.5, 42.4, 37.96, 37.22, 33.68, 36.48, 35.74, 35, 35, 37.22, 37.22, 39.44, 32.6, 34.54, 36.48, 35.74, 34.34, 33.68, 33.02, 31.04, 29.72, 29.72, 29.72, 26.16, 25.6, 29.72, 18.3, 22.3, 21.3, 21.8, 21.8, 20.3, 20.8, 25.04, 25.04, 25.6, 25.6, 25.04, 25.6, 25.04, 25.6, 23.92, 25.04, 21.3, 21.8, 22.3, 21.8, 20.8, 16.1, 20.3, 18.3, 13.22, 19.3, 19.3, 18.3, 14.4, 13.86, 13.36, 12.9, 12.48, 12.1, 11.75, 11.43, 11.15, 10.9, 10.67, 10.48, 10.31, 10.16, 10.04, 9.93, 9.85, 9.78, 9.73, 9.69, 9.67, 9.65, 9.65, 12.08, 8.67, 11.7, 11.38, 10.65, 9.84, 9.32, 9.07, 8.85, 8.66, 8.49, 8.35, 8.22, 8.1, 7.98, 7.86, 7.74, 7.61, 7.47, 7.31, 7.14, 6.96, 6.78, 6.58, 6.39, 6.19, 5.99, 5.78, 5.58, 5.39, 5.2, 5.01, 4.83, 4.67, 4.51, 4.37, 4.24, 4.12, 4.02, 3.95, 3.89, 3.85, 3.84, 4.41, 5.77, 7.39, 8.75, 9.32, 9.18, 9, 8.94, 8.88, 8.83, 8.78, 8.73, 8.68, 8.64, 8.6, 8.56, 8.53, 8.5, 8.47, 8.45, 8.42, 8.4, 8.39, 8.37, 8.36, 8.35, 8.35, 8.34, 8.34, 8.67, 9.65, 9.62, 9.53, 9.4, 9.21, 8.98, 8.7, 8.4, 8.06, 7.69, 7.3, 6.89, 6.47, 6.03, 5.59, 5.14, 4.7, 4.26, 3.83, 3.42, 3.02, 2.65, 2.3, 1.98, 1.7, 1.45, 1.25, 1.09, 0.99, 0.94, 0.92, 0.91, 0.89, 0.87, 0.85, 0.84, 0.82, 0.81, 0.79, 0.78, 0.77, 0.75, 0.74, 0.73, 0.72, 0.71, 0.7, 0.69, 0.68, 0.67, 0.66, 0.65, 0.64, 0.64, 0.63, 0.63, 0.62, 0.62, 0.61, 0.61, 0.61, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.61, 0.61, 0.61, 0.61, 0.61, 0.61, 0.62, 0.62, 0.62, 0.62, 0.63, 0.63, 0.63, 0.63, 0.63, 0.64, 0.64, 0.64, 0.64, 0.64, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.65, 0.64, 0.63, 0.62, 0.6, 0.59, 0.57, 0.55, 0.54, 0.53, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.51, 0.51, 0.51, 0.5, 0.5, 0.49, 0.48, 0.47, 0.47, 0.46, 0.45, 0.45, 0.44, 0.43, 0.42, 0.42, 0.41, 0.41, 0.41, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.41, 0.42, 0.43, 0.44, 0.46, 0.48, 0.5, 0.53, 0.55, 0.58, 0.61, 0.64, 0.67, 0.7, 0.73, 0.77, 0.8, 0.83, 0.87, 0.9, 0.93, 0.96, 0.99, 1.02, 1.05, 1.08, 1.1, 1.12, 1.14, 1.16, 1.17, 1.18, 1.19, 1.2, 1.2, 1.2, 1.19, 1.17, 1.15, 1.12, 1.09, 1.06, 1.02, 0.98, 0.94, 0.9, 0.86, 0.82, 0.78, 0.74, 0.7, 0.66, 0.63, 0.6, 0.57, 0.55, 0.53, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.52, 0.51, 0.51, 0.5, 0.5, 0.49, 0.49, 0.48, 0.47, 0.47, 0.47, 0.46, 0.46, 0.45, 0.45, 0.45, 0.44, 0.44, 0.44, 0.43, 0.43, 0.43, 0.42, 0.42, 0.42, 0.41, 0.41, 0.41, 0.41, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.41, 0.41, 0.41, 0.41, 0.41, 0.41, 0.41, 0.41, 0.41, 0.41, 0.41, 0.41, 0.41, 0.41, 0.41, 0.42, 0.42, 0.42, 0.42, 0.42, 0.42, 0.42, 0.42, 0.42, 0.43, 0.43, 0.43, 0.43, 0.43, 0.43, 0.44, 0.44, 0.44, 0.44, 0.44, 0.44, 0.45, 0.45, 0.45]
rainfall = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.005, 0.017, 0.017, 0.017, 0.017, 0.011, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.021, 0.026, 0.03, 0.036, 0.036, 0.195, 0.221, 0.019, 0.013, 0.017, 0.03, 0.03, 0.03, 0.046, 0.045, 0.038, 0.084, 0.045, 0.045, 0.037, 0.034, 0.035, 0.036, 0.044, 0.052, 0.048, 0.109, 0.033, 0.029, 0.04, 0.042, 0.042, 0.042, 0.073, 0.076, 0.062, 0.066, 0.066, 0.075, 0.096, 0.128, 0.121, 0.128, 0.14, 0.226, 0.143, 0.097, 0.018, 0, 0, 0, 0, 0, 0.018, 0.047, 0.054, 0.054, 0.054, 0.036, 0.185, 0.009, 0.038, 0.061, 0.077, 0.091, 0.126, 0.69, 0.182, 0.349, 0.231, 0.146, 0.128, 0.167, 0.1, 0.075, 0.071, 0.071, 0.117, 0.01, 0.002, 0.002, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.005, 0.026, 0.038, 0.038, 0.038, 0.076, 0.086, 0.109, 0.213, 0.276, 0.288, 0.297, 0.642, 1.799, 1.236, 2.138, 0.921, 0.497, 0.685, 0.828, 0.41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.018, 0.024, 0.024, 0.024, 0.024, 0.006, 0.003, 0.046, 0.046, 0.046, 0.046, 0.043, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.204, 0.303, 1.028, 1.328, 1.524, 1.41, 1.362, 1.292, 1.191, 0.529, 0.501, 0.944, 1.81, 2.899, 0.859, 0.126, 0.087, 0.047, 0, 0, 0, 0, 0.011, 0.028, 0.028, 0.028, 0.028, 0.017, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.099, 0.159, 0.297, 0.309, 0.309, 0.614, 0.818, 1.436, 1.195, 0.553, 0.542, 0.955, 0.898, 0.466, 0.386, 0.556, 0.388, 0.221, 0.192, 0.192, 0.187, 0.166, 0.18, 0.302, 0.158, 0.009, 0.009, 0.009, 0.009, 0.009, 0.007, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.004, 0.032, 0.032, 0.032, 0.032, 0.082, 0.149, 0.204, 0.247, 0.262, 0.49, 0.51, 0.533, 0.746, 0.847, 2.393, 1.188, 1.114, 0.475, 0.043, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.017, 0.017, 0.021, 0.042, 0.079, 0.111, 0.126, 0.122, 0.133, 0.846, 0.102, 0.077, 0.067, 0.056, 0.005, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.011, 0.017, 0.017, 0.017, 0.017, 0.006, 0, 0, 0, 0, 0, 0.01, 0.03, 0.054, 0.067, 0.07, 0.25, 0.251, 0.494, 0.065, 0.054, 0.054, 0.064, 0.084, 0.077, 0.101, 0.132, 0.248, 0.069, 0.117, 0.115, 0.087, 0.326, 0.036, 0.009, 0.009, 0.009, 0.009, 0.009, 0.004, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.02, 0.039, 0.04, 0.04, 0.04, 0.229, 0.079, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.023, 0.069, 0.082, 0.082, 0.082, 0.503, 0.774, 0.038, 0.012, 0.012, 0.012, 0.016, 0.02, 0.028, 0.051, 0.06, 0.064, 0.19, 0.15, 0.164, 0.139, 0.13, 0.085, 0.031, 0.023, 0.022, 0.007, 0.005, 0.005, 0.001, 0, 0.02, 0.048, 0.048, 0.053, 0.056, 0.036, 0.008, 0.008, 0.004, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.013, 0.017, 0.036, 0.068, 0.095, 0.233, 0.272, 0.377, 0.722, 1.494, 3.756, 0.954, 0.439, 0.442, 0.462, 0.373, 0.249, 0.214, 0.1, 0.044, 0.037, 0.023, 0.002, 0, 0, 0, 0, 0, 0, 0.02, 0.024, 0.024, 0.024, 0.024, 0.004, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.008, 0.017, 0.017, 0.045, 0.186, 0.308, 0.241, 0.241, 0.893, 4.067, 4.494, 5.015, 3.494, 2.057, 1.411, 0.718, 0.407, 0.313, 0.339, 1.537, 1.105, 0.218, 0.136, 0.03, 0.005, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.037, 0.448, 1.2, 1.309, 1.309, 1.425, 1.223, 0.471, 0.767, 0.423, 0.273, 0.412, 0.646, 0.481, 0.239, 0.131, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.044, 0.15, 0.223, 0.388, 0.513, 0.883, 2.828, 4.786, 5.959, 4.95, 6.434, 6.319, 3.35, 2.806, 4.204, 1.395, 1.015, 1.015, 0.836, 0.74, 0.72, 0.615, 0.477, 0.192, 0.046, 0.007, 0.007, 0.007, 0.007, 0.007, 0.007, 0.007, 0.008, 0.005, 0.005, 0.005, 0.005, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.001, 0.012, 0.012, 0.012, 0.012, 0.011, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.002, 0.012, 0.028, 0.028, 0.028, 0.138, 0.092, 0.082, 0.082, 0.096, 0.719, 0.155, 0.042, 0.047, 0.129, 0.021, 0.021, 0.014, 0.009, 0.029, 0.067, 0.088, 0.095, 0.095, 0.138, 0.091, 0.032, 0.025, 0.025, 0.003, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.002, 0.045, 0.228, 0.297, 0.325, 0.339, 0.581, 1.244, 0.796, 0.517, 0.227, 0.053, 0.006, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.003, 0.005, 0.005, 0.005, 0.005, 0.081, 0.129, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.014, 0.041, 0.041, 0.041, 0.041, 0.027, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.009, 0.017, 0.017, 0.017, 0.017, 0.355, 0.174, 0.009, 0.009, 0.012, 0.136, 0.208, 0.208, 0.208, 0.215, 7.359, 1.858, 0.458, 0.053, 0.053, 0.047, 0.045, 0.045, 0.059, 0.136, 0.188, 0.206, 0.21, 0.588, 1.517, 6.02, 4.688, 4.42, 0.624, 0.326, 0.359, 0.553, 0.899, 0.94, 2.95, 9.415, 5.752, 1.092, 0.096, 0.035, 0.026, 0.018, 0.015, 0.011, 0.011, 0.011, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.056, 0.27, 0.314, 0.351, 0.354, 0.609, 0.796, 1.857, 0.848, 0.538, 0.214, 0.178, 0.178, 0.201, 0.231, 0.227, 0.272, 0.397, 0.45, 1.014, 2.917, 1.675, 0.081, 0.059, 0.059, 0.148, 0.075, 0.075, 0.078, 0.236, 0.784, 0.784, 0.784, 0.784, 0.741, 0.115, 0.058, 0.058, 0.058, 0.029, 0.015, 0.015, 0.015, 0.015, 0.012, 0.008, 0.604, 0.985, 1.305, 2.273, 2.528, 2.336, 2.496, 2.281, 1.397, 1.713, 3.259, 1.167, 0.745, 0.548, 1.058, 0.684, 0.728, 0.392, 0.179, 0.283, 0.283, 0.46, 0.08, 0.099, 0.099, 0.099, 0.1, 0.143, 0.137, 0.238, 0.317, 0.262, 0.225, 0.792, 0.426, 0.332, 0.261, 0.11, 0.093, 0.102, 0.171, 0.292, 0.504, 0.605, 1.745, 2.485, 1.964, 0.33, 0.171, 0.259, 0.242, 0.215, 0.366, 0.354, 0.205, 0.203, 0.262, 0.153, 0.13, 0.137, 0.362, 0.691, 0.295, 0.433, 0.154, 0.056, 0.053, 0.053, 0.053, 0.051, 0.047, 0.065, 0.078, 0.091, 0.206, 0.813, 0.102, 0.151, 0.05, 0.024, 0.004, 0.001, 0, 0, 0, 0.021, 0.021, 0.021, 0.021, 0.021, 0.013, 0.013, 0.013, 0.013, 0.013, 0.013, 0.013, 0.013, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.008, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.018, 0.021, 0.021, 0.021, 0.021, 0.003, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.024, 0.173, 0.261, 0.267, 0.267, 0.534, 1.354, 1.772, 0.72, 0.218, 0.018, 0.018, 0.028, 0.036, 0.032, 0.194, 0.082, 0.035, 0.286, 0.027, 0.038, 0.038, 0.027, 0.021, 0.014, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.016, 0.017, 0.017, 0.031, 0.047, 0.043, 0.056, 0.104, 0.149, 0.179, 0.205, 0.328, 0.998, 0.522, 1.851, 3.727, 3.273, 2.204, 1.169, 1.006, 1.179, 0.74, 0.741, 1.065, 0.925, 0.671, 0.497, 0.431, 0.327, 0.277, 0.126, 0.581, 0.207, 0.359, 2.485, 0.038, 0.036, 0.003, 0.003, 0.003, 0.003, 0.004, 0.098, 0.023, 0.021, 0.021, 0.022, 0.041, 0.041, 0.043, 0.045, 0.043, 0.014, 0.014, 0.014, 0.014, 0.014, 0.014, 0.014, 0.031, 0.046, 0.063, 0.119, 0.107, 0.092, 0.085, 0.065, 0.06, 0.054, 0.042, 0.039, 0.046, 0.044, 0.028, 0.028, 0.02, 0.013, 0.013, 0.013, 0.013, 0.016, 0.032, 0.031, 0.031, 0.031, 0.028, 0.011, 0.011, 0.011, 0.011, 0.011, 0.023, 0.024, 0.024, 0.024, 0.019, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.013, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.001, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.011, 0.017, 0.024, 0.026, 0.061, 0.172, 0.206, 0.213, 0.267, 0.511, 0.668, 0.157, 0.017, 0.017, 0.017, 0.046, 0.054, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.001, 0.017, 0.017, 0.017, 0.017, 0.016, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.01, 0.017, 0.017, 0.017, 0.017, 0.012, 0.017, 0.017, 0.017, 0.017, 0.012, 0, 0, 0, 0, 0, 0.003, 0.031, 0.066, 0.093, 0.112, 0.122, 0.202, 0.068, 0.041, 0.022, 0.011, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.002, 0.005, 0.012, 0.021, 0.021, 0.019, 0.033, 0.03, 0.026, 0.026, 0.034, 0.095, 0.024, 0.024, 0.024, 0.023, 0.019, 0.018, 0.018, 0.018, 0.011, 0.03, 0.045, 0.044, 0.044, 0.044, 0.022, 0.009, 0.024, 0.033, 0.033, 0.033, 0.024, 0.009, 0, 0, 0, 0, 0, 0, 0.003, 0.017, 0.017, 0.017, 0.017, 0.014, 0, 0, 0, 0, 0, 0.032, 0.032, 0.032, 0.032, 0.032, 0.005, 0.008, 0.009, 0.014, 0.014, 0.009, 0.005, 0.004, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.007, 0.009, 0.009, 0.009, 0.009, 0.043, 0.063, 0.084, 0.098, 0.101, 0.213, 0.334, 0.383, 0.43, 0.448, 0.511, 0.801, 0.835, 1.642, 1.614, 1.496, 1.496, 1.476, 1.068, 0.481, 0.22, 0.119, 0.099, 0.07, 0.072, 0.063, 0.076, 0.14, 0.205, 0.28, 0.297, 0.3, 0.479, 0.877, 1.098, 1.611, 1.629, 1.686, 1.686, 1.631, 1.528, 1.862, 1.703, 1.531, 2.196, 0.395, 0.416, 0.453, 0.728, 0.917, 0.986, 1.17, 2.171, 3.011, 2.909, 3.301, 1.377, 0.778, 0.799, 0.947, 1.039, 0.879, 0.76, 1.372, 1.674, 1.674, 1.68, 1.823, 1.793, 1.162, 0.783, 0.216, 0.152, 0.152, 0.152, 0.049, 0, 0, 0, 0.117, 0.127, 0.127, 0.127, 0.127, 0.127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.003, 0.005, 0.005, 0.005, 0.005, 0.003, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.309, 0.364, 0.364, 0.364, 0.364, 0.063, 0.01, 0.01, 0.01, 0.012, 0.015, 0.015, 0.11, 0.55, 0.824, 0.825, 0.829, 1.39, 1.429, 1.342, 1.43, 1.636, 1.717, 2.135, 2.203, 3.191, 3.022, 1.589, 0.86, 0.807, 0.645, 0.595, 0.588, 0.557, 0.552, 1.271, 0.708, 0.677, 0.629, 0.714, 0.203, 0.133, 0.061, 0.062, 0.018, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.001, 0.072, 0.29, 0.438, 0.53, 0.557, 0.873, 1.039, 1.04, 0.208, 0.049, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.03, 0.039, 0.039, 0.039, 0.039, 0.098, 0.008, 0.007, 0.007, 0.007, 0.007, 0.007, 0.007, 0.007, 0.007, 0.007, 0.056, 0.062, 0.065, 0.065, 0.065, 0.047, 0.216, 0.256, 0.315, 0.4, 0.502, 0.449, 0.47, 0.571, 0.814, 1.153, 0.774, 0.202, 0.086, 0.075, 0.071, 0.032, 0.019, 0.003, 0.004, 0.004, 0.004, 0.004, 0.004, 0.004, 0.007, 0.072, 0.153, 0.256, 0.306, 0.404, 0.698, 0.733, 0.823, 0.715, 0.563, 0.404, 0.293, 0.217, 0.213, 0.202, 0.202, 0.294, 0.704, 0.797, 1.359, 1.101, 0.72, 0.514, 0.539, 0.434, 0.389, 0.387, 0.386, 0.375, 0.369, 0.319, 0.239, 0.183, 0.136, 0.062, 0.052, 0.096, 0.119, 0.119, 0.114, 0.127, 0.132, 0.139, 0.169, 0.191, 0.278, 0.254, 0.214, 0.237, 0.221, 0.143, 0.129, 0.125, 0.109, 0.1, 0.087, 0.06, 0.038, 0.029, 0.029, 0.028, 0.048, 0.053, 0.053, 0.111, 0.125, 0.102, 0.097, 0.097, 0.039, 0.02, 0.02, 0.02, 0.014, 0.004, 0.031, 0.043, 0.047, 0.052, 0.08, 0.144, 0.182, 0.176, 0.171, 0.149, 0.112, 0.025, 0, 0, 0, 0, 0, 0, 0, 0.016, 0.031, 0.031, 0.031, 0.031, 0.015, 0, 0, 0, 0, 0, 0.005, 0.005, 0.005, 0.005, 0.005, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.005, 0.005, 0.005, 0.005, 0.005, 0.001, 0, 0, 0]
time = ['2009/6/12\n2:00', '2009/6/12\n3:00', '2009/6/12\n4:00', '2009/6/12\n5:00', '2009/6/12\n6:00', '2009/6/12\n7:00', '2009/6/12\n8:00', '2009/6/12\n9:00', '2009/6/12\n10:00', '2009/6/12\n11:00', '2009/6/12\n12:00', '2009/6/12\n13:00', '2009/6/12\n14:00', '2009/6/12\n15:00', '2009/6/12\n16:00', '2009/6/12\n17:00', '2009/6/12\n18:00', '2009/6/12\n19:00', '2009/6/12\n20:00', '2009/6/12\n21:00', '2009/6/12\n22:00', '2009/6/12\n23:00', '2009/6/13\n0:00', '2009/6/13\n1:00', '2009/6/13\n2:00', '2009/6/13\n3:00', '2009/6/13\n4:00', '2009/6/13\n5:00', '2009/6/13\n6:00', '2009/6/13\n7:00', '2009/6/13\n8:00', '2009/6/13\n9:00', '2009/6/13\n10:00', '2009/6/13\n11:00', '2009/6/13\n12:00', '2009/6/13\n13:00', '2009/6/13\n14:00', '2009/6/13\n15:00', '2009/6/13\n16:00', '2009/6/13\n17:00', '2009/6/13\n18:00', '2009/6/13\n19:00', '2009/6/13\n20:00', '2009/6/13\n21:00', '2009/6/13\n22:00', '2009/6/13\n23:00', '2009/6/14\n0:00', '2009/6/14\n1:00', '2009/6/14\n2:00', '2009/6/14\n3:00', '2009/6/14\n4:00', '2009/6/14\n5:00', '2009/6/14\n6:00', '2009/6/14\n7:00', '2009/6/14\n8:00', '2009/6/14\n9:00', '2009/6/14\n10:00', '2009/6/14\n11:00', '2009/6/14\n12:00', '2009/6/14\n13:00', '2009/6/14\n14:00', '2009/6/14\n15:00', '2009/6/14\n16:00', '2009/6/14\n17:00', '2009/6/14\n18:00', '2009/6/14\n19:00', '2009/6/14\n20:00', '2009/6/14\n21:00', '2009/6/14\n22:00', '2009/6/14\n23:00', '2009/6/15\n0:00', '2009/6/15\n1:00', '2009/6/15\n2:00', '2009/6/15\n3:00', '2009/6/15\n4:00', '2009/6/15\n5:00', '2009/6/15\n6:00', '2009/6/15\n7:00', '2009/6/15\n8:00', '2009/6/15\n9:00', '2009/6/15\n10:00', '2009/6/15\n11:00', '2009/6/15\n12:00', '2009/6/15\n13:00', '2009/6/15\n14:00', '2009/6/15\n15:00', '2009/6/15\n16:00', '2009/6/15\n17:00', '2009/6/15\n18:00', '2009/6/15\n19:00', '2009/6/15\n20:00', '2009/6/15\n21:00', '2009/6/15\n22:00', '2009/6/15\n23:00', '2009/6/15\n0:00', '2009/6/16\n1:00', '2009/6/16\n2:00', '2009/6/16\n3:00', '2009/6/16\n4:00', '2009/6/16\n5:00', '2009/6/16\n6:00', '2009/6/16\n7:00', '2009/6/16\n8:00', '2009/6/16\n9:00', '2009/6/16\n10:00', '2009/6/16\n11:00', '2009/6/16\n12:00', '2009/6/16\n13:00', '2009/6/16\n14:00', '2009/6/16\n15:00', '2009/6/16\n16:00', '2009/6/16\n17:00', '2009/6/16\n18:00', '2009/6/16\n19:00', '2009/6/16\n20:00', '2009/6/16\n21:00', '2009/6/16\n22:00', '2009/6/16\n23:00', '2009/6/15\n0:00', '2009/6/17\n1:00', '2009/6/17\n2:00', '2009/6/17\n3:00', '2009/6/17\n4:00', '2009/6/17\n5:00', '2009/6/17\n6:00', '2009/6/17\n7:00', '2009/6/17\n8:00', '2009/6/17\n9:00', '2009/6/17\n10:00', '2009/6/17\n11:00', '2009/6/17\n12:00', '2009/6/17\n13:00', '2009/6/17\n14:00', '2009/6/17\n15:00', '2009/6/17\n16:00', '2009/6/17\n17:00', '2009/6/17\n18:00', '2009/6/17\n19:00', '2009/6/17\n20:00', '2009/6/17\n21:00', '2009/6/17\n22:00', '2009/6/17\n23:00', '2009/6/18\n0:00', '2009/6/18\n1:00', '2009/6/18\n2:00', '2009/6/18\n3:00', '2009/6/18\n4:00', '2009/6/18\n5:00', '2009/6/18\n6:00', '2009/6/18\n7:00', '2009/6/18\n8:00', '2009/6/18\n9:00', '2009/6/18\n10:00', '2009/6/18\n11:00', '2009/6/18\n12:00', '2009/6/18\n13:00', '2009/6/18\n14:00', '2009/6/18\n15:00', '2009/6/18\n16:00', '2009/6/18\n17:00', '2009/6/18\n18:00', '2009/6/18\n19:00', '2009/6/18\n20:00', '2009/6/18\n21:00', '2009/6/18\n22:00', '2009/6/18\n23:00', '2009/6/15\n0:00', '2009/6/19\n1:00', '2009/6/19\n2:00', '2009/6/19\n3:00', '2009/6/19\n4:00', '2009/6/19\n5:00', '2009/6/19\n6:00', '2009/6/19\n7:00', '2009/6/19\n8:00', '2009/6/19\n9:00', '2009/6/19\n10:00', '2009/6/19\n11:00', '2009/6/19\n12:00', '2009/6/19\n13:00', '2009/6/19\n14:00', '2009/6/19\n15:00', '2009/6/19\n16:00', '2009/6/19\n17:00', '2009/6/19\n18:00', '2009/6/19\n19:00', '2009/6/19\n20:00', '2009/6/19\n21:00', '2009/6/19\n22:00', '2009/6/19\n23:00', '2009/6/20\n0:00', '2009/6/20\n1:00', '2009/6/20\n2:00', '2009/6/20\n3:00', '2009/6/20\n4:00', '2009/6/20\n5:00', '2009/6/20\n6:00', '2009/6/20\n7:00', '2009/6/20\n8:00', '2009/6/20\n9:00', '2009/6/20\n10:00', '2009/6/20\n11:00', '2009/6/20\n12:00', '2009/6/20\n13:00', '2009/6/20\n14:00', '2009/6/20\n15:00', '2009/6/20\n16:00', '2009/6/20\n17:00', '2009/6/20\n18:00', '2009/6/20\n19:00', '2009/6/20\n20:00', '2009/6/20\n21:00', '2009/6/20\n22:00', '2009/6/20\n23:00', '2009/6/21\n0:00', '2009/6/21\n1:00', '2009/6/21\n2:00', '2009/6/21\n3:00', '2009/6/21\n4:00', '2009/6/21\n5:00', '2009/6/21\n6:00', '2009/6/21\n7:00', '2009/6/21\n8:00', '2009/6/21\n9:00', '2009/6/21\n10:00', '2009/6/21\n11:00', '2009/6/21\n12:00', '2009/6/21\n13:00', '2009/6/21\n14:00', '2009/6/21\n15:00', '2009/6/21\n16:00', '2009/6/21\n17:00', '2009/6/21\n18:00', '2009/6/21\n19:00', '2009/6/21\n20:00', '2009/6/21\n21:00', '2009/6/21\n22:00', '2009/6/21\n23:00', '2009/6/22\n0:00', '2009/6/22\n1:00', '2009/6/22\n2:00', '2009/6/22\n3:00', '2009/6/22\n4:00', '2009/6/22\n5:00', '2009/6/22\n6:00', '2009/6/22\n7:00', '2009/6/22\n8:00', '2009/6/22\n9:00', '2009/6/22\n10:00', '2009/6/22\n11:00', '2009/6/22\n12:00', '2009/6/22\n13:00', '2009/6/22\n14:00', '2009/6/22\n15:00', '2009/6/22\n16:00', '2009/6/22\n17:00', '2009/6/22\n18:00', '2009/6/22\n19:00', '2009/6/22\n20:00', '2009/6/22\n21:00', '2009/6/22\n22:00', '2009/6/22\n23:00', '2009/6/23\n0:00', '2009/6/23\n1:00', '2009/6/23\n2:00', '2009/6/23\n3:00', '2009/6/23\n4:00', '2009/6/23\n5:00', '2009/6/23\n6:00', '2009/6/23\n7:00', '2009/6/23\n8:00', '2009/6/23\n9:00', '2009/6/23\n10:00', '2009/6/23\n11:00', '2009/6/23\n12:00', '2009/6/23\n13:00', '2009/6/23\n14:00', '2009/6/23\n15:00', '2009/6/23\n16:00', '2009/6/23\n17:00', '2009/6/23\n18:00', '2009/6/23\n19:00', '2009/6/23\n20:00', '2009/6/23\n21:00', '2009/6/23\n22:00', '2009/6/23\n23:00', '2009/6/24\n0:00', '2009/6/24\n1:00', '2009/6/24\n2:00', '2009/6/24\n3:00', '2009/6/24\n4:00', '2009/6/24\n5:00', '2009/6/24\n6:00', '2009/6/24\n7:00', '2009/6/24\n8:00', '2009/6/24\n9:00', '2009/6/24\n10:00', '2009/6/24\n11:00', '2009/6/24\n12:00', '2009/6/24\n13:00', '2009/6/24\n14:00', '2009/6/24\n15:00', '2009/6/24\n16:00', '2009/6/24\n17:00', '2009/6/24\n18:00', '2009/6/24\n19:00', '2009/6/24\n20:00', '2009/6/24\n21:00', '2009/6/24\n22:00', '2009/6/24\n23:00', '2009/6/25\n0:00', '2009/6/25\n1:00', '2009/6/25\n2:00', '2009/6/25\n3:00', '2009/6/25\n4:00', '2009/6/25\n5:00', '2009/6/25\n6:00', '2009/6/25\n7:00', '2009/6/25\n8:00', '2009/6/25\n9:00', '2009/6/25\n10:00', '2009/6/25\n11:00', '2009/6/25\n12:00', '2009/6/25\n13:00', '2009/6/25\n14:00', '2009/6/25\n15:00', '2009/6/25\n16:00', '2009/6/25\n17:00', '2009/6/25\n18:00', '2009/6/25\n19:00', '2009/6/25\n20:00', '2009/6/25\n21:00', '2009/6/25\n22:00', '2009/6/25\n23:00', '2009/6/26\n0:00', '2009/6/26\n1:00', '2009/6/26\n2:00', '2009/6/26\n3:00', '2009/6/26\n4:00', '2009/6/26\n5:00', '2009/6/26\n6:00', '2009/6/26\n7:00', '2009/6/26\n8:00', '2009/6/26\n9:00', '2009/6/26\n10:00', '2009/6/26\n11:00', '2009/6/26\n12:00', '2009/6/26\n13:00', '2009/6/26\n14:00', '2009/6/26\n15:00', '2009/6/26\n16:00', '2009/6/26\n17:00', '2009/6/26\n18:00', '2009/6/26\n19:00', '2009/6/26\n20:00', '2009/6/26\n21:00', '2009/6/26\n22:00', '2009/6/26\n23:00', '2009/6/27\n0:00', '2009/6/27\n1:00', '2009/6/27\n2:00', '2009/6/27\n3:00', '2009/6/27\n4:00', '2009/6/27\n5:00', '2009/6/27\n6:00', '2009/6/27\n7:00', '2009/6/27\n8:00', '2009/6/27\n9:00', '2009/6/27\n10:00', '2009/6/27\n11:00', '2009/6/27\n12:00', '2009/6/27\n13:00', '2009/6/27\n14:00', '2009/6/27\n15:00', '2009/6/27\n16:00', '2009/6/27\n17:00', '2009/6/27\n18:00', '2009/6/27\n19:00', '2009/6/27\n20:00', '2009/6/27\n21:00', '2009/6/27\n22:00', '2009/6/27\n23:00', '2009/6/28\n0:00', '2009/6/28\n1:00', '2009/6/28\n2:00', '2009/6/28\n3:00', '2009/6/28\n4:00', '2009/6/28\n5:00', '2009/6/28\n6:00', '2009/6/28\n7:00', '2009/6/28\n8:00', '2009/6/28\n9:00', '2009/6/28\n10:00', '2009/6/28\n11:00', '2009/6/28\n12:00', '2009/6/28\n13:00', '2009/6/28\n14:00', '2009/6/28\n15:00', '2009/6/28\n16:00', '2009/6/28\n17:00', '2009/6/28\n18:00', '2009/6/28\n19:00', '2009/6/28\n20:00', '2009/6/28\n21:00', '2009/6/28\n22:00', '2009/6/28\n23:00', '2009/6/29\n0:00', '2009/6/29\n1:00', '2009/6/29\n2:00', '2009/6/29\n3:00', '2009/6/29\n4:00', '2009/6/29\n5:00', '2009/6/29\n6:00', '2009/6/29\n7:00', '2009/6/29\n8:00', '2009/6/29\n9:00', '2009/6/29\n10:00', '2009/6/29\n11:00', '2009/6/29\n12:00', '2009/6/29\n13:00', '2009/6/29\n14:00', '2009/6/29\n15:00', '2009/6/29\n16:00', '2009/6/29\n17:00', '2009/6/29\n18:00', '2009/6/29\n19:00', '2009/6/29\n20:00', '2009/6/29\n21:00', '2009/6/29\n22:00', '2009/6/29\n23:00', '2009/6/30\n0:00', '2009/6/30\n1:00', '2009/6/30\n2:00', '2009/6/30\n3:00', '2009/6/30\n4:00', '2009/6/30\n5:00', '2009/6/30\n6:00', '2009/6/30\n7:00', '2009/6/30\n8:00', '2009/6/30\n9:00', '2009/6/30\n10:00', '2009/6/30\n11:00', '2009/6/30\n12:00', '2009/6/30\n13:00', '2009/6/30\n14:00', '2009/6/30\n15:00', '2009/6/30\n16:00', '2009/6/30\n17:00', '2009/6/30\n18:00', '2009/6/30\n19:00', '2009/6/30\n20:00', '2009/6/30\n21:00', '2009/6/30\n22:00', '2009/6/30\n23:00', '2009/7/1\n0:00', '2009/7/1\n1:00', '2009/7/1\n2:00', '2009/7/1\n3:00', '2009/7/1\n4:00', '2009/7/1\n5:00', '2009/7/1\n6:00', '2009/7/1\n7:00', '2009/7/1\n8:00', '2009/7/1\n9:00', '2009/7/1\n10:00', '2009/7/1\n11:00', '2009/7/1\n12:00', '2009/7/1\n13:00', '2009/7/1\n14:00', '2009/7/1\n15:00', '2009/7/1\n16:00', '2009/7/1\n17:00', '2009/7/1\n18:00', '2009/7/1\n19:00', '2009/7/1\n20:00', '2009/7/1\n21:00', '2009/7/1\n22:00', '2009/7/1\n23:00', '2009/7/2\n0:00', '2009/7/2\n1:00', '2009/7/2\n2:00', '2009/7/2\n3:00', '2009/7/2\n4:00', '2009/7/2\n5:00', '2009/7/2\n6:00', '2009/7/2\n7:00', '2009/7/2\n8:00', '2009/7/2\n9:00', '2009/7/2\n10:00', '2009/7/2\n11:00', '2009/7/2\n12:00', '2009/7/2\n13:00', '2009/7/2\n14:00', '2009/7/2\n15:00', '2009/7/2\n16:00', '2009/7/2\n17:00', '2009/7/2\n18:00', '2009/7/2\n19:00', '2009/7/2\n20:00', '2009/7/2\n21:00', '2009/7/2\n22:00', '2009/7/2\n23:00', '2009/7/3\n0:00', '2009/7/3\n1:00', '2009/7/3\n2:00', '2009/7/3\n3:00', '2009/7/3\n4:00', '2009/7/3\n5:00', '2009/7/3\n6:00', '2009/7/3\n7:00', '2009/7/3\n8:00', '2009/7/3\n9:00', '2009/7/3\n10:00', '2009/7/3\n11:00', '2009/7/3\n12:00', '2009/7/3\n13:00', '2009/7/3\n14:00', '2009/7/3\n15:00', '2009/7/3\n16:00', '2009/7/3\n17:00', '2009/7/3\n18:00', '2009/7/3\n19:00', '2009/7/3\n20:00', '2009/7/3\n21:00', '2009/7/3\n22:00', '2009/7/3\n23:00', '2009/7/4\n0:00', '2009/7/4\n1:00', '2009/7/4\n2:00', '2009/7/4\n3:00', '2009/7/4\n4:00', '2009/7/4\n5:00', '2009/7/4\n6:00', '2009/7/4\n7:00', '2009/7/4\n8:00', '2009/7/4\n9:00', '2009/7/4\n10:00', '2009/7/4\n11:00', '2009/7/4\n12:00', '2009/7/4\n13:00', '2009/7/4\n14:00', '2009/7/4\n15:00', '2009/7/4\n16:00', '2009/7/4\n17:00', '2009/7/4\n18:00', '2009/7/4\n19:00', '2009/7/4\n20:00', '2009/7/4\n21:00', '2009/7/4\n22:00', '2009/7/4\n23:00', '2009/7/5\n0:00', '2009/7/5\n1:00', '2009/7/5\n2:00', '2009/7/5\n3:00', '2009/7/5\n4:00', '2009/7/5\n5:00', '2009/7/5\n6:00', '2009/7/5\n7:00', '2009/7/5\n8:00', '2009/7/5\n9:00', '2009/7/5\n10:00', '2009/7/5\n11:00', '2009/7/5\n12:00', '2009/7/5\n13:00', '2009/7/5\n14:00', '2009/7/5\n15:00', '2009/7/5\n16:00', '2009/7/5\n17:00', '2009/7/5\n18:00', '2009/7/5\n19:00', '2009/7/5\n20:00', '2009/7/5\n21:00', '2009/7/5\n22:00', '2009/7/5\n23:00', '2009/7/6\n0:00', '2009/7/6\n1:00', '2009/7/6\n2:00', '2009/7/6\n3:00', '2009/7/6\n4:00', '2009/7/6\n5:00', '2009/7/6\n6:00', '2009/7/6\n7:00', '2009/7/6\n8:00', '2009/7/6\n9:00', '2009/7/6\n10:00', '2009/7/6\n11:00', '2009/7/6\n12:00', '2009/7/6\n13:00', '2009/7/6\n14:00', '2009/7/6\n15:00', '2009/7/6\n16:00', '2009/7/6\n17:00', '2009/7/6\n18:00', '2009/7/6\n19:00', '2009/7/6\n20:00', '2009/7/6\n21:00', '2009/7/6\n22:00', '2009/7/6\n23:00', '2009/7/7\n0:00', '2009/7/7\n1:00', '2009/7/7\n2:00', '2009/7/7\n3:00', '2009/7/7\n4:00', '2009/7/7\n5:00', '2009/7/7\n6:00', '2009/7/7\n7:00', '2009/7/7\n8:00', '2009/7/7\n9:00', '2009/7/7\n10:00', '2009/7/7\n11:00', '2009/7/7\n12:00', '2009/7/7\n13:00', '2009/7/7\n14:00', '2009/7/7\n15:00', '2009/7/7\n16:00', '2009/7/7\n17:00', '2009/7/7\n18:00', '2009/7/7\n19:00', '2009/7/7\n20:00', '2009/7/7\n21:00', '2009/7/7\n22:00', '2009/7/7\n23:00', '2009/7/8\n0:00', '2009/7/8\n1:00', '2009/7/8\n2:00', '2009/7/8\n3:00', '2009/7/8\n4:00', '2009/7/8\n5:00', '2009/7/8\n6:00', '2009/7/8\n7:00', '2009/7/8\n8:00', '2009/7/8\n9:00', '2009/7/8\n10:00', '2009/7/8\n11:00', '2009/7/8\n12:00', '2009/7/8\n13:00', '2009/7/8\n14:00', '2009/7/8\n15:00', '2009/7/8\n16:00', '2009/7/8\n17:00', '2009/7/8\n18:00', '2009/7/8\n19:00', '2009/7/8\n20:00', '2009/7/8\n21:00', '2009/7/8\n22:00', '2009/7/8\n23:00', '2009/7/9\n0:00', '2009/7/9\n1:00', '2009/7/9\n2:00', '2009/7/9\n3:00', '2009/7/9\n4:00', '2009/7/9\n5:00', '2009/7/9\n6:00', '2009/7/9\n7:00', '2009/7/9\n8:00', '2009/7/9\n9:00', '2009/7/9\n10:00', '2009/7/9\n11:00', '2009/7/9\n12:00', '2009/7/9\n13:00', '2009/7/9\n14:00', '2009/7/9\n15:00', '2009/7/9\n16:00', '2009/7/9\n17:00', '2009/7/9\n18:00', '2009/7/9\n19:00', '2009/7/9\n20:00', '2009/7/9\n21:00', '2009/7/9\n22:00', '2009/7/9\n23:00', '2009/7/10\n0:00', '2009/7/10\n1:00', '2009/7/10\n2:00', '2009/7/10\n3:00', '2009/7/10\n4:00', '2009/7/10\n5:00', '2009/7/10\n6:00', '2009/7/10\n7:00', '2009/7/10\n8:00', '2009/7/10\n9:00', '2009/7/10\n10:00', '2009/7/10\n11:00', '2009/7/10\n12:00', '2009/7/10\n13:00', '2009/7/10\n14:00', '2009/7/10\n15:00', '2009/7/10\n16:00', '2009/7/10\n17:00', '2009/7/10\n18:00', '2009/7/10\n19:00', '2009/7/10\n20:00', '2009/7/10\n21:00', '2009/7/10\n22:00', '2009/7/10\n23:00', '2009/7/11\n0:00', '2009/7/11\n1:00', '2009/7/11\n2:00', '2009/7/11\n3:00', '2009/7/11\n4:00', '2009/7/11\n5:00', '2009/7/11\n6:00', '2009/7/11\n7:00', '2009/7/11\n8:00', '2009/7/11\n9:00', '2009/7/11\n10:00', '2009/7/11\n11:00', '2009/7/11\n12:00', '2009/7/11\n13:00', '2009/7/11\n14:00', '2009/7/11\n15:00', '2009/7/11\n16:00', '2009/7/11\n17:00', '2009/7/11\n18:00', '2009/7/11\n19:00', '2009/7/11\n20:00', '2009/7/11\n21:00', '2009/7/11\n22:00', '2009/7/11\n23:00', '2009/7/12\n0:00', '2009/7/12\n1:00', '2009/7/12\n2:00', '2009/7/12\n3:00', '2009/7/12\n4:00', '2009/7/12\n5:00', '2009/7/12\n6:00', '2009/7/12\n7:00', '2009/7/12\n8:00', '2009/7/12\n9:00', '2009/7/12\n10:00', '2009/7/12\n11:00', '2009/7/12\n12:00', '2009/7/12\n13:00', '2009/7/12\n14:00', '2009/7/12\n15:00', '2009/7/12\n16:00', '2009/7/12\n17:00', '2009/7/12\n18:00', '2009/7/12\n19:00', '2009/7/12\n20:00', '2009/7/12\n21:00', '2009/7/12\n22:00', '2009/7/12\n23:00', '2009/7/13\n0:00', '2009/7/13\n1:00', '2009/7/13\n2:00', '2009/7/13\n3:00', '2009/7/13\n4:00', '2009/7/13\n5:00', '2009/7/13\n6:00', '2009/7/13\n7:00', '2009/7/13\n8:00', '2009/7/13\n9:00', '2009/7/13\n10:00', '2009/7/13\n11:00', '2009/7/13\n12:00', '2009/7/13\n13:00', '2009/7/13\n14:00', '2009/7/13\n15:00', '2009/7/13\n16:00', '2009/7/13\n17:00', '2009/7/13\n18:00', '2009/7/13\n19:00', '2009/7/13\n20:00', '2009/7/13\n21:00', '2009/7/13\n22:00', '2009/7/13\n23:00', '2009/7/14\n0:00', '2009/7/14\n1:00', '2009/7/14\n2:00', '2009/7/14\n3:00', '2009/7/14\n4:00', '2009/7/14\n5:00', '2009/7/14\n6:00', '2009/7/14\n7:00', '2009/7/14\n8:00', '2009/7/14\n9:00', '2009/7/14\n10:00', '2009/7/14\n11:00', '2009/7/14\n12:00', '2009/7/14\n13:00', '2009/7/14\n14:00', '2009/7/14\n15:00', '2009/7/14\n16:00', '2009/7/14\n17:00', '2009/7/14\n18:00', '2009/7/14\n19:00', '2009/7/14\n20:00', '2009/7/14\n21:00', '2009/7/14\n22:00', '2009/7/14\n23:00', '2009/7/15\n0:00', '2009/7/15\n1:00', '2009/7/15\n2:00', '2009/7/15\n3:00', '2009/7/15\n4:00', '2009/7/15\n5:00', '2009/7/15\n6:00', '2009/7/15\n7:00', '2009/7/15\n8:00', '2009/7/15\n9:00', '2009/7/15\n10:00', '2009/7/15\n11:00', '2009/7/15\n12:00', '2009/7/15\n13:00', '2009/7/15\n14:00', '2009/7/15\n15:00', '2009/7/15\n16:00', '2009/7/15\n17:00', '2009/7/15\n18:00', '2009/7/15\n19:00', '2009/7/15\n20:00', '2009/7/15\n21:00', '2009/7/15\n22:00', '2009/7/15\n23:00', '2009/7/16\n0:00', '2009/7/16\n1:00', '2009/7/16\n2:00', '2009/7/16\n3:00', '2009/7/16\n4:00', '2009/7/16\n5:00', '2009/7/16\n6:00', '2009/7/16\n7:00', '2009/7/16\n8:00', '2009/7/16\n9:00', '2009/7/16\n10:00', '2009/7/16\n11:00', '2009/7/16\n12:00', '2009/7/16\n13:00', '2009/7/16\n14:00', '2009/7/16\n15:00', '2009/7/16\n16:00', '2009/7/16\n17:00', '2009/7/16\n18:00', '2009/7/16\n19:00', '2009/7/16\n20:00', '2009/7/16\n21:00', '2009/7/16\n22:00', '2009/7/16\n23:00', '2009/7/17\n0:00', '2009/7/17\n1:00', '2009/7/17\n2:00', '2009/7/17\n3:00', '2009/7/17\n4:00', '2009/7/17\n5:00', '2009/7/17\n6:00', '2009/7/17\n7:00', '2009/7/17\n8:00', '2009/7/17\n9:00', '2009/7/17\n10:00', '2009/7/17\n11:00', '2009/7/17\n12:00', '2009/7/17\n13:00', '2009/7/17\n14:00', '2009/7/17\n15:00', '2009/7/17\n16:00', '2009/7/17\n17:00', '2009/7/17\n18:00', '2009/7/17\n19:00', '2009/7/17\n20:00', '2009/7/17\n21:00', '2009/7/17\n22:00', '2009/7/17\n23:00', '2009/7/18\n0:00', '2009/7/18\n1:00', '2009/7/18\n2:00', '2009/7/18\n3:00', '2009/7/18\n4:00', '2009/7/18\n5:00', '2009/7/18\n6:00', '2009/7/18\n7:00', '2009/7/18\n8:00', '2009/7/18\n9:00', '2009/7/18\n10:00', '2009/7/18\n11:00', '2009/7/18\n12:00', '2009/7/18\n13:00', '2009/7/18\n14:00', '2009/7/18\n15:00', '2009/7/18\n16:00', '2009/7/18\n17:00', '2009/7/18\n18:00', '2009/7/18\n19:00', '2009/7/18\n20:00', '2009/7/18\n21:00', '2009/7/18\n22:00', '2009/7/18\n23:00', '2009/7/19\n0:00', '2009/7/19\n1:00', '2009/7/19\n2:00', '2009/7/19\n3:00', '2009/7/19\n4:00', '2009/7/19\n5:00', '2009/7/19\n6:00', '2009/7/19\n7:00', '2009/7/19\n8:00', '2009/7/19\n9:00', '2009/7/19\n10:00', '2009/7/19\n11:00', '2009/7/19\n12:00', '2009/7/19\n13:00', '2009/7/19\n14:00', '2009/7/19\n15:00', '2009/7/19\n16:00', '2009/7/19\n17:00', '2009/7/19\n18:00', '2009/7/19\n19:00', '2009/7/19\n20:00', '2009/7/19\n21:00', '2009/7/19\n22:00', '2009/7/19\n23:00', '2009/7/20\n0:00', '2009/7/20\n1:00', '2009/7/20\n2:00', '2009/7/20\n3:00', '2009/7/20\n4:00', '2009/7/20\n5:00', '2009/7/20\n6:00', '2009/7/20\n7:00', '2009/7/20\n8:00', '2009/7/20\n9:00', '2009/7/20\n10:00', '2009/7/20\n11:00', '2009/7/20\n12:00', '2009/7/20\n13:00', '2009/7/20\n14:00', '2009/7/20\n15:00', '2009/7/20\n16:00', '2009/7/20\n17:00', '2009/7/20\n18:00', '2009/7/20\n19:00', '2009/7/20\n20:00', '2009/7/20\n21:00', '2009/7/20\n22:00', '2009/7/20\n23:00', '2009/7/21\n0:00', '2009/7/21\n1:00', '2009/7/21\n2:00', '2009/7/21\n3:00', '2009/7/21\n4:00', '2009/7/21\n5:00', '2009/7/21\n6:00', '2009/7/21\n7:00', '2009/7/21\n8:00', '2009/7/21\n9:00', '2009/7/21\n10:00', '2009/7/21\n11:00', '2009/7/21\n12:00', '2009/7/21\n13:00', '2009/7/21\n14:00', '2009/7/21\n15:00', '2009/7/21\n16:00', '2009/7/21\n17:00', '2009/7/21\n18:00', '2009/7/21\n19:00', '2009/7/21\n20:00', '2009/7/21\n21:00', '2009/7/21\n22:00', '2009/7/21\n23:00', '2009/7/22\n0:00', '2009/7/22\n1:00', '2009/7/22\n2:00', '2009/7/22\n3:00', '2009/7/22\n4:00', '2009/7/22\n5:00', '2009/7/22\n6:00', '2009/7/22\n7:00', '2009/7/22\n8:00', '2009/7/22\n9:00', '2009/7/22\n10:00', '2009/7/22\n11:00', '2009/7/22\n12:00', '2009/7/22\n13:00', '2009/7/22\n14:00', '2009/7/22\n15:00', '2009/7/22\n16:00', '2009/7/22\n17:00', '2009/7/22\n18:00', '2009/7/22\n19:00', '2009/7/22\n20:00', '2009/7/22\n21:00', '2009/7/22\n22:00', '2009/7/22\n23:00', '2009/7/23\n0:00', '2009/7/23\n1:00', '2009/7/23\n2:00', '2009/7/23\n3:00', '2009/7/23\n4:00', '2009/7/23\n5:00', '2009/7/23\n6:00', '2009/7/23\n7:00', '2009/7/23\n8:00', '2009/7/23\n9:00', '2009/7/23\n10:00', '2009/7/23\n11:00', '2009/7/23\n12:00', '2009/7/23\n13:00', '2009/7/23\n14:00', '2009/7/23\n15:00', '2009/7/23\n16:00', '2009/7/23\n17:00', '2009/7/23\n18:00', '2009/7/23\n19:00', '2009/7/23\n20:00', '2009/7/23\n21:00', '2009/7/23\n22:00', '2009/7/23\n23:00', '2009/7/24\n0:00', '2009/7/24\n1:00', '2009/7/24\n2:00', '2009/7/24\n3:00', '2009/7/24\n4:00', '2009/7/24\n5:00', '2009/7/24\n6:00', '2009/7/24\n7:00', '2009/7/24\n8:00', '2009/7/24\n9:00', '2009/7/24\n10:00', '2009/7/24\n11:00', '2009/7/24\n12:00', '2009/7/24\n13:00', '2009/7/24\n14:00', '2009/7/24\n15:00', '2009/7/24\n16:00', '2009/7/24\n17:00', '2009/7/24\n18:00', '2009/7/24\n19:00', '2009/7/24\n20:00', '2009/7/24\n21:00', '2009/7/24\n22:00', '2009/7/24\n23:00', '2009/7/25\n0:00', '2009/7/25\n1:00', '2009/7/25\n2:00', '2009/7/25\n3:00', '2009/7/25\n4:00', '2009/7/25\n5:00', '2009/7/25\n6:00', '2009/7/25\n7:00', '2009/7/25\n8:00', '2009/7/25\n9:00', '2009/7/25\n10:00', '2009/7/25\n11:00', '2009/7/25\n12:00', '2009/7/25\n13:00', '2009/7/25\n14:00', '2009/7/25\n15:00', '2009/7/25\n16:00', '2009/7/25\n17:00', '2009/7/25\n18:00', '2009/7/25\n19:00', '2009/7/25\n20:00', '2009/7/25\n21:00', '2009/7/25\n22:00', '2009/7/25\n23:00', '2009/7/26\n0:00', '2009/7/26\n1:00', '2009/7/26\n2:00', '2009/7/26\n3:00', '2009/7/26\n4:00', '2009/7/26\n5:00', '2009/7/26\n6:00', '2009/7/26\n7:00', '2009/7/26\n8:00', '2009/7/26\n9:00', '2009/7/26\n10:00', '2009/7/26\n11:00', '2009/7/26\n12:00', '2009/7/26\n13:00', '2009/7/26\n14:00', '2009/7/26\n15:00', '2009/7/26\n16:00', '2009/7/26\n17:00', '2009/7/26\n18:00', '2009/7/26\n19:00', '2009/7/26\n20:00', '2009/7/26\n21:00', '2009/7/26\n22:00', '2009/7/26\n23:00', '2009/7/27\n0:00', '2009/7/27\n1:00', '2009/7/27\n2:00', '2009/7/27\n3:00', '2009/7/27\n4:00', '2009/7/27\n5:00', '2009/7/27\n6:00', '2009/7/27\n7:00', '2009/7/27\n8:00', '2009/7/27\n9:00', '2009/7/27\n10:00', '2009/7/27\n11:00', '2009/7/27\n12:00', '2009/7/27\n13:00', '2009/7/27\n14:00', '2009/7/27\n15:00', '2009/7/27\n16:00', '2009/7/27\n17:00', '2009/7/27\n18:00', '2009/7/27\n19:00', '2009/7/27\n20:00', '2009/7/27\n21:00', '2009/7/27\n22:00', '2009/7/27\n23:00', '2009/7/28\n0:00', '2009/7/28\n1:00', '2009/7/28\n2:00', '2009/7/28\n3:00', '2009/7/28\n4:00', '2009/7/28\n5:00', '2009/7/28\n6:00', '2009/7/28\n7:00', '2009/7/28\n8:00', '2009/7/28\n9:00', '2009/7/28\n10:00', '2009/7/28\n11:00', '2009/7/28\n12:00', '2009/7/28\n13:00', '2009/7/28\n14:00', '2009/7/28\n15:00', '2009/7/28\n16:00', '2009/7/28\n17:00', '2009/7/28\n18:00', '2009/7/28\n19:00', '2009/7/28\n20:00', '2009/7/28\n21:00', '2009/7/28\n22:00', '2009/7/28\n23:00', '2009/7/29\n0:00', '2009/7/29\n1:00', '2009/7/29\n2:00', '2009/7/29\n3:00', '2009/7/29\n4:00', '2009/7/29\n5:00', '2009/7/29\n6:00', '2009/7/29\n7:00', '2009/7/29\n8:00', '2009/7/29\n9:00', '2009/7/29\n10:00', '2009/7/29\n11:00', '2009/7/29\n12:00', '2009/7/29\n13:00', '2009/7/29\n14:00', '2009/7/29\n15:00', '2009/7/29\n16:00', '2009/7/29\n17:00', '2009/7/29\n18:00', '2009/7/29\n19:00', '2009/7/29\n20:00', '2009/7/29\n21:00', '2009/7/29\n22:00', '2009/7/29\n23:00', '2009/7/30\n0:00', '2009/7/30\n1:00', '2009/7/30\n2:00', '2009/7/30\n3:00', '2009/7/30\n4:00', '2009/7/30\n5:00', '2009/7/30\n6:00', '2009/7/30\n7:00', '2009/7/30\n8:00', '2009/7/30\n9:00', '2009/7/30\n10:00', '2009/7/30\n11:00', '2009/7/30\n12:00', '2009/7/30\n13:00', '2009/7/30\n14:00', '2009/7/30\n15:00', '2009/7/30\n16:00', '2009/7/30\n17:00', '2009/7/30\n18:00', '2009/7/30\n19:00', '2009/7/30\n20:00', '2009/7/30\n21:00', '2009/7/30\n22:00', '2009/7/30\n23:00', '2009/7/31\n0:00', '2009/7/31\n1:00', '2009/7/31\n2:00', '2009/7/31\n3:00', '2009/7/31\n4:00', '2009/7/31\n5:00', '2009/7/31\n6:00', '2009/7/31\n7:00', '2009/7/31\n8:00', '2009/7/31\n9:00', '2009/7/31\n10:00', '2009/7/31\n11:00', '2009/7/31\n12:00', '2009/7/31\n13:00', '2009/7/31\n14:00', '2009/7/31\n15:00', '2009/7/31\n16:00', '2009/7/31\n17:00', '2009/7/31\n18:00', '2009/7/31\n19:00', '2009/7/31\n20:00', '2009/7/31\n21:00', '2009/7/31\n22:00', '2009/7/31\n23:00', '2009/8/1\n0:00', '2009/8/1\n1:00', '2009/8/1\n2:00', '2009/8/1\n3:00', '2009/8/1\n4:00', '2009/8/1\n5:00', '2009/8/1\n6:00', '2009/8/1\n7:00', '2009/8/1\n8:00', '2009/8/1\n9:00', '2009/8/1\n10:00', '2009/8/1\n11:00', '2009/8/1\n12:00', '2009/8/1\n13:00', '2009/8/1\n14:00', '2009/8/1\n15:00', '2009/8/1\n16:00', '2009/8/1\n17:00', '2009/8/1\n18:00', '2009/8/1\n19:00', '2009/8/1\n20:00', '2009/8/1\n21:00', '2009/8/1\n22:00', '2009/8/1\n23:00', '2009/8/2\n0:00', '2009/8/2\n1:00', '2009/8/2\n2:00', '2009/8/2\n3:00', '2009/8/2\n4:00', '2009/8/2\n5:00', '2009/8/2\n6:00', '2009/8/2\n7:00', '2009/8/2\n8:00', '2009/8/2\n9:00', '2009/8/2\n10:00', '2009/8/2\n11:00', '2009/8/2\n12:00', '2009/8/2\n13:00', '2009/8/2\n14:00', '2009/8/2\n15:00', '2009/8/2\n16:00', '2009/8/2\n17:00', '2009/8/2\n18:00', '2009/8/2\n19:00', '2009/8/2\n20:00', '2009/8/2\n21:00', '2009/8/2\n22:00', '2009/8/2\n23:00', '2009/8/3\n0:00', '2009/8/3\n1:00', '2009/8/3\n2:00', '2009/8/3\n3:00', '2009/8/3\n4:00', '2009/8/3\n5:00', '2009/8/3\n6:00', '2009/8/3\n7:00', '2009/8/3\n8:00', '2009/8/3\n9:00', '2009/8/3\n10:00', '2009/8/3\n11:00', '2009/8/3\n12:00', '2009/8/3\n13:00', '2009/8/3\n14:00', '2009/8/3\n15:00', '2009/8/3\n16:00', '2009/8/3\n17:00', '2009/8/3\n18:00', '2009/8/3\n19:00', '2009/8/3\n20:00', '2009/8/3\n21:00', '2009/8/3\n22:00', '2009/8/3\n23:00', '2009/8/4\n0:00', '2009/8/4\n1:00', '2009/8/4\n2:00', '2009/8/4\n3:00', '2009/8/4\n4:00', '2009/8/4\n5:00', '2009/8/4\n6:00', '2009/8/4\n7:00', '2009/8/4\n8:00', '2009/8/4\n9:00', '2009/8/4\n10:00', '2009/8/4\n11:00', '2009/8/4\n12:00', '2009/8/4\n13:00', '2009/8/4\n14:00', '2009/8/4\n15:00', '2009/8/4\n16:00', '2009/8/4\n17:00', '2009/8/4\n18:00', '2009/8/4\n19:00', '2009/8/4\n20:00', '2009/8/4\n21:00', '2009/8/4\n22:00', '2009/8/4\n23:00', '2009/8/5\n0:00', '2009/8/5\n1:00', '2009/8/5\n2:00', '2009/8/5\n3:00', '2009/8/5\n4:00', '2009/8/5\n5:00', '2009/8/5\n6:00', '2009/8/5\n7:00', '2009/8/5\n8:00', '2009/8/5\n9:00', '2009/8/5\n10:00', '2009/8/5\n11:00', '2009/8/5\n12:00', '2009/8/5\n13:00', '2009/8/5\n14:00', '2009/8/5\n15:00', '2009/8/5\n16:00', '2009/8/5\n17:00', '2009/8/5\n18:00', '2009/8/5\n19:00', '2009/8/5\n20:00', '2009/8/5\n21:00', '2009/8/5\n22:00', '2009/8/5\n23:00', '2009/8/6\n0:00', '2009/8/6\n1:00', '2009/8/6\n2:00', '2009/8/6\n3:00', '2009/8/6\n4:00', '2009/8/6\n5:00', '2009/8/6\n6:00', '2009/8/6\n7:00', '2009/8/6\n8:00', '2009/8/6\n9:00', '2009/8/6\n10:00', '2009/8/6\n11:00', '2009/8/6\n12:00', '2009/8/6\n13:00', '2009/8/6\n14:00', '2009/8/6\n15:00', '2009/8/6\n16:00', '2009/8/6\n17:00', '2009/8/6\n18:00', '2009/8/6\n19:00', '2009/8/6\n20:00', '2009/8/6\n21:00', '2009/8/6\n22:00', '2009/8/6\n23:00', '2009/8/7\n0:00', '2009/8/7\n1:00', '2009/8/7\n2:00', '2009/8/7\n3:00', '2009/8/7\n4:00', '2009/8/7\n5:00', '2009/8/7\n6:00', '2009/8/7\n7:00', '2009/8/7\n8:00', '2009/8/7\n9:00', '2009/8/7\n10:00', '2009/8/7\n11:00', '2009/8/7\n12:00', '2009/8/7\n13:00', '2009/8/7\n14:00', '2009/8/7\n15:00', '2009/8/7\n16:00', '2009/8/7\n17:00', '2009/8/7\n18:00', '2009/8/7\n19:00', '2009/8/7\n20:00', '2009/8/7\n21:00', '2009/8/7\n22:00', '2009/8/7\n23:00', '2009/8/8\n0:00', '2009/8/8\n1:00', '2009/8/8\n2:00', '2009/8/8\n3:00', '2009/8/8\n4:00', '2009/8/8\n5:00', '2009/8/8\n6:00', '2009/8/8\n7:00', '2009/8/8\n8:00', '2009/8/8\n9:00', '2009/8/8\n10:00', '2009/8/8\n11:00', '2009/8/8\n12:00', '2009/8/8\n13:00', '2009/8/8\n14:00', '2009/8/8\n15:00', '2009/8/8\n16:00', '2009/8/8\n17:00', '2009/8/8\n18:00', '2009/8/8\n19:00', '2009/8/8\n20:00', '2009/8/8\n21:00', '2009/8/8\n22:00', '2009/8/8\n23:00', '2009/8/9\n0:00', '2009/8/9\n1:00', '2009/8/9\n2:00', '2009/8/9\n3:00', '2009/8/9\n4:00', '2009/8/9\n5:00', '2009/8/9\n6:00', '2009/8/9\n7:00', '2009/8/9\n8:00', '2009/8/9\n9:00', '2009/8/9\n10:00', '2009/8/9\n11:00', '2009/8/9\n12:00', '2009/8/9\n13:00', '2009/8/9\n14:00', '2009/8/9\n15:00', '2009/8/9\n16:00', '2009/8/9\n17:00', '2009/8/9\n18:00', '2009/8/9\n19:00', '2009/8/9\n20:00', '2009/8/9\n21:00', '2009/8/9\n22:00', '2009/8/9\n23:00', '2009/8/10\n0:00', '2009/8/10\n1:00', '2009/8/10\n2:00', '2009/8/10\n3:00', '2009/8/10\n4:00', '2009/8/10\n5:00', '2009/8/10\n6:00', '2009/8/10\n7:00', '2009/8/10\n8:00', '2009/8/10\n9:00', '2009/8/10\n10:00', '2009/8/10\n11:00', '2009/8/10\n12:00', '2009/8/10\n13:00', '2009/8/10\n14:00', '2009/8/10\n15:00', '2009/8/10\n16:00', '2009/8/10\n17:00', '2009/8/10\n18:00', '2009/8/10\n19:00', '2009/8/10\n20:00', '2009/8/10\n21:00', '2009/8/10\n22:00', '2009/8/10\n23:00', '2009/8/11\n0:00', '2009/8/11\n1:00', '2009/8/11\n2:00', '2009/8/11\n3:00', '2009/8/11\n4:00', '2009/8/11\n5:00', '2009/8/11\n6:00', '2009/8/11\n7:00', '2009/8/11\n8:00', '2009/8/11\n9:00', '2009/8/11\n10:00', '2009/8/11\n11:00', '2009/8/11\n12:00', '2009/8/11\n13:00', '2009/8/11\n14:00', '2009/8/11\n15:00', '2009/8/11\n16:00', '2009/8/11\n17:00', '2009/8/11\n18:00', '2009/8/11\n19:00', '2009/8/11\n20:00', '2009/8/11\n21:00', '2009/8/11\n22:00', '2009/8/11\n23:00', '2009/8/12\n0:00', '2009/8/12\n1:00', '2009/8/12\n2:00', '2009/8/12\n3:00', '2009/8/12\n4:00', '2009/8/12\n5:00', '2009/8/12\n6:00', '2009/8/12\n7:00', '2009/8/12\n8:00', '2009/8/12\n9:00', '2009/8/12\n10:00', '2009/8/12\n11:00', '2009/8/12\n12:00', '2009/8/12\n13:00', '2009/8/12\n14:00', '2009/8/12\n15:00', '2009/8/12\n16:00', '2009/8/12\n17:00', '2009/8/12\n18:00', '2009/8/12\n19:00', '2009/8/12\n20:00', '2009/8/12\n21:00', '2009/8/12\n22:00', '2009/8/12\n23:00', '2009/8/13\n0:00', '2009/8/13\n1:00', '2009/8/13\n2:00', '2009/8/13\n3:00', '2009/8/13\n4:00', '2009/8/13\n5:00', '2009/8/13\n6:00', '2009/8/13\n7:00', '2009/8/13\n8:00', '2009/8/13\n9:00', '2009/8/13\n10:00', '2009/8/13\n11:00', '2009/8/13\n12:00', '2009/8/13\n13:00', '2009/8/13\n14:00', '2009/8/13\n15:00', '2009/8/13\n16:00', '2009/8/13\n17:00', '2009/8/13\n18:00', '2009/8/13\n19:00', '2009/8/13\n20:00', '2009/8/13\n21:00', '2009/8/13\n22:00', '2009/8/13\n23:00', '2009/8/14\n0:00', '2009/8/14\n1:00', '2009/8/14\n2:00', '2009/8/14\n3:00', '2009/8/14\n4:00', '2009/8/14\n5:00', '2009/8/14\n6:00', '2009/8/14\n7:00', '2009/8/14\n8:00', '2009/8/14\n9:00', '2009/8/14\n10:00', '2009/8/14\n11:00', '2009/8/14\n12:00', '2009/8/14\n13:00', '2009/8/14\n14:00', '2009/8/14\n15:00', '2009/8/14\n16:00', '2009/8/14\n17:00', '2009/8/14\n18:00', '2009/8/14\n19:00', '2009/8/14\n20:00', '2009/8/14\n21:00', '2009/8/14\n22:00', '2009/8/14\n23:00', '2009/8/15\n0:00', '2009/8/15\n1:00', '2009/8/15\n2:00', '2009/8/15\n3:00', '2009/8/15\n4:00', '2009/8/15\n5:00', '2009/8/15\n6:00', '2009/8/15\n7:00', '2009/8/15\n8:00', '2009/8/15\n9:00', '2009/8/15\n10:00', '2009/8/15\n11:00', '2009/8/15\n12:00', '2009/8/15\n13:00', '2009/8/15\n14:00', '2009/8/15\n15:00', '2009/8/15\n16:00', '2009/8/15\n17:00', '2009/8/15\n18:00', '2009/8/15\n19:00', '2009/8/15\n20:00', '2009/8/15\n21:00', '2009/8/15\n22:00', '2009/8/15\n23:00', '2009/8/16\n0:00', '2009/8/16\n1:00', '2009/8/16\n2:00', '2009/8/16\n3:00', '2009/8/16\n4:00', '2009/8/16\n5:00', '2009/8/16\n6:00', '2009/8/16\n7:00', '2009/8/16\n8:00', '2009/8/16\n9:00', '2009/8/16\n10:00', '2009/8/16\n11:00', '2009/8/16\n12:00', '2009/8/16\n13:00', '2009/8/16\n14:00', '2009/8/16\n15:00', '2009/8/16\n16:00', '2009/8/16\n17:00', '2009/8/16\n18:00', '2009/8/16\n19:00', '2009/8/16\n20:00', '2009/8/16\n21:00', '2009/8/16\n22:00', '2009/8/16\n23:00', '2009/8/17\n0:00', '2009/8/17\n1:00', '2009/8/17\n2:00', '2009/8/17\n3:00', '2009/8/17\n4:00', '2009/8/17\n5:00', '2009/8/17\n6:00', '2009/8/17\n7:00', '2009/8/17\n8:00', '2009/8/17\n9:00', '2009/8/17\n10:00', '2009/8/17\n11:00', '2009/8/17\n12:00', '2009/8/17\n13:00', '2009/8/17\n14:00', '2009/8/17\n15:00', '2009/8/17\n16:00', '2009/8/17\n17:00', '2009/8/17\n18:00', '2009/8/17\n19:00', '2009/8/17\n20:00', '2009/8/17\n21:00', '2009/8/17\n22:00', '2009/8/17\n23:00', '2009/8/18\n0:00', '2009/8/18\n1:00', '2009/8/18\n2:00', '2009/8/18\n3:00', '2009/8/18\n4:00', '2009/8/18\n5:00', '2009/8/18\n6:00', '2009/8/18\n7:00', '2009/8/18\n8:00', '2009/8/18\n9:00', '2009/8/18\n10:00', '2009/8/18\n11:00', '2009/8/18\n12:00', '2009/8/18\n13:00', '2009/8/18\n14:00', '2009/8/18\n15:00', '2009/8/18\n16:00', '2009/8/18\n17:00', '2009/8/18\n18:00', '2009/8/18\n19:00', '2009/8/18\n20:00', '2009/8/18\n21:00', '2009/8/18\n22:00', '2009/8/18\n23:00', '2009/8/19\n0:00', '2009/8/19\n1:00', '2009/8/19\n2:00', '2009/8/19\n3:00', '2009/8/19\n4:00', '2009/8/19\n5:00', '2009/8/19\n6:00', '2009/8/19\n7:00', '2009/8/19\n8:00', '2009/8/19\n9:00', '2009/8/19\n10:00', '2009/8/19\n11:00', '2009/8/19\n12:00', '2009/8/19\n13:00', '2009/8/19\n14:00', '2009/8/19\n15:00', '2009/8/19\n16:00', '2009/8/19\n17:00', '2009/8/19\n18:00', '2009/8/19\n19:00', '2009/8/19\n20:00', '2009/8/19\n21:00', '2009/8/19\n22:00', '2009/8/19\n23:00', '2009/8/20\n0:00', '2009/8/20\n1:00', '2009/8/20\n2:00', '2009/8/20\n3:00', '2009/8/20\n4:00', '2009/8/20\n5:00', '2009/8/20\n6:00', '2009/8/20\n7:00', '2009/8/20\n8:00', '2009/8/20\n9:00', '2009/8/20\n10:00', '2009/8/20\n11:00', '2009/8/20\n12:00', '2009/8/20\n13:00', '2009/8/20\n14:00', '2009/8/20\n15:00', '2009/8/20\n16:00', '2009/8/20\n17:00', '2009/8/20\n18:00', '2009/8/20\n19:00', '2009/8/20\n20:00', '2009/8/20\n21:00', '2009/8/20\n22:00', '2009/8/20\n23:00', '2009/8/21\n0:00', '2009/8/21\n1:00', '2009/8/21\n2:00', '2009/8/21\n3:00', '2009/8/21\n4:00', '2009/8/21\n5:00', '2009/8/21\n6:00', '2009/8/21\n7:00', '2009/8/21\n8:00', '2009/8/21\n9:00', '2009/8/21\n10:00', '2009/8/21\n11:00', '2009/8/21\n12:00', '2009/8/21\n13:00', '2009/8/21\n14:00', '2009/8/21\n15:00', '2009/8/21\n16:00', '2009/8/21\n17:00', '2009/8/21\n18:00', '2009/8/21\n19:00', '2009/8/21\n20:00', '2009/8/21\n21:00', '2009/8/21\n22:00', '2009/8/21\n23:00', '2009/8/22\n0:00', '2009/8/22\n1:00', '2009/8/22\n2:00', '2009/8/22\n3:00', '2009/8/22\n4:00', '2009/8/22\n5:00', '2009/8/22\n6:00', '2009/8/22\n7:00', '2009/8/22\n8:00', '2009/8/22\n9:00', '2009/8/22\n10:00', '2009/8/22\n11:00', '2009/8/22\n12:00', '2009/8/22\n13:00', '2009/8/22\n14:00', '2009/8/22\n15:00', '2009/8/22\n16:00', '2009/8/22\n17:00', '2009/8/22\n18:00', '2009/8/22\n19:00', '2009/8/22\n20:00', '2009/8/22\n21:00', '2009/8/22\n22:00', '2009/8/22\n23:00', '2009/8/23\n0:00', '2009/8/23\n1:00', '2009/8/23\n2:00', '2009/8/23\n3:00', '2009/8/23\n4:00', '2009/8/23\n5:00', '2009/8/23\n6:00', '2009/8/23\n7:00', '2009/8/23\n8:00', '2009/8/23\n9:00', '2009/8/23\n10:00', '2009/8/23\n11:00', '2009/8/23\n12:00', '2009/8/23\n13:00', '2009/8/23\n14:00', '2009/8/23\n15:00', '2009/8/23\n16:00', '2009/8/23\n17:00', '2009/8/23\n18:00', '2009/8/23\n19:00', '2009/8/23\n20:00', '2009/8/23\n21:00', '2009/8/23\n22:00', '2009/8/23\n23:00', '2009/8/24\n0:00', '2009/8/24\n1:00', '2009/8/24\n2:00', '2009/8/24\n3:00', '2009/8/24\n4:00', '2009/8/24\n5:00', '2009/8/24\n6:00', '2009/8/24\n7:00', '2009/8/24\n8:00', '2009/8/24\n9:00', '2009/8/24\n10:00', '2009/8/24\n11:00', '2009/8/24\n12:00', '2009/8/24\n13:00', '2009/8/24\n14:00', '2009/8/24\n15:00', '2009/8/24\n16:00', '2009/8/24\n17:00', '2009/8/24\n18:00', '2009/8/24\n19:00', '2009/8/24\n20:00', '2009/8/24\n21:00', '2009/8/24\n22:00', '2009/8/24\n23:00', '2009/8/25\n0:00', '2009/8/25\n1:00', '2009/8/25\n2:00', '2009/8/25\n3:00', '2009/8/25\n4:00', '2009/8/25\n5:00', '2009/8/25\n6:00', '2009/8/25\n7:00', '2009/8/25\n8:00', '2009/8/25\n9:00', '2009/8/25\n10:00', '2009/8/25\n11:00', '2009/8/25\n12:00', '2009/8/25\n13:00', '2009/8/25\n14:00', '2009/8/25\n15:00', '2009/8/25\n16:00', '2009/8/25\n17:00', '2009/8/25\n18:00', '2009/8/25\n19:00', '2009/8/25\n20:00', '2009/8/25\n21:00', '2009/8/25\n22:00', '2009/8/25\n23:00', '2009/8/26\n0:00', '2009/8/26\n1:00', '2009/8/26\n2:00', '2009/8/26\n3:00', '2009/8/26\n4:00', '2009/8/26\n5:00', '2009/8/26\n6:00', '2009/8/26\n7:00', '2009/8/26\n8:00', '2009/8/26\n9:00', '2009/8/26\n10:00', '2009/8/26\n11:00', '2009/8/26\n12:00', '2009/8/26\n13:00', '2009/8/26\n14:00', '2009/8/26\n15:00', '2009/8/26\n16:00', '2009/8/26\n17:00', '2009/8/26\n18:00', '2009/8/26\n19:00', '2009/8/26\n20:00', '2009/8/26\n21:00', '2009/8/26\n22:00', '2009/8/26\n23:00', '2009/8/27\n0:00', '2009/8/27\n1:00', '2009/8/27\n2:00', '2009/8/27\n3:00', '2009/8/27\n4:00', '2009/8/27\n5:00', '2009/8/27\n6:00', '2009/8/27\n7:00', '2009/8/27\n8:00', '2009/8/27\n9:00', '2009/8/27\n10:00', '2009/8/27\n11:00', '2009/8/27\n12:00', '2009/8/27\n13:00', '2009/8/27\n14:00', '2009/8/27\n15:00', '2009/8/27\n16:00', '2009/8/27\n17:00', '2009/8/27\n18:00', '2009/8/27\n19:00', '2009/8/27\n20:00', '2009/8/27\n21:00', '2009/8/27\n22:00', '2009/8/27\n23:00', '2009/8/28\n0:00', '2009/8/28\n1:00', '2009/8/28\n2:00', '2009/8/28\n3:00', '2009/8/28\n4:00', '2009/8/28\n5:00', '2009/8/28\n6:00', '2009/8/28\n7:00', '2009/8/28\n8:00', '2009/8/28\n9:00', '2009/8/28\n10:00', '2009/8/28\n11:00', '2009/8/28\n12:00', '2009/8/28\n13:00', '2009/8/28\n14:00', '2009/8/28\n15:00', '2009/8/28\n16:00', '2009/8/28\n17:00', '2009/8/28\n18:00', '2009/8/28\n19:00', '2009/8/28\n20:00', '2009/8/28\n21:00', '2009/8/28\n22:00', '2009/8/28\n23:00', '2009/8/29\n0:00', '2009/8/29\n1:00', '2009/8/29\n2:00', '2009/8/29\n3:00', '2009/8/29\n4:00', '2009/8/29\n5:00', '2009/8/29\n6:00', '2009/8/29\n7:00', '2009/8/29\n8:00', '2009/8/29\n9:00', '2009/8/29\n10:00', '2009/8/29\n11:00', '2009/8/29\n12:00', '2009/8/29\n13:00', '2009/8/29\n14:00', '2009/8/29\n15:00', '2009/8/29\n16:00', '2009/8/29\n17:00', '2009/8/29\n18:00', '2009/8/29\n19:00', '2009/8/29\n20:00', '2009/8/29\n21:00', '2009/8/29\n22:00', '2009/8/29\n23:00', '2009/8/30\n0:00', '2009/8/30\n1:00', '2009/8/30\n2:00', '2009/8/30\n3:00', '2009/8/30\n4:00', '2009/8/30\n5:00', '2009/8/30\n6:00', '2009/8/30\n7:00', '2009/8/30\n8:00', '2009/8/30\n9:00', '2009/8/30\n10:00', '2009/8/30\n11:00', '2009/8/30\n12:00', '2009/8/30\n13:00', '2009/8/30\n14:00', '2009/8/30\n15:00', '2009/8/30\n16:00', '2009/8/30\n17:00', '2009/8/30\n18:00', '2009/8/30\n19:00', '2009/8/30\n20:00', '2009/8/30\n21:00', '2009/8/30\n22:00', '2009/8/30\n23:00', '2009/8/31\n0:00', '2009/8/31\n1:00', '2009/8/31\n2:00', '2009/8/31\n3:00', '2009/8/31\n4:00', '2009/8/31\n5:00', '2009/8/31\n6:00', '2009/8/31\n7:00', '2009/8/31\n8:00', '2009/8/31\n9:00', '2009/8/31\n10:00', '2009/8/31\n11:00', '2009/8/31\n12:00', '2009/8/31\n13:00', '2009/8/31\n14:00', '2009/8/31\n15:00', '2009/8/31\n16:00', '2009/8/31\n17:00', '2009/8/31\n18:00', '2009/8/31\n19:00', '2009/8/31\n20:00', '2009/8/31\n21:00', '2009/8/31\n22:00', '2009/8/31\n23:00', '2009/9/1\n0:00', '2009/9/1\n1:00', '2009/9/1\n2:00', '2009/9/1\n3:00', '2009/9/1\n4:00', '2009/9/1\n5:00', '2009/9/1\n6:00', '2009/9/1\n7:00', '2009/9/1\n8:00', '2009/9/1\n9:00', '2009/9/1\n10:00', '2009/9/1\n11:00', '2009/9/1\n12:00', '2009/9/1\n13:00', '2009/9/1\n14:00', '2009/9/1\n15:00', '2009/9/1\n16:00', '2009/9/1\n17:00', '2009/9/1\n18:00', '2009/9/1\n19:00', '2009/9/1\n20:00', '2009/9/1\n21:00', '2009/9/1\n22:00', '2009/9/1\n23:00', '2009/9/2\n0:00', '2009/9/2\n1:00', '2009/9/2\n2:00', '2009/9/2\n3:00', '2009/9/2\n4:00', '2009/9/2\n5:00', '2009/9/2\n6:00', '2009/9/2\n7:00', '2009/9/2\n8:00', '2009/9/2\n9:00', '2009/9/2\n10:00', '2009/9/2\n11:00', '2009/9/2\n12:00', '2009/9/2\n13:00', '2009/9/2\n14:00', '2009/9/2\n15:00', '2009/9/2\n16:00', '2009/9/2\n17:00', '2009/9/2\n18:00', '2009/9/2\n19:00', '2009/9/2\n20:00', '2009/9/2\n21:00', '2009/9/2\n22:00', '2009/9/2\n23:00', '2009/9/3\n0:00', '2009/9/3\n1:00', '2009/9/3\n2:00', '2009/9/3\n3:00', '2009/9/3\n4:00', '2009/9/3\n5:00', '2009/9/3\n6:00', '2009/9/3\n7:00', '2009/9/3\n8:00', '2009/9/3\n9:00', '2009/9/3\n10:00', '2009/9/3\n11:00', '2009/9/3\n12:00', '2009/9/3\n13:00', '2009/9/3\n14:00', '2009/9/3\n15:00', '2009/9/3\n16:00', '2009/9/3\n17:00', '2009/9/3\n18:00', '2009/9/3\n19:00', '2009/9/3\n20:00', '2009/9/3\n21:00', '2009/9/3\n22:00', '2009/9/3\n23:00', '2009/9/4\n0:00', '2009/9/4\n1:00', '2009/9/4\n2:00', '2009/9/4\n3:00', '2009/9/4\n4:00', '2009/9/4\n5:00', '2009/9/4\n6:00', '2009/9/4\n7:00', '2009/9/4\n8:00', '2009/9/4\n9:00', '2009/9/4\n10:00', '2009/9/4\n11:00', '2009/9/4\n12:00', '2009/9/4\n13:00', '2009/9/4\n14:00', '2009/9/4\n15:00', '2009/9/4\n16:00', '2009/9/4\n17:00', '2009/9/4\n18:00', '2009/9/4\n19:00', '2009/9/4\n20:00', '2009/9/4\n21:00', '2009/9/4\n22:00', '2009/9/4\n23:00', '2009/9/5\n0:00', '2009/9/5\n1:00', '2009/9/5\n2:00', '2009/9/5\n3:00', '2009/9/5\n4:00', '2009/9/5\n5:00', '2009/9/5\n6:00', '2009/9/5\n7:00', '2009/9/5\n8:00', '2009/9/5\n9:00', '2009/9/5\n10:00', '2009/9/5\n11:00', '2009/9/5\n12:00', '2009/9/5\n13:00', '2009/9/5\n14:00', '2009/9/5\n15:00', '2009/9/5\n16:00', '2009/9/5\n17:00', '2009/9/5\n18:00', '2009/9/5\n19:00', '2009/9/5\n20:00', '2009/9/5\n21:00', '2009/9/5\n22:00', '2009/9/5\n23:00', '2009/9/6\n0:00', '2009/9/6\n1:00', '2009/9/6\n2:00', '2009/9/6\n3:00', '2009/9/6\n4:00', '2009/9/6\n5:00', '2009/9/6\n6:00', '2009/9/6\n7:00', '2009/9/6\n8:00', '2009/9/6\n9:00', '2009/9/6\n10:00', '2009/9/6\n11:00', '2009/9/6\n12:00', '2009/9/6\n13:00', '2009/9/6\n14:00', '2009/9/6\n15:00', '2009/9/6\n16:00', '2009/9/6\n17:00', '2009/9/6\n18:00', '2009/9/6\n19:00', '2009/9/6\n20:00', '2009/9/6\n21:00', '2009/9/6\n22:00', '2009/9/6\n23:00', '2009/9/7\n0:00', '2009/9/7\n1:00', '2009/9/7\n2:00', '2009/9/7\n3:00', '2009/9/7\n4:00', '2009/9/7\n5:00', '2009/9/7\n6:00', '2009/9/7\n7:00', '2009/9/7\n8:00', '2009/9/7\n9:00', '2009/9/7\n10:00', '2009/9/7\n11:00', '2009/9/7\n12:00', '2009/9/7\n13:00', '2009/9/7\n14:00', '2009/9/7\n15:00', '2009/9/7\n16:00', '2009/9/7\n17:00', '2009/9/7\n18:00', '2009/9/7\n19:00', '2009/9/7\n20:00', '2009/9/7\n21:00', '2009/9/7\n22:00', '2009/9/7\n23:00', '2009/9/8\n0:00', '2009/9/8\n1:00', '2009/9/8\n2:00', '2009/9/8\n3:00', '2009/9/8\n4:00', '2009/9/8\n5:00', '2009/9/8\n6:00', '2009/9/8\n7:00', '2009/9/8\n8:00', '2009/9/8\n9:00', '2009/9/8\n10:00', '2009/9/8\n11:00', '2009/9/8\n12:00', '2009/9/8\n13:00', '2009/9/8\n14:00', '2009/9/8\n15:00', '2009/9/8\n16:00', '2009/9/8\n17:00', '2009/9/8\n18:00', '2009/9/8\n19:00', '2009/9/8\n20:00', '2009/9/8\n21:00', '2009/9/8\n22:00', '2009/9/8\n23:00', '2009/9/9\n0:00', '2009/9/9\n1:00', '2009/9/9\n2:00', '2009/9/9\n3:00', '2009/9/9\n4:00', '2009/9/9\n5:00', '2009/9/9\n6:00', '2009/9/9\n7:00', '2009/9/9\n8:00', '2009/9/9\n9:00', '2009/9/9\n10:00', '2009/9/9\n11:00', '2009/9/9\n12:00', '2009/9/9\n13:00', '2009/9/9\n14:00', '2009/9/9\n15:00', '2009/9/9\n16:00', '2009/9/9\n17:00', '2009/9/9\n18:00', '2009/9/9\n19:00', '2009/9/9\n20:00', '2009/9/9\n21:00', '2009/9/9\n22:00', '2009/9/9\n23:00', '2009/9/10\n0:00', '2009/9/10\n1:00', '2009/9/10\n2:00', '2009/9/10\n3:00', '2009/9/10\n4:00', '2009/9/10\n5:00', '2009/9/10\n6:00', '2009/9/10\n7:00', '2009/9/10\n8:00', '2009/9/10\n9:00', '2009/9/10\n10:00', '2009/9/10\n11:00', '2009/9/10\n12:00', '2009/9/10\n13:00', '2009/9/10\n14:00', '2009/9/10\n15:00', '2009/9/10\n16:00', '2009/9/10\n17:00', '2009/9/10\n18:00', '2009/9/10\n19:00', '2009/9/10\n20:00', '2009/9/10\n21:00', '2009/9/10\n22:00', '2009/9/10\n23:00', '2009/9/11\n0:00', '2009/9/11\n1:00', '2009/9/11\n2:00', '2009/9/11\n3:00', '2009/9/11\n4:00', '2009/9/11\n5:00', '2009/9/11\n6:00', '2009/9/11\n7:00', '2009/9/11\n8:00', '2009/9/11\n9:00', '2009/9/11\n10:00', '2009/9/11\n11:00', '2009/9/11\n12:00', '2009/9/11\n13:00', '2009/9/11\n14:00', '2009/9/11\n15:00', '2009/9/11\n16:00', '2009/9/11\n17:00', '2009/9/11\n18:00', '2009/9/11\n19:00', '2009/9/11\n20:00', '2009/9/11\n21:00', '2009/9/11\n22:00', '2009/9/11\n23:00', '2009/9/12\n0:00', '2009/9/12\n1:00', '2009/9/12\n2:00', '2009/9/12\n3:00', '2009/9/12\n4:00', '2009/9/12\n5:00', '2009/9/12\n6:00', '2009/9/12\n7:00', '2009/9/12\n8:00', '2009/9/12\n9:00', '2009/9/12\n10:00', '2009/9/12\n11:00', '2009/9/12\n12:00', '2009/9/12\n13:00', '2009/9/12\n14:00', '2009/9/12\n15:00', '2009/9/12\n16:00', '2009/9/12\n17:00', '2009/9/12\n18:00', '2009/9/12\n19:00', '2009/9/12\n20:00', '2009/9/12\n21:00', '2009/9/12\n22:00', '2009/9/12\n23:00', '2009/9/13\n0:00', '2009/9/13\n1:00', '2009/9/13\n2:00', '2009/9/13\n3:00', '2009/9/13\n4:00', '2009/9/13\n5:00', '2009/9/13\n6:00', '2009/9/13\n7:00', '2009/9/13\n8:00', '2009/9/13\n9:00', '2009/9/13\n10:00', '2009/9/13\n11:00', '2009/9/13\n12:00', '2009/9/13\n13:00', '2009/9/13\n14:00', '2009/9/13\n15:00', '2009/9/13\n16:00', '2009/9/13\n17:00', '2009/9/13\n18:00', '2009/9/13\n19:00', '2009/9/13\n20:00', '2009/9/13\n21:00', '2009/9/13\n22:00', '2009/9/13\n23:00', '2009/9/14\n0:00', '2009/9/14\n1:00', '2009/9/14\n2:00', '2009/9/14\n3:00', '2009/9/14\n4:00', '2009/9/14\n5:00', '2009/9/14\n6:00', '2009/9/14\n7:00', '2009/9/14\n8:00', '2009/9/14\n9:00', '2009/9/14\n10:00', '2009/9/14\n11:00', '2009/9/14\n12:00', '2009/9/14\n13:00', '2009/9/14\n14:00', '2009/9/14\n15:00', '2009/9/14\n16:00', '2009/9/14\n17:00', '2009/9/14\n18:00', '2009/9/14\n19:00', '2009/9/14\n20:00', '2009/9/14\n21:00', '2009/9/14\n22:00', '2009/9/14\n23:00', '2009/9/15\n0:00', '2009/9/15\n1:00', '2009/9/15\n2:00', '2009/9/15\n3:00', '2009/9/15\n4:00', '2009/9/15\n5:00', '2009/9/15\n6:00', '2009/9/15\n7:00', '2009/9/15\n8:00', '2009/9/15\n9:00', '2009/9/15\n10:00', '2009/9/15\n11:00', '2009/9/15\n12:00', '2009/9/15\n13:00', '2009/9/15\n14:00', '2009/9/15\n15:00', '2009/9/15\n16:00', '2009/9/15\n17:00', '2009/9/15\n18:00', '2009/9/15\n19:00', '2009/9/15\n20:00', '2009/9/15\n21:00', '2009/9/15\n22:00', '2009/9/15\n23:00', '2009/9/16\n0:00', '2009/9/16\n1:00', '2009/9/16\n2:00', '2009/9/16\n3:00', '2009/9/16\n4:00', '2009/9/16\n5:00', '2009/9/16\n6:00', '2009/9/16\n7:00', '2009/9/16\n8:00', '2009/9/16\n9:00', '2009/9/16\n10:00', '2009/9/16\n11:00', '2009/9/16\n12:00', '2009/9/16\n13:00', '2009/9/16\n14:00', '2009/9/16\n15:00', '2009/9/16\n16:00', '2009/9/16\n17:00', '2009/9/16\n18:00', '2009/9/16\n19:00', '2009/9/16\n20:00', '2009/9/16\n21:00', '2009/9/16\n22:00', '2009/9/16\n23:00', '2009/9/17\n0:00', '2009/9/17\n1:00', '2009/9/17\n2:00', '2009/9/17\n3:00', '2009/9/17\n4:00', '2009/9/17\n5:00', '2009/9/17\n6:00', '2009/9/17\n7:00', '2009/9/17\n8:00', '2009/9/17\n9:00', '2009/9/17\n10:00', '2009/9/17\n11:00', '2009/9/17\n12:00', '2009/9/17\n13:00', '2009/9/17\n14:00', '2009/9/17\n15:00', '2009/9/17\n16:00', '2009/9/17\n17:00', '2009/9/17\n18:00', '2009/9/17\n19:00', '2009/9/17\n20:00', '2009/9/17\n21:00', '2009/9/17\n22:00', '2009/9/17\n23:00', '2009/9/18\n0:00', '2009/9/18\n1:00', '2009/9/18\n2:00', '2009/9/18\n3:00', '2009/9/18\n4:00', '2009/9/18\n5:00', '2009/9/18\n6:00', '2009/9/18\n7:00', '2009/9/18\n8:00', '2009/9/18\n9:00', '2009/9/18\n10:00', '2009/9/18\n11:00', '2009/9/18\n12:00', '2009/9/18\n13:00', '2009/9/18\n14:00', '2009/9/18\n15:00', '2009/9/18\n16:00', '2009/9/18\n17:00', '2009/9/18\n18:00', '2009/9/18\n19:00', '2009/9/18\n20:00', '2009/9/18\n21:00', '2009/9/18\n22:00', '2009/9/18\n23:00', '2009/9/19\n0:00', '2009/9/19\n1:00', '2009/9/19\n2:00', '2009/9/19\n3:00', '2009/9/19\n4:00', '2009/9/19\n5:00', '2009/9/19\n6:00', '2009/9/19\n7:00', '2009/9/19\n8:00', '2009/9/19\n9:00', '2009/9/19\n10:00', '2009/9/19\n11:00', '2009/9/19\n12:00', '2009/9/19\n13:00', '2009/9/19\n14:00', '2009/9/19\n15:00', '2009/9/19\n16:00', '2009/9/19\n17:00', '2009/9/19\n18:00', '2009/9/19\n19:00', '2009/9/19\n20:00', '2009/9/19\n21:00', '2009/9/19\n22:00', '2009/9/19\n23:00', '2009/9/20\n0:00', '2009/9/20\n1:00', '2009/9/20\n2:00', '2009/9/20\n3:00', '2009/9/20\n4:00', '2009/9/20\n5:00', '2009/9/20\n6:00', '2009/9/20\n7:00', '2009/9/20\n8:00', '2009/9/20\n9:00', '2009/9/20\n10:00', '2009/9/20\n11:00', '2009/9/20\n12:00', '2009/9/20\n13:00', '2009/9/20\n14:00', '2009/9/20\n15:00', '2009/9/20\n16:00', '2009/9/20\n17:00', '2009/9/20\n18:00', '2009/9/20\n19:00', '2009/9/20\n20:00', '2009/9/20\n21:00', '2009/9/20\n22:00', '2009/9/20\n23:00', '2009/9/21\n0:00', '2009/9/21\n1:00', '2009/9/21\n2:00', '2009/9/21\n3:00', '2009/9/21\n4:00', '2009/9/21\n5:00', '2009/9/21\n6:00', '2009/9/21\n7:00', '2009/9/21\n8:00', '2009/9/21\n9:00', '2009/9/21\n10:00', '2009/9/21\n11:00', '2009/9/21\n12:00', '2009/9/21\n13:00', '2009/9/21\n14:00', '2009/9/21\n15:00', '2009/9/21\n16:00', '2009/9/21\n17:00', '2009/9/21\n18:00', '2009/9/21\n19:00', '2009/9/21\n20:00', '2009/9/21\n21:00', '2009/9/21\n22:00', '2009/9/21\n23:00', '2009/9/22\n0:00', '2009/9/22\n1:00', '2009/9/22\n2:00', '2009/9/22\n3:00', '2009/9/22\n4:00', '2009/9/22\n5:00', '2009/9/22\n6:00', '2009/9/22\n7:00', '2009/9/22\n8:00', '2009/9/22\n9:00', '2009/9/22\n10:00', '2009/9/22\n11:00', '2009/9/22\n12:00', '2009/9/22\n13:00', '2009/9/22\n14:00', '2009/9/22\n15:00', '2009/9/22\n16:00', '2009/9/22\n17:00', '2009/9/22\n18:00', '2009/9/22\n19:00', '2009/9/22\n20:00', '2009/9/22\n21:00', '2009/9/22\n22:00', '2009/9/22\n23:00', '2009/9/23\n0:00', '2009/9/23\n1:00', '2009/9/23\n2:00', '2009/9/23\n3:00', '2009/9/23\n4:00', '2009/9/23\n5:00', '2009/9/23\n6:00', '2009/9/23\n7:00', '2009/9/23\n8:00', '2009/9/23\n9:00', '2009/9/23\n10:00', '2009/9/23\n11:00', '2009/9/23\n12:00', '2009/9/23\n13:00', '2009/9/23\n14:00', '2009/9/23\n15:00', '2009/9/23\n16:00', '2009/9/23\n17:00', '2009/9/23\n18:00', '2009/9/23\n19:00', '2009/9/23\n20:00', '2009/9/23\n21:00', '2009/9/23\n22:00', '2009/9/23\n23:00', '2009/9/24\n0:00', '2009/9/24\n1:00', '2009/9/24\n2:00', '2009/9/24\n3:00', '2009/9/24\n4:00', '2009/9/24\n5:00', '2009/9/24\n6:00', '2009/9/24\n7:00', '2009/9/24\n8:00', '2009/9/24\n9:00', '2009/9/24\n10:00', '2009/9/24\n11:00', '2009/9/24\n12:00', '2009/9/24\n13:00', '2009/9/24\n14:00', '2009/9/24\n15:00', '2009/9/24\n16:00', '2009/9/24\n17:00', '2009/9/24\n18:00', '2009/9/24\n19:00', '2009/9/24\n20:00', '2009/9/24\n21:00', '2009/9/24\n22:00', '2009/9/24\n23:00', '2009/9/25\n0:00', '2009/9/25\n1:00', '2009/9/25\n2:00', '2009/9/25\n3:00', '2009/9/25\n4:00', '2009/9/25\n5:00', '2009/9/25\n6:00', '2009/9/25\n7:00', '2009/9/25\n8:00', '2009/9/25\n9:00', '2009/9/25\n10:00', '2009/9/25\n11:00', '2009/9/25\n12:00', '2009/9/25\n13:00', '2009/9/25\n14:00', '2009/9/25\n15:00', '2009/9/25\n16:00', '2009/9/25\n17:00', '2009/9/25\n18:00', '2009/9/25\n19:00', '2009/9/25\n20:00', '2009/9/25\n21:00', '2009/9/25\n22:00', '2009/9/25\n23:00', '2009/9/26\n0:00', '2009/9/26\n1:00', '2009/9/26\n2:00', '2009/9/26\n3:00', '2009/9/26\n4:00', '2009/9/26\n5:00', '2009/9/26\n6:00', '2009/9/26\n7:00', '2009/9/26\n8:00', '2009/9/26\n9:00', '2009/9/26\n10:00', '2009/9/26\n11:00', '2009/9/26\n12:00', '2009/9/26\n13:00', '2009/9/26\n14:00', '2009/9/26\n15:00', '2009/9/26\n16:00', '2009/9/26\n17:00', '2009/9/26\n18:00', '2009/9/26\n19:00', '2009/9/26\n20:00', '2009/9/26\n21:00', '2009/9/26\n22:00', '2009/9/26\n23:00', '2009/9/27\n0:00', '2009/9/27\n1:00', '2009/9/27\n2:00', '2009/9/27\n3:00', '2009/9/27\n4:00', '2009/9/27\n5:00', '2009/9/27\n6:00', '2009/9/27\n7:00', '2009/9/27\n8:00', '2009/9/27\n9:00', '2009/9/27\n10:00', '2009/9/27\n11:00', '2009/9/27\n12:00', '2009/9/27\n13:00', '2009/9/27\n14:00', '2009/9/27\n15:00', '2009/9/27\n16:00', '2009/9/27\n17:00', '2009/9/27\n18:00', '2009/9/27\n19:00', '2009/9/27\n20:00', '2009/9/27\n21:00', '2009/9/27\n22:00', '2009/9/27\n23:00', '2009/9/28\n0:00', '2009/9/28\n1:00', '2009/9/28\n2:00', '2009/9/28\n3:00', '2009/9/28\n4:00', '2009/9/28\n5:00', '2009/9/28\n6:00', '2009/9/28\n7:00', '2009/9/28\n8:00', '2009/9/28\n9:00', '2009/9/28\n10:00', '2009/9/28\n11:00', '2009/9/28\n12:00', '2009/9/28\n13:00', '2009/9/28\n14:00', '2009/9/28\n15:00', '2009/9/28\n16:00', '2009/9/28\n17:00', '2009/9/28\n18:00', '2009/9/28\n19:00', '2009/9/28\n20:00', '2009/9/28\n21:00', '2009/9/28\n22:00', '2009/9/28\n23:00', '2009/9/29\n0:00', '2009/9/29\n1:00', '2009/9/29\n2:00', '2009/9/29\n3:00', '2009/9/29\n4:00', '2009/9/29\n5:00', '2009/9/29\n6:00', '2009/9/29\n7:00', '2009/9/29\n8:00', '2009/9/29\n9:00', '2009/9/29\n10:00', '2009/9/29\n11:00', '2009/9/29\n12:00', '2009/9/29\n13:00', '2009/9/29\n14:00', '2009/9/29\n15:00', '2009/9/29\n16:00', '2009/9/29\n17:00', '2009/9/29\n18:00', '2009/9/29\n19:00', '2009/9/29\n20:00', '2009/9/29\n21:00', '2009/9/29\n22:00', '2009/9/29\n23:00', '2009/9/30\n0:00', '2009/9/30\n1:00', '2009/9/30\n2:00', '2009/9/30\n3:00', '2009/9/30\n4:00', '2009/9/30\n5:00', '2009/9/30\n6:00', '2009/9/30\n7:00', '2009/9/30\n8:00', '2009/9/30\n9:00', '2009/9/30\n10:00', '2009/9/30\n11:00', '2009/9/30\n12:00', '2009/9/30\n13:00', '2009/9/30\n14:00', '2009/9/30\n15:00', '2009/9/30\n16:00', '2009/9/30\n17:00', '2009/9/30\n18:00', '2009/9/30\n19:00', '2009/9/30\n20:00', '2009/9/30\n21:00', '2009/9/30\n22:00', '2009/9/30\n23:00', '2009/10/1\n0:00', '2009/10/1\n1:00', '2009/10/1\n2:00', '2009/10/1\n3:00', '2009/10/1\n4:00', '2009/10/1\n5:00', '2009/10/1\n6:00', '2009/10/1\n7:00', '2009/10/1\n8:00', '2009/10/1\n9:00', '2009/10/1\n10:00', '2009/10/1\n11:00', '2009/10/1\n12:00', '2009/10/1\n13:00', '2009/10/1\n14:00', '2009/10/1\n15:00', '2009/10/1\n16:00', '2009/10/1\n17:00', '2009/10/1\n18:00', '2009/10/1\n19:00', '2009/10/1\n20:00', '2009/10/1\n21:00', '2009/10/1\n22:00', '2009/10/1\n23:00', '2009/10/2\n0:00', '2009/10/2\n1:00', '2009/10/2\n2:00', '2009/10/2\n3:00', '2009/10/2\n4:00', '2009/10/2\n5:00', '2009/10/2\n6:00', '2009/10/2\n7:00', '2009/10/2\n8:00', '2009/10/2\n9:00', '2009/10/2\n10:00', '2009/10/2\n11:00', '2009/10/2\n12:00', '2009/10/2\n13:00', '2009/10/2\n14:00', '2009/10/2\n15:00', '2009/10/2\n16:00', '2009/10/2\n17:00', '2009/10/2\n18:00', '2009/10/2\n19:00', '2009/10/2\n20:00', '2009/10/2\n21:00', '2009/10/2\n22:00', '2009/10/2\n23:00', '2009/10/3\n0:00', '2009/10/3\n1:00', '2009/10/3\n2:00', '2009/10/3\n3:00', '2009/10/3\n4:00', '2009/10/3\n5:00', '2009/10/3\n6:00', '2009/10/3\n7:00', '2009/10/3\n8:00', '2009/10/3\n9:00', '2009/10/3\n10:00', '2009/10/3\n11:00', '2009/10/3\n12:00', '2009/10/3\n13:00', '2009/10/3\n14:00', '2009/10/3\n15:00', '2009/10/3\n16:00', '2009/10/3\n17:00', '2009/10/3\n18:00', '2009/10/3\n19:00', '2009/10/3\n20:00', '2009/10/3\n21:00', '2009/10/3\n22:00', '2009/10/3\n23:00', '2009/10/4\n0:00', '2009/10/4\n1:00', '2009/10/4\n2:00', '2009/10/4\n3:00', '2009/10/4\n4:00', '2009/10/4\n5:00', '2009/10/4\n6:00', '2009/10/4\n7:00', '2009/10/4\n8:00', '2009/10/4\n9:00', '2009/10/4\n10:00', '2009/10/4\n11:00', '2009/10/4\n12:00', '2009/10/4\n13:00', '2009/10/4\n14:00', '2009/10/4\n15:00', '2009/10/4\n16:00', '2009/10/4\n17:00', '2009/10/4\n18:00', '2009/10/4\n19:00', '2009/10/4\n20:00', '2009/10/4\n21:00', '2009/10/4\n22:00', '2009/10/4\n23:00', '2009/10/5\n0:00', '2009/10/5\n1:00', '2009/10/5\n2:00', '2009/10/5\n3:00', '2009/10/5\n4:00', '2009/10/5\n5:00', '2009/10/5\n6:00', '2009/10/5\n7:00', '2009/10/5\n8:00', '2009/10/5\n9:00', '2009/10/5\n10:00', '2009/10/5\n11:00', '2009/10/5\n12:00', '2009/10/5\n13:00', '2009/10/5\n14:00', '2009/10/5\n15:00', '2009/10/5\n16:00', '2009/10/5\n17:00', '2009/10/5\n18:00', '2009/10/5\n19:00', '2009/10/5\n20:00', '2009/10/5\n21:00', '2009/10/5\n22:00', '2009/10/5\n23:00', '2009/10/6\n0:00', '2009/10/6\n1:00', '2009/10/6\n2:00', '2009/10/6\n3:00', '2009/10/6\n4:00', '2009/10/6\n5:00', '2009/10/6\n6:00', '2009/10/6\n7:00', '2009/10/6\n8:00', '2009/10/6\n9:00', '2009/10/6\n10:00', '2009/10/6\n11:00', '2009/10/6\n12:00', '2009/10/6\n13:00', '2009/10/6\n14:00', '2009/10/6\n15:00', '2009/10/6\n16:00', '2009/10/6\n17:00', '2009/10/6\n18:00', '2009/10/6\n19:00', '2009/10/6\n20:00', '2009/10/6\n21:00', '2009/10/6\n22:00', '2009/10/6\n23:00', '2009/10/7\n0:00', '2009/10/7\n1:00', '2009/10/7\n2:00', '2009/10/7\n3:00', '2009/10/7\n4:00', '2009/10/7\n5:00', '2009/10/7\n6:00', '2009/10/7\n7:00', '2009/10/7\n8:00', '2009/10/7\n9:00', '2009/10/7\n10:00', '2009/10/7\n11:00', '2009/10/7\n12:00', '2009/10/7\n13:00', '2009/10/7\n14:00', '2009/10/7\n15:00', '2009/10/7\n16:00', '2009/10/7\n17:00', '2009/10/7\n18:00', '2009/10/7\n19:00', '2009/10/7\n20:00', '2009/10/7\n21:00', '2009/10/7\n22:00', '2009/10/7\n23:00', '2009/10/8\n0:00', '2009/10/8\n1:00', '2009/10/8\n2:00', '2009/10/8\n3:00', '2009/10/8\n4:00', '2009/10/8\n5:00', '2009/10/8\n6:00', '2009/10/8\n7:00', '2009/10/8\n8:00', '2009/10/8\n9:00', '2009/10/8\n10:00', '2009/10/8\n11:00', '2009/10/8\n12:00', '2009/10/8\n13:00', '2009/10/8\n14:00', '2009/10/8\n15:00', '2009/10/8\n16:00', '2009/10/8\n17:00', '2009/10/8\n18:00', '2009/10/8\n19:00', '2009/10/8\n20:00', '2009/10/8\n21:00', '2009/10/8\n22:00', '2009/10/8\n23:00', '2009/10/9\n0:00', '2009/10/9\n1:00', '2009/10/9\n2:00', '2009/10/9\n3:00', '2009/10/9\n4:00', '2009/10/9\n5:00', '2009/10/9\n6:00', '2009/10/9\n7:00', '2009/10/9\n8:00', '2009/10/9\n9:00', '2009/10/9\n10:00', '2009/10/9\n11:00', '2009/10/9\n12:00', '2009/10/9\n13:00', '2009/10/9\n14:00', '2009/10/9\n15:00', '2009/10/9\n16:00', '2009/10/9\n17:00', '2009/10/9\n18:00', '2009/10/9\n19:00', '2009/10/9\n20:00', '2009/10/9\n21:00', '2009/10/9\n22:00', '2009/10/9\n23:00', '2009/10/10\n0:00', '2009/10/10\n1:00', '2009/10/10\n2:00', '2009/10/10\n3:00', '2009/10/10\n4:00', '2009/10/10\n5:00', '2009/10/10\n6:00', '2009/10/10\n7:00', '2009/10/10\n8:00', '2009/10/10\n9:00', '2009/10/10\n10:00', '2009/10/10\n11:00', '2009/10/10\n12:00', '2009/10/10\n13:00', '2009/10/10\n14:00', '2009/10/10\n15:00', '2009/10/10\n16:00', '2009/10/10\n17:00', '2009/10/10\n18:00', '2009/10/10\n19:00', '2009/10/10\n20:00', '2009/10/10\n21:00', '2009/10/10\n22:00', '2009/10/10\n23:00', '2009/10/11\n0:00', '2009/10/11\n1:00', '2009/10/11\n2:00', '2009/10/11\n3:00', '2009/10/11\n4:00', '2009/10/11\n5:00', '2009/10/11\n6:00', '2009/10/11\n7:00', '2009/10/11\n8:00', '2009/10/11\n9:00', '2009/10/11\n10:00', '2009/10/11\n11:00', '2009/10/11\n12:00', '2009/10/11\n13:00', '2009/10/11\n14:00', '2009/10/11\n15:00', '2009/10/11\n16:00', '2009/10/11\n17:00', '2009/10/11\n18:00', '2009/10/11\n19:00', '2009/10/11\n20:00', '2009/10/11\n21:00', '2009/10/11\n22:00', '2009/10/11\n23:00', '2009/10/12\n0:00', '2009/10/12\n1:00', '2009/10/12\n2:00', '2009/10/12\n3:00', '2009/10/12\n4:00', '2009/10/12\n5:00', '2009/10/12\n6:00', '2009/10/12\n7:00', '2009/10/12\n8:00', '2009/10/12\n9:00', '2009/10/12\n10:00', '2009/10/12\n11:00', '2009/10/12\n12:00', '2009/10/12\n13:00', '2009/10/12\n14:00', '2009/10/12\n15:00', '2009/10/12\n16:00', '2009/10/12\n17:00', '2009/10/12\n18:00', '2009/10/12\n19:00', '2009/10/12\n20:00', '2009/10/12\n21:00', '2009/10/12\n22:00', '2009/10/12\n23:00', '2009/10/13\n0:00', '2009/10/13\n1:00', '2009/10/13\n2:00', '2009/10/13\n3:00', '2009/10/13\n4:00', '2009/10/13\n5:00', '2009/10/13\n6:00', '2009/10/13\n7:00', '2009/10/13\n8:00', '2009/10/13\n9:00', '2009/10/13\n10:00', '2009/10/13\n11:00', '2009/10/13\n12:00', '2009/10/13\n13:00', '2009/10/13\n14:00', '2009/10/13\n15:00', '2009/10/13\n16:00', '2009/10/13\n17:00', '2009/10/13\n18:00', '2009/10/13\n19:00', '2009/10/13\n20:00', '2009/10/13\n21:00', '2009/10/13\n22:00', '2009/10/13\n23:00', '2009/10/14\n0:00', '2009/10/14\n1:00', '2009/10/14\n2:00', '2009/10/14\n3:00', '2009/10/14\n4:00', '2009/10/14\n5:00', '2009/10/14\n6:00', '2009/10/14\n7:00', '2009/10/14\n8:00', '2009/10/14\n9:00', '2009/10/14\n10:00', '2009/10/14\n11:00', '2009/10/14\n12:00', '2009/10/14\n13:00', '2009/10/14\n14:00', '2009/10/14\n15:00', '2009/10/14\n16:00', '2009/10/14\n17:00', '2009/10/14\n18:00', '2009/10/14\n19:00', '2009/10/14\n20:00', '2009/10/14\n21:00', '2009/10/14\n22:00', '2009/10/14\n23:00', '2009/10/15\n0:00', '2009/10/15\n1:00', '2009/10/15\n2:00', '2009/10/15\n3:00', '2009/10/15\n4:00', '2009/10/15\n5:00', '2009/10/15\n6:00', '2009/10/15\n7:00', '2009/10/15\n8:00', '2009/10/15\n9:00', '2009/10/15\n10:00', '2009/10/15\n11:00', '2009/10/15\n12:00', '2009/10/15\n13:00', '2009/10/15\n14:00', '2009/10/15\n15:00', '2009/10/15\n16:00', '2009/10/15\n17:00', '2009/10/15\n18:00', '2009/10/15\n19:00', '2009/10/15\n20:00', '2009/10/15\n21:00', '2009/10/15\n22:00', '2009/10/15\n23:00', '2009/10/16\n0:00', '2009/10/16\n1:00', '2009/10/16\n2:00', '2009/10/16\n3:00', '2009/10/16\n4:00', '2009/10/16\n5:00', '2009/10/16\n6:00', '2009/10/16\n7:00', '2009/10/16\n8:00', '2009/10/16\n9:00', '2009/10/16\n10:00', '2009/10/16\n11:00', '2009/10/16\n12:00', '2009/10/16\n13:00', '2009/10/16\n14:00', '2009/10/16\n15:00', '2009/10/16\n16:00', '2009/10/16\n17:00', '2009/10/16\n18:00', '2009/10/16\n19:00', '2009/10/16\n20:00', '2009/10/16\n21:00', '2009/10/16\n22:00', '2009/10/16\n23:00', '2009/10/17\n0:00', '2009/10/17\n1:00', '2009/10/17\n2:00', '2009/10/17\n3:00', '2009/10/17\n4:00', '2009/10/17\n5:00', '2009/10/17\n6:00', '2009/10/17\n7:00', '2009/10/17\n8:00', '2009/10/17\n9:00', '2009/10/17\n10:00', '2009/10/17\n11:00', '2009/10/17\n12:00', '2009/10/17\n13:00', '2009/10/17\n14:00', '2009/10/17\n15:00', '2009/10/17\n16:00', '2009/10/17\n17:00', '2009/10/17\n18:00', '2009/10/17\n19:00', '2009/10/17\n20:00', '2009/10/17\n21:00', '2009/10/17\n22:00', '2009/10/17\n23:00', '2009/10/18\n0:00', '2009/10/18\n1:00', '2009/10/18\n2:00', '2009/10/18\n3:00', '2009/10/18\n4:00', '2009/10/18\n5:00', '2009/10/18\n6:00', '2009/10/18\n7:00', '2009/10/18\n8:00']
flow = flow[:2]
rainfall = rainfall[:2]
time = time[:2]

sunburst_data = [{
    "name": "Root 1",
    "children": [
        {
            "name": "Children A",
            "value": 15,
            "children": [
                {
                    "name": "Children A1",
                    "value": 2
                },
                {
                    "name": "Children AA1",
                    "value": 5,
                    "children": [
                        {
                            "name": "Children AAA1",
                            "value": 2
                        }
                    ]
                },
                {
                    "name": "Children A2",
                    "value": 4
                }
            ]
        },
        {
            "name": "Children B",
            "value": 10,
            "children": [
                {
                    "name": "Children B1",
                    "value": 5
                },
                {
                    "name": "Children B2",
                    "value": 1
                }
            ]
        }
    ]
}, {
    "name": "Root 2",
    "children": [
        {
            "name": "Children A1",
            "children": [
                {
                    "name": "Children AA1",
                    "value": 1
                },
                {
                    "name": "Children AA2",
                    "value": 2
                }
            ]
        }
    ]
}]

tree_data = [
    {
        'name': 'root',
        'value': 35,
        'children': [
            {
                'name': 'Child A',
                'value': 9,
                'children': [
                    {'name': 'Child A1', 'value': 23},
                    {'name': 'Child A2', 'value': 72},
                    {'name': 'Child A3', 'value': 93},
                ],
            },
            {
                'name': 'Child B',
                'value': 56,
                'children': [
                    {'name': 'Child B1', 'value': 39},
                    {'name': 'Child B2', 'value': 61},
                    {'name': 'Child B3', 'value': 71},
                ],
            },
            {
                'name': 'Child C',
                'value': 100,
                'children': [
                    {'name': 'Child C1', 'value': 19},
                    {'name': 'Child C2', 'value': 66},
                    {'name': 'Child C3', 'value': 47},
                ],
            },
        ],
    }
]


def table():
    s.set_menu_path('test', 'table')

    s.plt.table(data=table_data, order=0, rows_size=3, title='Table test', page_size_options=[3, 5, 10],
                initial_sort_column='date', sort_descending=True, columns_options={'y': {'hideColumn': True}},
                categorical_columns=['filtA', 'filtB'])


def table_with_labels():
    s.set_menu_path('test', 'table-test-with-labels')

    data_ = [
        {'date': dt.date(2021, 1, 1), 'x': 5, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'Z',
         'name': 'Ana', 'name2': 'Ana', 'name3': 'Ana'},
        {'date': dt.date(2021, 1, 2), 'x': 6, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'B', 'filtB': 'Z',
         'name': 'Laura', 'name2': 'Laura', 'name3': 'Laura'},
        {'date': dt.date(2021, 1, 3), 'x': 4, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'W',
         'name': 'Audrey', 'name2': 'Audrey', 'name3': 'Audrey'},
        {'date': dt.date(2021, 1, 4), 'x': 7, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'B', 'filtB': 'W',
         'name': 'Jose', 'name2': 'Jose', 'name3': 'Jose'},
        {'date': dt.date(2021, 1, 5), 'x': 3, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'Z',
         'name': 'Jorge', 'name2': 'Jorge', 'name3': 'Jorge'},
        {'date': dt.date(2021, 1, 1), 'x': 5, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'Z',
         'name': 'Ana', 'name2': 'Ana', 'name3': 'Ana'},
        {'date': dt.date(2021, 1, 2), 'x': 6, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'B', 'filtB': 'Z',
         'name': 'Laura', 'name2': 'Laura', 'name3': 'Laura'},
        {'date': dt.date(2021, 1, 3), 'x': 4, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'W',
         'name': 'Audrey', 'name2': 'Audrey', 'name3': 'Audrey'},
        {'date': dt.date(2021, 1, 4), 'x': 7, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'B', 'filtB': 'W',
         'name': 'Jose', 'name2': 'Jose', 'name3': 'Jose'},
        {'date': dt.date(2021, 1, 5), 'x': 3, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'Z',
         'name': 'Jorge', 'name2': 'Jorge', 'name3': 'Jorge'},
        {'date': dt.date(2021, 1, 1), 'x': 5, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'Z',
         'name': 'Ana', 'name2': 'Ana', 'name3': 'Ana'},
        {'date': dt.date(2021, 1, 2), 'x': 6, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'B', 'filtB': 'Z',
         'name': 'Laura', 'name2': 'Laura', 'name3': 'Laura'},
        {'date': dt.date(2021, 1, 3), 'x': 4, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'W',
         'name': 'Audrey', 'name2': 'Audrey', 'name3': 'Audrey'},
        {'date': dt.date(2021, 1, 4), 'x': 7, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'B', 'filtB': 'W',
         'name': 'Jose', 'name2': 'Jose', 'name3': 'Jose'},
        {'date': dt.date(2021, 1, 5), 'x': 3, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'Z',
         'name': 'Jorge', 'name2': 'Jorge', 'name3': 'Jorge'},
        {'date': dt.date(2021, 1, 1), 'x': 5, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'Z',
         'name': 'Ana', 'name2': 'Ana', 'name3': 'Ana'},
        {'date': dt.date(2021, 1, 2), 'x': 6, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'B', 'filtB': 'Z',
         'name': 'Laura', 'name2': 'Laura', 'name3': 'Laura'},
        {'date': dt.date(2021, 1, 3), 'x': 4, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'W',
         'name': 'Audrey', 'name2': 'Audrey', 'name3': 'Audrey'},
        {'date': dt.date(2021, 1, 4), 'x': 7, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'B', 'filtB': 'W',
         'name': 'Jose', 'name2': 'Jose', 'name3': 'Jose'},
        {'date': dt.date(2021, 1, 5), 'x': 3, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'Z',
         'name': 'Jorge', 'name2': 'Jorge', 'name3': 'Jorge'},
        {'date': dt.date(2021, 1, 1), 'x': 5, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'Z',
         'name': 'Ana', 'name2': 'Ana', 'name3': 'Ana'},
        {'date': dt.date(2021, 1, 2), 'x': 6, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'B', 'filtB': 'Z',
         'name': 'Laura', 'name2': 'Laura', 'name3': 'Laura'},
        {'date': dt.date(2021, 1, 3), 'x': 4, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'W',
         'name': 'Audrey', 'name2': 'Audrey', 'name3': 'Audrey'},
        {'date': dt.date(2021, 1, 4), 'x': 7, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'B', 'filtB': 'W',
         'name': 'Jose', 'name2': 'Jose', 'name3': 'Jose'},
        {'date': dt.date(2021, 1, 5), 'x': 3, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'Z',
         'name': 'Jorge', 'name2': 'Jorge', 'name3': 'Jorge'},
        {'date': dt.date(2021, 1, 1), 'x': 5, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'Z',
         'name': 'Ana', 'name2': 'Ana', 'name3': 'Ana'},
        {'date': dt.date(2021, 1, 2), 'x': 6, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'B', 'filtB': 'Z',
         'name': 'Laura', 'name2': 'Laura', 'name3': 'Laura'},
        {'date': dt.date(2021, 1, 3), 'x': 4, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'W',
         'name': 'Audrey', 'name2': 'Audrey', 'name3': 'Audrey'},
        {'date': dt.date(2021, 1, 4), 'x': 7, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'B', 'filtB': 'W',
         'name': 'Jose', 'name2': 'Jose', 'name3': 'Jose'},
        {'date': dt.date(2021, 1, 5), 'x': 3, 'y': round(100 * random.random(), 10),
         'z': round(100 * random.random(), 1), 'a': round(100 * random.random(), 1), 'filtA': 'A', 'filtB': 'Z',
         'name': 'Jorge', 'name2': 'Jorge', 'name3': 'Jorge'},

    ]

    s.plt.table(
        data=data_, order=0, rows_size=10,
        page_size=100,
        initial_sort_column="date",
        categorical_columns=["filtA", "filtB"],
        label_columns={
            ("x", 'outlined'): {
                5: "#666666",
                6: "#4287f5",
                4: "#42F548",
                7: [255, 0, 0],
                3: [0, 255, 0],
            },
            ("y", 'outlined'): {
                (0, 25): "red",
                (25, 50): "orange",
                (50, 75): "yellow",
                (75, np.inf): "green",
            },
            "z": {
                (0, 25): [100, 100, 100],
                (25, 50): "yellow",
                (50, 75): "orange",
                (75, np.inf): "red"
            },
            "a": {
                (0, 25): [100, 100, 100],
                (25, 50): "yellow",
                (50, 75): "orange",
                (75, np.inf): "red"
            },
            "filtA": "#666666",
            ("filtB", 'outlined'): [125, 54, 200],
            "name": "warning",
            "name2": {
                'Ana': 'active',
                'Laura': "error",
                'Audrey': "warning",
                'Jose': "caution",
                'Jorge': "main"
            },
            ("name3", 'outlined'): "neutral"
        },
    )


def bar_with_filters():
    print('test_bar_with_filters')
    menu_path: str = 'test', 'multifilter-bar-test'
    # First reset
    data_ = pd.read_csv('../../data/test_multifilter.csv')
    y: List[str] = [
        'Acné', 'Adeslas', 'Asisa',
        'Aspy', 'Caser', 'Clínica Navarra', 'Cualtis', 'Cáncer', 'DKV',
        'Depresión', 'Dermatólogo', 'Dermatólogo Adeslas', 'Diabetes',
        'Fundación Jiménez Díaz', 'Ginecólogo', 'Ginecólogo Adeslas',
        'HM Hospitales', 'Hemorroides', 'IMQ', 'Preving', 'Psicólogo',
        'Psiquiatra', 'Quirón', 'Quirón Prevención + quirónprevención',
        'Quirón+Quirónsalud', 'Quirónsalud', 'Ruber', 'Ruber Internacional',
        'Ruber Juan Bravo', 'Sanitas', 'Teknon', 'Traumatólogo', 'Vithas'
    ]

    data_1 = data_[data_['seccion'].isin(['Empresas hospitalarias', 'Empresas PRL'])]

    s.activate_sequential_execution()
    filters: Dict = {
        'order': 0,
        'filter_cols': [
            'seccion', 'frecuencia', 'region',
        ],
    }
    s.plt.bar(
        data=data_1,
        x='fecha', y=y,
        menu_path=f'{menu_path}-bysize',
        order=1, rows_size=2,
        cols_size=12,
        filters=filters,
    )

    filters: Dict = {
        'row': 1, 'column': 1,
        'filter_cols': [
            'seccion', 'frecuencia', 'region',
        ],
    }
    s.plt.bar(
        data=data_1,
        x='fecha', y=y,
        menu_path=menu_path,
        row=2, column=1,
        filters=filters,
    )

    data_2 = data_[data_['seccion'].isin(['Enfermedades'])]
    filters: Dict = {
        'update_filter_type': 'concat',
        'row': 1, 'column': 1,
        'filter_cols': [
            'seccion', 'frecuencia', 'region',
        ],
    }

    s.plt.bar(
        data=data_2,
        x='fecha', y=y,
        menu_path=menu_path,
        row=2, column=1,
        filters=filters,
    )

    filters: Dict = {
        'update_filter_type': 'append',
        'row': 1, 'column': 1,
        'filter_cols': [
            'seccion', 'frecuencia', 'region',
        ],
    }

    data_3 = pd.concat([data_1, data_2])
    s.plt.bar(
        data=data_3,
        x='fecha', y=y,
        menu_path=menu_path,
        row=2, column=2,
        filters=filters,
    )
    s.activate_async_execution()

    if delete_paths:
        s.plt.delete_path(menu_path)
        s.plt.delete_path(menu_path=f'{menu_path}-bysize')


def bar_with_filters_with_aggregation_methods():
    print("test_bar_with_filters_with_aggregation_methods")
    menu_path = "test2/bar-with-filters-with-aggregation-methods"
    data = [
        {'date': dt.date(2021, 1, 1), 'Restaurant rating': 1, 'food rating': 10, 'Location': "Barcelona",
         'Fav Food': "pizza", 'Fav Drink': "water"},
        {'date': dt.date(2021, 1, 2), 'Restaurant rating': 2, 'food rating': 8, 'Location': "Barcelona",
         'Fav Food': "sushi", 'Fav Drink': "fanta"},
        {'date': dt.date(2021, 1, 3), 'Restaurant rating': 3, 'food rating': 10, 'Location': "Madrid",
         'Fav Food': "pasta", 'Fav Drink': "wine"},
        {'date': dt.date(2021, 1, 4), 'Restaurant rating': 4, 'food rating': 5, 'Location': "Madrid",
         'Fav Food': "pizza", 'Fav Drink': "wine"},
        {'date': dt.date(2021, 1, 5), 'Restaurant rating': 5, 'food rating': 7, 'Location': "Madrid",
         'Fav Food': "sushi", 'Fav Drink': "water"},

        {'date': dt.date(2021, 1, 1), 'Restaurant rating': 5, 'food rating': 6, 'Location': "Andorra",
         'Fav Food': "pizza", 'Fav Drink': "water"},
        {'date': dt.date(2021, 1, 2), 'Restaurant rating': 4, 'food rating': 0, 'Location': "Paris",
         'Fav Food': "sushi", 'Fav Drink': "fanta"},
        {'date': dt.date(2021, 1, 3), 'Restaurant rating': 3, 'food rating': 5, 'Location': "Paris",
         'Fav Food': "pasta", 'Fav Drink': "wine"},
        {'date': dt.date(2021, 1, 4), 'Restaurant rating': 2, 'food rating': 9, 'Location': "Andorra",
         'Fav Food': "pizza", 'Fav Drink': "wine"},
        {'date': dt.date(2021, 1, 5), 'Restaurant rating': 1, 'food rating': 8, 'Location': "Andorra",
         'Fav Food': "sushi", 'Fav Drink': "water"},
    ]
    filters = {'order': 0,
               'filter_cols': ["Location", "Fav Food", 'Fav Drink']
               }

    s.plt.bar(
        data=data,
        x='date', y=['Restaurant rating', 'food rating'],
        menu_path=menu_path,
        order=1,
        rows_size=2, cols_size=9,
        filters=filters
    )

    filters = {'order': 2,
               'filter_cols': ["Location", "Fav Food", 'Fav Drink'],
               'get_all': True
               }

    s.plt.bar(
        data=data,
        x='date', y=['Restaurant rating', 'food rating'],
        menu_path=menu_path,
        order=3,
        rows_size=2, cols_size=9,
        filters=filters,
        aggregation_func={"food rating": [np.sum, np.mean],
                          "Restaurant rating": [np.mean, np.amax, np.amin]}
    )

    filters = {'order': 4,
               'filter_cols': ["Location", "Fav Food", 'Fav Drink'],
               'get_all': ["Location", "Fav Drink"],
               }

    s.plt.bar(
        data=data,
        x='date', y=['Restaurant rating', 'food rating'],
        menu_path=menu_path,
        order=5,
        rows_size=2, cols_size=9,
        filters=filters,
        aggregation_func=np.mean,
    )
    if delete_paths:
        s.plt.delete_path(menu_path=menu_path)


def bar():
    s.set_menu_path('test', 'bar-test')
    data_ = [{'date': dt.date(2021, 1, 1), 'x': 50000000, 'y': 5},
             {'date': dt.date(2021, 1, 2), 'x': 60000000, 'y': 5},
             {'date': dt.date(2021, 1, 3), 'x': 40000000, 'y': 5},
             {'date': dt.date(2021, 1, 4), 'x': 70000000, 'y': 5},
             {'date': dt.date(2021, 1, 5), 'x': 30000000, 'y': 5}]
    s.plt.bar(
        data=data_, x='date', y=['x', 'y'],
        x_axis_name='Date', y_axis_name='Revenue',
        order=0, rows_size=2,
        cols_size=12,
    )
    s.plt.bar(data='main data', x='date', order=1)


def stacked_bar_chart():
    s.set_menu_path('test-free-echarts', 'stacked-bar-chart')

    s.plt.stacked_bar(
        data='stacked data', x="Segment",
        x_axis_name='Distribution and weight of the Drivers',
        order=0, show_values=['Price'],
    )


def stacked_horizontal_bar_chart():
    s.set_menu_path('test-free-echarts', 'horizontal-stacked-bar-chart')

    s.plt.stacked_horizontal_bar(
        data='stacked data', x="Segment", order=0,
        x_axis_name='Distribution and weight of the Drivers',
    )


def stacked_area_chart():
    print("test_area_chart")
    s.set_menu_path('test-free-echarts', 'stacked-area-chart')
    data_ = [
        {'Email': 120, 'Union Ads': 132, 'Video Ads': 101, 'Search Engine': 134, 'Weekday': 'Mon'},
        {'Email': 220, 'Union Ads': 182, 'Video Ads': 191, 'Search Engine': 234, 'Weekday': 'Tue'},
        {'Email': 150, 'Union Ads': 232, 'Video Ads': 201, 'Search Engine': 154, 'Weekday': 'Wed'},
        {'Email': 820, 'Union Ads': 932, 'Video Ads': 901, 'Search Engine': 934, 'Weekday': 'Thu'},
        {'Email': 120, 'Union Ads': 132, 'Video Ads': 101, 'Search Engine': 134, 'Weekday': 'Fri'},
        {'Email': 220, 'Union Ads': 182, 'Video Ads': 191, 'Search Engine': 234, 'Weekday': 'Sat'},
        {'Email': 150, 'Union Ads': 232, 'Video Ads': 201, 'Search Engine': 154, 'Weekday': 'Sun'},
    ]
    s.plt.stacked_area(
        data=data_,
        x="Weekday",
        x_axis_name='Visits per weekday',
        order=0,
    )


def zero_centered_barchart():
    s.set_menu_path('test', 'zero-centered-bar-test')

    s.plt.zero_centered_bar(
        data='zero centered data',
        x='Name', y='y',
        order=0,
    )

    s.plt.zero_centered_bar(
        data='zero centered data',
        x='Name', y=['y', 'z', 'a'],
        x_axis_name="Axis x",
        y_axis_name="Axis y",
        title="Title",
        order=1, rows_size=3, cols_size=10,
        padding="0,0,0,1"
    )


def horizontal_bar_chart():
    s.set_menu_path('test', 'horizontal-bar-test')

    data_ = [
        {'Name': 'a', 'y': 5, 'z': 3, 'a': 0.01},
        {'Name': 'b', 'y': 7, 'z': 4, 'a': 0.1},
        {'Name': 'c', 'y': 3, 'z': 5, 'a': 0.1},
        {'Name': 'd', 'y': 5, 'z': 6, 'a': 0.01},
    ]

    s.plt.horizontal_bar(data=data_, x='Name', y=['y', 'z'], order=0)

    s.plt.horizontal_bar(
        data=data_,
        x='Name', y=['y', 'z', 'a'],
        x_axis_name="Axis x",
        y_axis_name="Axis y",
        title="Title",
        order=1, rows_size=3, cols_size=10,
        padding="0,0,0,1"
    )


def line():
    s.set_menu_path('test', 'line-test')
    s.plt.line(data='main data', x='date', order=0, variant='minimal')
    s.plt.line(data='main data', x='date', order=1, rows_size=2, cols_size=12)


def area():
    s.set_menu_path('test', 'area-test')
    s.plt.area(data='main data', x='date', order=0, variant='clean')
    s.plt.area(data='main data', x='date', order=1, rows_size=2, cols_size=12)


def scatter():
    s.set_menu_path('test', 'scatter-test')

    s.plt.scatter(data='main data', point_fields=[('x', 'y')], order=0, cols_size=6, variant='clean')

    # https://figshare.com/articles/dataset/Age_height_and_weight_raw_data/16920130
    df_ = pd.read_csv('../../data/scatter_test.csv')[
        ['AgeGroup1', 'AgeGroup2', 'AgeGroup3', 'AllGroupAge', 'WeightGroup1',
         'WeightGroup2', 'WeightGroup3', 'AllGroupWeight']]

    s.plt.scatter(
        data=df_, point_fields=[
            ('AgeGroup1', 'WeightGroup1'), ('AgeGroup2', 'WeightGroup2'),
            ('AgeGroup3', 'WeightGroup3'), ('AllGroupAge', 'AllGroupWeight')],
        title='Age Weight correlation study',
        x_axis_name='Age',
        y_axis_name='Weight',
        order=1, rows_size=4, cols_size=6,
    )


def scatter_with_effect():
    s.set_menu_path('test-free-echarts', 'scatter-with-effect-test')

    scatter_data_raw = [[161.2, 51.6], [167.5, 59.0], [159.5, 49.2], [157.0, 63.0], [155.8, 53.6],
                        [170.0, 59.0], [159.1, 47.6], [166.0, 69.8], [176.2, 66.8], [160.2, 75.2],
                        [172.5, 55.2], [170.9, 54.2], [172.9, 62.5], [153.4, 42.0], [160.0, 50.0],
                        [147.2, 49.8], [168.2, 49.2], [175.0, 73.2], [157.0, 47.8], [167.6, 68.8],
                        [159.5, 50.6], [175.0, 82.5], [166.8, 57.2], [176.5, 87.8], [170.2, 72.8],
                        [174.0, 54.5], [173.0, 59.8], [179.9, 67.3], [170.5, 67.8], [160.0, 47.0],
                        [154.4, 46.2], [162.0, 55.0], [176.5, 83.0], [160.0, 54.4], [152.0, 45.8],
                        [162.1, 53.6], [170.0, 73.2], [160.2, 52.1], [161.3, 67.9], [166.4, 56.6],
                        [168.9, 62.3], [163.8, 58.5], [167.6, 54.5], [160.0, 50.2], [161.3, 60.3],
                        [167.6, 58.3], [165.1, 56.2], [160.0, 50.2], [170.0, 72.9], [157.5, 59.8],
                        ]

    scatter_source = [
        {
            'x': point[0],
            'y': point[1],
        } for point in scatter_data_raw
    ]

    s.plt.scatter_with_effect(
        data=scatter_source,
        x='x', y='y', order=0,
        x_axis_name='X axis',
        y_axis_name='Y axis',
        title='Scatter with effect',
        effect_points=[1, 2, [172.7, 105.2], [153.4, 42]]
    )


def waterfall():
    s.set_menu_path('test-free-echarts', 'waterfall-test')

    data = [
        {'x': 'Nov 1', 'income': 900, 'expenses': 0},
        {'x': 'Nov 2', 'income': 345, 'expenses': 0},
        {'x': 'Nov 3', 'income': 393, 'expenses': 0},
        {'x': 'Nov 4', 'income': 0, 'expenses': 108},
        {'x': 'Nov 5', 'income': 0, 'expenses': 154},
        {'x': 'Nov 6', 'income': 135, 'expenses': 0},
        {'x': 'Nov 7', 'income': 178, 'expenses': 0},
        {'x': 'Nov 8', 'income': 286, 'expenses': 0},
        {'x': 'Nov 9', 'income': 0, 'expenses': 119},
        {'x': 'Nov 10', 'income': 0, 'expenses': 361},
        {'x': 'Nov 11', 'income': 0, 'expenses': 203},
        {'x': 'Nov 12', 'income': 450, 'expenses': 156},
        {'x': 'Nov 13', 'income': 45, 'expenses': 189},
        {'x': 'Nov 14', 'income': 0, 'expenses': 0},
        {'x': 'Nov 15', 'income': 122, 'expenses': 87},
        {'x': 'Nov 16', 'income': 65, 'expenses': 156},
        {'x': 'Nov 17', 'income': 336, 'expenses': 450},
        {'x': 'Nov 18', 'income': 560, 'expenses': 400},
        {'x': 'Nov 19', 'income': 1200, 'expenses': 1130},
        {'x': 'Nov 20', 'income': 3200, 'expenses': 3130},
        {'x': 'Nov 21', 'income': 100, 'expenses': 3000},
        {'x': 'Nov 22', 'income': 5000, 'expenses': 30},
    ]

    s.plt.waterfall(
        data=data, x='x',
        positive='income',
        negative='expenses',
        order=0,
        variant='minimal'
    )

    s.plt.waterfall(
        data=data, x='x',
        title='Waterfall with balance',
        positive='income',
        negative='expenses',
        show_balance=True,
        order=1,
    )

    random_waterfall_data = [{'x': f'day {i}', 'Income': random.randint(0, 100), 'Expenses': random.randint(0, 100)}
                             for i in range(500)]
    s.update_data_sets()
    s.plt.waterfall(
        data=random_waterfall_data,
        x='x',
        title='Big random waterfall',
        positive='Income',
        negative='Expenses',
        x_axis_name='Day',
        y_axis_name='Money in €',
        show_balance=True,
        order=2,
        variant='clean'
    )
    s.reuse_data_sets()


def line_with_confidence_area():
    s.set_menu_path('test-free-echarts', 'Line with confidence area')

    # Download the data
    res = requests.get(url='https://echarts.apache.org/examples/data/asset/data/confidence-band.json')

    # Convert it to json
    confidence_data = res.json()

    for dat in confidence_data:
        dat['value'] = dat['value'] * 100
        dat['l'] = dat['l'] * 100
        dat['u'] = dat['u'] * 100

    s.plt.line_with_confidence_area(
        data=confidence_data,
        order=0,
        title='Confidence Band Chart',
        x='date', y='value', lower='l', upper='u',
        x_axis_name='Date',
        y_axis_name='Value',
        percentages=True,
        variant='clean'
    )


def funnel():
    s.set_menu_path('test', 'funnel-test')

    s.plt.funnel(
        data='funnel data', order=0, title='Funnel Chart',
        names='name', values='value',
    )

    s.plt.funnel(
        data='funnel data', names='name', values='value',
        order=1, rows_size=2, cols_size=12,
    )


def heatmap():
    s.set_menu_path('test', 'heatmap')

    s.plt.heatmap(data=heatmap_data, x='xAxis', y='yAxis', values='value', order=0, calculate_color_range=True,
                  variant='minimal')

    s.plt.heatmap(data='heatmap data', x='xAxis', y='yAxis', values='value', order=1, continuous=True,
                  title='Heatmap Chart', rows_size=2, cols_size=12, x_axis_name='xAxis', y_axis_name='yAxis')


def heatmap_with_filters():
    print('test_heatmap_with_filters')
    menu_path: str = 'test', 'heatmap-with-filters-test'
    data_ = [
        {
            "Filter": "Option 1",
            "xAxis": "Lunes",
            "yAxis": "12 a.m",
            "value": 9
        },
        {
            "Filter": "Option 1",
            "xAxis": "Lunes",
            "yAxis": "6 p.m",
            "value": 10
        },
        {
            "Filter": "Option 1",
            "xAxis": "Lunes",
            "yAxis": "12 p.m",
            "value": 9
        },
        {
            "Filter": "Option 1",
            "xAxis": "Lunes",
            "yAxis": "6 a.m",
            "value": 10
        },
        {
            "Filter": "Option 1",
            "xAxis": "Martes",
            "yAxis": "12 a.m",
            "value": 9
        },
        {
            "Filter": "Option 1",
            "xAxis": "Martes",
            "yAxis": "6 p.m",
            "value": 9
        },
        {
            "Filter": "Option 1",
            "xAxis": "Martes",
            "yAxis": "12 p.m",
            "value": 8
        },
        {
            "Filter": "Option 1",
            "xAxis": "Martes",
            "yAxis": "6 a.m",
            "value": 0
        },
        {
            "Filter": "Option 1",
            "xAxis": "Miercoles",
            "yAxis": "12 a.m",
            "value": 2
        },
        {
            "Filter": "Option 1",
            "xAxis": "Miercoles",
            "yAxis": "6 p.m",
            "value": 7
        },
        {
            "Filter": "Option 1",
            "xAxis": "Miercoles",
            "yAxis": "12 p.m",
            "value": 0
        },
        {
            "Filter": "Option 1",
            "xAxis": "Miercoles",
            "yAxis": "6 a.m",
            "value": 2
        },
        {
            "Filter": "Option 1",
            "xAxis": "Jueves",
            "yAxis": "12 a.m",
            "value": 4
        },
        {
            "Filter": "Option 1",
            "xAxis": "Jueves",
            "yAxis": "6 p.m",
            "value": 0
        },
        {
            "Filter": "Option 1",
            "xAxis": "Jueves",
            "yAxis": "12 p.m",
            "value": 1
        },
        {
            "Filter": "Option 1",
            "xAxis": "Jueves",
            "yAxis": "6 a.m",
            "value": 6
        },

        {
            "Filter": "Option 2",
            "xAxis": "Lunes",
            "yAxis": "12 a.m",
            "value": 6
        },
        {
            "Filter": "Option 2",
            "xAxis": "Lunes",
            "yAxis": "6 p.m",
            "value": 4
        },
        {
            "Filter": "Option 2",
            "xAxis": "Lunes",
            "yAxis": "12 p.m",
            "value": 8
        },
        {
            "Filter": "Option 2",
            "xAxis": "Lunes",
            "yAxis": "6 a.m",
            "value": 15
        },
        {
            "Filter": "Option 2",
            "xAxis": "Martes",
            "yAxis": "12 a.m",
            "value": 2
        },
        {
            "Filter": "Option 2",
            "xAxis": "Martes",
            "yAxis": "6 p.m",
            "value": 6
        },
        {
            "Filter": "Option 2",
            "xAxis": "Martes",
            "yAxis": "12 p.m",
            "value": 7
        },
        {
            "Filter": "Option 2",
            "xAxis": "Martes",
            "yAxis": "6 a.m",
            "value": 4
        },
        {
            "Filter": "Option 2",
            "xAxis": "Miercoles",
            "yAxis": "12 a.m",
            "value": 2
        },
        {
            "Filter": "Option 2",
            "xAxis": "Miercoles",
            "yAxis": "6 p.m",
            "value": 7
        },
        {
            "Filter": "Option 2",
            "xAxis": "Miercoles",
            "yAxis": "12 p.m",
            "value": 4
        },
        {
            "Filter": "Option 2",
            "xAxis": "Miercoles",
            "yAxis": "6 a.m",
            "value": 2
        },
        {
            "Filter": "Option 2",
            "xAxis": "Jueves",
            "yAxis": "12 a.m",
            "value": 8
        },
        {
            "Filter": "Option 2",
            "xAxis": "Jueves",
            "yAxis": "6 p.m",
            "value": 0
        },
        {
            "Filter": "Option 1",
            "xAxis": "Jueves",
            "yAxis": "12 p.m",
            "value": 4
        },
        {
            "Filter": "Option 2",
            "xAxis": "Jueves",
            "yAxis": "6 a.m",
            "value": 10
        }
    ]
    filters: Dict = {
        'order': 0,
        'filter_cols': ['Filter']
    }
    s.plt.heatmap(
        data=data_, x='xAxis', y='yAxis', value='value',
        menu_path=menu_path,
        order=1,
        filters=filters
    )
    filters: Dict = {
        'order': 2,
        'filter_cols': ['Filter'],
        'get_all': True
    }
    s.plt.heatmap(
        data=data_, x='xAxis', y='yAxis', value='value',
        menu_path=menu_path,
        order=3, rows_size=2, cols_size=12,
        filters=filters,
        aggregation_func=np.mean
    )

    if delete_paths:
        s.plt.delete(
            menu_path=menu_path,
            component_type='heatmap',
            row=1, column=1,
        )
        s.plt.delete(
            menu_path=menu_path,
            component_type='heatmap',
            order=1
        )
        s.plt.delete_path(menu_path)


def doughnut():
    s.set_menu_path('test', 'doughnut')
    data_ = [
        {'value': 1048, 'name': 'Search Engine'},
        {'value': 735, 'name': 'Direct'},
        {'value': 580, 'name': 'Email'},
        {'value': 484, 'name': 'Union Ads'},
        {'value': 300, 'name': 'Video Ads'}
    ]
    s.plt.doughnut(data=data, names='date', values='x', order=0)
    s.plt.doughnut(data=data_, names='name', values='value', order=1)

    df = pd.read_csv('../../data/test_stack_distribution.csv')

    value_columns = [col for col in df.columns if col != "Segment"]
    df = df[['Segment'] + value_columns]

    doughnut_data = pd.DataFrame(columns=["name", "value"])
    df_transposed = df.transpose().reset_index().drop(0)
    value_columns = [col for col in df_transposed.columns if col != "index"]
    doughnut_data["value"] = df_transposed[value_columns].apply(lambda row: sum(row), axis=1)
    doughnut_data["name"] = df_transposed['index']
    s.plt.doughnut(data=doughnut_data, values='value', names='name', order=2, rows_size=3, cols_size=6)


def rose():
    s.set_menu_path('test', 'rose')
    data_ = [
        {'value': 1048, 'name': 'Search Engine'},
        {'value': 735, 'name': 'Direct'},
        {'value': 580, 'name': 'Email'},
        {'value': 484, 'name': 'Union Ads'},
        {'value': 300, 'name': 'Video Ads'}
    ]
    s.plt.rose(data='main data', names='date', values='x', order=0)
    s.plt.rose(data=data_, names='name', values='value', order=1)

    df = pd.read_csv('../../data/test_stack_distribution.csv')

    value_columns = [col for col in df.columns if col != "Segment"]
    df = df[['Segment'] + value_columns]

    rose_data = pd.DataFrame(columns=["name", "value"])
    df_transposed = df.transpose().reset_index().drop(0)
    value_columns = [col for col in df_transposed.columns if col != "index"]
    rose_data["value"] = df_transposed[value_columns].apply(lambda row: sum(row), axis=1)
    rose_data["name"] = df_transposed['index']
    s.plt.rose(data=rose_data, values='value', names='name', order=2, rows_size=3, cols_size=6)


def shimoku_gauges():
    s.set_menu_path('test-free-echarts', 'shimoku-gauges')
    df = pd.read_csv('../../data/test_stack_distribution.csv')

    value_columns = [col for col in df.columns if col != "Segment"]
    df = df[['Segment'] + value_columns]

    gauges_data = pd.DataFrame(columns=["name", "value", "color"])
    df_transposed = df.transpose().reset_index().drop(0)
    value_columns = [col for col in df_transposed.columns if col != "index"]
    gauges_data["value"] = df_transposed[value_columns].apply(lambda row: sum(row), axis=1)
    gauges_data["name"] = df_transposed['index']
    gauges_data["color"] = range(1, len(df_transposed) + 1)

    order = s.plt.shimoku_gauges_group(
        gauges_data=gauges_data, order=0,
        cols_size=12, rows_size=3,
        calculate_percentages=True,
    )

    s.plt.shimoku_gauge(
        value=-60, order=order, color=1
    )

    order += 1
    s.plt.shimoku_gauge(
        value=60, order=order,
        name="test", color="status-error"
    )

    order += 1
    s.plt.shimoku_gauge(
        value=-90, order=order,
        name="test", color='#FF0000'
    )


def speed_gauge():
    s.set_menu_path('test', 'speed-gauge-test')

    # s.plt.iframe('https://www.marca.com', order=0)
    s.plt.speed_gauge(name='Third', value=60, min_value=0, max_value=70, order=0)


# TODO implement
def change_report_type():
    pass


def ring_gauge():
    s.set_menu_path('test', 'ring-gauge-test')
    data_ = [
        {
            "value": 60,
            "name": "Third"
        },
        {
            "value": 40,
            "name": "Fourth"
        },
        {
            "value": 20,
            "name": "Fifth"
        },
        {
            "value": 80,
            "name": "Second"
        },
        {
            "value": 100,
            "name": "First"
        }
    ]
    s.plt.ring_gauge(names='date', values='x', order=0)
    s.plt.ring_gauge(
        data=data_, names='name', values='value',
        order=1, rows_size=2, cols_size=12,
    )


def sunburst():
    s.set_menu_path('test', 'sunburst')
    # Using the data set from the tree test
    s.plt.sunburst(data='tree_data', order=0)
    s.plt.sunburst(data=sunburst_data, order=1)


def tree():
    s.set_menu_path('test', 'tree-test')

    s.plt.tree(data=sunburst_data, order=0)
    s.plt.tree(data='tree_data', order=1, rows_size=4, cols_size=12, title='Tree', radial=True)
    s.plt.tree(data='tree_data', order=2, rows_size=2, cols_size=12, title='Tree', vertical=True)
    s.plt.tree(data='tree_data', order=3, rows_size=4, cols_size=12, title='Tree', radial=True, vertical=True)


def treemap():
    s.set_menu_path('test', 'treemap-test')
    # Using the data set from the tree test
    s.plt.treemap(data=tree_data, order=0)
    s.plt.treemap(data=sunburst_data, order=1)


def radar():
    s.set_menu_path('test', 'radar-test')
    data_ = [
        {'name': 'Matcha Latte', 'value1': 78, 'value2': 6, 'value3': 85},
        {'name': 'Milk Tea', 'value1': 17, 'value2': 10, 'value3': 63},
        {'name': 'Cheese Cocoa', 'value1': 18, 'value2': 15, 'value3': 65},
        {'name': 'Walnut Brownie', 'value1': 9, 'value2': 71, 'value3': 16},
    ]
    # s.plt.radar(data=data, names='date', order=0, cols_size=6)

    s.plt.radar(data=data_, names='name', order=1, rows_size=2, cols_size=6)

    data_ = deepcopy(data_)
    data_[0]['max'] = 90
    data_[1]['max'] = 70
    data_[2]['max'] = 70
    data_[3]['max'] = 80

    # s.plt.radar(data=data_, names='name', order=2, rows_size=2, cols_size=12, max_field='max', fill_area=True)


def indicator():
    s.set_menu_path('test', 'indicators')
    data_ = [
        {
            "description": "",
            "title": "Estado",
            "value": "Abierto",
            "align": "center",
        },
        {
            "description": "",
            "title": "Price ($)",
            "value": "455",
            "color": "success",
        },
        {
            "description": "this is a description",
            "title": "Volumen Changed!",
            "value": "41153"
        },
        {
            "description": "Crazy description",
            "title": "Cambio €/$",
            "value": "1.1946",
        },
    ]

    order = s.plt.indicator(data=data_, order=0)
    order = s.plt.indicator(data=data_ + data_[2:], order=order)

    data_ = [{
        "color": "success",
        "variant": "contained",
        "description": "This indicator has a Link",
        "targetPath": "/indicators/indicator/1",
        "title": "Target Indicator",
        "align": "left",
        "value": "500€",
    }, {
        "color": "warning",
        "backgroundImage": "https://images.unsplash.com/photo-1535957998253-26ae1ef29506?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=736&q=80",
        "variant": "outlined",
        "description": "This has a background",
        "title": "Super cool indicator",
        "align": "left",
        "value": "Value",
    }, {
        "color": "error",
        "variant": "outlined",
        "description": "This hasn't got any icons",
        "title": "Error indicator",
        "align": "left",
        "value": "Value",
        "icon": "Line/download",
    }, {
        "color": "caution",
        "variant": "contained",
        "description": "Aligned to right and full of icons",
        "title": "Multiple cases",
        "align": "right",
        "value": "Value",
        "icon": "Line/download",
        "bigIcon": "Line/calendar",
    }
    ]
    s.plt.indicator(data=data_, order=order, rows_size=1, cols_size=12)

    s.set_menu_path('test', 'indicators-vertical')
    order = s.plt.indicator(
        data=data_ + data_,
        order=0, rows_size=1, cols_size=6,
        vertical="Title of the indicators",
    )
    order = s.plt.indicator(
        data=data_,
        order=order, rows_size=2, cols_size=4,
        vertical=True,
    )
    order = s.plt.indicator(
        data=data_[0],
        order=order, rows_size=8, cols_size=2,
        vertical="Title of the indicator",
    )
    s.plt.indicator(
        data=data_[0],
        order=order, rows_size=8, cols_size=12,
        vertical=True,
    )


def color_by_value_indicators():
    s.set_menu_path('test', 'indicators-by-value')
    s.plt.indicator(
        data=[{
            'align': 'center',
            'title': 'Positive case',
            'value': 10,
        }, {
            'align': 'center',
            'title': 'Negative case',
            'value': -10,
        }, {
            'align': 'center',
            'title': 'Neutral case',
            'value': 0,
        }],
        cols_size=12,
        rows_size=1,
        order=4,
        color_by_value=True
    )


def predictive_line():
    s.set_menu_path('test', 'predictive-line-test')
    s.plt.predictive_line(
        data='main data', x='date', min_value_mark=3, max_value_mark=4,
        order=1, rows_size=2, cols_size=12,
    )


def sankey():
    s.set_menu_path('test', 'sankey-test')
    data_ = [
        {
            "source": "a",
            "target": "a1",
            "value": 5
        },
        {
            "source": "a",
            "target": "a2",
            "value": 3
        },
        {
            "source": "a",
            "target": "b1",
            "value": 8
        },
        {
            "source": "b",
            "target": "b1",
            "value": 6
        },
        {
            "source": "b1",
            "target": "a1",
            "value": 1
        },
        {
            "source": "b1",
            "target": "c",
            "value": 2
        }
    ]
    s.plt.sankey(data=data_, sources='source', targets='target', values='value', order=0)


def pie():
    s.set_menu_path('test', 'pie-test')
    data_ = [
        {'name': 'Matcha Latte', 'value': 78},
        {'name': 'Milk Tea', 'value': 17},
        {'name': 'Cheese Cocoa', 'value': 18},
        {'name': 'Walnut Brownie', 'value': 9},
    ]

    s.plt.pie(data='main data', names='date', values='x', order=0)
    s.plt.pie(data=data_, names='name', values='value', order=1, rows_size=2, cols_size=12)


def iframe():
    s.set_menu_path('test', 'iframe-test')
    url = 'https://www.marca.com/'
    s.plt.iframe(url=url, order=0)
    s.plt.iframe(url=url, order=1, height=160 * 8, cols_size=6, padding='0,3,0,3')


def html():
    s.set_menu_path('test', 'html-test')
    html = (
        "<p style='background-color: #daf4f0';>"
        "Comparing the results of predictions that happened previous "
        "periods vs reality, so that you can measure the accuracy of our predictor"
        "</p>"
    )
    s.plt.html(html=html, order=0)
    s.plt.html(html=html, order=1, rows_size=2, cols_size=12)


def bentobox():
    s.set_menu_path('test', 'bentobox-test')

    s.plt.set_bentobox(cols_size=8, rows_size=3)

    data_ = [
        {
            "description": "",
            "title": "Estado",
            "value": "Abierto",
        },
    ]
    s.plt.indicator(data=data_, order=0, rows_size=10, cols_size=12)
    s.plt.indicator(data=data_, order=1, rows_size=10, cols_size=12)
    s.plt.bar(data='main data', x='date', y=['x', 'y'], order=2, rows_size=26, cols_size=24)

    s.plt.pop_out_of_bentobox()


def cohorts():
    print('test_cohorts')
    # s.plt.cohort()
    raise NotImplementedError


def free_echarts():
    # https://echarts.apache.org/examples/en/editor.html?c=area-time-axis
    s.set_menu_path('test-free-echarts', 'raw')
    raw_options = """
        {title: {
            text: 'Stacked Area Chart'
          },
          tooltip: {
            trigger: 'axis',
            axisPointer: {
              type: 'cross',
              label: {
                backgroundColor: '#6a7985'
              }
            }
          },
          legend: {
            data: ['Email', 'Union Ads', 'Video Ads', 'Direct']
          },
          toolbox: {
            feature: {
              saveAsImage: {}
            }
          },
          grid: {
            left: '3%',
            right: '4%',
            bottom: '3%',
            containLabel: true
          },
          xAxis: [
            {
              type: 'category',
              boundaryGap: false,
              data: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']
            }
          ],
          yAxis: [
            {
              type: 'value'
            }
          ],
          series: [
            {
              name: 'Email',
              type: 'line',
              stack: 'Total',
              areaStyle: {},
              emphasis: {
                focus: 'series'
              },
              data: [120, 132, 101, 134, 90, 230, 210]
            },
            {
              name: 'Union Ads',
              type: 'line',
              stack: 'Total',
              areaStyle: {},
              emphasis: {
                focus: 'series'
              },
              data: [220, 182, 191, 234, 290, 330, 310]
            },
            {
              name: 'Video Ads',
              type: 'line',
              stack: 'Total',
              areaStyle: {},
              emphasis: {
                focus: 'series'
              },
              data: [150, 232, 201, 154, 190, 330, 410]
            },
            {
              name: 'Direct',
              type: 'line',
              stack: 'Total',
              areaStyle: {},
              emphasis: {
                focus: 'series'
              },
              data: [320, 332, 301, 334, 390, 330, 320]
            },
          ]
        }
    """
    s.plt.free_echarts(
        raw_options=raw_options,
        order=0, rows_size=2, cols_size=12,
    )

    # https://echarts.apache.org/examples/en/editor.html?c=line-marker
    raw_options = """
    {
      title: {
        text: 'Temperature Change in the Coming Week'
      },
      tooltip: {
        trigger: 'axis'
      },
      legend: {},
      toolbox: {
        show: true,
        feature: {
          dataZoom: {
            yAxisIndex: 'none'
          },
          dataView: { readOnly: false },
          magicType: { type: ['line', 'bar'] },
          restore: {},
          saveAsImage: {}
        }
      },
      xAxis: {
        type: 'category',
        boundaryGap: false,
        data: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']
      },
      yAxis: {
        type: 'value',
        axisLabel: {
          formatter: '{value} °C'
        }
      },
      series: [
        {
          name: 'Highest',
          type: 'line',
          data: [10, 11, 13, 11, 12, 12, 9],
          markPoint: {
            data: [
              { type: 'max', name: 'Max' },
              { type: 'min', name: 'Min' }
            ]
          },
          markLine: {
            data: [{ type: 'average', name: 'Avg' }]
          }
        },
        {
          name: 'Lowest',
          type: 'line',
          data: [1, -2, 2, 5, 3, 2, 0],
          markPoint: {
            data: [{ name: '周最低', value: -2, xAxis: 1, yAxis: -1.5 }]
          },
          markLine: {
            data: [
              { type: 'average', name: 'Avg' },
              [
                {
                  symbol: 'none',
                  x: '90%',
                  yAxis: 'max'
                },
                {
                  symbol: 'circle',
                  label: {
                    position: 'start',
                    formatter: 'Max'
                  },
                  type: 'max',
                  name: '最高点'
                }
              ]
            ]
          }
        }
      ]
    };
    """
    s.plt.free_echarts(
        raw_options=raw_options,
        order=1, rows_size=2, cols_size=12,
    )
    # https://echarts.apache.org/examples/en/editor.html?c=line-style
    raw_options = """
        {
      xAxis: {
        type: 'category',
        data: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']
      },
      yAxis: {
        type: 'value'
      },
      series: [
        {
          data: [120, 200, 150, 80, 70, 110, 130],
          type: 'line',
          symbol: 'triangle',
          symbolSize: 20,
          lineStyle: {
            color: '#5470C6',
            width: 4,
            type: 'dashed'
          },
          itemStyle: {
            borderWidth: 3,
            borderColor: '#EE6666',
            color: 'yellow'
          }
        }
      ]
    };
    """
    s.plt.free_echarts(
        raw_options=raw_options,
        order=2, rows_size=2, cols_size=12,
    )
    # https://echarts.apache.org/examples/en/editor.html?c=bar-y-category-stack
    raw_options = """
    {
      tooltip: {
        trigger: 'axis',
        axisPointer: {
          type: 'shadow'
        }
      },
      legend: {},
      grid: {
        left: '3%',
        right: '4%',
        bottom: '3%',
        containLabel: true
      },
      xAxis: {
        type: 'value'
      },
      yAxis: {
        type: 'category',
        data: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']
      },
      series: [
        {
          name: 'Direct',
          type: 'bar',
          stack: 'total',
          label: {
            show: true
          },
          emphasis: {
            focus: 'series'
          },
          data: [320, 302, 301, 334, 390, 330, 320]
        },
        {
          name: 'Mail Ad',
          type: 'bar',
          stack: 'total',
          label: {
            show: true
          },
          emphasis: {
            focus: 'series'
          },
          data: [120, 132, 101, 134, 90, 230, 210]
        },
        {
          name: 'Affiliate Ad',
          type: 'bar',
          stack: 'total',
          label: {
            show: true
          },
          emphasis: {
            focus: 'series'
          },
          data: [220, 182, 191, 234, 290, 330, 310]
        },
        {
          name: 'Video Ad',
          type: 'bar',
          stack: 'total',
          label: {
            show: true
          },
          emphasis: {
            focus: 'series'
          },
          data: [150, 212, 201, 154, 190, 330, 410]
        },
      ]
    };
    """
    s.plt.free_echarts(
        raw_options=raw_options,
        order=3, rows_size=2, cols_size=12,
    )
    # https://echarts.apache.org/examples/en/editor.html?c=bar-waterfall2
    # Without functions!
    # Replace "-" by "0"
    raw_options = """
        {      title: {        text: 'Accumulated Waterfall Chart'      },      tooltip: {        trigger: 'axis',        axisPointer: {          type: 'shadow'        },      },      legend: {        data: ['Expenses', 'Income']      },      grid: {        left: '3%',        right: '4%',        bottom: '3%',        containLabel: true      },      xAxis: {        type: 'category',        data:  [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]      },      yAxis: {        type: 'value'      },      series: [        {          name: 'Placeholder',          type: 'bar',          stack: 'Total',          itemStyle: {            borderColor: 'transparent',            color: 'transparent'          },          emphasis: {            itemStyle: {              borderColor: 'transparent',              color: 'transparent'            }          },          data: [0, 900, 1245, 1530, 1376, 1376, 1511, 1689, 1856, 1495, 1292]        },        {          name: 'Income',          type: 'bar',          stack: 'Total',          label: {            show: true,            position: 'top'          },          data: [900, 345, 393, 0, 0, 135, 178, 286, 0, 0, 0]        },        {          name: 'Expenses',          type: 'bar',          stack: 'Total',          label: {            show: true,            position: 'bottom'          },          data: [0, 0, 0, 108, 154, 0, 0, 0, 119, 361, 203]        }      ]    };
    """
    s.plt.free_echarts(
        raw_options=raw_options,
        order=4, rows_size=2, cols_size=12,
    )
    # https://echarts.apache.org/examples/en/editor.html?c=pie-roseType-simple
    raw_options = """
    {
      legend: {
        top: 'bottom'
      },
      toolbox: {    
        show: true,
        feature: {
          mark: { show: true },
          dataView: { show: true, readOnly: false },
          restore: { show: true },
          saveAsImage: { show: true }
        }
      },
      series: [
        {
          name: 'Nightingale Chart',
          type: 'pie',
          radius: [50, 250],
          center: ['50%', '50%'],
          roseType: 'area',
          itemStyle: {
            borderRadius: 8
          },
          data: [
            { value: 40, name: 'rose 1' },
            { value: 38, name: 'rose 2' },
            { value: 32, name: 'rose 3' },
            { value: 30, name: 'rose 4' },
            { value: 28, name: 'rose 5' },
            { value: 26, name: 'rose 6' },
            { value: 22, name: 'rose 7' },
            { value: 18, name: 'rose 8' }
          ]
        }
      ]
    };
    """
    s.plt.free_echarts(
        raw_options=raw_options,
        order=5, rows_size=2, cols_size=12,
    )
    # https://echarts.apache.org/examples/en/editor.html?c=pie-borderRadius
    raw_options = """
    {
      tooltip: {
        trigger: 'item'
      },
      legend: {
        top: '5%',
        left: 'center'
      },
      series: [
        {
          name: 'Access From',
          type: 'pie',
          radius: ['40%', '70%'],
          avoidLabelOverlap: false,
          itemStyle: {
            borderRadius: 10,
            borderColor: '#fff',
            borderWidth: 2
          },
          label: {
            show: false,
            position: 'center'
          },
          emphasis: {
            label: {
              show: true,
              fontSize: '40',
              fontWeight: 'bold'
            }
          },
          labelLine: {
            show: false
          },
          data: [
            { value: 1048, name: 'Search Engine' },
            { value: 735, name: 'Direct' },
            { value: 580, name: 'Email' },
            { value: 484, name: 'Union Ads' },
            { value: 300, name: 'Video Ads' }
          ]
        }
      ]
    };
    """
    s.plt.free_echarts(
        raw_options=raw_options,
        order=6, rows_size=4, cols_size=8,
    )
    # https://echarts.apache.org/examples/en/editor.html?c=radar
    raw_options = """
    {
      title: {
        text: 'Basic Radar Chart'
      },
      legend: {
        data: ['Allocated Budget', 'Actual Spending']
      },
      radar: {
        indicator: [
          { name: 'Sales', max: 6500 },
          { name: 'Administration', max: 16000 },
          { name: 'Information Technology', max: 30000 },
          { name: 'Customer Support', max: 38000 },
          { name: 'Development', max: 52000 },
          { name: 'Marketing', max: 25000 }
        ]
      },
      series: [
        {
          name: 'Budget vs spending',
          type: 'radar',
          data: [
            {
              value: [4200, 3000, 20000, 35000, 50000, 18000],
              name: 'Allocated Budget'
            },
            {
              value: [5000, 14000, 28000, 26000, 42000, 21000],
              name: 'Actual Spending'
            }
          ]
        }
      ]
    };
    """
    s.plt.free_echarts(
        raw_options=raw_options,
        order=7, rows_size=3, cols_size=8,
    )
    # https://echarts.apache.org/examples/en/editor.html?c=gauge-speed
    raw_options = """{
      series: [
        {
          type: 'gauge',
          progress: {
            show: true,
            width: 18
          },
          axisLine: {
            lineStyle: {
              width: 18
            }
          },
          axisTick: {
            show: false
          },
          splitLine: {
            length: 15,
            lineStyle: {
              width: 2,
              color: '#999'
            }
          },
          axisLabel: {
            distance: 25,
            color: '#999',
            fontSize: 20
          },
          anchor: {
            show: true,
            showAbove: true,
            size: 25,
            itemStyle: {
              borderWidth: 10
            }
          },
          title: {
            show: false
          },
          detail: {
            valueAnimation: true,
            fontSize: 80,
            offsetCenter: [0, '70%']
          },
          data: [
            {
              value: 70
            }
          ]
        }
      ]
    };
    """
    s.plt.free_echarts(
        raw_options=raw_options,
        order=8, rows_size=3, cols_size=8,
    )
    # TODO pendings
    #  https://echarts.apache.org/examples/en/editor.html?c=sunburst-visualMap
    #  https://echarts.apache.org/examples/en/editor.html?c=data-transform-aggregate
    #  https://echarts.apache.org/examples/en/editor.html?c=custom-ohlc
    #  https://echarts.apache.org/examples/en/editor.html?c=scatter-clustering

    s.set_menu_path('test-free-echarts')

    data = [
        {'product': 'Matcha Latte', '2015': 43.3, '2016': 85.8, '2017': 93.7},
        {'product': 'Milk Tea', '2015': 83.1, '2016': 73.4, '2017': 55.1},
        {'product': 'Cheese Cocoa', '2015': 86.4, '2016': 65.2, '2017': 82.5},
        {'product': 'Walnut Brownie', '2015': 72.4, '2016': 53.9, '2017': 39.1}
    ]
    options = {
        'legend': {},
        'tooltip': {},
        'xAxis': {'type': 'category', 'data': '#set_data#'},
        'yAxis': {},
        'series': [{'type': 'bar', 'data': '#set_data#'},
                   {'type': 'bar', 'data': '#set_data#'},
                   {'type': 'bar', 'data': '#set_data#'}]
    }
    s.plt.free_echarts(
        data=data,
        options=options, fields=['product', '2015', '2016', '2017'],
        order=0, rows_size=2, cols_size=12,
    )

    # https://echarts.apache.org/examples/en/editor.html?c=area-stack
    data = [
        {'Mon': 120, 'Tue': 132, 'Wed': 101, 'Thu': 134},  # , 'Fri': 90, 'Sat': 230, 'Sun': 210},
        {'Mon': 220, 'Tue': 182, 'Wed': 191, 'Thu': 234},  # , 'Fri': 290, 'Sat': 330, 'Sun': 310},
        {'Mon': 150, 'Tue': 232, 'Wed': 201, 'Thu': 154},  # , 'Fri': 190, 'Sat': 330, 'Sun': 410},
        {'Mon': 820, 'Tue': 932, 'Wed': 901, 'Thu': 934},  # , 'Fri': 1290, 'Sat': 1330, 'Sun': 1320}
    ]
    data = [
        {'Weekday': 'Mon', 'Email': 120, 'Union Ads': 132, 'Video Ads': 101, 'Search Engine': 134},
        {'Weekday': 'Tue', 'Email': 220, 'Union Ads': 182, 'Video Ads': 191, 'Search Engine': 234},
        {'Weekday': 'Wed', 'Email': 150, 'Union Ads': 232, 'Video Ads': 201, 'Search Engine': 154},
        {'Weekday': 'Thu', 'Email': 820, 'Union Ads': 932, 'Video Ads': 901, 'Search Engine': 934},
        {'Weekday': 'Fri', 'Email': 120, 'Union Ads': 132, 'Video Ads': 101, 'Search Engine': 134},
        {'Weekday': 'Sat', 'Email': 220, 'Union Ads': 182, 'Video Ads': 191, 'Search Engine': 234},
        {'Weekday': 'Sun', 'Email': 150, 'Union Ads': 232, 'Video Ads': 201, 'Search Engine': 154},
    ]
    options = {
        'title': {'text': 'Stacked Area Chart'},
        'tooltip': {
            'trigger': 'axis',
            'axisPointer': {
                'type': 'cross',
                'label': {'backgroundColor': '#6a7985'}
            }
        },
        'legend': {
            'data': ['Email', 'Union Ads', 'Video Ads', 'Search Engine']
        },
        'toolbox': {
            'feature': {
                'saveAsImage': {}
            }
        },
        'grid': {
            'left': '3%',
            'right': '4%',
            'bottom': '3%',
            'containLabel': True
        },
        'xAxis': [{
            'type': 'category',
            'boundaryGap': False,
        }],
        'yAxis': [{'type': 'value'}],
        'series': [{
            'name': 'Email',
            'type': 'line',
            'stack': 'Total',
            'areaStyle': {},
            'emphasis': {'focus': 'series'},
        }, {
            'name': 'Union Ads',
            'type': 'line',
            'stack': 'Total',
            'areaStyle': {},
            'emphasis': {'focus': 'series'},
        }, {
            'name': 'Video Ads',
            'type': 'line',
            'stack': 'Total',
            'areaStyle': {},
            'emphasis': {'focus': 'series'},
        }, {
            'name': 'Search Engine',
            'type': 'line',
            'stack': 'Total',
            'label': {
                'show': True,
                'position': 'top'
            },
            'areaStyle': {},
            'emphasis': {'focus': 'series'},
        }],
        'dataset': {'source': '#set_data#'}
    }

    s.plt.free_echarts(
        data=data,
        options=options, fields=[['Weekday', 'Email', 'Union Ads', 'Video Ads', 'Search Engine']],
        order=1, rows_size=2, cols_size=12,
    )

    # https://echarts.apache.org/examples/en/editor.html?c=bar-waterfall
    data = [
        ['Total', 'Rent', 'Utilities', 'Transportation', 'Meals', 'Other'],
        [0, 1700, 1400, 1200, 300, 0],
        [2900, 1200, 300, 200, 900, 300],
    ]
    data = [
        {'Type': 'Total', 'Placeholder': 0, 'Life Cost': 2900},
        {'Type': 'Rent', 'Placeholder': 1700, 'Life Cost': 1200},
        {'Type': 'Utilities', 'Placeholder': 1400, 'Life Cost': 300},
        {'Type': 'Transportation', 'Placeholder': 1200, 'Life Cost': 200},
        {'Type': 'Meals', 'Placeholder': 300, 'Life Cost': 900},
        {'Type': 'Other', 'Placeholder': 0, 'Life Cost': 300},
    ]
    options = {
        'title': {
            'text': 'Waterfall Chart',
            'subtext': 'Living Expenses in Shenzhen'
        },
        'tooltip': {
            'trigger': 'axis',
            'axisPointer': {
                'type': 'shadow'
            },
        },
        'grid': {
            'left': '3%',
            'right': '4%',
            'bottom': '3%',
            'containLabel': True
        },
        'xAxis': {
            'type': 'category',
            'splitLine': {'show': False},
        },
        'yAxis': {'type': 'value'},
        'series': [
            {
                'name': 'Placeholder',
                'type': 'bar',
                'stack': 'Total',
                'itemStyle': {
                    'borderColor': 'transparent',
                    'color': 'transparent'
                },
                'emphasis': {
                    'itemStyle': {
                        'borderColor': 'transparent',
                        'color': 'transparent'
                    }
                },
            },
            {
                'name': 'Life Cost',
                'type': 'bar',
                'stack': 'Total',
                'label': {
                    'show': True,
                    'position': 'inside'
                },
            }
        ],
        'dataset': {'source': '#set_data#'}
    }

    s.plt.free_echarts(
        data=data,
        options=options, fields=[['Type', 'Placeholder', 'Life Cost']],
        order=2, rows_size=2, cols_size=6,
    )

    # https://echarts.apache.org/examples/en/editor.html?c=bar-polar-stack-radial
    data = [
        ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
        [1, 2, 3, 4, 3, 5, 1],
        [2, 4, 6, 1, 3, 2, 1],
        [1, 2, 3, 4, 1, 2, 5],
    ]
    data = [
        {'Mon': 1, 'Tue': 2, 'Wed': 3, 'Thu': 4},
        {'Mon': 2, 'Tue': 4, 'Wed': 6, 'Thu': 1},
        {'Mon': 1, 'Tue': 2, 'Wed': 3, 'Thu': 4},
    ]
    data = [
        {'Weekday': 'Mon', 'A': 1, 'B': 2, 'C': 1},
        {'Weekday': 'Tue', 'A': 2, 'B': 4, 'C': 2},
        {'Weekday': 'Wed', 'A': 3, 'B': 6, 'C': 3},
        {'Weekday': 'Thu', 'A': 4, 'B': 1, 'C': 4},
        {'Weekday': 'Fri', 'A': 4, 'B': 1, 'C': 4},
        {'Weekday': 'Sat', 'A': 4, 'B': 1, 'C': 4},
        {'Weekday': 'Sun', 'A': 4, 'B': 1, 'C': 4},
    ]
    options = {
        'angleAxis': {'type': 'category'},
        'radiusAxis': {},
        'polar': {},
        'series': [
            {
                'type': 'bar',
                'coordinateSystem': 'polar',
                'name': 'A',
                'stack': 'a',
                'emphasis': {'focus': 'series'}
            },
            {
                'type': 'bar',
                'coordinateSystem': 'polar',
                'name': 'B',
                'stack': 'a',
                'emphasis': {'focus': 'series'}
            },
            {
                'type': 'bar',
                'coordinateSystem': 'polar',
                'name': 'C',
                'stack': 'a',
                'emphasis': {'focus': 'series'}
            }
        ],
        'legend': {
            'show': True,
            'data': ['A', 'B', 'C']
        },
        'dataset': {'source': '#set_data#'}
    }

    s.plt.free_echarts(
        data=data,
        options=options, fields=[['Weekday', 'A', 'B', 'C']],
        order=3, rows_size=2, cols_size=6,
    )

    # https://echarts.apache.org/examples/en/editor.html?c=pie-borderRadius
    data = [
        {'value': 1048, 'name': 'Search Engine'},
        {'value': 735, 'name': 'Direct'},
        {'value': 580, 'name': 'Email'},
        {'value': 484, 'name': 'Union Ads'},
        {'value': 300, 'name': 'Video Ads'}
    ]
    options = {
        'tooltip': {'trigger': 'item'},
        'legend': {
            'top': '5%',
            'left': 'center'
        },
        'series': [
            {
                'name': 'Access From',
                'type': 'pie',
                'radius': ['40%', '70%'],
                'avoidLabelOverlap': False,
                'itemStyle': {
                    'borderRadius': 10,
                    'borderColor': '#fff',
                    'borderWidth': 2
                },
                'label': {
                    'show': False,
                    'position': 'center'
                },
                'emphasis': {
                    'label': {
                        'show': True,
                        'fontSize': '40',
                        'fontWeight': 'bold'
                    }
                },
                'labelLine': {'show': False},
            }
        ],
        'dataset': {'source': '#set_data#'}
    }
    s.plt.free_echarts(
        data=data,
        options=options, fields=[['name', 'value']],
        order=4, rows_size=2, cols_size=6,
    )

    data = [
        {'product': 'Matcha Latte', '2015': 43.3, '2016': 85.8},
        {'product': 'Milk Tea', '2015': 83.1, '2016': 73.4},
        {'product': 'Cheese Cocoa', '2015': 86.4, '2016': 65.2},
        {'product': 'Walnut Brownie', '2015': 72.4, '2016': 53.9},
        {'product': 'Cold brew', '2015': 43.3, '2016': 85.8},
        {'product': 'Espresso', '2015': 83.1, '2016': 73.4},
        {'product': 'Kombucola', '2015': 86.4, '2016': 65.2},
    ]
    options = {
        'legend': {},
        'tooltip': {},
        'xAxis': {'type': 'category'},
        'yAxis': {},
        'series': [{'type': 'bar'}, {'type': 'line'}],
        'dataset': {'source': '#set_data#'}
    }
    s.plt.free_echarts(
        data=data,
        options=options, fields=[['product', '2015', '2016']],
        order=5, rows_size=2, cols_size=6,
    )

    # TODO it is not showing the normal & outliers simultaneously
    # https://echarts.apache.org/examples/en/editor.html?c=scatter-effect
    data = [
        # shining dots
        [172.7, 105.2], [153.4, 42],
        # the rest
        [161.2, 51.6], [167.5, 59.0], [159.5, 49.2], [157.0, 63.0], [155.8, 53.6],
        [170.0, 59.0], [159.1, 47.6], [166.0, 69.8], [176.2, 66.8], [160.2, 75.2],
        [172.5, 55.2], [170.9, 54.2], [172.9, 62.5], [153.4, 42.0], [160.0, 50.0],
        [147.2, 49.8], [168.2, 49.2], [175.0, 73.2], [157.0, 47.8], [167.6, 68.8],
        [159.5, 50.6], [175.0, 82.5], [166.8, 57.2], [176.5, 87.8], [170.2, 72.8],
        [174.0, 54.5], [173.0, 59.8], [179.9, 67.3], [170.5, 67.8], [160.0, 47.0],
    ]
    data = [
        {'x': 172.7, 'y': 105.2},
        {'x': 153.4, 'y': 42.0},
        {'x': 161.2, 'y': 51.6},
        {'x': 167.5, 'y': 59.0},
        {'x': 159.5, 'y': 49.2},
        {'x': 157.0, 'y': 63.0},
        {'x': 155.8, 'y': 53.6},
        {'x': 170.0, 'y': 59.0},
        {'x': 159.1, 'y': 47.6},
        {'x': 166.0, 'y': 69.8},
        {'x': 176.2, 'y': 66.8},
        {'x': 160.2, 'y': 75.2},
        {'x': 172.5, 'y': 55.2},
        {'x': 170.9, 'y': 54.2},
        {'x': 172.9, 'y': 62.5},
        {'x': 153.4, 'y': 42.0},
        {'x': 160.0, 'y': 50.0},
        {'x': 147.2, 'y': 49.8},
        {'x': 168.2, 'y': 49.2},
        {'x': 175.0, 'y': 73.2},
        {'x': 157.0, 'y': 47.8},
        {'x': 167.6, 'y': 68.8},
        {'x': 159.5, 'y': 50.6},
        {'x': 175.0, 'y': 82.5},
        {'x': 166.8, 'y': 57.2},
        {'x': 176.5, 'y': 87.8},
        {'x': 170.2, 'y': 72.8},
        {'x': 174.0, 'y': 54.5},
        {'x': 173.0, 'y': 59.8},
        {'x': 179.9, 'y': 67.3},
        {'x': 170.5, 'y': 67.8},
        {'x': 160.0, 'y': 47.0}
    ]
    data = [
        {'x': 172.7, 'y': 105.2, 'x2': 153.4, 'y2': 42.0},
        {'x': 161.2, 'y': 51.6, 'x2': 167.5, 'y2': 59.0},
        {'x': 161.2, 'y': 51.6, 'x2': 150, 'y2': 20},
        {'x': 150, 'y': 20, 'x2': 157.0, 'y2': 63.0},
        {'x': 150, 'y': 20, 'x2': 155.8, 'y2': 53.6},
        {'x': 150, 'y': 20, 'x2': 170.0, 'y2': 59.0},
        {'x': 150, 'y': 20, 'x2': 159.1, 'y2': 47.6},
        {'x': 150, 'y': 20, 'x2': 166.0, 'y2': 69.8},
        {'x': 150, 'y': 20, 'x2': 176.2, 'y2': 66.8},
        {'x': 150, 'y': 20, 'x2': 160.2, 'y2': 75.2},
        {'x': 150, 'y': 20, 'x2': 172.5, 'y2': 55.2},
        {'x': 150, 'y': 20, 'x2': 170.9, 'y2': 54.2},
        {'x': 150, 'y': 20, 'x2': 172.9, 'y2': 62.5},
        {'x': 150, 'y': 20, 'x2': 153.4, 'y2': 42.0},
        {'x': 150, 'y': 20, 'x2': 160.0, 'y2': 50.0},
        {'x': 150, 'y': 20, 'x2': 147.2, 'y2': 49.8},
    ]
    options = {
        'xAxis': {'scale': True},
        'yAxis': {'scale': True},
        'series': [
            {'type': 'effectScatter', 'symbolSize': 20},
            {'type': 'scatter'},
        ],
        'dataset': {'source': '#set_data#'}
    }
    s.plt.free_echarts(
        data=data,
        options=options, fields=[['x', 'y', 'x2', 'y2']],
        order=6, rows_size=2, cols_size=7,
    )

    data = [
        {'product': 'Matcha Latte', '2015': 43.3, '2016': 85.8, '2017': 93.7},
        {'product': 'Milk Tea', '2015': 83.1, '2016': 73.4, '2017': 55.1},
        {'product': 'Cheese Cocoa', '2015': 86.4, '2016': 65.2, '2017': 82.5},
        {'product': 'Walnut Brownie', '2015': 72.4, '2016': 53.9, '2017': 39.1}
    ]
    options = {
        'legend': {},
        'tooltip': {},
        'xAxis': {'type': 'category'},
        'yAxis': {},
        'series': [{'type': 'bar'}, {'type': 'line'}, {'type': 'bar'}],
        'dataset': {'source': '#set_data#'}
    }
    s.plt.free_echarts(
        data=data,
        options=options, fields=[['product', '2015', '2016', '2017']],
        order=7, rows_size=2, cols_size=5,
    )

    print('Free echarts finished')

    # TODO no funca!!
    """
    # https://echarts.apache.org/examples/en/editor.html?c=themeRiver-basic
    data = [
        ['2015/11/08', 10, 'DQ'],
        ['2015/11/09', 15, 'DQ'],
        ['2015/11/10', 35, 'DQ'],
        ['2015/11/11', 38, 'DQ'],
        ['2015/11/12', 22, 'DQ'],
        ['2015/11/13', 16, 'DQ'],
        ['2015/11/14', 7, 'DQ'],
        ['2015/11/15', 2, 'DQ'],
        ['2015/11/16', 17, 'DQ'],
        ['2015/11/17', 33, 'DQ'],
        ['2015/11/18', 40, 'DQ'],
        ['2015/11/19', 32, 'DQ'],
        ['2015/11/20', 26, 'DQ'],
        ['2015/11/21', 35, 'DQ'],
        ['2015/11/22', 40, 'DQ'],
        ['2015/11/23', 32, 'DQ'],
        ['2015/11/24', 26, 'DQ'],
        ['2015/11/25', 22, 'DQ'],
        ['2015/11/26', 16, 'DQ'],
        ['2015/11/27', 22, 'DQ'],
        ['2015/11/28', 10, 'DQ'],
        ['2015/11/08', 35, 'TY'],
        ['2015/11/09', 36, 'TY'],
        ['2015/11/10', 37, 'TY'],
        ['2015/11/11', 22, 'TY'],
        ['2015/11/12', 24, 'TY'],
        ['2015/11/13', 26, 'TY'],
        ['2015/11/14', 34, 'TY'],
        ['2015/11/15', 21, 'TY'],
        ['2015/11/16', 18, 'TY'],
        ['2015/11/17', 45, 'TY'],
        ['2015/11/18', 32, 'TY'],
        ['2015/11/19', 35, 'TY'],
        ['2015/11/20', 30, 'TY'],
        ['2015/11/21', 28, 'TY'],
        ['2015/11/22', 27, 'TY'],
        ['2015/11/23', 26, 'TY'],
        ['2015/11/24', 15, 'TY'],
        ['2015/11/25', 30, 'TY'],
        ['2015/11/26', 35, 'TY'],
        ['2015/11/27', 42, 'TY'],
        ['2015/11/28', 42, 'TY'],
        ['2015/11/08', 21, 'SS'],
        ['2015/11/09', 25, 'SS'],
        ['2015/11/10', 27, 'SS'],
        ['2015/11/11', 23, 'SS'],
        ['2015/11/12', 24, 'SS'],
        ['2015/11/13', 21, 'SS'],
        ['2015/11/14', 35, 'SS'],
        ['2015/11/15', 39, 'SS'],
        ['2015/11/16', 40, 'SS'],
        ['2015/11/17', 36, 'SS'],
        ['2015/11/18', 33, 'SS'],
        ['2015/11/19', 43, 'SS'],
        ['2015/11/20', 40, 'SS'],
        ['2015/11/21', 34, 'SS'],
        ['2015/11/22', 28, 'SS'],
        ['2015/11/23', 26, 'SS'],
        ['2015/11/24', 37, 'SS'],
        ['2015/11/25', 41, 'SS'],
        ['2015/11/26', 46, 'SS'],
        ['2015/11/27', 47, 'SS'],
        ['2015/11/28', 41, 'SS'],
        ['2015/11/08', 10, 'QG'],
        ['2015/11/09', 15, 'QG'],
        ['2015/11/10', 35, 'QG'],
        ['2015/11/11', 38, 'QG'],
        ['2015/11/12', 22, 'QG'],
        ['2015/11/13', 16, 'QG'],
        ['2015/11/14', 7, 'QG'],
        ['2015/11/15', 2, 'QG'],
        ['2015/11/16', 17, 'QG'],
        ['2015/11/17', 33, 'QG'],
        ['2015/11/18', 40, 'QG'],
        ['2015/11/19', 32, 'QG'],
        ['2015/11/20', 26, 'QG'],
        ['2015/11/21', 35, 'QG'],
        ['2015/11/22', 40, 'QG'],
        ['2015/11/23', 32, 'QG'],
        ['2015/11/24', 26, 'QG'],
        ['2015/11/25', 22, 'QG'],
        ['2015/11/26', 16, 'QG'],
        ['2015/11/27', 22, 'QG'],
        ['2015/11/28', 10, 'QG'],
        ['2015/11/08', 10, 'SY'],
        ['2015/11/09', 15, 'SY'],
        ['2015/11/10', 35, 'SY'],
        ['2015/11/11', 38, 'SY'],
        ['2015/11/12', 22, 'SY'],
        ['2015/11/13', 16, 'SY'],
        ['2015/11/14', 7, 'SY'],
        ['2015/11/15', 2, 'SY'],
        ['2015/11/16', 17, 'SY'],
        ['2015/11/17', 33, 'SY'],
        ['2015/11/18', 40, 'SY'],
        ['2015/11/19', 32, 'SY'],
        ['2015/11/20', 26, 'SY'],
        ['2015/11/21', 35, 'SY'],
        ['2015/11/22', 4, 'SY'],
        ['2015/11/23', 32, 'SY'],
        ['2015/11/24', 26, 'SY'],
        ['2015/11/25', 22, 'SY'],
        ['2015/11/26', 16, 'SY'],
        ['2015/11/27', 22, 'SY'],
        ['2015/11/28', 10, 'SY'],
        ['2015/11/08', 10, 'DD'],
        ['2015/11/09', 15, 'DD'],
        ['2015/11/10', 35, 'DD'],
        ['2015/11/11', 38, 'DD'],
        ['2015/11/12', 22, 'DD'],
        ['2015/11/13', 16, 'DD'],
        ['2015/11/14', 7, 'DD'],
        ['2015/11/15', 2, 'DD'],
        ['2015/11/16', 17, 'DD'],
        ['2015/11/17', 33, 'DD'],
        ['2015/11/18', 4, 'DD'],
        ['2015/11/19', 32, 'DD'],
        ['2015/11/20', 26, 'DD'],
        ['2015/11/21', 35, 'DD'],
        ['2015/11/22', 40, 'DD'],
        ['2015/11/23', 32, 'DD'],
        ['2015/11/24', 26, 'DD'],
        ['2015/11/25', 22, 'DD'],
        ['2015/11/26', 16, 'DD'],
        ['2015/11/27', 22, 'DD'],
        ['2015/11/28', 10, 'DD']
    ]
    data = [
        {'date': 1, 'DQ': 15, 'TY': 36, 'SS': 25},
        {'date': 2, 'DQ': 15, 'TY': 36, 'SS': 25},
        {'date': 3, 'DQ': 15, 'TY': 36, 'SS': 25},
        {'date': 4, 'DQ': 15, 'TY': 36, 'SS': 25},
        {'date': 5, 'DQ': 15, 'TY': 36, 'SS': 25},
        {'date': 6, 'DQ': 15, 'TY': 36, 'SS': 25},
    ]
    options = {
        'tooltip': {
            'trigger': 'axis',
            'axisPointer': {
                'type': 'line',
                'lineStyle': {
                    'color': 'rgba(0,0,0,0.2)',
                    'width': 1,
                    'type': 'solid'
                }
            }
        },
        'legend': {
            'data': ['DQ', 'TY', 'SS']
        },
        'singleAxis': {
            'top': 50,
            'bottom': 50,
            'axisTick': {},
            'axisLabel': {},
            'type': 'time',
            'axisPointer': {
                'animation': True,
                'label': {'show': True}
            },
            'splitLine': {
                'show': True,
                'lineStyle': {
                    'type': 'dashed',
                    'opacity': 0.2
                }
            }
        },
        'series': [
            {
                'type': 'themeRiver',
                'emphasis': {
                    'itemStyle': {
                        'shadowBlur': 20,
                        'shadowColor': 'rgba(0, 0, 0, 0.8)'
                    }
                },
            }
        ]
    }
    s.plt.free_echarts(
        data=data,
        options=options,
        menu_path='test', 'free-echarts',
        order=8, rows_size=2, cols_size=6,
        sort={
            'field': 'date',
            'direction': 'asc',
        }
    )
    """


def input_form():
    """ Test input form """
    s.set_menu_path('Input forms')
    s.plt.input_form(order=0, options=input_form_data)


def dynamic_conditional_and_auto_send_input_form():
    s.set_menu_path('Input forms', 'dynamic conditional and auto send')

    form_groups = {
        f'form group {i}': [{
            'mapping': 'country',
            'fieldName': f'Country {i}',
            'inputType': 'select',
            'options': ['España', 'Colombia']
        },
            {
                'dependsOn': f'Country {i}',
                'mapping': 'city',
                'fieldName': f'City {i}',
                'inputType': 'select',
                'options': {
                    'España': ['Madrid', 'Barcelona'],
                    'Colombia': ['Bogotá', 'Medellin']
                }
            }
        ] for i in range(4)}

    form_groups['Personal information'] = \
        [
            {
                'mapping': 'name',
                'fieldName': 'name',
                'inputType': 'text',
            },
            {
                'mapping': 'surname',
                'fieldName': 'surname',
                'inputType': 'text',
            },
            {
                'mapping': 'age',
                'fieldName': 'age',
                'inputType': 'number',
            },
            {
                'mapping': 'tel',
                'fieldName': 'phone',
                'inputType': 'tel',
            },
            {
                'mapping': 'gender',
                'fieldName': 'Gender',
                'inputType': 'radio',
                'options': ['Male', 'Female', 'No-binary', 'Undefined'],
            },
            {
                'mapping': 'email',
                'fieldName': 'email',
                'inputType': 'email',
            },
        ]

    form_groups['Other data'] = \
        [
            {
                'mapping': 'skills',
                'fieldName': 'Skills',
                'options': ['Backend', 'Frontend', 'UX/UI', 'Api Builder', 'DevOps'],
                'inputType': 'checkbox',
            },
            {
                'mapping': 'birthDay',
                'fieldName': 'Birthday',
                'inputType': 'date',
            },
            {
                'mapping': 'onCompany',
                'fieldName': 'time on Shimoku',
                'inputType': 'dateRange',
            },
            {
                'mapping': 'hobbies',
                'fieldName': 'Hobbies',
                'inputType': 'select',
                'options': ['Make Strong Api', 'Sailing to Canarias', 'Send Abracitos'],
            },
            {
                'mapping': 'textField2',
                'fieldName': 'Test Text',
                'inputType': 'text',
            },
            {
                'mapping': 'objectives',
                'fieldName': 'Objetivos',
                'inputType': 'multiSelect',
                'options': ['sleep', 'close eyes', 'awake']
            }
        ]

    s.plt.generate_input_form_groups(
        order=0, form_groups=form_groups,
        dynamic_sequential_show=True
    )

    form_groups = {
        'Personal information': form_groups['Personal information'],
        'Other data': form_groups['Other data'],
    }
    s.plt.generate_input_form_groups(
        order=1, form_groups=form_groups,
        auto_send=True,
        dynamic_sequential_show=True,
    )


def get_input_forms():
    s.set_menu_path('Input forms', 'get input forms')
    s.plt.input_form(order=0, options=input_form_data)
    rs: List[Dict] = s.plt.get_input_forms()
    print(rs)
    assert rs


def tabs():
    s.set_menu_path("test-tabs")
    # s.plt.clear_menu_path()
    s.plt.set_shared_data(dfs={'main data': data})

    def _test_bentobox():
        with s.plt.set_bentobox(cols_size=8, rows_size=3):

            data_indic = [
                {
                    "description": "",
                    "title": "Estado",
                    "value": "Abierto",
                },
            ]
            s.plt.indicator(
                data=data_indic,
                order=0, rows_size=10, cols_size=12,
            )

            s.plt.indicator(
                data=data_indic,
                order=1, rows_size=10, cols_size=12,
            )

            s.plt.bar(
                data='main data', x='date',
                order=2, rows_size=26, cols_size=24,
            )

    with s.plt.set_tabs_index(tabs_index=("Deepness 0", "Bento box"), order=0):
        _test_bentobox()

        s.plt.change_current_tab("Table")
        s.plt.table(
            title="Test-table",
            data=table_data,
            order=0,
            categorical_columns=['filtA', 'filtB'],
            initial_sort_column='date',
            search=True,
        )

        s.plt.change_current_tab("line test")
        s.plt.line(data='main data', x='date', order=0)

        s.plt.change_current_tab("Bar 1")
        s.plt.bar(
            data='main data', x='date',
            x_axis_name='Date',
            y_axis_name='Revenue',
            order=0, rows_size=2,
            cols_size=12,
        )

        s.plt.change_current_tab("Input Form")
        s.plt.input_form(order=0, options=input_form_data)

        indicators_data = {
            "description": "",
            "title": "",
            "value": "INDICATOR CHANGED!",
            "color": "warning"
        }
        indicators_data_2 = {
            "description": "",
            "title": "",
            "value": "INDICATOR CHANGED!",
            "color": "main"
        }
        s.plt.change_current_tab("Indicators 2")
        s.plt.indicator(data=indicators_data_2, order=0)
        s.plt.change_current_tab("Indicators 1")
        s.plt.indicator(data=indicators_data, order=0)

    with s.plt.set_tabs_index(
        tabs_index=("Deepness 1", "Bento box"), order=1,
        parent_tabs_index=("Deepness 0", "Indicators 1"),
        sticky=False, just_labels=True):
        _test_bentobox()
        s.plt.change_current_tab("Indicators 1")

    for i in range(2, 5):
        with s.plt.set_tabs_index(
            (f"Deepness {i}", "Indicators 2"), order=1,
            parent_tabs_index=(f"Deepness {i - 1}", "Indicators 1"),
            sticky=False, just_labels=True
        ):
            s.plt.indicator(data=indicators_data_2, order=0)
            s.plt.change_current_tab("Indicators 1")
            s.plt.indicator(data=indicators_data, order=0)

    with s.plt.set_tabs_index(
        ("Bar deep 1", "Bar 1"), order=1,
        parent_tabs_index=("Deepness 0", "Bar 1"),
        sticky=False, just_labels=True
    ):
        s.plt.bar(
            data='main data', x='date',
            x_axis_name='Date',
            y_axis_name='Revenue',
            order=0, rows_size=2,
            cols_size=12,
        )
    with s.plt.set_tabs_index(
        ("Bar deep 2", "Bar 2"), order=1,
        parent_tabs_index=("Bar deep 1", "Bar 1"),
        sticky=False, just_labels=True
    ):
        s.plt.bar(
            data='main data',
            x='date', y='y',
            x_axis_name='Date',
            y_axis_name='Revenue',
            order=2, rows_size=2,
            cols_size=12,
        )
        s.plt.change_current_tab("Line 1")
        s.plt.line(
            data='main data', x='date',
            x_axis_name='Date',
            y_axis_name='Revenue',
            order=0, rows_size=2,
            cols_size=12,
        )
        s.plt.change_current_tab("Line 2")
        s.plt.line(
            data='main data', x='date',
            x_axis_name='Date',
            y_axis_name='Revenue',
            order=0, rows_size=2,
            cols_size=12,
        )

    # s.set_menu_path('test_delete_tabs')
    # s.plt.set_tabs_index(tabs_index=(f"Deepness 0", "Indicators 1"), order=0)
    # s.plt.indicator(data=indicators_data, order=0)
    # s.plt.change_current_tab("Indicators 2")
    # s.plt.indicator(data=indicators_data_2, order=0)
    # for i in range(1, 5):
    #     s.plt.set_tabs_index(tabs_index=(f"Deepness {i}", "Indicators 2"), order=1,
    #                          parent_tabs_index=(f"Deepness {i-1}", "Indicators 1"), sticky=False, just_labels=True)
    #     s.plt.indicator(data=indicators_data_2, order=0)
    #     s.plt.change_current_tab("Indicators 1")
    #     s.plt.indicator(data=indicators_data, order=0)
    #
    # s.plt.pop_out_of_tabs_group()
    #
    # s.plt.delete_tabs_group(name="Deepness 0")
    # assert 0 == len(s.app.get_app_reports(menu_path='test_delete_tabs'))


def gauge_indicators():
    s.set_menu_path('test-free-echarts', 'gauge-indicator')

    s.plt.gauge_indicator(
        order=0,
        value=83,
        description='Síntomas coincidientes | Mareo, Dolor cervical',
        title='Sobrecarga muscular en cervicales y espalda',
    )

    s.plt.gauge_indicator(
        order=2,
        value=31, color=2,
        description='Síntomas coincidientes | Dolor cervical',
        title='Bruxismo',
    )


def annotation_chart():
    s.set_menu_path('test', 'Annotation Chart')
    annotatted_data = [
        {'date': '2021-01-01', 'x': 1},
        {'date': '2021-01-02', 'x': 2},
        {'date': '2021-01-03', 'x': 3},
        {'date': '2021-01-04', 'x': 4},
        {'date': '2021-01-05', 'x': 5},
        {'date': '2021-01-06', 'x': 6},
        {'date': '2021-01-07', 'x': 7},
        {'date': '2021-01-08', 'x': 8},
        {'date': '2021-01-09', 'x': 9},
        {'date': '2021-01-10', 'x': 10},
    ]

    s.plt.annotated_chart(data=[annotatted_data], x='date', y='x', order=0)

    data1 = [
        {'date': '2022-01-01', 'Síntoma [1]': 3},
        {'date': '2022-03-01', 'Síntoma [1]': 7, 'Annotation': 'Got really sick'},
        {'date': '2022-04-01', 'Síntoma [1]': 7},
        {'date': '2022-07-01', 'Síntoma [1]': 8},
        {'date': '2022-08-01', 'Síntoma [1]': 9},
        {'date': '2022-12-01', 'Síntoma [1]': 5},
    ]
    data2 = [
        {'date': '2021-12-31', 'Síntoma [2]': 6},
        {'date': '2022-01-02', 'Síntoma [2]': 9},
        {'date': '2022-02-01', 'Síntoma [2]': 7},
        {'date': '2022-03-01', 'Síntoma [2]': 8},
        {'date': '2022-04-01', 'Síntoma [2]': 9},
        {'date': '2022-05-01', 'Síntoma [2]': 7},
        {'date': '2022-06-01', 'Síntoma [2]': 8, 'Annotation': 'Go away symptom [2]!'},
        {'date': '2022-07-01', 'Síntoma [2]': 9},
        {'date': '2022-08-01', 'Síntoma [2]': 8},
    ]

    s.plt.annotated_chart(
        order=7, x='date', y=['Síntoma [1]', 'Síntoma [2]'], annotations='Annotation',
        data=[data1, data2], slider_config={'max': 100, 'defaultValue': 50},
        slider_marks=[('Low', 15), ('Medium', 50), ('High', 85)]
    )


def rainfall_area():
    s.set_menu_path('test-free-echarts', 'rainfall-area')
    how_many = 100

    data = []
    for i in range(0, len(flow), max(3, len(flow) // how_many)):
        data.append({'Date': time[i], 'flow': flow[i], 'flow+1': flow[(i + 101) % len(flow)],
                     'flow+2': flow[(i + 202) % len(flow)],
                     'rainfall': rainfall[i], 'rainfall+1': rainfall[(i + 101) % len(flow)],
                     'rainfall+2': rainfall[(i + 202) % len(flow)]})

    s.plt.top_bottom_area(
        data=data, order=0,
        x='Date', top_names=['flow', 'flow+1', 'flow+2'], bottom_names=['rainfall', 'rainfall+1', 'rainfall+2'],
        title='rainfall and flow', x_axis_name='Date', top_axis_name='flow(m³/s)', bottom_axis_name='rainfall(mm)',
        variant='minimal'
    )

    data = []
    for i in range(0, len(flow), max(1, len(flow) // how_many)):
        data.append({'Date': time[i], 'flow': flow[i], 'rainfall': rainfall[i]})

    s.plt.top_bottom_area(
        data=data, order=1,
        x='Date', top_names=['flow'], bottom_names=['rainfall'],
        title='rainfall and flow', x_axis_name='Date', top_axis_name='flow(m³/s)', bottom_axis_name='rainfall(mm)',
        variant='clean'
    )


def rainfall_line():
    s.set_menu_path('test-free-echarts', 'rainfall-line')
    how_many = 100

    data = []
    for i in range(0, len(flow), max(3, len(flow) // how_many)):
        data.append({'Date': time[i], 'flow': flow[i], 'flow+1': flow[(i + 101) % len(flow)],
                     'flow+2': flow[(i + 202) % len(flow)],
                     'rainfall': rainfall[i], 'rainfall+1': rainfall[(i + 101) % len(flow)],
                     'rainfall+2': rainfall[(i + 202) % len(flow)]})

    s.plt.top_bottom_line(
        data=data, order=0,
        x='Date', top_names=['flow', 'flow+1', 'flow+2'], bottom_names=['rainfall', 'rainfall+1', 'rainfall+2'],
        title='rainfall and flow', x_axis_name='Date', top_axis_name='flow(m³/s)', bottom_axis_name='rainfall(mm)',
    )

    data = []
    for i in range(0, len(flow), max(1, len(flow) // how_many)):
        data.append({'Date': time[i], 'flow': flow[i], 'rainfall': rainfall[i]})

    s.plt.top_bottom_line(
        data=data, order=1,
        x='Date', top_names=['flow'], bottom_names=['rainfall'],
        title='rainfall and flow', x_axis_name='Date', top_axis_name='flow(m³/s)', bottom_axis_name='rainfall(mm)',
    )


def modal():
    prediction_header = (
        "<head>"
        "<style>"  # Styles title
        ".component-title{height:auto; width:100%; "
        "border-radius:16px; padding:16px;"
        "display:flex; align-items:center;"
        "background-color:var(--chart-C1); color:var(--color-white);}"
        "<style>.base-white{color:var(--color-white);}</style>"
        "</head>"  # Styles subtitle
        "<div class='component-title'>"
        "<div class='big-icon-banner'></div>"
        "<div class='text-block'>"
        "<h1>Predictions</h1>"
        "<p class='base-white'>"
        "Modal Test</p>"
        "</div>"
        "</div>"
    )
    s.set_menu_path('Modal Test')

    with s.plt.set_modal('Test modal', open_by_default=True, width=70, height=60):
        s.plt.html(html=prediction_header, order=0)

        with s.plt.set_tabs_index(('Test', 'Tab 1'), order=1):
            s.plt.table(data=table_data, order=0, rows_size=3,
                        title='Table test', categorical_columns=['filtA', 'filtB'])
            s.plt.html(html=prediction_header, order=1)

    s.plt.html(html=prediction_header, order=0)
    with s.plt.set_tabs_index(('TestNoModal', 'Table'), order=0):
        s.plt.table(data=table_data, order=0, rows_size=3, title='Table test', categorical_columns=['filtA', 'filtB'])

    s.plt.modal_button(order=1, modal='Test modal', label='Open modal')


def bar_and_line_chart():
    s.set_menu_path('test-free-echarts', 'Bar and line chart')

    _data = [
        {'day': 'Mon', 'Evaporation': 2.0, 'Precipitation': 2.6, 'Temperature': 2.0},
        {'day': 'Tue', 'Evaporation': 4.9, 'Precipitation': 5.9, 'Temperature': 2.2},
        {'day': 'Wed', 'Evaporation': 7.0, 'Precipitation': 9.0, 'Temperature': 3.3},
        {'day': 'Thu', 'Evaporation': 23.2, 'Precipitation': 26.4, 'Temperature': 4.5},
        {'day': 'Fri', 'Evaporation': 25.6, 'Precipitation': 28.7, 'Temperature': 6.3},
        {'day': 'Sat', 'Evaporation': 76.7, 'Precipitation': 70.7, 'Temperature': 10.2},
        {'day': 'Sun', 'Evaporation': 135.6, 'Precipitation': 175.6, 'Temperature': 20.3},
    ]

    s.plt.line_and_bar_charts(
        data=_data, order=0,
        x='day', bar_names=['Evaporation', 'Precipitation'], line_names=['Temperature'],
        title='rainfall and temperature', x_axis_name='Day', line_axis_name='Temperature',
        line_suffix=' °C', bar_axis_name='Evaporation and precipitacion', bar_suffix=' ml',
        variant='minimal'
    )

    aux_data = pd.DataFrame(_data)

    aux_data['Temperature'] = aux_data['Temperature'] * 67
    aux_data['Evaporation'] = aux_data['Evaporation'] * 42
    aux_data['Precipitation'] = aux_data['Precipitation'] * 42

    s.plt.line_and_bar_charts(
        data=aux_data, order=1,
        x='day', bar_names=['Evaporation', 'Precipitation'], line_names=['Temperature'],
        title='rainfall and temperature', x_axis_name='Day', line_axis_name='Temperature',
        line_suffix=' °C', bar_axis_name='Evaporation and precipitacion', bar_suffix=' ml',
        variant='clean'
    )

    aux_data = pd.DataFrame(_data)

    aux_data['Temperature'] = aux_data['Temperature'] / 10000
    aux_data['Evaporation'] = aux_data['Evaporation'] * 542
    aux_data['Precipitation'] = aux_data['Precipitation'] * 542

    s.plt.line_and_bar_charts(
        data=aux_data, order=2,
        x='day', bar_names=['Evaporation', 'Precipitation'], line_names=['Temperature'],
        title='rainfall and temperature', x_axis_name='Day', line_axis_name='Temperature',
        line_suffix=' °C', bar_axis_name='Evaporation and precipitacion', bar_suffix=' ml',
    )


def segmented_line_chart():
    res = requests.get(url='https://echarts.apache.org/examples/data/asset/data/aqi-beijing.json')

    # Convert it to json
    data = res.json()[-100:]

    # Remap data
    df = pd.DataFrame([
        {
            'date': data[i][0],
            'y': data[i][1],
            'y_displaced': data[(i + 10) % len(data)][1],
            'y_multiplied': data[i][1] * 2,
        } for i in range(len(data))
    ])

    s.set_menu_path('test-free-echarts', 'Segmented Line Chart')
    marking_lines = [0, 50, 100, 150, 200, 300]
    range_colors = ['green', 'yellow', 'orange', 'red', 'purple', 'maroon']
    x_axis_name = 'Date'
    y_axis_name = 'AQI'

    s.plt.segmented_line(data=df, order=0, x='date', y=['y', 'y_displaced', 'y_multiplied'],
                         marking_lines=marking_lines)

    s.plt.segmented_line(
        data=df, order=1, x='date', y='y', title="Beijing's Air Quality Index",
        marking_lines=marking_lines, range_colors=range_colors,
        x_axis_name=x_axis_name, y_axis_name=y_axis_name,
        variant='clean'
    )


def segmented_area_chart():
    s.set_menu_path('test-free-echarts', 'Segmented Area Chart')
    labels = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
              'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z']
    s.plt.segmented_area(
        data='noise', order=1, x='x', y='y', threshold=0.7,
        top_area=True, default_color=(0, 0, 255), labels=labels
    )
    s.plt.segmented_area(
        data='noise', order=2, x='x', y='y', threshold=0.7, labels=labels
    )
    s.plt.segmented_area(
        data='noise', order=3, x='x', y='y',
        segments=[(30, 45), (60, 70, 'var(--chart-C1)'), (75, 95, (1, 220, 1))]
    )


def marked_line_chart():
    s.set_menu_path('test-free-echarts', 'Marked Line Chart')
    s.plt.marked_line(
        data='table', x='date',
        marks=[('first segment', 0, 1), ('second segment', 2, 3)],
        order=0, rows_size=2, cols_size=12, y=['x', 'y']
    )


def variants():
    s.set_menu_path('test-free-echarts', 'Variants')

    s.plt.stacked_bar(
        data='stacked data', order=0, cols_size=6,
        x='Segment', variant='clean shadow', show_values='all'
    )
    s.plt.stacked_horizontal_bar(
        data='stacked data', order=1, cols_size=6,
        x='Segment', variant='minimal shadow', show_values='all',
    )
    s.plt.bar(
        data='table', order=2, cols_size=6, x='date',
        variant='shadow', show_values=['x']
    )
    s.plt.horizontal_bar(
        data='horizontal bar', x='name', order=3, cols_size=6,
        show_values=['value'], variant='clean shadow',
    )
    s.plt.bar(
        data='table', order=4, cols_size=6, x='date',
        variant='clean thin', show_values=['x']
    )
    s.plt.horizontal_bar(
        data='horizontal bar',
        x='name', order=5, cols_size=6,
        show_values=['value'], variant='clean thin',
    )
    s.plt.stacked_bar(
        data='stacked data', order=6, cols_size=6, x='Segment',
        variant='thin', show_values='all'
    )
    s.plt.stacked_horizontal_bar(
        data='stacked data', order=7, cols_size=6,
        x='Segment', variant='clean thin', show_values='all',
    )
    s.plt.area(data='table', order=8, cols_size=3, rows_size=2, x='date', y='x', variant='minimal')
    s.plt.line(data='table', order=9, cols_size=3, rows_size=2, x='date', y='x', variant='minimal')


def x_axis_tandem_chart():
    menu_path = 'test-free-echarts', 'X Axis Tandem Chart'
    top_axis_name = 'months of 2015'
    bottom_axis_name = 'months of 2016'
    y_axis_name = 'values'
    title = 'Comparison of values between 2015 and 2016'

    data = [
        {'dates2015': '2015-1', 'dates2016': '2016-1', '2015': 2.6, '2016': 3.9},
        {'dates2015': '2015-2', 'dates2016': '2016-2', '2015': 5.9, '2016': 5.9},
        {'dates2015': '2015-3', 'dates2016': '2016-3', '2015': 9.0, '2016': 11.1},
        {'dates2015': '2015-4', 'dates2016': '2016-4', '2015': 26.4, '2016': 18.7},
        {'dates2015': '2015-5', 'dates2016': '2016-5', '2015': 28.7, '2016': 48.3},
        {'dates2015': '2015-6', 'dates2016': '2016-6', '2015': 70.7, '2016': 69.2},
        {'dates2015': '2015-7', 'dates2016': '2016-7', '2015': 175.6, '2016': 231.6},
        {'dates2015': '2015-8', 'dates2016': '2016-8', '2015': 182.2, '2016': 46.6},
        {'dates2015': '2015-9', 'dates2016': '2016-9', '2015': 48.7, '2016': 55.4},
        {'dates2015': '2015-10', 'dates2016': '2016-10', '2015': 18.8, '2016': 18.4},
        {'dates2015': '2015-11', 'dates2016': '2016-11', '2015': 6.0, '2016': 10.3},
        {'dates2015': '2015-12', 'dates2016': '2016-12', '2015': 2.3, '2016': 0.7}
    ]

    s.plt.x_axes_tandem_chart(
        data=data, menu_path=menu_path, order=0, top_x='dates2015', bottom_x='dates2016'
    )

    s.plt.x_axes_tandem_chart(
        data=data, menu_path=menu_path, order=1, top_x='2015', bottom_x='2016', top_axis_name=top_axis_name,
        bottom_axis_name=bottom_axis_name, y_axis_name=y_axis_name, title=title, begin_as_bar=True
    )
    s.run()


def infographics():
    s.set_menu_path('test-bentobox', 'Infographics')
    title = 'Lorem ipsum'
    text = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et " \
           "dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex" \
           " ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu" \
           " fugiat nulla pariatur. "

    s.plt.infographics_text_bubble(
        order=0, cols_size=6,
        title=title, text=text, bubble_location='bottom',
        chart_parameters=dict(
            data=data, x='date',
            rows_size=16,
            option_modifications=dict(
                toolbox={'show': False},
                grid={'left': '0%', 'right': '0%', 'top': '0%', 'bottom': '0%', 'containLabel': True},
            ),
        ),
    )

    s.plt.infographics_text_bubble(
        order=2, cols_size=6,
        title=title, text=text,
        chart_function=s.plt.line,
        chart_parameters=dict(
            x='date', y='x', data=data,
            option_modifications=dict(
                toolbox={'show': False},
                grid={'left': '0%', 'right': '0%', 'top': '0%', 'bottom': '0%', 'containLabel': True},
            ),
        ),
    )

    s.plt.infographics_text_bubble(
        order=4, cols_size=6,
        title=title, text=text,
        chart_function=s.plt.shimoku_gauge,
        chart_parameters=dict(
            value=70, name='Gauge', rows_size=18,
            padding='0,0,0,0'
        ),
    )
    stacked_data = [
        {'Weekday': 'Mon', 'Email': 120, 'Union Ads': 132, 'Video Ads': 101, 'Search Engine': 134},
        {'Weekday': 'Tue', 'Email': 220, 'Union Ads': 182, 'Video Ads': 191, 'Search Engine': 234},
        {'Weekday': 'Wed', 'Email': 150, 'Union Ads': 232, 'Video Ads': 201, 'Search Engine': 154},
        {'Weekday': 'Thu', 'Email': 820, 'Union Ads': 932, 'Video Ads': 901, 'Search Engine': 934},
        {'Weekday': 'Fri', 'Email': 120, 'Union Ads': 132, 'Video Ads': 101, 'Search Engine': 134},
        {'Weekday': 'Sat', 'Email': 220, 'Union Ads': 182, 'Video Ads': 191, 'Search Engine': 234},
        {'Weekday': 'Sun', 'Email': 150, 'Union Ads': 232, 'Video Ads': 201, 'Search Engine': 154},
    ]
    s.plt.infographics_text_bubble(
        order=6, cols_size=6, rows_size=4,
        title=title, text=text, bubble_location='bottom',
        chart_function=s.plt.stacked_bar,
        chart_parameters=dict(
            data=stacked_data,
            x="Weekday",
            x_axis_name='weekday',
            y_axis_name='visits',
            option_modifications=dict(
                toolbox={'show': False},
                grid={'left': '0%', 'right': '0%', 'top': '0%', 'bottom': '0%', 'containLabel': True},
            ),
        ),
        background_color='var(--color-stripe-light)',
    )

    s.plt.infographics_text_bubble(
        order=8, title=title, text=text, bubble_location='right',
        chart_parameters=dict(
            data=data, x='date',
            option_modifications=dict(
                toolbox={'show': False},
                grid={'left': '0%', 'right': '0%', 'top': '0%', 'bottom': '0%', 'containLabel': True},
            ),
        ),
        background_url='https://images.unsplash.com/photo-1569982175971-d92b01cf8694?ixlib=rb-4.0.3&ixid='
                       'MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=870&q=80'
    )

    form_groups = {
        'Personal information':
            [
                {
                    'mapping': 'name',
                    'fieldName': 'name',
                    'inputType': 'text',
                },
            ],
        'Other group':
            [
                {
                    'mapping': 'skills',
                    'fieldName': 'Skills',
                    'options': ['Backend', 'Frontend', 'UX/UI', 'Api Builder', 'DevOps'],
                    'inputType': 'checkbox',
                },
            ]
    }

    s.plt.infographics_text_bubble(
        order=10, cols_size=8,
        title=title, text=text, bubble_location='left',
        chart_function=s.plt.generate_input_form_groups,
        chart_parameters=dict(
            form_groups=form_groups,
            dynamic_sequential_show=True,
            padding='5,1,0,0',
        ),
        background_color='var(--color-primary-light)'
    )

    s.plt.infographics_text_bubble(
        order=12, cols_size=4,
        title=title, text=text, bubble_location='left',
        chart_function=s.plt.shimoku_gauge,
        chart_parameters=dict(
            value=49, name='Gauge', padding='5,1,0,0',
            cols_size=10, color=3,
        )
    )
    s.plt.infographics_text_bubble(
        order=14, cols_size=6,
        title=title, text=text, bubble_location='left',
        image_url='default', image_size=60,
        background_color='var(--color-primary-light)',
        chart_parameters=dict(
            data=data, x='date',
            cols_size=10,
            option_modifications=dict(
                toolbox={'show': False},
                grid={'left': '0%', 'right': '0%', 'top': '0%', 'bottom': '0%', 'containLabel': True},
            ),
        )
    )
    s.plt.infographics_text_bubble(
        order=16, cols_size=6, rows_size=4,
        title=title, text=text, bubble_location='right',
        image_url='default',
        chart_function=s.plt.table,
        chart_parameters=dict(
            data=data, rows_size=3,
            cols_size=10,
        )
    )

    s.plt.infographics_text_bubble(
        order=18,
        title=title, text=text, bubble_location='right',
        image_url='default', image_size=50,
        chart_function=s.plt.table,
        chart_parameters=dict(
            data=stacked_data,
            cols_size=16, rows_size=3,
        )
    )


def chart_and_indicators():
    s.set_menu_path('test-bentobox', 'chart-and-indicators')
    indicator_groups = [
        [
            {
                "description": "-950.55",
                "title": "Dow Jones",
                "value": "33,195.92",
                "align": "left",
                "color": "success",
                'variant': 'contained'
            },
            {
                "description": "-84.68",
                "title": "Nasdaq",
                "value": "10,852.16",
                "align": "left",
                "color": "success",
                'variant': 'contained'
            },
            {
                "description": "-950.55",
                "title": "Dow Jones",
                "value": "33,195.92",
                "align": "left",
                "color": "success",
                'variant': 'contained'
            },
            {
                "description": "-84.68",
                "title": "Nasdaq",
                "value": "10,852.16",
                "align": "left",
                "color": "success",
                'variant': 'contained'
            },
            {
                "description": "-950.55",
                "title": "Dow Jones",
                "value": "33,195.92",
                "align": "left",
                "color": "success",
                'variant': 'contained'
            },
        ],
        [
            {
                "description": "-950.55",
                "title": "Dow Jones",
                "value": "33,195.92",
                "align": "left",
                "color": "success",
                'variant': 'contained'
            },
            {
                "description": "-84.68",
                "title": "Nasdaq",
                "value": "10,852.16",
                "align": "left",
                "color": "success",
                'variant': 'contained'
            }
        ],
        [
            {
                "description": "Return of investment",
                "title": "ROI",
                "value": "1.5M",
                "align": "left",
                "color": "success",
                'variant': 'contained'
            },
            {
                "description": "% of times the algorithm has predicted the relative position of "
                               "NY prices with respect to HK prices correctly",
                "title": "Accuracy",
                "value": "76.67%",
                "align": "left",
                "color": "success",
                'variant': 'contained'
            }
        ],
        [
            {
                "description": "Return of investment",
                "title": "ROI",
                "value": "1.5M",
                "align": "left",
                "color": "success",
                'variant': 'contained'
            },
            {
                "description": "% of times the algorithm has predicted the relative position of "
                               "NY prices with respect to HK prices correctly",
                "title": "Accuracy",
                "value": "76.67%",
                "align": "left",
                "color": "success",
                'variant': 'contained'
            },
            {
                "description": "% of times the algorithm has predicted the relative position of "
                               "NY prices with respect to HK prices correctly",
                "title": "Accuracy",
                "value": "76.67%",
                "align": "left",
                "color": "success",
                'variant': 'contained'
            }
        ]
    ]

    s.plt.chart_and_indicators(
        order=0,
        chart_rows_size=3, cols_size=6,
        chart_function=s.plt.line,
        chart_parameters=dict(
            data=data,
            x='date',
            y='x',
            title='Line Chart With Indicators',
        ),
        indicators_groups=indicator_groups,
        indicators_parameters={}
    )


def summary_line():
    s.set_menu_path('test-bentobox', 'summary-line')
    summary_data = [
        {'date': '28 days', 'x': 5, 'y': 5, 'filtA': 'A', 'filtB': 'Z', 'name': 'Ana'},
        {'date': '21 days', 'x': 6, 'y': 5, 'filtA': 'B', 'filtB': 'Z', 'name': 'Laura'},
        {'date': '14 days', 'x': 4, 'y': 5, 'filtA': 'A', 'filtB': 'W', 'name': 'Audrey'},
        {'date': '7 days', 'x': 7, 'y': 5, 'filtA': 'B', 'filtB': 'W', 'name': 'Jose'},
        {'date': 'today', 'x': 3, 'y': 5, 'filtA': 'A', 'filtB': 'Z', 'name': 'Jorge'},
    ]
    s.plt.line_with_summary(
        data=summary_data, order=4, x='date', y='x',
        title='Total', description='Today', value=7.94
    )


class TestPlotApi(unittest.TestCase):
    def test_delete_path(self):
        init_time = perf_counter()
        ini_calls = s.get_api_calls_counter()
        menu_path: str = 'test-path'
        sub_path: str = 'line-test'
        sub_path_2: str = 'line-test-2'
        sub_path_3: str = 'line-test-3'

        s.set_menu_path(menu_path)
        s.plt.clear_menu_path()

        s.set_menu_path(menu_path, sub_path)

        s.plt.line(data=data, x='date', order=0)
        s.plt.line(data=data, x='date', order=1)

        reports: List[Dict] = s.menu_paths.get_menu_path_components(name=menu_path)
        assert len(reports) == 2

        s.plt.clear_menu_path()

        assert len(s.menu_paths.get_menu_path_components(name=menu_path)) == 0
        for i in range(10):
            s.plt.line(data=data, x='date', order=i)

        s.set_menu_path(menu_path, sub_path_2)
        s.plt.line(data=data, x='date', order=0)

        s.set_menu_path(menu_path, sub_path_3)
        s.plt.line(data=data, x='date', order=0)

        assert len(s.menu_paths.get_menu_path_components(name=menu_path)) == 12

        s.set_menu_path(menu_path, sub_path)
        s.plt.clear_menu_path()
        assert len(s.menu_paths.get_menu_path_components(name=menu_path)) == 2

        s.set_menu_path(menu_path)
        s.plt.clear_menu_path()
        assert len(s.menu_paths.get_menu_path_components(name=menu_path)) == 0

        s.set_menu_path('test')
        s.menu_paths.delete_menu_path(name=menu_path)

        print(f'Total elapsed time: {perf_counter() - init_time:.2f} s')
        print(f'Number of api calls {s.get_api_calls_counter() - ini_calls}')

    def test_delete(self):
        init_time = perf_counter()
        ini_calls = s.get_api_calls_counter()
        s.set_menu_path('test-delete', 'line-test')
        s.plt.line(data=data, x='date', order=0)
        assert s.menu_paths.get_menu_path_components(name='test-delete')
        s.plt.delete_chart_by_order(order=0)
        assert not s.menu_paths.get_menu_path_components(name='test-delete')
        s.set_menu_path('test')
        s.menu_paths.delete_menu_path(name='test-delete')
        print(f'Total elapsed time: {perf_counter() - init_time:.2f} s')
        print(f'Number of api calls {s.get_api_calls_counter() - ini_calls}')

    def test_charts(self):
        init_time = perf_counter()
        ini_calls = s.get_api_calls_counter()

        s.set_menu_path('test')
        s.plt.set_shared_data(
            dfs={
                'main data': data,
                'zero centered data': zero_centered_data,
                'funnel data': funnel_data,
                'heatmap data': heatmap_data,
            },
            custom_data={
                'tree_data': tree_data,
                'sunburst_data': sunburst_data,
            }
        )
        indicator()
        color_by_value_indicators()
        speed_gauge()
        line()
        predictive_line()
        bar()
        scatter()
        area()
        horizontal_bar_chart()
        zero_centered_barchart()
        funnel()
        iframe()
        bentobox()
        radar()
        pie()
        rose()
        doughnut()
        html()
        tree()
        sunburst()
        treemap()
        sankey()
        heatmap()
        table()
        s.update_data_sets()
        table_with_labels()
        s.reuse_data_sets()
        annotation_chart()
        s.run()
        print(f'Total elapsed time: {perf_counter() - init_time:.2f} s')
        print(f'Number of api calls {s.get_api_calls_counter() - ini_calls}')

    def test_free_echarts(self):
        init_time = perf_counter()
        ini_calls = s.get_api_calls_counter()
        s.set_menu_path('test-free-echarts')
        stacked_data = pd.read_csv('../../data/test_stack_distribution.csv')
        s.plt.set_shared_data({
            'stacked data': stacked_data,
            'noise': noise_data,
            'table': table_data,
            'horizontal bar': horizontal_bar_data,
        })
        stacked_bar_chart()
        stacked_horizontal_bar_chart()
        stacked_area_chart()
        shimoku_gauges()
        gauge_indicators()
        free_echarts()
        rainfall_area()
        rainfall_line()
        line_with_confidence_area()
        scatter_with_effect()
        waterfall()
        bar_and_line_chart()
        segmented_line_chart()
        segmented_area_chart()
        marked_line_chart()
        variants()
        s.run()
        print(f'Total elapsed time: {perf_counter() - init_time:.2f} s')
        print(f'Number of api calls {s.get_api_calls_counter() - ini_calls}')

    def test_bento_box(self):
        init_time = perf_counter()
        ini_calls = s.get_api_calls_counter()
        infographics()
        chart_and_indicators()
        summary_line()
        s.run()
        print(f'Total elapsed time: {perf_counter() - init_time:.2f} s')
        print(f'Number of api calls {s.get_api_calls_counter() - ini_calls}')

    def test_filters(self):
        init_time = perf_counter()
        ini_calls = s.get_api_calls_counter()
        s.set_board('Test')
        s.set_menu_path('test-filters')
        s.plt.set_shared_data(
            dfs={
                'table': pd.DataFrame(table_data),
            }
        )
        s.plt.filter(order=0, data='table', field='date')
        s.plt.filter(order=1, data='table', field='x')
        s.plt.filter(order=2, data='table', field='filtA')
        s.plt.filter(order=3, data='table', field='filtB', multi_select=True, padding='0,0,0,8')

        s.plt.bar(data='table', order=4, cols_size=6, x='date', y=['x', 'y'])
        s.plt.line(data='table', order=5, cols_size=6, x='date', y=['x', 'y'])
        s.plt.stacked_bar(data='table', x='date', y=['x', 'y'], order=6)
        s.plt.table(data=table_data * 10, order=7, rows_size=3, title='Table test',
                    categorical_columns=['filtA', 'filtB'])
        s.run()
        print(f'Total elapsed time: {perf_counter() - init_time:.2f} s')
        print(f'Number of api calls {s.get_api_calls_counter() - ini_calls}')

    # Filters and sequential needed TODO resolve with filter dataset
    # test_heatmap_with_filters()
    # test_bar_with_filters_with_aggregation_methods()
    # test_bar_with_filters()

    def test_tabs(self):
        init_time = perf_counter()
        ini_calls = s.get_api_calls_counter()
        s.set_board("Tabs dashboard")
        tabs()
        s.run()
        print(f'Total elapsed time: {perf_counter() - init_time:.2f} s')
        print(f'Number of api calls {s.get_api_calls_counter() - ini_calls}')

    def test_modals(self):
        init_time = perf_counter()
        ini_calls = s.get_api_calls_counter()
        s.set_board("Modals dashboard")
        modal()
        s.run()
        print(f'Total elapsed time: {perf_counter() - init_time:.2f} s')
        print(f'Number of api calls {s.get_api_calls_counter() - ini_calls}')

    def test_forms(self):
        init_time = perf_counter()
        ini_calls = s.get_api_calls_counter()
        s.set_board('Others')
        input_form()
        dynamic_conditional_and_auto_send_input_form()
        get_input_forms()
        s.run()
        print(f'Total elapsed time: {perf_counter() - init_time:.2f} s')
        print(f'Number of api calls {s.get_api_calls_counter() - ini_calls}')

    def test_menu_order(self):
        init_time = perf_counter()
        ini_calls = s.get_api_calls_counter()
        s.workspaces.change_boards_order(
            uuid=workspace_id,
            boards=[
                'Dashboard',
                'Others',
                'Modals dashboard',
                'Tabs dashboard',
                '---'
            ]
        )
        s.workspaces.change_menu_order(
            uuid=workspace_id,
            menu_order=[
                ('test', [
                    'line-test',
                    'bar-test',
                    'pie-test',
                    'area-test',
                    'scatter-test',
                    'radar-test',
                    '---'
                ]),
                ('test-bentobox', [
                    'chart-and-indicators',
                    'Infographics',
                ]),
                'test-free-echarts',
                '---'
            ]
        )
        print(f'Total elapsed time: {perf_counter() - init_time:.2f} s')
        print(f'Number of api calls {s.get_api_calls_counter() - ini_calls}')

    def test_same_position_charts(self):
        init_time = perf_counter()
        ini_calls = s.get_api_calls_counter()
        s.set_menu_path('test-same-position', 'no conflict path 1')

        s.activate_async_execution()

        s.plt.clear_menu_path()
        s.plt.gauge_indicator(
            order=0,
            value=83,
            description='Síntomas coincidientes | Mareo, Dolor cervical',
            title='Sobrecarga muscular en cervicales y espalda',
        )

        s.set_menu_path('test-same-position', 'no conflict path 2')
        s.plt.gauge_indicator(
            order=1,
            value=31, color=2,
            description='Síntomas coincidientes | Dolor cervical',
            title='Bruxismo',
        )

        s.set_menu_path('test-same-position', 'no conflict tabs')
        s.plt.set_tabs_index(tabs_index=('tabs', '1'), order=0)
        s.plt.gauge_indicator(
            order=0,
            value=83,
            description='Síntomas coincidientes | Mareo, Dolor cervical',
            title='Sobrecarga muscular en cervicales y espalda',
        )

        s.plt.change_current_tab("2")
        s.plt.gauge_indicator(
            order=1,
            value=31, color=2,
            description='Síntomas coincidientes | Dolor cervical',
            title='Bruxismo',
        )

        s.plt.pop_out_of_tabs_group()
        s.run()

        with self.assertRaises(RuntimeError):
            s.set_menu_path('test-same-position', 'conflict')
            s.plt.gauge_indicator(
                order=0,
                value=83,
                description='Síntomas coincidientes | Mareo, Dolor cervical',
                title='Sobrecarga muscular en cervicales y espalda',
            )

            s.plt.gauge_indicator(
                order=1,
                value=31, color=2,
                description='Síntomas coincidientes | Dolor cervical',
                title='Bruxismo',
            )
            s.run()

        with self.assertRaises(RuntimeError):
            s.set_menu_path('test-same-position', 'conflict')
            s.plt.set_tabs_index(tabs_index=('conflict', 'conflict'), order=0)
            s.plt.gauge_indicator(
                order=0,
                value=83,
                description='Síntomas coincidientes | Mareo, Dolor cervical',
                title='Sobrecarga muscular en cervicales y espalda',
            )

            s.plt.gauge_indicator(
                order=1,
                value=31, color=2,
                description='Síntomas coincidientes | Dolor cervical',
                title='Bruxismo',
            )
            s.run()

        s.set_menu_path('test-same-position')
        s.plt.clear_menu_path()

        assert 0 == len(s.menu_paths.get_menu_path_components(name='test-same-position'))

        s.set_menu_path('test')
        s.menu_paths.delete_menu_path(name='test-same-position')

        print(f'Total elapsed time: {perf_counter() - init_time:.2f} s')
        print(f'Number of api calls {s.get_api_calls_counter() - ini_calls}')

    def test_no_reappend_app_to_dashboard(self):
        init_time = perf_counter()
        ini_calls = s.get_api_calls_counter()

        s.set_board('Test')
        s.set_menu_path('test-no-reappend')
        s.pop_out_of_menu_path()
        how_many_apps = len(s.boards.get_board_menu_path_ids(name='Test'))
        s.set_menu_path('test-no-reappend')
        s.pop_out_of_menu_path()
        assert how_many_apps == len(s.boards.get_board_menu_path_ids(name='Test'))

        s2 = initiate_shimoku()
        s2.set_workspace(workspace_id)
        s2.set_board('Test')
        s2.set_menu_path('test-no-reappend')
        s2.pop_out_of_menu_path()
        assert how_many_apps == len(s2.boards.get_board_menu_path_ids(name='Test'))

        s.menu_paths.delete_menu_path(name='test-no-reappend')

        print(f'Total elapsed time: {perf_counter() - init_time:.2f} s')
        print(f'Number of api calls {s.get_api_calls_counter() - ini_calls}')


if __name__ == '__main__':
    # profiler = cProfile.Profile()
    # profiler.enable()
    unittest.main()
    # profiler.disable()
    # stats = pstats.Stats(profiler)
    # stats.dump_stats('profile_output.prof')
