# Micro Shop Framework

[![CircleCI](https://circleci.com/bb/Qoyyuum/shoppy.svg?style=svg)](https://circleci.com/bb/Qoyyuum/shoppy)


Made in Python 3.

Welcome to the micro shopping framework, `shop-python`.

Install it with pip:

```python
python3 -m pip install shop-python --upgrade
```

You can then import the module.

This module consists of 4 other packages, namely:

- Product
- POS
- Customer
- Store

```python
from shop_python import Product, POS, Customer, Store
```

## Product

Product package class has the following attributes:

- uniqueId
- name
- price
- description
- quantity

`uniqueId` is not autogenerated for each product. Developer will have to create one, including for all other attributes.

Example usage:

```python
banana = Product(uniqueId="FRUITBANANA001", name="Yellow Sweet Banana", price=2.50, description="Sweet, yellow, ripe banana, air-flown from Australia", quantity=100)
```

## POS

POS is the Point of Sale package that operates the cash register for the clerk/teller to manage customer transactions. Currently it only checks for balance amount and movement of the transactions.

Initiate the POS instance with a starting balance amount.

```python
cashier_pos = POS(balance=100.0)
```

When performing a transaction for money coming into the cash register, use the `money_in()` function.

```python
cashier_pos.money_in(amount=24.99)
```

When performing a transaction for money coming out of the cash register, use the `money_out()` function.

```python
cashier_pos.money_out(amount=24.99)
```

To get the current balance of the POS, get its balance attribute.

```python
cashier_pos.balance
```

## Customer

// TODO

## Store

A store is one shop. A shop has a name, a list of products and a POS associated with it (TODO: Turn it into a list of POS for multiple tellers/cashiers)

Initiate a store instance with a POS and a list of Products.

```python
my_shop = Store(name="My Supermarket", pos=cashier_pos, products=[banana])
```

Display a list of products in the store:

```python
my_shop.displayProducts()
```