# Shotcut Python API Client

A Python client for the Shotcut.in URL shortener API. This package provides a simple interface to interact with all Shotcut.in API endpoints.

## Installation

```bash
pip install shotcut-python
```

## Quick Start

```python
from shotcut import ShotcutAPI

# Initialize the client
api = ShotcutAPI(api_key="your_api_key_here")

# Shorten a URL
response = api.shorten_link(
    url="https://example.com",
    custom="my-custom-alias"
)
print(response['shorturl'])

# Create a QR code
qr = api.create_qr_code(
    type="link",
    data="https://example.com"
)
print(qr['link'])
```

## Features

- Full support for all Shotcut.in API endpoints
- Rate limiting handling
- Error handling
- Type hints for better IDE support
- Comprehensive documentation

## Documentation

For full documentation, visit [https://shotcut-python.readthedocs.io](https://shotcut-python.readthedocs.io)

## License

MIT License - see LICENSE file for details
