import pytest
from shotcut import ShotcutAPI, ShotcutAPIError
from unittest.mock import patch, Mock

@pytest.fixture
def api():
    return ShotcutAPI(api_key="7901c0be871cecfe075fb85f0bb01c38")

def test_shorten_link(api):
    with patch('requests.request') as mock_request:
        mock_request.return_value.json.return_value = {
            "error": 0,
            "id": 1,
            "shorturl": "https://shotcut.in/test"
        }
        
        response = api.shorten_link(url="https://example.com")
        assert response["shorturl"] == "https://shotcut.in/test"

def test_invalid_api_key():
    with patch('requests.request') as mock_request:
        mock_request.return_value.json.return_value = {
            "error": 1,
            "message": "Invalid API key"
        }
        
        api = ShotcutAPI(api_key="invalid_key")
        with pytest.raises(ShotcutAPIError) as exc_info:
            api.get_account()
            
        # Verify the exact error message
        assert str(exc_info.value) == "Invalid API key"