# Signplus Python SDK 1.1.0<a id="signplus-python-sdk-110"></a>

Welcome to the Signplus SDK documentation. This guide will help you get started with integrating and using the Signplus SDK in your project.

[![This SDK was generated by liblab](https://public-liblab-readme-assets.s3.us-east-1.amazonaws.com/built-by-liblab-icon.svg)](https://liblab.com/?utm_source=readme)

## Versions<a id="versions"></a>

- API version: `2.1.0`
- SDK version: `1.1.0`

## About the API<a id="about-the-api"></a>

Integrate legally-binding electronic signature to your workflow

## Table of Contents<a id="table-of-contents"></a>

- [Setup & Configuration](#setup--configuration)
  - [Supported Language Versions](#supported-language-versions)
  - [Installation](#installation)
- [Authentication](#authentication)
  - [Access Token Authentication](#access-token-authentication)
- [Setting a Custom Timeout](#setting-a-custom-timeout)
- [Sample Usage](#sample-usage)
- [Services](#services)
- [Models](#models)
- [License](#license)

## Setup & Configuration<a id="setup--configuration"></a>

### Supported Language Versions<a id="supported-language-versions"></a>

This SDK is compatible with the following versions: `Python >= 3.7`

### Installation<a id="installation"></a>

To get started with the SDK, we recommend installing using `pip`:

```bash
pip install signplus-python
```

## Authentication<a id="authentication"></a>

### Access Token Authentication<a id="access-token-authentication"></a>

The Signplus API uses an Access Token for authentication.

This token must be provided to authenticate your requests to the API.

#### Setting the Access Token<a id="setting-the-access-token"></a>

When you initialize the SDK, you can set the access token as follows:

```py
Signplus(
    access_token="YOUR_ACCESS_TOKEN",
    timeout=10000
)
```

If you need to set or update the access token after initializing the SDK, you can use:

```py
sdk.set_access_token("YOUR_ACCESS_TOKEN")
```

## Setting a Custom Timeout<a id="setting-a-custom-timeout"></a>

You can set a custom timeout for the SDK's HTTP requests as follows:

```py
from signplus import Signplus

sdk = Signplus(timeout=10000)
```

# Sample Usage<a id="sample-usage"></a>

Below is a comprehensive example demonstrating how to authenticate and call a simple endpoint:

```py
from signplus import Signplus

sdk = Signplus(
    access_token="YOUR_ACCESS_TOKEN",
    timeout=10000
)

result = sdk.signplus.get_envelope(envelope_id="envelope_id")

print(result)

```

## Services<a id="services"></a>

The SDK provides various services to interact with the API.

<details> 
<summary>Below is a list of all available services:</summary>

| Name     |
| :------- |
| signplus |

</details>

## Models<a id="models"></a>

The SDK includes several models that represent the data structures used in API requests and responses. These models help in organizing and managing the data efficiently.

<details> 
<summary>Below is a list of all available models:</summary>

| Name                                    | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| :-------------------------------------- | :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| CreateEnvelopeRequest                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| Envelope                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| CreateEnvelopeFromTemplateRequest       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ListEnvelopesRequest                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ListEnvelopesResponse                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| Document                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ListEnvelopeDocumentsResponse           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| AddEnvelopeDocumentRequest              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| SetEnvelopeDynamicFieldsRequest         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| AddEnvelopeSigningStepsRequest          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| RenameEnvelopeRequest                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| SetEnvelopeCommentRequest               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| EnvelopeNotification                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| SetEnvelopeExpirationRequest            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| SetEnvelopeLegalityLevelRequest         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| Annotation                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ListEnvelopeDocumentAnnotationsResponse |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| AddAnnotationRequest                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| CreateTemplateRequest                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| Template                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ListTemplatesRequest                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ListTemplatesResponse                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| AddTemplateDocumentRequest              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ListTemplateDocumentsResponse           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| AddTemplateSigningStepsRequest          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| RenameTemplateRequest                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| SetTemplateCommentRequest               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ListTemplateAnnotationsResponse         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ListTemplateDocumentAnnotationsResponse |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| CreateWebhookRequest                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| Webhook                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ListWebhooksRequest                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ListWebhooksResponse                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| EnvelopeLegalityLevel                   | Legal level of the envelope (SES is Simple Electronic Signature, QES_EIDAS is Qualified Electronic Signature, QES_ZERTES is Qualified Electronic Signature with Zertes)                                                                                                                                                                                                                                                                                                                   |
| EnvelopeFlowType                        | Flow type of the envelope (REQUEST_SIGNATURE is a request for signature, SIGN_MYSELF is a self-signing flow)                                                                                                                                                                                                                                                                                                                                                                              |
| EnvelopeStatus                          | Status of the envelope                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| SigningStep                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| Recipient                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| RecipientRole                           | Role of the recipient (SIGNER signs the document, RECEIVES_COPY receives a copy of the document, IN_PERSON_SIGNER signs the document in person, SENDER sends the document)                                                                                                                                                                                                                                                                                                                |
| RecipientVerification                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| RecipientVerificationType               | Type of signature verification (SMS sends a code via SMS, PASSCODE requires a code to be entered)                                                                                                                                                                                                                                                                                                                                                                                         |
| Page                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| EnvelopeOrderField                      | Field to order envelopes by                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| DynamicField                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| AnnotationType                          | Type of the annotation                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| AnnotationSignature                     | Signature annotation (null if annotation is not a signature)                                                                                                                                                                                                                                                                                                                                                                                                                              |
| AnnotationInitials                      | Initials annotation (null if annotation is not initials)                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| AnnotationText                          | Text annotation (null if annotation is not a text)                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| AnnotationDateTime                      | Date annotation (null if annotation is not a date)                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| AnnotationCheckbox                      | Checkbox annotation (null if annotation is not a checkbox)                                                                                                                                                                                                                                                                                                                                                                                                                                |
| AnnotationFont                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| AnnotationFontFamily                    | Font family of the text                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| AnnotationDateTimeFormat                | Format of the date time (DMY_NUMERIC_SLASH is day/month/year with slashes, MDY_NUMERIC_SLASH is month/day/year with slashes, YMD_NUMERIC_SLASH is year/month/day with slashes, DMY_NUMERIC_DASH_SHORT is day/month/year with dashes, DMY_NUMERIC_DASH is day/month/year with dashes, YMD_NUMERIC_DASH is year/month/day with dashes, MDY_TEXT_DASH_SHORT is month/day/year with dashes, MDY_TEXT_SPACE_SHORT is month/day/year with spaces, MDY_TEXT_SPACE is month/day/year with spaces) |
| AnnotationCheckboxStyle                 | Style of the checkbox                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| TemplateSigningStep                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| TemplateRecipient                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| TemplateRecipientRole                   | Role of the recipient (SIGNER signs the document, RECEIVES_COPY receives a copy of the document, IN_PERSON_SIGNER signs the document in person, SENDER sends the document)                                                                                                                                                                                                                                                                                                                |
| TemplateOrderField                      | Field to order templates by                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| WebhookEvent                            | Event of the webhook                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |

</details>

## License<a id="license"></a>

This SDK is licensed under the MIT License.

See the [LICENSE](LICENSE) file for more details.
