from typing import Optional


class RequestError(Exception):
    """
    Class representing a Request Error.
    """

    def __init__(
        self,
        message: str,
        stack: Optional["RequestError"] = None,
    ):
        """
        Initialize a new instance of RequestError.

        :param str message: The error message.
        """
        super().__init__(message)
        self.stack = stack

    def __str__(self):
        """
        Get the string representation of the error.

        :return: The string representation of the error.
        :rtype: str
        """
        error_stack = []
        current_error = self
        while current_error is not None:
            error_stack.append(f"Error: {super().__str__()}")
            current_error = current_error.stack
        return "\n".join(error_stack)
