import asyncio
from typing import TypeVar, Awaitable, Callable

T = TypeVar("T")


def to_async(sync_func: Callable[..., T]) -> Callable[..., Awaitable[T]]:
    """
    Converts a synchronous function to an asynchronous function.

    :param sync_func: The synchronous function to convert.
    :type sync_func: Callable[..., T]
    :return: The asynchronous function.
    :rtype: Callable[..., Awaitable[T]]
    """

    async def async_func(*args, **kwargs) -> T:
        return await asyncio.to_thread(sync_func, *args, **kwargs)

    return async_func
