# coding: utf-8

"""
    SignRequest API

    API for SignRequest.com

    OpenAPI spec version: v1
    Contact: tech-support@signrequest.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from signrequest_client.api_client import ApiClient


class TeamMembersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def team_members_list(self, **kwargs):  # noqa: E501
        """Retrieve a list of Team Members  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.team_members_list(async=True)
        >>> result = thread.get()

        :param async bool
        :param str is_active: 
        :param str is_owner: 
        :param str is_admin: 
        :param str user__email: 
        :param str user__first_name: 
        :param str user__last_name: 
        :param int page: A page number within the paginated result set.
        :param int limit: Number of results to return per page.
        :return: InlineResponse2006
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.team_members_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.team_members_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def team_members_list_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve a list of Team Members  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.team_members_list_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str is_active: 
        :param str is_owner: 
        :param str is_admin: 
        :param str user__email: 
        :param str user__first_name: 
        :param str user__last_name: 
        :param int page: A page number within the paginated result set.
        :param int limit: Number of results to return per page.
        :return: InlineResponse2006
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['is_active', 'is_owner', 'is_admin', 'user__email', 'user__first_name', 'user__last_name', 'page', 'limit']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method team_members_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'is_active' in params:
            query_params.append(('is_active', params['is_active']))  # noqa: E501
        if 'is_owner' in params:
            query_params.append(('is_owner', params['is_owner']))  # noqa: E501
        if 'is_admin' in params:
            query_params.append(('is_admin', params['is_admin']))  # noqa: E501
        if 'user__email' in params:
            query_params.append(('user__email', params['user__email']))  # noqa: E501
        if 'user__first_name' in params:
            query_params.append(('user__first_name', params['user__first_name']))  # noqa: E501
        if 'user__last_name' in params:
            query_params.append(('user__last_name', params['user__last_name']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/team-members/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2006',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def team_members_read(self, uuid, **kwargs):  # noqa: E501
        """Retrieve a Team Member  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.team_members_read(uuid, async=True)
        >>> result = thread.get()

        :param async bool
        :param str uuid: (required)
        :return: TeamMember
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.team_members_read_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.team_members_read_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def team_members_read_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Retrieve a Team Member  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.team_members_read_with_http_info(uuid, async=True)
        >>> result = thread.get()

        :param async bool
        :param str uuid: (required)
        :return: TeamMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method team_members_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `team_members_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/team-members/{uuid}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TeamMember',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
