# coding: utf-8

"""
    SignRequest API

    API for SignRequest.com

    OpenAPI spec version: v1
    Contact: tech-support@signrequest.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from signrequest_client.models.document_attachment import DocumentAttachment  # noqa: F401,E501
from signrequest_client.models.document_signing_log import DocumentSigningLog  # noqa: F401,E501
from signrequest_client.models.document_signrequest import DocumentSignrequest  # noqa: F401,E501
from signrequest_client.models.document_team import DocumentTeam  # noqa: F401,E501
from signrequest_client.models.file_from_sf import FileFromSf  # noqa: F401,E501
from signrequest_client.models.inline_integration_data import InlineIntegrationData  # noqa: F401,E501
from signrequest_client.models.inline_prefill_tags import InlinePrefillTags  # noqa: F401,E501
from signrequest_client.models.user import User  # noqa: F401,E501


class Document(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'url': 'str',
        'team': 'DocumentTeam',
        'uuid': 'str',
        'user': 'User',
        'file_as_pdf': 'str',
        'name': 'str',
        'external_id': 'str',
        'frontend_id': 'str',
        'file': 'str',
        'file_from_url': 'str',
        'events_callback_url': 'str',
        'file_from_content': 'str',
        'file_from_content_name': 'str',
        'template': 'str',
        'prefill_tags': 'list[InlinePrefillTags]',
        'integrations': 'list[InlineIntegrationData]',
        'file_from_sf': 'FileFromSf',
        'auto_delete_days': 'int',
        'auto_expire_days': 'int',
        'pdf': 'str',
        'status': 'str',
        'signrequest': 'DocumentSignrequest',
        'api_used': 'bool',
        'signing_log': 'DocumentSigningLog',
        'security_hash': 'str',
        'attachments': 'list[DocumentAttachment]',
        'auto_delete_after': 'datetime',
        'sandbox': 'bool',
        'auto_expire_after': 'datetime'
    }

    attribute_map = {
        'url': 'url',
        'team': 'team',
        'uuid': 'uuid',
        'user': 'user',
        'file_as_pdf': 'file_as_pdf',
        'name': 'name',
        'external_id': 'external_id',
        'frontend_id': 'frontend_id',
        'file': 'file',
        'file_from_url': 'file_from_url',
        'events_callback_url': 'events_callback_url',
        'file_from_content': 'file_from_content',
        'file_from_content_name': 'file_from_content_name',
        'template': 'template',
        'prefill_tags': 'prefill_tags',
        'integrations': 'integrations',
        'file_from_sf': 'file_from_sf',
        'auto_delete_days': 'auto_delete_days',
        'auto_expire_days': 'auto_expire_days',
        'pdf': 'pdf',
        'status': 'status',
        'signrequest': 'signrequest',
        'api_used': 'api_used',
        'signing_log': 'signing_log',
        'security_hash': 'security_hash',
        'attachments': 'attachments',
        'auto_delete_after': 'auto_delete_after',
        'sandbox': 'sandbox',
        'auto_expire_after': 'auto_expire_after'
    }

    def __init__(self, url=None, team=None, uuid=None, user=None, file_as_pdf=None, name=None, external_id=None, frontend_id=None, file=None, file_from_url=None, events_callback_url=None, file_from_content=None, file_from_content_name=None, template=None, prefill_tags=None, integrations=None, file_from_sf=None, auto_delete_days=None, auto_expire_days=None, pdf=None, status=None, signrequest=None, api_used=None, signing_log=None, security_hash=None, attachments=None, auto_delete_after=None, sandbox=None, auto_expire_after=None):  # noqa: E501
        """Document - a model defined in Swagger"""  # noqa: E501

        self._url = None
        self._team = None
        self._uuid = None
        self._user = None
        self._file_as_pdf = None
        self._name = None
        self._external_id = None
        self._frontend_id = None
        self._file = None
        self._file_from_url = None
        self._events_callback_url = None
        self._file_from_content = None
        self._file_from_content_name = None
        self._template = None
        self._prefill_tags = None
        self._integrations = None
        self._file_from_sf = None
        self._auto_delete_days = None
        self._auto_expire_days = None
        self._pdf = None
        self._status = None
        self._signrequest = None
        self._api_used = None
        self._signing_log = None
        self._security_hash = None
        self._attachments = None
        self._auto_delete_after = None
        self._sandbox = None
        self._auto_expire_after = None
        self.discriminator = None

        if url is not None:
            self.url = url
        if team is not None:
            self.team = team
        if uuid is not None:
            self.uuid = uuid
        if user is not None:
            self.user = user
        if file_as_pdf is not None:
            self.file_as_pdf = file_as_pdf
        if name is not None:
            self.name = name
        if external_id is not None:
            self.external_id = external_id
        if frontend_id is not None:
            self.frontend_id = frontend_id
        if file is not None:
            self.file = file
        if file_from_url is not None:
            self.file_from_url = file_from_url
        if events_callback_url is not None:
            self.events_callback_url = events_callback_url
        if file_from_content is not None:
            self.file_from_content = file_from_content
        if file_from_content_name is not None:
            self.file_from_content_name = file_from_content_name
        if template is not None:
            self.template = template
        if prefill_tags is not None:
            self.prefill_tags = prefill_tags
        if integrations is not None:
            self.integrations = integrations
        if file_from_sf is not None:
            self.file_from_sf = file_from_sf
        if auto_delete_days is not None:
            self.auto_delete_days = auto_delete_days
        if auto_expire_days is not None:
            self.auto_expire_days = auto_expire_days
        if pdf is not None:
            self.pdf = pdf
        if status is not None:
            self.status = status
        if signrequest is not None:
            self.signrequest = signrequest
        if api_used is not None:
            self.api_used = api_used
        if signing_log is not None:
            self.signing_log = signing_log
        if security_hash is not None:
            self.security_hash = security_hash
        if attachments is not None:
            self.attachments = attachments
        if auto_delete_after is not None:
            self.auto_delete_after = auto_delete_after
        if sandbox is not None:
            self.sandbox = sandbox
        if auto_expire_after is not None:
            self.auto_expire_after = auto_expire_after

    @property
    def url(self):
        """Gets the url of this Document.  # noqa: E501


        :return: The url of this Document.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this Document.


        :param url: The url of this Document.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def team(self):
        """Gets the team of this Document.  # noqa: E501


        :return: The team of this Document.  # noqa: E501
        :rtype: DocumentTeam
        """
        return self._team

    @team.setter
    def team(self, team):
        """Sets the team of this Document.


        :param team: The team of this Document.  # noqa: E501
        :type: DocumentTeam
        """

        self._team = team

    @property
    def uuid(self):
        """Gets the uuid of this Document.  # noqa: E501


        :return: The uuid of this Document.  # noqa: E501
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """Sets the uuid of this Document.


        :param uuid: The uuid of this Document.  # noqa: E501
        :type: str
        """
        if uuid is not None and len(uuid) < 1:
            raise ValueError("Invalid value for `uuid`, length must be greater than or equal to `1`")  # noqa: E501

        self._uuid = uuid

    @property
    def user(self):
        """Gets the user of this Document.  # noqa: E501


        :return: The user of this Document.  # noqa: E501
        :rtype: User
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this Document.


        :param user: The user of this Document.  # noqa: E501
        :type: User
        """

        self._user = user

    @property
    def file_as_pdf(self):
        """Gets the file_as_pdf of this Document.  # noqa: E501

        Temporary URL to original file as PDF, expires in five minutes  # noqa: E501

        :return: The file_as_pdf of this Document.  # noqa: E501
        :rtype: str
        """
        return self._file_as_pdf

    @file_as_pdf.setter
    def file_as_pdf(self, file_as_pdf):
        """Sets the file_as_pdf of this Document.

        Temporary URL to original file as PDF, expires in five minutes  # noqa: E501

        :param file_as_pdf: The file_as_pdf of this Document.  # noqa: E501
        :type: str
        """
        if file_as_pdf is not None and len(file_as_pdf) < 1:
            raise ValueError("Invalid value for `file_as_pdf`, length must be greater than or equal to `1`")  # noqa: E501

        self._file_as_pdf = file_as_pdf

    @property
    def name(self):
        """Gets the name of this Document.  # noqa: E501

        Defaults to filename, including extension  # noqa: E501

        :return: The name of this Document.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Document.

        Defaults to filename, including extension  # noqa: E501

        :param name: The name of this Document.  # noqa: E501
        :type: str
        """
        if name is not None and len(name) > 255:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501

        self._name = name

    @property
    def external_id(self):
        """Gets the external_id of this Document.  # noqa: E501

        ID used to reference document in external system  # noqa: E501

        :return: The external_id of this Document.  # noqa: E501
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """Sets the external_id of this Document.

        ID used to reference document in external system  # noqa: E501

        :param external_id: The external_id of this Document.  # noqa: E501
        :type: str
        """
        if external_id is not None and len(external_id) > 255:
            raise ValueError("Invalid value for `external_id`, length must be less than or equal to `255`")  # noqa: E501

        self._external_id = external_id

    @property
    def frontend_id(self):
        """Gets the frontend_id of this Document.  # noqa: E501

        Shared secret used in conjunction with <a href=\"#section/Frontend-API/SignRequest-js-client-(beta)\">SignRequest-js client</a> to grant user access to a document that's not a member of the document's team  # noqa: E501

        :return: The frontend_id of this Document.  # noqa: E501
        :rtype: str
        """
        return self._frontend_id

    @frontend_id.setter
    def frontend_id(self, frontend_id):
        """Sets the frontend_id of this Document.

        Shared secret used in conjunction with <a href=\"#section/Frontend-API/SignRequest-js-client-(beta)\">SignRequest-js client</a> to grant user access to a document that's not a member of the document's team  # noqa: E501

        :param frontend_id: The frontend_id of this Document.  # noqa: E501
        :type: str
        """
        if frontend_id is not None and len(frontend_id) > 255:
            raise ValueError("Invalid value for `frontend_id`, length must be less than or equal to `255`")  # noqa: E501

        self._frontend_id = frontend_id

    @property
    def file(self):
        """Gets the file of this Document.  # noqa: E501

        Temporary URL to original file, expires in five minutes  # noqa: E501

        :return: The file of this Document.  # noqa: E501
        :rtype: str
        """
        return self._file

    @file.setter
    def file(self, file):
        """Sets the file of this Document.

        Temporary URL to original file, expires in five minutes  # noqa: E501

        :param file: The file of this Document.  # noqa: E501
        :type: str
        """

        self._file = file

    @property
    def file_from_url(self):
        """Gets the file_from_url of this Document.  # noqa: E501

        Publicly accessible URL of document to be downloaded by SignRequest  # noqa: E501

        :return: The file_from_url of this Document.  # noqa: E501
        :rtype: str
        """
        return self._file_from_url

    @file_from_url.setter
    def file_from_url(self, file_from_url):
        """Sets the file_from_url of this Document.

        Publicly accessible URL of document to be downloaded by SignRequest  # noqa: E501

        :param file_from_url: The file_from_url of this Document.  # noqa: E501
        :type: str
        """
        if file_from_url is not None and len(file_from_url) > 2100:
            raise ValueError("Invalid value for `file_from_url`, length must be less than or equal to `2100`")  # noqa: E501

        self._file_from_url = file_from_url

    @property
    def events_callback_url(self):
        """Gets the events_callback_url of this Document.  # noqa: E501

        URL at which to receive [event callbacks](#section/Events/Events-callback) for this document  # noqa: E501

        :return: The events_callback_url of this Document.  # noqa: E501
        :rtype: str
        """
        return self._events_callback_url

    @events_callback_url.setter
    def events_callback_url(self, events_callback_url):
        """Sets the events_callback_url of this Document.

        URL at which to receive [event callbacks](#section/Events/Events-callback) for this document  # noqa: E501

        :param events_callback_url: The events_callback_url of this Document.  # noqa: E501
        :type: str
        """
        if events_callback_url is not None and len(events_callback_url) > 2100:
            raise ValueError("Invalid value for `events_callback_url`, length must be less than or equal to `2100`")  # noqa: E501

        self._events_callback_url = events_callback_url

    @property
    def file_from_content(self):
        """Gets the file_from_content of this Document.  # noqa: E501

        Base64 encoded document content  # noqa: E501

        :return: The file_from_content of this Document.  # noqa: E501
        :rtype: str
        """
        return self._file_from_content

    @file_from_content.setter
    def file_from_content(self, file_from_content):
        """Sets the file_from_content of this Document.

        Base64 encoded document content  # noqa: E501

        :param file_from_content: The file_from_content of this Document.  # noqa: E501
        :type: str
        """

        self._file_from_content = file_from_content

    @property
    def file_from_content_name(self):
        """Gets the file_from_content_name of this Document.  # noqa: E501

        Filename, including extension. Required when using `file_from_content`.  # noqa: E501

        :return: The file_from_content_name of this Document.  # noqa: E501
        :rtype: str
        """
        return self._file_from_content_name

    @file_from_content_name.setter
    def file_from_content_name(self, file_from_content_name):
        """Sets the file_from_content_name of this Document.

        Filename, including extension. Required when using `file_from_content`.  # noqa: E501

        :param file_from_content_name: The file_from_content_name of this Document.  # noqa: E501
        :type: str
        """

        self._file_from_content_name = file_from_content_name

    @property
    def template(self):
        """Gets the template of this Document.  # noqa: E501


        :return: The template of this Document.  # noqa: E501
        :rtype: str
        """
        return self._template

    @template.setter
    def template(self, template):
        """Sets the template of this Document.


        :param template: The template of this Document.  # noqa: E501
        :type: str
        """

        self._template = template

    @property
    def prefill_tags(self):
        """Gets the prefill_tags of this Document.  # noqa: E501

        Prefill signer input data, see [prefill tags](#section/Preparing-a-document/Prefill-tags-templates)  # noqa: E501

        :return: The prefill_tags of this Document.  # noqa: E501
        :rtype: list[InlinePrefillTags]
        """
        return self._prefill_tags

    @prefill_tags.setter
    def prefill_tags(self, prefill_tags):
        """Sets the prefill_tags of this Document.

        Prefill signer input data, see [prefill tags](#section/Preparing-a-document/Prefill-tags-templates)  # noqa: E501

        :param prefill_tags: The prefill_tags of this Document.  # noqa: E501
        :type: list[InlinePrefillTags]
        """

        self._prefill_tags = prefill_tags

    @property
    def integrations(self):
        """Gets the integrations of this Document.  # noqa: E501


        :return: The integrations of this Document.  # noqa: E501
        :rtype: list[InlineIntegrationData]
        """
        return self._integrations

    @integrations.setter
    def integrations(self, integrations):
        """Sets the integrations of this Document.


        :param integrations: The integrations of this Document.  # noqa: E501
        :type: list[InlineIntegrationData]
        """

        self._integrations = integrations

    @property
    def file_from_sf(self):
        """Gets the file_from_sf of this Document.  # noqa: E501


        :return: The file_from_sf of this Document.  # noqa: E501
        :rtype: FileFromSf
        """
        return self._file_from_sf

    @file_from_sf.setter
    def file_from_sf(self, file_from_sf):
        """Sets the file_from_sf of this Document.


        :param file_from_sf: The file_from_sf of this Document.  # noqa: E501
        :type: FileFromSf
        """

        self._file_from_sf = file_from_sf

    @property
    def auto_delete_days(self):
        """Gets the auto_delete_days of this Document.  # noqa: E501

        Number of days after which a finished document (signed/cancelled/declined) will be automatically deleted  # noqa: E501

        :return: The auto_delete_days of this Document.  # noqa: E501
        :rtype: int
        """
        return self._auto_delete_days

    @auto_delete_days.setter
    def auto_delete_days(self, auto_delete_days):
        """Sets the auto_delete_days of this Document.

        Number of days after which a finished document (signed/cancelled/declined) will be automatically deleted  # noqa: E501

        :param auto_delete_days: The auto_delete_days of this Document.  # noqa: E501
        :type: int
        """
        if auto_delete_days is not None and auto_delete_days > 730:  # noqa: E501
            raise ValueError("Invalid value for `auto_delete_days`, must be a value less than or equal to `730`")  # noqa: E501
        if auto_delete_days is not None and auto_delete_days < 1:  # noqa: E501
            raise ValueError("Invalid value for `auto_delete_days`, must be a value greater than or equal to `1`")  # noqa: E501

        self._auto_delete_days = auto_delete_days

    @property
    def auto_expire_days(self):
        """Gets the auto_expire_days of this Document.  # noqa: E501

        Number of days after which a non finished document will be automatically expired  # noqa: E501

        :return: The auto_expire_days of this Document.  # noqa: E501
        :rtype: int
        """
        return self._auto_expire_days

    @auto_expire_days.setter
    def auto_expire_days(self, auto_expire_days):
        """Sets the auto_expire_days of this Document.

        Number of days after which a non finished document will be automatically expired  # noqa: E501

        :param auto_expire_days: The auto_expire_days of this Document.  # noqa: E501
        :type: int
        """
        if auto_expire_days is not None and auto_expire_days > 730:  # noqa: E501
            raise ValueError("Invalid value for `auto_expire_days`, must be a value less than or equal to `730`")  # noqa: E501
        if auto_expire_days is not None and auto_expire_days < 1:  # noqa: E501
            raise ValueError("Invalid value for `auto_expire_days`, must be a value greater than or equal to `1`")  # noqa: E501

        self._auto_expire_days = auto_expire_days

    @property
    def pdf(self):
        """Gets the pdf of this Document.  # noqa: E501

        Temporary URL to signed document as PDF, expires in five minutes  # noqa: E501

        :return: The pdf of this Document.  # noqa: E501
        :rtype: str
        """
        return self._pdf

    @pdf.setter
    def pdf(self, pdf):
        """Sets the pdf of this Document.

        Temporary URL to signed document as PDF, expires in five minutes  # noqa: E501

        :param pdf: The pdf of this Document.  # noqa: E501
        :type: str
        """

        self._pdf = pdf

    @property
    def status(self):
        """Gets the status of this Document.  # noqa: E501

        `co`: converting, `ne`: new, `se`: sent, `vi`: viewed, `si`: signed, `do`: downloaded, `sd`: signed and downloaded, `ca`: cancelled, `de`: declined, `ec`: error converting, `es`: error sending, `xp`: expired  # noqa: E501

        :return: The status of this Document.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Document.

        `co`: converting, `ne`: new, `se`: sent, `vi`: viewed, `si`: signed, `do`: downloaded, `sd`: signed and downloaded, `ca`: cancelled, `de`: declined, `ec`: error converting, `es`: error sending, `xp`: expired  # noqa: E501

        :param status: The status of this Document.  # noqa: E501
        :type: str
        """
        allowed_values = ["co", "ne", "se", "vi", "si", "do", "sd", "ca", "de", "ec", "es", "xp"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def signrequest(self):
        """Gets the signrequest of this Document.  # noqa: E501


        :return: The signrequest of this Document.  # noqa: E501
        :rtype: DocumentSignrequest
        """
        return self._signrequest

    @signrequest.setter
    def signrequest(self, signrequest):
        """Sets the signrequest of this Document.


        :param signrequest: The signrequest of this Document.  # noqa: E501
        :type: DocumentSignrequest
        """

        self._signrequest = signrequest

    @property
    def api_used(self):
        """Gets the api_used of this Document.  # noqa: E501

        Indicates whether document was created using the API  # noqa: E501

        :return: The api_used of this Document.  # noqa: E501
        :rtype: bool
        """
        return self._api_used

    @api_used.setter
    def api_used(self, api_used):
        """Sets the api_used of this Document.

        Indicates whether document was created using the API  # noqa: E501

        :param api_used: The api_used of this Document.  # noqa: E501
        :type: bool
        """

        self._api_used = api_used

    @property
    def signing_log(self):
        """Gets the signing_log of this Document.  # noqa: E501


        :return: The signing_log of this Document.  # noqa: E501
        :rtype: DocumentSigningLog
        """
        return self._signing_log

    @signing_log.setter
    def signing_log(self, signing_log):
        """Sets the signing_log of this Document.


        :param signing_log: The signing_log of this Document.  # noqa: E501
        :type: DocumentSigningLog
        """

        self._signing_log = signing_log

    @property
    def security_hash(self):
        """Gets the security_hash of this Document.  # noqa: E501

        SHA256 hash of PDF contents  # noqa: E501

        :return: The security_hash of this Document.  # noqa: E501
        :rtype: str
        """
        return self._security_hash

    @security_hash.setter
    def security_hash(self, security_hash):
        """Sets the security_hash of this Document.

        SHA256 hash of PDF contents  # noqa: E501

        :param security_hash: The security_hash of this Document.  # noqa: E501
        :type: str
        """
        if security_hash is not None and len(security_hash) < 1:
            raise ValueError("Invalid value for `security_hash`, length must be greater than or equal to `1`")  # noqa: E501

        self._security_hash = security_hash

    @property
    def attachments(self):
        """Gets the attachments of this Document.  # noqa: E501


        :return: The attachments of this Document.  # noqa: E501
        :rtype: list[DocumentAttachment]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments):
        """Sets the attachments of this Document.


        :param attachments: The attachments of this Document.  # noqa: E501
        :type: list[DocumentAttachment]
        """

        self._attachments = attachments

    @property
    def auto_delete_after(self):
        """Gets the auto_delete_after of this Document.  # noqa: E501

        Date and time calculated using `auto_delete_days` after which a finished document (signed/cancelled/declined) will be automatically deleted  # noqa: E501

        :return: The auto_delete_after of this Document.  # noqa: E501
        :rtype: datetime
        """
        return self._auto_delete_after

    @auto_delete_after.setter
    def auto_delete_after(self, auto_delete_after):
        """Sets the auto_delete_after of this Document.

        Date and time calculated using `auto_delete_days` after which a finished document (signed/cancelled/declined) will be automatically deleted  # noqa: E501

        :param auto_delete_after: The auto_delete_after of this Document.  # noqa: E501
        :type: datetime
        """

        self._auto_delete_after = auto_delete_after

    @property
    def sandbox(self):
        """Gets the sandbox of this Document.  # noqa: E501

        Indicates whether document was created as part of a sandbox team  # noqa: E501

        :return: The sandbox of this Document.  # noqa: E501
        :rtype: bool
        """
        return self._sandbox

    @sandbox.setter
    def sandbox(self, sandbox):
        """Sets the sandbox of this Document.

        Indicates whether document was created as part of a sandbox team  # noqa: E501

        :param sandbox: The sandbox of this Document.  # noqa: E501
        :type: bool
        """

        self._sandbox = sandbox

    @property
    def auto_expire_after(self):
        """Gets the auto_expire_after of this Document.  # noqa: E501

        Date and time calculated using `auto_expire_days` after which a non finished document will be automatically expired  # noqa: E501

        :return: The auto_expire_after of this Document.  # noqa: E501
        :rtype: datetime
        """
        return self._auto_expire_after

    @auto_expire_after.setter
    def auto_expire_after(self, auto_expire_after):
        """Sets the auto_expire_after of this Document.

        Date and time calculated using `auto_expire_days` after which a non finished document will be automatically expired  # noqa: E501

        :param auto_expire_after: The auto_expire_after of this Document.  # noqa: E501
        :type: datetime
        """

        self._auto_expire_after = auto_expire_after

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Document, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Document):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
