# coding: utf-8

"""
    SignRequest API

    API for SignRequest.com

    OpenAPI spec version: v1
    Contact: tech-support@signrequest.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SignRequestQuickCreate(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'from_email': 'str',
        'from_email_name': 'str',
        'is_being_prepared': 'bool',
        'prepare_url': 'str',
        'redirect_url': 'str',
        'redirect_url_declined': 'str',
        'required_attachments': 'list[RequiredAttachment]',
        'disable_attachments': 'bool',
        'disable_text_signatures': 'bool',
        'disable_text': 'bool',
        'disable_date': 'bool',
        'disable_emails': 'bool',
        'disable_upload_signatures': 'bool',
        'disable_blockchain_proof': 'bool',
        'text_message_verification_locked': 'bool',
        'subject': 'str',
        'message': 'str',
        'who': 'str',
        'send_reminders': 'bool',
        'signers': 'list[Signer]',
        'uuid': 'str',
        'url': 'str',
        'document': 'str',
        'integration': 'str',
        'integration_data': 'object',
        'name': 'str',
        'external_id': 'str',
        'frontend_id': 'str',
        'file': 'str',
        'file_from_url': 'str',
        'events_callback_url': 'str',
        'file_from_content': 'str',
        'file_from_content_name': 'str',
        'template': 'str',
        'prefill_tags': 'list[InlinePrefillTags]',
        'integrations': 'list[InlineIntegrationData]',
        'file_from_sf': 'FileFromSf',
        'auto_delete_days': 'int',
        'auto_expire_days': 'int'
    }

    attribute_map = {
        'from_email': 'from_email',
        'from_email_name': 'from_email_name',
        'is_being_prepared': 'is_being_prepared',
        'prepare_url': 'prepare_url',
        'redirect_url': 'redirect_url',
        'redirect_url_declined': 'redirect_url_declined',
        'required_attachments': 'required_attachments',
        'disable_attachments': 'disable_attachments',
        'disable_text_signatures': 'disable_text_signatures',
        'disable_text': 'disable_text',
        'disable_date': 'disable_date',
        'disable_emails': 'disable_emails',
        'disable_upload_signatures': 'disable_upload_signatures',
        'disable_blockchain_proof': 'disable_blockchain_proof',
        'text_message_verification_locked': 'text_message_verification_locked',
        'subject': 'subject',
        'message': 'message',
        'who': 'who',
        'send_reminders': 'send_reminders',
        'signers': 'signers',
        'uuid': 'uuid',
        'url': 'url',
        'document': 'document',
        'integration': 'integration',
        'integration_data': 'integration_data',
        'name': 'name',
        'external_id': 'external_id',
        'frontend_id': 'frontend_id',
        'file': 'file',
        'file_from_url': 'file_from_url',
        'events_callback_url': 'events_callback_url',
        'file_from_content': 'file_from_content',
        'file_from_content_name': 'file_from_content_name',
        'template': 'template',
        'prefill_tags': 'prefill_tags',
        'integrations': 'integrations',
        'file_from_sf': 'file_from_sf',
        'auto_delete_days': 'auto_delete_days',
        'auto_expire_days': 'auto_expire_days'
    }

    def __init__(self, from_email=None, from_email_name=None, is_being_prepared=None, prepare_url=None, redirect_url=None, redirect_url_declined=None, required_attachments=None, disable_attachments=None, disable_text_signatures=None, disable_text=None, disable_date=None, disable_emails=None, disable_upload_signatures=None, disable_blockchain_proof=None, text_message_verification_locked=None, subject=None, message=None, who='o', send_reminders=None, signers=None, uuid=None, url=None, document=None, integration=None, integration_data=None, name=None, external_id=None, frontend_id=None, file=None, file_from_url=None, events_callback_url=None, file_from_content=None, file_from_content_name=None, template=None, prefill_tags=None, integrations=None, file_from_sf=None, auto_delete_days=None, auto_expire_days=None):  # noqa: E501
        """SignRequestQuickCreate - a model defined in Swagger"""  # noqa: E501

        self._from_email = None
        self._from_email_name = None
        self._is_being_prepared = None
        self._prepare_url = None
        self._redirect_url = None
        self._redirect_url_declined = None
        self._required_attachments = None
        self._disable_attachments = None
        self._disable_text_signatures = None
        self._disable_text = None
        self._disable_date = None
        self._disable_emails = None
        self._disable_upload_signatures = None
        self._disable_blockchain_proof = None
        self._text_message_verification_locked = None
        self._subject = None
        self._message = None
        self._who = None
        self._send_reminders = None
        self._signers = None
        self._uuid = None
        self._url = None
        self._document = None
        self._integration = None
        self._integration_data = None
        self._name = None
        self._external_id = None
        self._frontend_id = None
        self._file = None
        self._file_from_url = None
        self._events_callback_url = None
        self._file_from_content = None
        self._file_from_content_name = None
        self._template = None
        self._prefill_tags = None
        self._integrations = None
        self._file_from_sf = None
        self._auto_delete_days = None
        self._auto_expire_days = None
        self.discriminator = None

        if from_email is not None:
            self.from_email = from_email
        if from_email_name is not None:
            self.from_email_name = from_email_name
        if is_being_prepared is not None:
            self.is_being_prepared = is_being_prepared
        if prepare_url is not None:
            self.prepare_url = prepare_url
        if redirect_url is not None:
            self.redirect_url = redirect_url
        if redirect_url_declined is not None:
            self.redirect_url_declined = redirect_url_declined
        if required_attachments is not None:
            self.required_attachments = required_attachments
        if disable_attachments is not None:
            self.disable_attachments = disable_attachments
        if disable_text_signatures is not None:
            self.disable_text_signatures = disable_text_signatures
        if disable_text is not None:
            self.disable_text = disable_text
        if disable_date is not None:
            self.disable_date = disable_date
        if disable_emails is not None:
            self.disable_emails = disable_emails
        if disable_upload_signatures is not None:
            self.disable_upload_signatures = disable_upload_signatures
        if disable_blockchain_proof is not None:
            self.disable_blockchain_proof = disable_blockchain_proof
        if text_message_verification_locked is not None:
            self.text_message_verification_locked = text_message_verification_locked
        if subject is not None:
            self.subject = subject
        if message is not None:
            self.message = message
        if who is not None:
            self.who = who
        if send_reminders is not None:
            self.send_reminders = send_reminders
        self.signers = signers
        if uuid is not None:
            self.uuid = uuid
        if url is not None:
            self.url = url
        if document is not None:
            self.document = document
        if integration is not None:
            self.integration = integration
        if integration_data is not None:
            self.integration_data = integration_data
        if name is not None:
            self.name = name
        if external_id is not None:
            self.external_id = external_id
        if frontend_id is not None:
            self.frontend_id = frontend_id
        if file is not None:
            self.file = file
        if file_from_url is not None:
            self.file_from_url = file_from_url
        if events_callback_url is not None:
            self.events_callback_url = events_callback_url
        if file_from_content is not None:
            self.file_from_content = file_from_content
        if file_from_content_name is not None:
            self.file_from_content_name = file_from_content_name
        if template is not None:
            self.template = template
        if prefill_tags is not None:
            self.prefill_tags = prefill_tags
        if integrations is not None:
            self.integrations = integrations
        if file_from_sf is not None:
            self.file_from_sf = file_from_sf
        if auto_delete_days is not None:
            self.auto_delete_days = auto_delete_days
        if auto_expire_days is not None:
            self.auto_expire_days = auto_expire_days

    @property
    def from_email(self):
        """Gets the from_email of this SignRequestQuickCreate.  # noqa: E501

        Email of user sending the SignRequest (must be a validated email)  # noqa: E501

        :return: The from_email of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._from_email

    @from_email.setter
    def from_email(self, from_email):
        """Sets the from_email of this SignRequestQuickCreate.

        Email of user sending the SignRequest (must be a validated email)  # noqa: E501

        :param from_email: The from_email of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """
        if from_email is not None and len(from_email) > 255:
            raise ValueError("Invalid value for `from_email`, length must be less than or equal to `255`")  # noqa: E501
        if from_email is not None and len(from_email) < 1:
            raise ValueError("Invalid value for `from_email`, length must be greater than or equal to `1`")  # noqa: E501

        self._from_email = from_email

    @property
    def from_email_name(self):
        """Gets the from_email_name of this SignRequestQuickCreate.  # noqa: E501

        Name to be used in the `From` email header, e.g. `{from_email_name} <no-reply@signrequest.com>`  # noqa: E501

        :return: The from_email_name of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._from_email_name

    @from_email_name.setter
    def from_email_name(self, from_email_name):
        """Sets the from_email_name of this SignRequestQuickCreate.

        Name to be used in the `From` email header, e.g. `{from_email_name} <no-reply@signrequest.com>`  # noqa: E501

        :param from_email_name: The from_email_name of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """
        if from_email_name is not None and len(from_email_name) > 255:
            raise ValueError("Invalid value for `from_email_name`, length must be less than or equal to `255`")  # noqa: E501

        self._from_email_name = from_email_name

    @property
    def is_being_prepared(self):
        """Gets the is_being_prepared of this SignRequestQuickCreate.  # noqa: E501

        Have the sender of a SignRequest prepare the document before sending the request out, see: [prepare using the web interface](#section/Preparing-a-document/Prepare-using-the-web-interface)  # noqa: E501

        :return: The is_being_prepared of this SignRequestQuickCreate.  # noqa: E501
        :rtype: bool
        """
        return self._is_being_prepared

    @is_being_prepared.setter
    def is_being_prepared(self, is_being_prepared):
        """Sets the is_being_prepared of this SignRequestQuickCreate.

        Have the sender of a SignRequest prepare the document before sending the request out, see: [prepare using the web interface](#section/Preparing-a-document/Prepare-using-the-web-interface)  # noqa: E501

        :param is_being_prepared: The is_being_prepared of this SignRequestQuickCreate.  # noqa: E501
        :type: bool
        """

        self._is_being_prepared = is_being_prepared

    @property
    def prepare_url(self):
        """Gets the prepare_url of this SignRequestQuickCreate.  # noqa: E501


        :return: The prepare_url of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._prepare_url

    @prepare_url.setter
    def prepare_url(self, prepare_url):
        """Sets the prepare_url of this SignRequestQuickCreate.


        :param prepare_url: The prepare_url of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """
        if prepare_url is not None and len(prepare_url) < 1:
            raise ValueError("Invalid value for `prepare_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._prepare_url = prepare_url

    @property
    def redirect_url(self):
        """Gets the redirect_url of this SignRequestQuickCreate.  # noqa: E501

        URL at which SignRequest will redirect to when a document is signed  # noqa: E501

        :return: The redirect_url of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._redirect_url

    @redirect_url.setter
    def redirect_url(self, redirect_url):
        """Sets the redirect_url of this SignRequestQuickCreate.

        URL at which SignRequest will redirect to when a document is signed  # noqa: E501

        :param redirect_url: The redirect_url of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """
        if redirect_url is not None and len(redirect_url) > 2100:
            raise ValueError("Invalid value for `redirect_url`, length must be less than or equal to `2100`")  # noqa: E501

        self._redirect_url = redirect_url

    @property
    def redirect_url_declined(self):
        """Gets the redirect_url_declined of this SignRequestQuickCreate.  # noqa: E501

        URL at which SignRequest will redirect to when a document is declined  # noqa: E501

        :return: The redirect_url_declined of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._redirect_url_declined

    @redirect_url_declined.setter
    def redirect_url_declined(self, redirect_url_declined):
        """Sets the redirect_url_declined of this SignRequestQuickCreate.

        URL at which SignRequest will redirect to when a document is declined  # noqa: E501

        :param redirect_url_declined: The redirect_url_declined of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """
        if redirect_url_declined is not None and len(redirect_url_declined) > 2100:
            raise ValueError("Invalid value for `redirect_url_declined`, length must be less than or equal to `2100`")  # noqa: E501

        self._redirect_url_declined = redirect_url_declined

    @property
    def required_attachments(self):
        """Gets the required_attachments of this SignRequestQuickCreate.  # noqa: E501

        Attachments that signers are required to upload  # noqa: E501

        :return: The required_attachments of this SignRequestQuickCreate.  # noqa: E501
        :rtype: list[RequiredAttachment]
        """
        return self._required_attachments

    @required_attachments.setter
    def required_attachments(self, required_attachments):
        """Sets the required_attachments of this SignRequestQuickCreate.

        Attachments that signers are required to upload  # noqa: E501

        :param required_attachments: The required_attachments of this SignRequestQuickCreate.  # noqa: E501
        :type: list[RequiredAttachment]
        """

        self._required_attachments = required_attachments

    @property
    def disable_attachments(self):
        """Gets the disable_attachments of this SignRequestQuickCreate.  # noqa: E501

        Disable uploading/adding of attachments  # noqa: E501

        :return: The disable_attachments of this SignRequestQuickCreate.  # noqa: E501
        :rtype: bool
        """
        return self._disable_attachments

    @disable_attachments.setter
    def disable_attachments(self, disable_attachments):
        """Sets the disable_attachments of this SignRequestQuickCreate.

        Disable uploading/adding of attachments  # noqa: E501

        :param disable_attachments: The disable_attachments of this SignRequestQuickCreate.  # noqa: E501
        :type: bool
        """

        self._disable_attachments = disable_attachments

    @property
    def disable_text_signatures(self):
        """Gets the disable_text_signatures of this SignRequestQuickCreate.  # noqa: E501

        Disable usage of signatures generated by typing (text)  # noqa: E501

        :return: The disable_text_signatures of this SignRequestQuickCreate.  # noqa: E501
        :rtype: bool
        """
        return self._disable_text_signatures

    @disable_text_signatures.setter
    def disable_text_signatures(self, disable_text_signatures):
        """Sets the disable_text_signatures of this SignRequestQuickCreate.

        Disable usage of signatures generated by typing (text)  # noqa: E501

        :param disable_text_signatures: The disable_text_signatures of this SignRequestQuickCreate.  # noqa: E501
        :type: bool
        """

        self._disable_text_signatures = disable_text_signatures

    @property
    def disable_text(self):
        """Gets the disable_text of this SignRequestQuickCreate.  # noqa: E501

        Disable adding of text  # noqa: E501

        :return: The disable_text of this SignRequestQuickCreate.  # noqa: E501
        :rtype: bool
        """
        return self._disable_text

    @disable_text.setter
    def disable_text(self, disable_text):
        """Sets the disable_text of this SignRequestQuickCreate.

        Disable adding of text  # noqa: E501

        :param disable_text: The disable_text of this SignRequestQuickCreate.  # noqa: E501
        :type: bool
        """

        self._disable_text = disable_text

    @property
    def disable_date(self):
        """Gets the disable_date of this SignRequestQuickCreate.  # noqa: E501

        Disable adding of dates  # noqa: E501

        :return: The disable_date of this SignRequestQuickCreate.  # noqa: E501
        :rtype: bool
        """
        return self._disable_date

    @disable_date.setter
    def disable_date(self, disable_date):
        """Sets the disable_date of this SignRequestQuickCreate.

        Disable adding of dates  # noqa: E501

        :param disable_date: The disable_date of this SignRequestQuickCreate.  # noqa: E501
        :type: bool
        """

        self._disable_date = disable_date

    @property
    def disable_emails(self):
        """Gets the disable_emails of this SignRequestQuickCreate.  # noqa: E501

        Disable all SignRequest status emails as well as the email that contains the signed documents  # noqa: E501

        :return: The disable_emails of this SignRequestQuickCreate.  # noqa: E501
        :rtype: bool
        """
        return self._disable_emails

    @disable_emails.setter
    def disable_emails(self, disable_emails):
        """Sets the disable_emails of this SignRequestQuickCreate.

        Disable all SignRequest status emails as well as the email that contains the signed documents  # noqa: E501

        :param disable_emails: The disable_emails of this SignRequestQuickCreate.  # noqa: E501
        :type: bool
        """

        self._disable_emails = disable_emails

    @property
    def disable_upload_signatures(self):
        """Gets the disable_upload_signatures of this SignRequestQuickCreate.  # noqa: E501

        Disable usage of uploaded signatures (images)  # noqa: E501

        :return: The disable_upload_signatures of this SignRequestQuickCreate.  # noqa: E501
        :rtype: bool
        """
        return self._disable_upload_signatures

    @disable_upload_signatures.setter
    def disable_upload_signatures(self, disable_upload_signatures):
        """Sets the disable_upload_signatures of this SignRequestQuickCreate.

        Disable usage of uploaded signatures (images)  # noqa: E501

        :param disable_upload_signatures: The disable_upload_signatures of this SignRequestQuickCreate.  # noqa: E501
        :type: bool
        """

        self._disable_upload_signatures = disable_upload_signatures

    @property
    def disable_blockchain_proof(self):
        """Gets the disable_blockchain_proof of this SignRequestQuickCreate.  # noqa: E501

        Disables storing timestamp proof hashes in blockchain integrations.  # noqa: E501

        :return: The disable_blockchain_proof of this SignRequestQuickCreate.  # noqa: E501
        :rtype: bool
        """
        return self._disable_blockchain_proof

    @disable_blockchain_proof.setter
    def disable_blockchain_proof(self, disable_blockchain_proof):
        """Sets the disable_blockchain_proof of this SignRequestQuickCreate.

        Disables storing timestamp proof hashes in blockchain integrations.  # noqa: E501

        :param disable_blockchain_proof: The disable_blockchain_proof of this SignRequestQuickCreate.  # noqa: E501
        :type: bool
        """

        self._disable_blockchain_proof = disable_blockchain_proof

    @property
    def text_message_verification_locked(self):
        """Gets the text_message_verification_locked of this SignRequestQuickCreate.  # noqa: E501

        When true a text message verification is needed before the signer can see the document  # noqa: E501

        :return: The text_message_verification_locked of this SignRequestQuickCreate.  # noqa: E501
        :rtype: bool
        """
        return self._text_message_verification_locked

    @text_message_verification_locked.setter
    def text_message_verification_locked(self, text_message_verification_locked):
        """Sets the text_message_verification_locked of this SignRequestQuickCreate.

        When true a text message verification is needed before the signer can see the document  # noqa: E501

        :param text_message_verification_locked: The text_message_verification_locked of this SignRequestQuickCreate.  # noqa: E501
        :type: bool
        """

        self._text_message_verification_locked = text_message_verification_locked

    @property
    def subject(self):
        """Gets the subject of this SignRequestQuickCreate.  # noqa: E501

        Subject of SignRequest email  # noqa: E501

        :return: The subject of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """Sets the subject of this SignRequestQuickCreate.

        Subject of SignRequest email  # noqa: E501

        :param subject: The subject of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """
        if subject is not None and len(subject) > 512:
            raise ValueError("Invalid value for `subject`, length must be less than or equal to `512`")  # noqa: E501

        self._subject = subject

    @property
    def message(self):
        """Gets the message of this SignRequestQuickCreate.  # noqa: E501

        Message to include in SignRequest email, may contain the following html tags: `a`, `abbr`, `acronym`, `b`, `blockquote`, `code`, `em`, `i`, `ul`, `li`, `ol`, and `strong`  # noqa: E501

        :return: The message of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this SignRequestQuickCreate.

        Message to include in SignRequest email, may contain the following html tags: `a`, `abbr`, `acronym`, `b`, `blockquote`, `code`, `em`, `i`, `ul`, `li`, `ol`, and `strong`  # noqa: E501

        :param message: The message of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def who(self):
        """Gets the who of this SignRequestQuickCreate.  # noqa: E501

        `m`: only me, `mo`: me and others, `o`: only others  # noqa: E501

        :return: The who of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._who

    @who.setter
    def who(self, who):
        """Sets the who of this SignRequestQuickCreate.

        `m`: only me, `mo`: me and others, `o`: only others  # noqa: E501

        :param who: The who of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """
        allowed_values = ["m", "mo", "o"]  # noqa: E501
        if who not in allowed_values:
            raise ValueError(
                "Invalid value for `who` ({0}), must be one of {1}"  # noqa: E501
                .format(who, allowed_values)
            )

        self._who = who

    @property
    def send_reminders(self):
        """Gets the send_reminders of this SignRequestQuickCreate.  # noqa: E501

        Automatically remind signers to sign a document, see: [automatic reminders](#section/Working-with-a-SignRequest/Automatic-reminders)  # noqa: E501

        :return: The send_reminders of this SignRequestQuickCreate.  # noqa: E501
        :rtype: bool
        """
        return self._send_reminders

    @send_reminders.setter
    def send_reminders(self, send_reminders):
        """Sets the send_reminders of this SignRequestQuickCreate.

        Automatically remind signers to sign a document, see: [automatic reminders](#section/Working-with-a-SignRequest/Automatic-reminders)  # noqa: E501

        :param send_reminders: The send_reminders of this SignRequestQuickCreate.  # noqa: E501
        :type: bool
        """

        self._send_reminders = send_reminders

    @property
    def signers(self):
        """Gets the signers of this SignRequestQuickCreate.  # noqa: E501


        :return: The signers of this SignRequestQuickCreate.  # noqa: E501
        :rtype: list[Signer]
        """
        return self._signers

    @signers.setter
    def signers(self, signers):
        """Sets the signers of this SignRequestQuickCreate.


        :param signers: The signers of this SignRequestQuickCreate.  # noqa: E501
        :type: list[Signer]
        """
        if signers is None:
            raise ValueError("Invalid value for `signers`, must not be `None`")  # noqa: E501

        self._signers = signers

    @property
    def uuid(self):
        """Gets the uuid of this SignRequestQuickCreate.  # noqa: E501


        :return: The uuid of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """Sets the uuid of this SignRequestQuickCreate.


        :param uuid: The uuid of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """
        if uuid is not None and len(uuid) < 1:
            raise ValueError("Invalid value for `uuid`, length must be greater than or equal to `1`")  # noqa: E501

        self._uuid = uuid

    @property
    def url(self):
        """Gets the url of this SignRequestQuickCreate.  # noqa: E501


        :return: The url of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this SignRequestQuickCreate.


        :param url: The url of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def document(self):
        """Gets the document of this SignRequestQuickCreate.  # noqa: E501


        :return: The document of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._document

    @document.setter
    def document(self, document):
        """Sets the document of this SignRequestQuickCreate.


        :param document: The document of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """

        self._document = document

    @property
    def integration(self):
        """Gets the integration of this SignRequestQuickCreate.  # noqa: E501


        :return: The integration of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._integration

    @integration.setter
    def integration(self, integration):
        """Sets the integration of this SignRequestQuickCreate.


        :param integration: The integration of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """
        allowed_values = ["mfiles", "salesforce", "formdesk", "zapier"]  # noqa: E501
        if integration not in allowed_values:
            raise ValueError(
                "Invalid value for `integration` ({0}), must be one of {1}"  # noqa: E501
                .format(integration, allowed_values)
            )

        self._integration = integration

    @property
    def integration_data(self):
        """Gets the integration_data of this SignRequestQuickCreate.  # noqa: E501


        :return: The integration_data of this SignRequestQuickCreate.  # noqa: E501
        :rtype: object
        """
        return self._integration_data

    @integration_data.setter
    def integration_data(self, integration_data):
        """Sets the integration_data of this SignRequestQuickCreate.


        :param integration_data: The integration_data of this SignRequestQuickCreate.  # noqa: E501
        :type: object
        """

        self._integration_data = integration_data

    @property
    def name(self):
        """Gets the name of this SignRequestQuickCreate.  # noqa: E501

        Defaults to filename, including extension  # noqa: E501

        :return: The name of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SignRequestQuickCreate.

        Defaults to filename, including extension  # noqa: E501

        :param name: The name of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """
        if name is not None and len(name) > 255:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501

        self._name = name

    @property
    def external_id(self):
        """Gets the external_id of this SignRequestQuickCreate.  # noqa: E501

        ID used to reference document in external system  # noqa: E501

        :return: The external_id of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """Sets the external_id of this SignRequestQuickCreate.

        ID used to reference document in external system  # noqa: E501

        :param external_id: The external_id of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """
        if external_id is not None and len(external_id) > 255:
            raise ValueError("Invalid value for `external_id`, length must be less than or equal to `255`")  # noqa: E501

        self._external_id = external_id

    @property
    def frontend_id(self):
        """Gets the frontend_id of this SignRequestQuickCreate.  # noqa: E501

        Shared secret used in conjunction with <a href=\"#section/Frontend-API/SignRequest-js-client-(beta)\">SignRequest-js client</a> to grant user access to a document that's not a member of the document's team  # noqa: E501

        :return: The frontend_id of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._frontend_id

    @frontend_id.setter
    def frontend_id(self, frontend_id):
        """Sets the frontend_id of this SignRequestQuickCreate.

        Shared secret used in conjunction with <a href=\"#section/Frontend-API/SignRequest-js-client-(beta)\">SignRequest-js client</a> to grant user access to a document that's not a member of the document's team  # noqa: E501

        :param frontend_id: The frontend_id of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """
        if frontend_id is not None and len(frontend_id) > 255:
            raise ValueError("Invalid value for `frontend_id`, length must be less than or equal to `255`")  # noqa: E501

        self._frontend_id = frontend_id

    @property
    def file(self):
        """Gets the file of this SignRequestQuickCreate.  # noqa: E501

        Temporary URL to original file, expires in five minutes  # noqa: E501

        :return: The file of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._file

    @file.setter
    def file(self, file):
        """Sets the file of this SignRequestQuickCreate.

        Temporary URL to original file, expires in five minutes  # noqa: E501

        :param file: The file of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """

        self._file = file

    @property
    def file_from_url(self):
        """Gets the file_from_url of this SignRequestQuickCreate.  # noqa: E501

        Publicly accessible URL of document to be downloaded by SignRequest  # noqa: E501

        :return: The file_from_url of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._file_from_url

    @file_from_url.setter
    def file_from_url(self, file_from_url):
        """Sets the file_from_url of this SignRequestQuickCreate.

        Publicly accessible URL of document to be downloaded by SignRequest  # noqa: E501

        :param file_from_url: The file_from_url of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """
        if file_from_url is not None and len(file_from_url) > 2100:
            raise ValueError("Invalid value for `file_from_url`, length must be less than or equal to `2100`")  # noqa: E501

        self._file_from_url = file_from_url

    @property
    def events_callback_url(self):
        """Gets the events_callback_url of this SignRequestQuickCreate.  # noqa: E501

        URL at which to receive [event callbacks](#section/Events/Events-callback) for this document  # noqa: E501

        :return: The events_callback_url of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._events_callback_url

    @events_callback_url.setter
    def events_callback_url(self, events_callback_url):
        """Sets the events_callback_url of this SignRequestQuickCreate.

        URL at which to receive [event callbacks](#section/Events/Events-callback) for this document  # noqa: E501

        :param events_callback_url: The events_callback_url of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """
        if events_callback_url is not None and len(events_callback_url) > 2100:
            raise ValueError("Invalid value for `events_callback_url`, length must be less than or equal to `2100`")  # noqa: E501

        self._events_callback_url = events_callback_url

    @property
    def file_from_content(self):
        """Gets the file_from_content of this SignRequestQuickCreate.  # noqa: E501

        Base64 encoded document content  # noqa: E501

        :return: The file_from_content of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._file_from_content

    @file_from_content.setter
    def file_from_content(self, file_from_content):
        """Sets the file_from_content of this SignRequestQuickCreate.

        Base64 encoded document content  # noqa: E501

        :param file_from_content: The file_from_content of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """

        self._file_from_content = file_from_content

    @property
    def file_from_content_name(self):
        """Gets the file_from_content_name of this SignRequestQuickCreate.  # noqa: E501

        Filename, including extension. Required when using `file_from_content`.  # noqa: E501

        :return: The file_from_content_name of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._file_from_content_name

    @file_from_content_name.setter
    def file_from_content_name(self, file_from_content_name):
        """Sets the file_from_content_name of this SignRequestQuickCreate.

        Filename, including extension. Required when using `file_from_content`.  # noqa: E501

        :param file_from_content_name: The file_from_content_name of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """

        self._file_from_content_name = file_from_content_name

    @property
    def template(self):
        """Gets the template of this SignRequestQuickCreate.  # noqa: E501


        :return: The template of this SignRequestQuickCreate.  # noqa: E501
        :rtype: str
        """
        return self._template

    @template.setter
    def template(self, template):
        """Sets the template of this SignRequestQuickCreate.


        :param template: The template of this SignRequestQuickCreate.  # noqa: E501
        :type: str
        """

        self._template = template

    @property
    def prefill_tags(self):
        """Gets the prefill_tags of this SignRequestQuickCreate.  # noqa: E501

        Prefill signer input data, see [prefill tags](#section/Preparing-a-document/Prefill-tags-templates)  # noqa: E501

        :return: The prefill_tags of this SignRequestQuickCreate.  # noqa: E501
        :rtype: list[InlinePrefillTags]
        """
        return self._prefill_tags

    @prefill_tags.setter
    def prefill_tags(self, prefill_tags):
        """Sets the prefill_tags of this SignRequestQuickCreate.

        Prefill signer input data, see [prefill tags](#section/Preparing-a-document/Prefill-tags-templates)  # noqa: E501

        :param prefill_tags: The prefill_tags of this SignRequestQuickCreate.  # noqa: E501
        :type: list[InlinePrefillTags]
        """

        self._prefill_tags = prefill_tags

    @property
    def integrations(self):
        """Gets the integrations of this SignRequestQuickCreate.  # noqa: E501


        :return: The integrations of this SignRequestQuickCreate.  # noqa: E501
        :rtype: list[InlineIntegrationData]
        """
        return self._integrations

    @integrations.setter
    def integrations(self, integrations):
        """Sets the integrations of this SignRequestQuickCreate.


        :param integrations: The integrations of this SignRequestQuickCreate.  # noqa: E501
        :type: list[InlineIntegrationData]
        """

        self._integrations = integrations

    @property
    def file_from_sf(self):
        """Gets the file_from_sf of this SignRequestQuickCreate.  # noqa: E501


        :return: The file_from_sf of this SignRequestQuickCreate.  # noqa: E501
        :rtype: FileFromSf
        """
        return self._file_from_sf

    @file_from_sf.setter
    def file_from_sf(self, file_from_sf):
        """Sets the file_from_sf of this SignRequestQuickCreate.


        :param file_from_sf: The file_from_sf of this SignRequestQuickCreate.  # noqa: E501
        :type: FileFromSf
        """

        self._file_from_sf = file_from_sf

    @property
    def auto_delete_days(self):
        """Gets the auto_delete_days of this SignRequestQuickCreate.  # noqa: E501

        Number of days after which a finished document (signed/cancelled/declined) will be automatically deleted  # noqa: E501

        :return: The auto_delete_days of this SignRequestQuickCreate.  # noqa: E501
        :rtype: int
        """
        return self._auto_delete_days

    @auto_delete_days.setter
    def auto_delete_days(self, auto_delete_days):
        """Sets the auto_delete_days of this SignRequestQuickCreate.

        Number of days after which a finished document (signed/cancelled/declined) will be automatically deleted  # noqa: E501

        :param auto_delete_days: The auto_delete_days of this SignRequestQuickCreate.  # noqa: E501
        :type: int
        """
        if auto_delete_days is not None and auto_delete_days > 730:  # noqa: E501
            raise ValueError("Invalid value for `auto_delete_days`, must be a value less than or equal to `730`")  # noqa: E501
        if auto_delete_days is not None and auto_delete_days < 1:  # noqa: E501
            raise ValueError("Invalid value for `auto_delete_days`, must be a value greater than or equal to `1`")  # noqa: E501

        self._auto_delete_days = auto_delete_days

    @property
    def auto_expire_days(self):
        """Gets the auto_expire_days of this SignRequestQuickCreate.  # noqa: E501

        Number of days after which a non finished document will be automatically expired  # noqa: E501

        :return: The auto_expire_days of this SignRequestQuickCreate.  # noqa: E501
        :rtype: int
        """
        return self._auto_expire_days

    @auto_expire_days.setter
    def auto_expire_days(self, auto_expire_days):
        """Sets the auto_expire_days of this SignRequestQuickCreate.

        Number of days after which a non finished document will be automatically expired  # noqa: E501

        :param auto_expire_days: The auto_expire_days of this SignRequestQuickCreate.  # noqa: E501
        :type: int
        """
        if auto_expire_days is not None and auto_expire_days > 730:  # noqa: E501
            raise ValueError("Invalid value for `auto_expire_days`, must be a value less than or equal to `730`")  # noqa: E501
        if auto_expire_days is not None and auto_expire_days < 1:  # noqa: E501
            raise ValueError("Invalid value for `auto_expire_days`, must be a value greater than or equal to `1`")  # noqa: E501

        self._auto_expire_days = auto_expire_days

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SignRequestQuickCreate, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SignRequestQuickCreate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
