# This an autogenerated file
# Description for stochastic wave.
# Generated with StochasticWave
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.stochasticwave import StochasticWaveBlueprint
from numpy import ndarray,asarray
from dmt.namedentity import NamedEntity

class StochasticWave(NamedEntity):
    """
    Description for stochastic wave.
    Keyword arguments
    -----------------
    description : str
         (default "")
    name : str
         name for the metocean data.(default None)
    hs : ndarray
         significant wave height.
    tp : ndarray
         peack period.
    tm : float
         mean period.(default 0.0)
    direction : ndarray
         dominant wave direction.
    meanDirection : float
         mean wave direction.(default 0.0)
    """

    def __init__(self , description="", tm=0.0, meanDirection=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.name = None
        self.hs = []
        self.tp = []
        self.tm = tm
        self.direction = []
        self.meanDirection = meanDirection
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return StochasticWaveBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def name(self) -> str:
        """name for the metocean data."""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def hs(self) -> ndarray:
        """significant wave height."""
        return self.__hs

    @hs.setter
    def hs(self, value: ndarray):
        """Set hs"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__hs = array

    @property
    def tp(self) -> ndarray:
        """peack period."""
        return self.__tp

    @tp.setter
    def tp(self, value: ndarray):
        """Set tp"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__tp = array

    @property
    def tm(self) -> float:
        """mean period."""
        return self.__tm

    @tm.setter
    def tm(self, value: float):
        """Set tm"""
        self.__tm = float(value)

    @property
    def direction(self) -> ndarray:
        """dominant wave direction."""
        return self.__direction

    @direction.setter
    def direction(self, value: ndarray):
        """Set direction"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__direction = array

    @property
    def meanDirection(self) -> float:
        """mean wave direction."""
        return self.__meanDirection

    @meanDirection.setter
    def meanDirection(self, value: float):
        """Set meanDirection"""
        self.__meanDirection = float(value)
