# This an autogenerated file
# Description for stochastic process at a sector.
# Generated with Sectors
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.sectors import SectorsBlueprint
from numpy import ndarray,asarray
from dmt.entity import Entity

class Sectors(Entity):
    """
    Description for stochastic process at a sector.
    Keyword arguments
    -----------------
    description : str
         (default "")
    direction : ndarray
         sector direction.
    sectorSize : ndarray
         sector size.
    probability : ndarray
         probability of this combination
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.direction = []
        self.sectorSize = []
        self.probability = []
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SectorsBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def direction(self) -> ndarray:
        """sector direction."""
        return self.__direction

    @direction.setter
    def direction(self, value: ndarray):
        """Set direction"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__direction = array

    @property
    def sectorSize(self) -> ndarray:
        """sector size."""
        return self.__sectorSize

    @sectorSize.setter
    def sectorSize(self, value: ndarray):
        """Set sectorSize"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__sectorSize = array

    @property
    def probability(self) -> ndarray:
        """probability of this combination"""
        return self.__probability

    @probability.setter
    def probability(self, value: ndarray):
        """Set probability"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__probability = array
