# This an autogenerated file
# Description weibull statistics.
# Generated with Weibull
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.weibull import WeibullBlueprint
from numpy import ndarray,asarray
from dmt.entity import Entity

class Weibull(Entity):
    """
    Description weibull statistics.
    Keyword arguments
    -----------------
    description : str
         (default "")
    variable : str
         variable.(default None)
    unit : str
         unit.(default None)
    shape : ndarray
         shape.
    scale : ndarray
         scale.
    location : ndarray
         location.
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.variable = None
        self.unit = None
        self.shape = []
        self.scale = []
        self.location = []
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return WeibullBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def variable(self) -> str:
        """variable."""
        return self.__variable

    @variable.setter
    def variable(self, value: str):
        """Set variable"""
        self.__variable = value

    @property
    def unit(self) -> str:
        """unit."""
        return self.__unit

    @unit.setter
    def unit(self, value: str):
        """Set unit"""
        self.__unit = value

    @property
    def shape(self) -> ndarray:
        """shape."""
        return self.__shape

    @shape.setter
    def shape(self, value: ndarray):
        """Set shape"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__shape = array

    @property
    def scale(self) -> ndarray:
        """scale."""
        return self.__scale

    @scale.setter
    def scale(self, value: ndarray):
        """Set scale"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__scale = array

    @property
    def location(self) -> ndarray:
        """location."""
        return self.__location

    @location.setter
    def location(self, value: ndarray):
        """Set location"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__location = array
