# This an autogenerated file
# Description for stochastic process with sampling at certain period.
# Generated with Period
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.period import PeriodBlueprint
from typing import Dict
from .level.stat import Stat
from .wave.stat import Stat
from dmt.namedentity import NamedEntity

class Period(NamedEntity):
    """
    Description for stochastic process with sampling at certain period.
    Keyword arguments
    -----------------
    description : str
         (default "")
    name : str
         name of the time period as seen in SIMA.(default None)
    period : str
         place holder identification for the time period e.g. Year, Jan(default None)
    wave : List[Stat]
         models for statistical representation of wave, e.g. omni, or 12sec.
    wind : List[Stat]
         models for statistical representation of wind, e.g. omni, or 12sec.
    current : List[Stat]
         models for statistical representation of current, e.g. omni, or 12sec.
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.name = None
        self.period = None
        self.wave = list()
        self.wind = list()
        self.current = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return PeriodBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def name(self) -> str:
        """name of the time period as seen in SIMA."""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def period(self) -> str:
        """place holder identification for the time period e.g. Year, Jan"""
        return self.__period

    @period.setter
    def period(self, value: str):
        """Set period"""
        self.__period = value

    @property
    def wave(self) -> List[Stat]:
        """models for statistical representation of wave, e.g. omni, or 12sec."""
        return self.__wave

    @wave.setter
    def wave(self, value: List[Stat]):
        """Set wave"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__wave = value

    @property
    def wind(self) -> List[Stat]:
        """models for statistical representation of wind, e.g. omni, or 12sec."""
        return self.__wind

    @wind.setter
    def wind(self, value: List[Stat]):
        """Set wind"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__wind = value

    @property
    def current(self) -> List[Stat]:
        """models for statistical representation of current, e.g. omni, or 12sec."""
        return self.__current

    @current.setter
    def current(self, value: List[Stat]):
        """Set current"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__current = value
