# This an autogenerated file
# Description for scatter data based on Hs-Tp.
# Generated with Metocean
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.metocean import MetoceanBlueprint
from typing import Dict
from .hindcast.hindcast import Hindcast
from .longTermStatistics.longtermstats import LongTermStats
from .scatter.scatter import Scatter
from dmt.namedentity import NamedEntity

class Metocean(NamedEntity):
    """
    Description for scatter data based on Hs-Tp.
    Keyword arguments
    -----------------
    description : str
         (default "")
    name : str
         name for the metocean data.(default None)
    hindcasts : List[Hindcast]
         hindcast data.
    scatters : List[Scatter]
         scatter data.
    longterms : List[LongTermStats]
         scatter data.
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.name = None
        self.hindcasts = list()
        self.scatters = list()
        self.longterms = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return MetoceanBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def name(self) -> str:
        """name for the metocean data."""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def hindcasts(self) -> List[Hindcast]:
        """hindcast data."""
        return self.__hindcasts

    @hindcasts.setter
    def hindcasts(self, value: List[Hindcast]):
        """Set hindcasts"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__hindcasts = value

    @property
    def scatters(self) -> List[Scatter]:
        """scatter data."""
        return self.__scatters

    @scatters.setter
    def scatters(self, value: List[Scatter]):
        """Set scatters"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scatters = value

    @property
    def longterms(self) -> List[LongTermStats]:
        """scatter data."""
        return self.__longterms

    @longterms.setter
    def longterms(self, value: List[LongTermStats]):
        """Set longterms"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__longterms = value
