# This an autogenerated file
# Description for stochastic process at a sector.
# Generated with Sector
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.sector import SectorBlueprint
from typing import Dict
from .wave import Wave
from .windcurrent import WindCurrent
from dmt.namedentity import NamedEntity

class Sector(NamedEntity):
    """
    Description for stochastic process at a sector.
    Keyword arguments
    -----------------
    description : str
         (default "")
    name : str
         unique name for the sector, e.g. sec120, or omni.(default None)
    direction : float
         sector direction.(default 0.0)
    sectorSize : float
         sector size.(default 0.0)
    wave : Wave
         the scatter data for wave.
    wind : List[WindCurrent]
         the scatter data for wind at different levels.
    current : List[WindCurrent]
         the scatter data for current at different levels.
    """

    def __init__(self , description="", direction=0.0, sectorSize=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.name = None
        self.direction = direction
        self.sectorSize = sectorSize
        self.wave = None
        self.wind = list()
        self.current = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SectorBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def name(self) -> str:
        """unique name for the sector, e.g. sec120, or omni."""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def direction(self) -> float:
        """sector direction."""
        return self.__direction

    @direction.setter
    def direction(self, value: float):
        """Set direction"""
        self.__direction = float(value)

    @property
    def sectorSize(self) -> float:
        """sector size."""
        return self.__sectorSize

    @sectorSize.setter
    def sectorSize(self, value: float):
        """Set sectorSize"""
        self.__sectorSize = float(value)

    @property
    def wave(self) -> Wave:
        """the scatter data for wave."""
        return self.__wave

    @wave.setter
    def wave(self, value: Wave):
        """Set wave"""
        self.__wave = value

    @property
    def wind(self) -> List[WindCurrent]:
        """the scatter data for wind at different levels."""
        return self.__wind

    @wind.setter
    def wind(self, value: List[WindCurrent]):
        """Set wind"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__wind = value

    @property
    def current(self) -> List[WindCurrent]:
        """the scatter data for current at different levels."""
        return self.__current

    @current.setter
    def current(self, value: List[WindCurrent]):
        """Set current"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__current = value
