# This an autogenerated file
# 
# Generated with ConditionRunCommand
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.conditionruncommand import ConditionRunCommandBlueprint
from typing import Dict
from ..sima import Property
from ..sima import ScriptableValue
from .command import Command

class ConditionRunCommand(Command):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    parameters : List[Property]
         Additional parameters
    task : str
         Name of task containing condition(default None)
    condition : str
         Name of condition to run(default None)
    runType : str
         Condition run type(default None)
    dir : str
         Optional working directory ( may be specified with sima resource urls: sima:// which are relative to the workspace).\nIf the working directory is given outside the workspace SIMA will not delete any of the files before running.(default None)
    output : str
         If set will export all the condition results to the given file(default None)
    input : List[Property]
         Enables override of condition variables. Specify variable name and wanted value
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.parameters = list()
        self.task = None
        self.condition = None
        self.runType = None
        self.dir = None
        self.output = None
        self.input = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ConditionRunCommandBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def parameters(self) -> List[Property]:
        """Additional parameters"""
        return self.__parameters

    @parameters.setter
    def parameters(self, value: List[Property]):
        """Set parameters"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__parameters = value

    @property
    def task(self) -> str:
        """Name of task containing condition"""
        return self.__task

    @task.setter
    def task(self, value: str):
        """Set task"""
        self.__task = value

    @property
    def condition(self) -> str:
        """Name of condition to run"""
        return self.__condition

    @condition.setter
    def condition(self, value: str):
        """Set condition"""
        self.__condition = value

    @property
    def runType(self) -> str:
        """Condition run type"""
        return self.__runType

    @runType.setter
    def runType(self, value: str):
        """Set runType"""
        self.__runType = value

    @property
    def dir(self) -> str:
        """Optional working directory ( may be specified with sima resource urls: sima:// which are relative to the workspace).
If the working directory is given outside the workspace SIMA will not delete any of the files before running."""
        return self.__dir

    @dir.setter
    def dir(self, value: str):
        """Set dir"""
        self.__dir = value

    @property
    def output(self) -> str:
        """If set will export all the condition results to the given file"""
        return self.__output

    @output.setter
    def output(self, value: str):
        """Set output"""
        self.__output = value

    @property
    def input(self) -> List[Property]:
        """Enables override of condition variables. Specify variable name and wanted value"""
        return self.__input

    @input.setter
    def input(self, value: List[Property]):
        """Set input"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__input = value
