# This an autogenerated file
# 
# Generated with CurrentItem
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.currentitem import CurrentItemBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class CurrentItem(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    level : float
         Global z-coordinate of current level(default 0.0)
    direction : float
         Current propagation direction(default 0.0)
    velocity : float
         Current velocity(default 0.0)
    """

    def __init__(self , description="", level=0.0, direction=0.0, velocity=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.level = level
        self.direction = direction
        self.velocity = velocity
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return CurrentItemBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def level(self) -> float:
        """Global z-coordinate of current level"""
        return self.__level

    @level.setter
    def level(self, value: float):
        """Set level"""
        self.__level = float(value)

    @property
    def direction(self) -> float:
        """Current propagation direction"""
        return self.__direction

    @direction.setter
    def direction(self, value: float):
        """Set direction"""
        self.__direction = float(value)

    @property
    def velocity(self) -> float:
        """Current velocity"""
        return self.__velocity

    @velocity.setter
    def velocity(self, value: float):
        """Set velocity"""
        self.__velocity = float(value)
