# This an autogenerated file
# 
# Generated with ComplexValues
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.complexvalues import ComplexValuesBlueprint
from numpy import ndarray,asarray
from ..sima import MOAO
from ..sima import ScriptableValue

class ComplexValues(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    realValues : ndarray of float
    imagValues : ndarray of float
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.realValues = []
        self.imagValues = []
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ComplexValuesBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def realValues(self) -> ndarray:
        """"""
        return self.__realValues

    @realValues.setter
    def realValues(self, value: ndarray):
        """Set realValues"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__realValues = array

    @property
    def imagValues(self) -> ndarray:
        """"""
        return self.__imagValues

    @imagValues.setter
    def imagValues(self, value: ndarray):
        """Set imagValues"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__imagValues = array
