# This an autogenerated file
# 
# Generated with DiffractedWaveVelocity
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.diffractedwavevelocity import DiffractedWaveVelocityBlueprint
from numpy import ndarray,asarray
from ..sima import MOAO
from ..sima import ScriptableValue
from .directiondependentcomplexvalues import DirectionDependentComplexValues

class DiffractedWaveVelocity(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    directions : ndarray of float
    frequencies : ndarray of float
    u : DirectionDependentComplexValues
    v : DirectionDependentComplexValues
    w : DirectionDependentComplexValues
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.directions = []
        self.frequencies = []
        self.u = None
        self.v = None
        self.w = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return DiffractedWaveVelocityBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def directions(self) -> ndarray:
        """"""
        return self.__directions

    @directions.setter
    def directions(self, value: ndarray):
        """Set directions"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__directions = array

    @property
    def frequencies(self) -> ndarray:
        """"""
        return self.__frequencies

    @frequencies.setter
    def frequencies(self, value: ndarray):
        """Set frequencies"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__frequencies = array

    @property
    def u(self) -> DirectionDependentComplexValues:
        """"""
        return self.__u

    @u.setter
    def u(self, value: DirectionDependentComplexValues):
        """Set u"""
        self.__u = value

    @property
    def v(self) -> DirectionDependentComplexValues:
        """"""
        return self.__v

    @v.setter
    def v(self, value: DirectionDependentComplexValues):
        """Set v"""
        self.__v = value

    @property
    def w(self) -> DirectionDependentComplexValues:
        """"""
        return self.__w

    @w.setter
    def w(self, value: DirectionDependentComplexValues):
        """Set w"""
        self.__w = value
