# This an autogenerated file
# 
# Generated with SumFrequencyQTF
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.sumfrequencyqtf import SumFrequencyQTFBlueprint
from numpy import ndarray,asarray
from ..sima import ScriptableValue
from .qtfdof import QTFDof
from .sparseqtf import SparseQTF

class SumFrequencyQTF(SparseQTF):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    nFreq : int
         (default 0)
    nDir : int
         (default 0)
    nValues : int
         (default 0)
    bidirectional : bool
         (default False)
    bichromatic : bool
         (default False)
    directions : ndarray of float
    frequencies : ndarray of float
    di : ndarray of int
    dj : ndarray of int
    wi : ndarray of int
    wj : ndarray of int
    surge : QTFDof
    sway : QTFDof
    heave : QTFDof
    roll : QTFDof
    pitch : QTFDof
    yaw : QTFDof
    """

    def __init__(self , description="", nFreq=0, nDir=0, nValues=0, bidirectional=False, bichromatic=False, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.nFreq = nFreq
        self.nDir = nDir
        self.nValues = nValues
        self.bidirectional = bidirectional
        self.bichromatic = bichromatic
        self.directions = []
        self.frequencies = []
        self.di = []
        self.dj = []
        self.wi = []
        self.wj = []
        self.surge = None
        self.sway = None
        self.heave = None
        self.roll = None
        self.pitch = None
        self.yaw = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SumFrequencyQTFBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def nFreq(self) -> int:
        """"""
        return self.__nFreq

    @nFreq.setter
    def nFreq(self, value: int):
        """Set nFreq"""
        self.__nFreq = int(value)

    @property
    def nDir(self) -> int:
        """"""
        return self.__nDir

    @nDir.setter
    def nDir(self, value: int):
        """Set nDir"""
        self.__nDir = int(value)

    @property
    def nValues(self) -> int:
        """"""
        return self.__nValues

    @nValues.setter
    def nValues(self, value: int):
        """Set nValues"""
        self.__nValues = int(value)

    @property
    def bidirectional(self) -> bool:
        """"""
        return self.__bidirectional

    @bidirectional.setter
    def bidirectional(self, value: bool):
        """Set bidirectional"""
        self.__bidirectional = bool(value)

    @property
    def bichromatic(self) -> bool:
        """"""
        return self.__bichromatic

    @bichromatic.setter
    def bichromatic(self, value: bool):
        """Set bichromatic"""
        self.__bichromatic = bool(value)

    @property
    def directions(self) -> ndarray:
        """"""
        return self.__directions

    @directions.setter
    def directions(self, value: ndarray):
        """Set directions"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__directions = array

    @property
    def frequencies(self) -> ndarray:
        """"""
        return self.__frequencies

    @frequencies.setter
    def frequencies(self, value: ndarray):
        """Set frequencies"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__frequencies = array

    @property
    def di(self) -> ndarray:
        """"""
        return self.__di

    @di.setter
    def di(self, value: ndarray):
        """Set di"""
        array = asarray(value, dtype=int)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__di = array

    @property
    def dj(self) -> ndarray:
        """"""
        return self.__dj

    @dj.setter
    def dj(self, value: ndarray):
        """Set dj"""
        array = asarray(value, dtype=int)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__dj = array

    @property
    def wi(self) -> ndarray:
        """"""
        return self.__wi

    @wi.setter
    def wi(self, value: ndarray):
        """Set wi"""
        array = asarray(value, dtype=int)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__wi = array

    @property
    def wj(self) -> ndarray:
        """"""
        return self.__wj

    @wj.setter
    def wj(self, value: ndarray):
        """Set wj"""
        array = asarray(value, dtype=int)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__wj = array

    @property
    def surge(self) -> QTFDof:
        """"""
        return self.__surge

    @surge.setter
    def surge(self, value: QTFDof):
        """Set surge"""
        self.__surge = value

    @property
    def sway(self) -> QTFDof:
        """"""
        return self.__sway

    @sway.setter
    def sway(self, value: QTFDof):
        """Set sway"""
        self.__sway = value

    @property
    def heave(self) -> QTFDof:
        """"""
        return self.__heave

    @heave.setter
    def heave(self, value: QTFDof):
        """Set heave"""
        self.__heave = value

    @property
    def roll(self) -> QTFDof:
        """"""
        return self.__roll

    @roll.setter
    def roll(self, value: QTFDof):
        """Set roll"""
        self.__roll = value

    @property
    def pitch(self) -> QTFDof:
        """"""
        return self.__pitch

    @pitch.setter
    def pitch(self, value: QTFDof):
        """Set pitch"""
        self.__pitch = value

    @property
    def yaw(self) -> QTFDof:
        """"""
        return self.__yaw

    @yaw.setter
    def yaw(self, value: QTFDof):
        """Set yaw"""
        self.__yaw = value
