# This an autogenerated file
# 
# Generated with ScatterDiagram
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.scatterdiagram import ScatterDiagramBlueprint
from numpy import ndarray,asarray
from ..sima import Named
from ..sima import ScriptableValue
from .scatterdimension import ScatterDimension

class ScatterDiagram(Named):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    hsUpperLimits : ScatterDimension
    tpUpperLimits : ScatterDimension
    values : ndarray of float
    unit : str
         (default None)
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.hsUpperLimits = None
        self.tpUpperLimits = None
        self.values = []
        self.unit = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ScatterDiagramBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def hsUpperLimits(self) -> ScatterDimension:
        """"""
        return self.__hsUpperLimits

    @hsUpperLimits.setter
    def hsUpperLimits(self, value: ScatterDimension):
        """Set hsUpperLimits"""
        self.__hsUpperLimits = value

    @property
    def tpUpperLimits(self) -> ScatterDimension:
        """"""
        return self.__tpUpperLimits

    @tpUpperLimits.setter
    def tpUpperLimits(self, value: ScatterDimension):
        """Set tpUpperLimits"""
        self.__tpUpperLimits = value

    @property
    def values(self) -> ndarray:
        """"""
        return self.__values

    @values.setter
    def values(self, value: ndarray):
        """Set values"""
        array = asarray(value, dtype=float)
        if len(array) > 0 and array.ndim != 1:
            raise ValueError("Expected array with 1 dimensions")
        self.__values = array

    @property
    def unit(self) -> str:
        """"""
        return self.__unit

    @unit.setter
    def unit(self, value: str):
        """Set unit"""
        self.__unit = value
