# This an autogenerated file
# 
# Generated with ConstantValue
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.constantvalue import ConstantValueBlueprint
from typing import Dict
from ..sima import ScriptableValue
from ..sima import SingleParameter
from .generatorsignal import GeneratorSignal
from .signalproperties import SignalProperties

class ConstantValue(GeneratorSignal,SingleParameter):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    properties : List[SignalProperties]
    name : str
         (default None)
    value : float
         Value of the constant(default 0.0)
    unit : str
         Defines the unit of the constant(default '-')
    """

    def __init__(self , description="", value=0.0, unit='-', **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.properties = list()
        self.name = None
        self.value = value
        self.unit = unit
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ConstantValueBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def properties(self) -> List[SignalProperties]:
        """"""
        return self.__properties

    @properties.setter
    def properties(self, value: List[SignalProperties]):
        """Set properties"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__properties = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def value(self) -> float:
        """Value of the constant"""
        return self.__value

    @value.setter
    def value(self, value: float):
        """Set value"""
        self.__value = float(value)

    @property
    def unit(self) -> str:
        """Defines the unit of the constant"""
        return self.__unit

    @unit.setter
    def unit(self, value: str):
        """Set unit"""
        self.__unit = value
