# This an autogenerated file
# 
# Generated with DistanceFixedLineToLineFilter
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.distancefixedlinetolinefilter import DistanceFixedLineToLineFilterBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .controlsignalinputslot import ControlSignalInputSlot
from .inputslot import InputSlot
from .operationnode import OperationNode
from .outputslot import OutputSlot

class DistanceFixedLineToLineFilter(OperationNode):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    x : int
         (default 0)
    y : int
         (default 0)
    h : int
         (default 0)
    w : int
         (default 0)
    controlSignalInputSlots : List[ControlSignalInputSlot]
    filterInputSlots : List[InputSlot]
    filterOutputSlots : List[OutputSlot]
    renameOutput : bool
         (default True)
    xg1 : float
         X value of end 1 of global fixed line(default 0.0)
    yg1 : float
         Y value of end 1 of global fixed line(default 0.0)
    zg1 : float
         Z value of end 1 of global fixed line(default 0.0)
    xg2 : float
         X value of end 2 of global fixed line(default 0.0)
    yg2 : float
         Y value of end 2 of global fixed line(default 0.0)
    zg2 : float
         Z value of end 2 of global fixed line(default 0.0)
    """

    def __init__(self , description="", x=0, y=0, h=0, w=0, renameOutput=True, xg1=0.0, yg1=0.0, zg1=0.0, xg2=0.0, yg2=0.0, zg2=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.x = x
        self.y = y
        self.h = h
        self.w = w
        self.controlSignalInputSlots = list()
        self.filterInputSlots = list()
        self.filterOutputSlots = list()
        self.renameOutput = renameOutput
        self.xg1 = xg1
        self.yg1 = yg1
        self.zg1 = zg1
        self.xg2 = xg2
        self.yg2 = yg2
        self.zg2 = zg2
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return DistanceFixedLineToLineFilterBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def x(self) -> int:
        """"""
        return self.__x

    @x.setter
    def x(self, value: int):
        """Set x"""
        self.__x = int(value)

    @property
    def y(self) -> int:
        """"""
        return self.__y

    @y.setter
    def y(self, value: int):
        """Set y"""
        self.__y = int(value)

    @property
    def h(self) -> int:
        """"""
        return self.__h

    @h.setter
    def h(self, value: int):
        """Set h"""
        self.__h = int(value)

    @property
    def w(self) -> int:
        """"""
        return self.__w

    @w.setter
    def w(self, value: int):
        """Set w"""
        self.__w = int(value)

    @property
    def controlSignalInputSlots(self) -> List[ControlSignalInputSlot]:
        """"""
        return self.__controlSignalInputSlots

    @controlSignalInputSlots.setter
    def controlSignalInputSlots(self, value: List[ControlSignalInputSlot]):
        """Set controlSignalInputSlots"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__controlSignalInputSlots = value

    @property
    def filterInputSlots(self) -> List[InputSlot]:
        """"""
        return self.__filterInputSlots

    @filterInputSlots.setter
    def filterInputSlots(self, value: List[InputSlot]):
        """Set filterInputSlots"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__filterInputSlots = value

    @property
    def filterOutputSlots(self) -> List[OutputSlot]:
        """"""
        return self.__filterOutputSlots

    @filterOutputSlots.setter
    def filterOutputSlots(self, value: List[OutputSlot]):
        """Set filterOutputSlots"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__filterOutputSlots = value

    @property
    def renameOutput(self) -> bool:
        """"""
        return self.__renameOutput

    @renameOutput.setter
    def renameOutput(self, value: bool):
        """Set renameOutput"""
        self.__renameOutput = bool(value)

    @property
    def xg1(self) -> float:
        """X value of end 1 of global fixed line"""
        return self.__xg1

    @xg1.setter
    def xg1(self, value: float):
        """Set xg1"""
        self.__xg1 = float(value)

    @property
    def yg1(self) -> float:
        """Y value of end 1 of global fixed line"""
        return self.__yg1

    @yg1.setter
    def yg1(self, value: float):
        """Set yg1"""
        self.__yg1 = float(value)

    @property
    def zg1(self) -> float:
        """Z value of end 1 of global fixed line"""
        return self.__zg1

    @zg1.setter
    def zg1(self, value: float):
        """Set zg1"""
        self.__zg1 = float(value)

    @property
    def xg2(self) -> float:
        """X value of end 2 of global fixed line"""
        return self.__xg2

    @xg2.setter
    def xg2(self, value: float):
        """Set xg2"""
        self.__xg2 = float(value)

    @property
    def yg2(self) -> float:
        """Y value of end 2 of global fixed line"""
        return self.__yg2

    @yg2.setter
    def yg2(self, value: float):
        """Set yg2"""
        self.__yg2 = float(value)

    @property
    def zg2(self) -> float:
        """Z value of end 2 of global fixed line"""
        return self.__zg2

    @zg2.setter
    def zg2(self, value: float):
        """Set zg2"""
        self.__zg2 = float(value)
