# This an autogenerated file
# 
# Generated with RotationMatrix
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.rotationmatrix import RotationMatrixBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .controlsignalinputslot import ControlSignalInputSlot
from .inputslot import InputSlot
from .operationnode import OperationNode
from .outputslot import OutputSlot

class RotationMatrix(OperationNode):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    x : int
         (default 0)
    y : int
         (default 0)
    h : int
         (default 0)
    w : int
         (default 0)
    controlSignalInputSlots : List[ControlSignalInputSlot]
    outputSlot : OutputSlot
    rotationX : float
         Rotation about new x-axis (third rotation)(default 0.0)
    rotationY : float
         Rotation about new y-axis (second rotation)(default 0.0)
    rotationZ : float
         Rotation about z-axis (first rotation)(default 0.0)
    transpose : bool
         Transpose (invert) the input reference rotation matrix before performing the transformation(default False)
    inputRotations : bool
         Input the euler angles(default False)
    rotationInput : InputSlot
    """

    def __init__(self , description="", x=0, y=0, h=0, w=0, rotationX=0.0, rotationY=0.0, rotationZ=0.0, transpose=False, inputRotations=False, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.x = x
        self.y = y
        self.h = h
        self.w = w
        self.controlSignalInputSlots = list()
        self.outputSlot = None
        self.rotationX = rotationX
        self.rotationY = rotationY
        self.rotationZ = rotationZ
        self.transpose = transpose
        self.inputRotations = inputRotations
        self.rotationInput = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return RotationMatrixBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def x(self) -> int:
        """"""
        return self.__x

    @x.setter
    def x(self, value: int):
        """Set x"""
        self.__x = int(value)

    @property
    def y(self) -> int:
        """"""
        return self.__y

    @y.setter
    def y(self, value: int):
        """Set y"""
        self.__y = int(value)

    @property
    def h(self) -> int:
        """"""
        return self.__h

    @h.setter
    def h(self, value: int):
        """Set h"""
        self.__h = int(value)

    @property
    def w(self) -> int:
        """"""
        return self.__w

    @w.setter
    def w(self, value: int):
        """Set w"""
        self.__w = int(value)

    @property
    def controlSignalInputSlots(self) -> List[ControlSignalInputSlot]:
        """"""
        return self.__controlSignalInputSlots

    @controlSignalInputSlots.setter
    def controlSignalInputSlots(self, value: List[ControlSignalInputSlot]):
        """Set controlSignalInputSlots"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__controlSignalInputSlots = value

    @property
    def outputSlot(self) -> OutputSlot:
        """"""
        return self.__outputSlot

    @outputSlot.setter
    def outputSlot(self, value: OutputSlot):
        """Set outputSlot"""
        self.__outputSlot = value

    @property
    def rotationX(self) -> float:
        """Rotation about new x-axis (third rotation)"""
        return self.__rotationX

    @rotationX.setter
    def rotationX(self, value: float):
        """Set rotationX"""
        self.__rotationX = float(value)

    @property
    def rotationY(self) -> float:
        """Rotation about new y-axis (second rotation)"""
        return self.__rotationY

    @rotationY.setter
    def rotationY(self, value: float):
        """Set rotationY"""
        self.__rotationY = float(value)

    @property
    def rotationZ(self) -> float:
        """Rotation about z-axis (first rotation)"""
        return self.__rotationZ

    @rotationZ.setter
    def rotationZ(self, value: float):
        """Set rotationZ"""
        self.__rotationZ = float(value)

    @property
    def transpose(self) -> bool:
        """Transpose (invert) the input reference rotation matrix before performing the transformation"""
        return self.__transpose

    @transpose.setter
    def transpose(self, value: bool):
        """Set transpose"""
        self.__transpose = bool(value)

    @property
    def inputRotations(self) -> bool:
        """Input the euler angles"""
        return self.__inputRotations

    @inputRotations.setter
    def inputRotations(self, value: bool):
        """Set inputRotations"""
        self.__inputRotations = bool(value)

    @property
    def rotationInput(self) -> InputSlot:
        """"""
        return self.__rotationInput

    @rotationInput.setter
    def rotationInput(self, value: InputSlot):
        """Set rotationInput"""
        self.__rotationInput = value
