# This an autogenerated file
# 
# Generated with SlotConnection
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.slotconnection import SlotConnectionBlueprint
from typing import Dict
from ..graph import Point
from ..sima import MOAO
from ..sima import ScriptableValue
from .requirement import Requirement
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from .inputslot import InputSlot
    from .outputslot import OutputSlot

class SlotConnection(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    useQuery : bool
         Use boolean expressions using operators =, !=,&&,|| to create more advanced queries(default False)
    query : str
         (default None)
    userRequirements : List[Requirement]
    points : List[Point]
    toSlot : InputSlot
    fromSlot : OutputSlot
    """

    def __init__(self , description="", useQuery=False, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.useQuery = useQuery
        self.query = None
        self.userRequirements = list()
        self.points = list()
        self.toSlot = None
        self.fromSlot = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SlotConnectionBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def useQuery(self) -> bool:
        """Use boolean expressions using operators =, !=,&&,|| to create more advanced queries"""
        return self.__useQuery

    @useQuery.setter
    def useQuery(self, value: bool):
        """Set useQuery"""
        self.__useQuery = bool(value)

    @property
    def query(self) -> str:
        """"""
        return self.__query

    @query.setter
    def query(self, value: str):
        """Set query"""
        self.__query = value

    @property
    def userRequirements(self) -> List[Requirement]:
        """"""
        return self.__userRequirements

    @userRequirements.setter
    def userRequirements(self, value: List[Requirement]):
        """Set userRequirements"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__userRequirements = value

    @property
    def points(self) -> List[Point]:
        """"""
        return self.__points

    @points.setter
    def points(self, value: List[Point]):
        """Set points"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__points = value

    @property
    def toSlot(self) -> InputSlot:
        """"""
        return self.__toSlot

    @toSlot.setter
    def toSlot(self, value: InputSlot):
        """Set toSlot"""
        self.__toSlot = value

    @property
    def fromSlot(self) -> OutputSlot:
        """"""
        return self.__fromSlot

    @fromSlot.setter
    def fromSlot(self, value: OutputSlot):
        """Set fromSlot"""
        self.__fromSlot = value
