# This an autogenerated file
# 
# Generated with Report
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.report import ReportBlueprint
from typing import Dict
from ..sima import NamedObject
from ..sima import ScriptableValue
from .reportitem import ReportItem

class Report(NamedObject):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    items : List[ReportItem]
    title : str
         The title of the report.(default None)
    subtitle : str
         A sub title for the report.(default None)
    filePath : str
         Optional path to the generated report file(default None)
    """

    def __init__(self , description="", **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.items = list()
        self.title = None
        self.subtitle = None
        self.filePath = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ReportBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def items(self) -> List[ReportItem]:
        """"""
        return self.__items

    @items.setter
    def items(self, value: List[ReportItem]):
        """Set items"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__items = value

    @property
    def title(self) -> str:
        """The title of the report."""
        return self.__title

    @title.setter
    def title(self, value: str):
        """Set title"""
        self.__title = value

    @property
    def subtitle(self) -> str:
        """A sub title for the report."""
        return self.__subtitle

    @subtitle.setter
    def subtitle(self, value: str):
        """Set subtitle"""
        self.__subtitle = value

    @property
    def filePath(self) -> str:
        """Optional path to the generated report file"""
        return self.__filePath

    @filePath.setter
    def filePath(self, value: str):
        """Set filePath"""
        self.__filePath = value
