# This an autogenerated file
# 
# Generated with Section
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.section import SectionBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .linkable import Linkable
from .orientation import Orientation
from .reportitem import ReportItem

class Section(ReportItem,Linkable):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    identifier : str
         (default None)
    items : List[ReportItem]
    title : str
         The title of the section.(default None)
    pageBreakBefore : bool
         (default False)
    orientation : Orientation
    """

    def __init__(self , description="", pageBreakBefore=False, orientation=Orientation.PORTRAIT, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.identifier = None
        self.items = list()
        self.title = None
        self.pageBreakBefore = pageBreakBefore
        self.orientation = orientation
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SectionBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def identifier(self) -> str:
        """"""
        return self.__identifier

    @identifier.setter
    def identifier(self, value: str):
        """Set identifier"""
        self.__identifier = value

    @property
    def items(self) -> List[ReportItem]:
        """"""
        return self.__items

    @items.setter
    def items(self, value: List[ReportItem]):
        """Set items"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__items = value

    @property
    def title(self) -> str:
        """The title of the section."""
        return self.__title

    @title.setter
    def title(self, value: str):
        """Set title"""
        self.__title = value

    @property
    def pageBreakBefore(self) -> bool:
        """"""
        return self.__pageBreakBefore

    @pageBreakBefore.setter
    def pageBreakBefore(self, value: bool):
        """Set pageBreakBefore"""
        self.__pageBreakBefore = bool(value)

    @property
    def orientation(self) -> Orientation:
        """"""
        return self.__orientation

    @orientation.setter
    def orientation(self, value: Orientation):
        """Set orientation"""
        self.__orientation = value
