# This an autogenerated file
# 
# Generated with AdditionalStructuralDampingParameters
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.additionalstructuraldampingparameters import AdditionalStructuralDampingParametersBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class AdditionalStructuralDampingParameters(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    globalSegmentNumber : int
         Global segment number(default 0)
    structuralDampingFile : str
         File with detailed structural damping specification, see VIVANA user manual(default None)
    """

    def __init__(self , description="", globalSegmentNumber=0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.globalSegmentNumber = globalSegmentNumber
        self.structuralDampingFile = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return AdditionalStructuralDampingParametersBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def globalSegmentNumber(self) -> int:
        """Global segment number"""
        return self.__globalSegmentNumber

    @globalSegmentNumber.setter
    def globalSegmentNumber(self, value: int):
        """Set globalSegmentNumber"""
        self.__globalSegmentNumber = int(value)

    @property
    def structuralDampingFile(self) -> str:
        """File with detailed structural damping specification, see VIVANA user manual"""
        return self.__structuralDampingFile

    @structuralDampingFile.setter
    def structuralDampingFile(self, value: str):
        """Set structuralDampingFile"""
        self.__structuralDampingFile = value
