# This an autogenerated file
# 
# Generated with CRSStiffnessDamping
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.crsstiffnessdamping import CRSStiffnessDampingBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue
from .rayleighdamping import RayleighDamping

class CRSStiffnessDamping(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    axialFactor : float
         Factor for stiffness proportional damping in axial dof(default 0.0)
    torsionalFactor : float
         Factor for stiffness proportional damping in torsional dof(default 0.0)
    bendingFactor : float
         Factor for stiffness proportional damping in bending dof(default 0.0)
    option : RayleighDamping
         Stiffness proportional damping options
    """

    def __init__(self , description="", axialFactor=0.0, torsionalFactor=0.0, bendingFactor=0.0, option=RayleighDamping.TOTAL, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.axialFactor = axialFactor
        self.torsionalFactor = torsionalFactor
        self.bendingFactor = bendingFactor
        self.option = option
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return CRSStiffnessDampingBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def axialFactor(self) -> float:
        """Factor for stiffness proportional damping in axial dof"""
        return self.__axialFactor

    @axialFactor.setter
    def axialFactor(self, value: float):
        """Set axialFactor"""
        self.__axialFactor = float(value)

    @property
    def torsionalFactor(self) -> float:
        """Factor for stiffness proportional damping in torsional dof"""
        return self.__torsionalFactor

    @torsionalFactor.setter
    def torsionalFactor(self, value: float):
        """Set torsionalFactor"""
        self.__torsionalFactor = float(value)

    @property
    def bendingFactor(self) -> float:
        """Factor for stiffness proportional damping in bending dof"""
        return self.__bendingFactor

    @bendingFactor.setter
    def bendingFactor(self, value: float):
        """Set bendingFactor"""
        self.__bendingFactor = float(value)

    @property
    def option(self) -> RayleighDamping:
        """Stiffness proportional damping options"""
        return self.__option

    @option.setter
    def option(self, value: RayleighDamping):
        """Set option"""
        self.__option = value
