# This an autogenerated file
# 
# Generated with DoubleSymmetricCrossSectionMassVolume
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.doublesymmetriccrosssectionmassvolume import DoubleSymmetricCrossSectionMassVolumeBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class DoubleSymmetricCrossSectionMassVolume(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    massCoefficient : float
         Mass / unit length(default 0.0)
    extCrossSectionalArea : float
         External cross-sectional area(default 0.0)
    intCrossSectionalArea : float
         Internal cross-sectional area(default 0.0)
    gyrationRadius : float
         Radius of gyration about local x-axis(default 0.0)
    """

    def __init__(self , description="", massCoefficient=0.0, extCrossSectionalArea=0.0, intCrossSectionalArea=0.0, gyrationRadius=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.massCoefficient = massCoefficient
        self.extCrossSectionalArea = extCrossSectionalArea
        self.intCrossSectionalArea = intCrossSectionalArea
        self.gyrationRadius = gyrationRadius
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return DoubleSymmetricCrossSectionMassVolumeBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def massCoefficient(self) -> float:
        """Mass / unit length"""
        return self.__massCoefficient

    @massCoefficient.setter
    def massCoefficient(self, value: float):
        """Set massCoefficient"""
        self.__massCoefficient = float(value)

    @property
    def extCrossSectionalArea(self) -> float:
        """External cross-sectional area"""
        return self.__extCrossSectionalArea

    @extCrossSectionalArea.setter
    def extCrossSectionalArea(self, value: float):
        """Set extCrossSectionalArea"""
        self.__extCrossSectionalArea = float(value)

    @property
    def intCrossSectionalArea(self) -> float:
        """Internal cross-sectional area"""
        return self.__intCrossSectionalArea

    @intCrossSectionalArea.setter
    def intCrossSectionalArea(self, value: float):
        """Set intCrossSectionalArea"""
        self.__intCrossSectionalArea = float(value)

    @property
    def gyrationRadius(self) -> float:
        """Radius of gyration about local x-axis"""
        return self.__gyrationRadius

    @gyrationRadius.setter
    def gyrationRadius(self, value: float):
        """Set gyrationRadius"""
        self.__gyrationRadius = float(value)
