# This an autogenerated file
# 
# Generated with EigenvalueAnalysisParameters
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.eigenvalueanalysisparameters import EigenvalueAnalysisParametersBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class EigenvalueAnalysisParameters(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    numberOfEigenvalues : int
         Number of eigenvalues to be calculated(default 10)
    maxRelativeError : float
         Maximum acceptable relative error in computed eigenvalues(default 1e-10)
    numberOfLanczoSteps : int
         Maximum number of Lanczos steps (vectors) to be used(default 0)
    storeVisualisationResponses : bool
         Store eigenvalue visualization file(default True)
    visualisationScaling : float
         Scaling of eigenvectors in visual results(default 10.0)
    numberOfEigenvectors : int
         Number of eigenvectors to be printed(default 0)
    """

    def __init__(self , description="", numberOfEigenvalues=10, maxRelativeError=1e-10, numberOfLanczoSteps=0, storeVisualisationResponses=True, visualisationScaling=10.0, numberOfEigenvectors=0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.numberOfEigenvalues = numberOfEigenvalues
        self.maxRelativeError = maxRelativeError
        self.numberOfLanczoSteps = numberOfLanczoSteps
        self.storeVisualisationResponses = storeVisualisationResponses
        self.visualisationScaling = visualisationScaling
        self.numberOfEigenvectors = numberOfEigenvectors
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return EigenvalueAnalysisParametersBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def numberOfEigenvalues(self) -> int:
        """Number of eigenvalues to be calculated"""
        return self.__numberOfEigenvalues

    @numberOfEigenvalues.setter
    def numberOfEigenvalues(self, value: int):
        """Set numberOfEigenvalues"""
        self.__numberOfEigenvalues = int(value)

    @property
    def maxRelativeError(self) -> float:
        """Maximum acceptable relative error in computed eigenvalues"""
        return self.__maxRelativeError

    @maxRelativeError.setter
    def maxRelativeError(self, value: float):
        """Set maxRelativeError"""
        self.__maxRelativeError = float(value)

    @property
    def numberOfLanczoSteps(self) -> int:
        """Maximum number of Lanczos steps (vectors) to be used"""
        return self.__numberOfLanczoSteps

    @numberOfLanczoSteps.setter
    def numberOfLanczoSteps(self, value: int):
        """Set numberOfLanczoSteps"""
        self.__numberOfLanczoSteps = int(value)

    @property
    def storeVisualisationResponses(self) -> bool:
        """Store eigenvalue visualization file"""
        return self.__storeVisualisationResponses

    @storeVisualisationResponses.setter
    def storeVisualisationResponses(self, value: bool):
        """Set storeVisualisationResponses"""
        self.__storeVisualisationResponses = bool(value)

    @property
    def visualisationScaling(self) -> float:
        """Scaling of eigenvectors in visual results"""
        return self.__visualisationScaling

    @visualisationScaling.setter
    def visualisationScaling(self, value: float):
        """Set visualisationScaling"""
        self.__visualisationScaling = float(value)

    @property
    def numberOfEigenvectors(self) -> int:
        """Number of eigenvectors to be printed"""
        return self.__numberOfEigenvectors

    @numberOfEigenvectors.setter
    def numberOfEigenvectors(self, value: int):
        """Set numberOfEigenvectors"""
        self.__numberOfEigenvectors = int(value)
