# This an autogenerated file
# 
# Generated with GrowthLevel
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.growthlevel import GrowthLevelBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue

class GrowthLevel(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    levelZCoordinate : float
         Z coordinate of level given in global coordinate system(default 0.0)
    thickness : float
         Growth thickness at this level(default 0.0)
    density : float
         Growth density at this level(default 0.0)
    """

    def __init__(self , description="", levelZCoordinate=0.0, thickness=0.0, density=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.levelZCoordinate = levelZCoordinate
        self.thickness = thickness
        self.density = density
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return GrowthLevelBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def levelZCoordinate(self) -> float:
        """Z coordinate of level given in global coordinate system"""
        return self.__levelZCoordinate

    @levelZCoordinate.setter
    def levelZCoordinate(self, value: float):
        """Set levelZCoordinate"""
        self.__levelZCoordinate = float(value)

    @property
    def thickness(self) -> float:
        """Growth thickness at this level"""
        return self.__thickness

    @thickness.setter
    def thickness(self, value: float):
        """Set thickness"""
        self.__thickness = float(value)

    @property
    def density(self) -> float:
        """Growth density at this level"""
        return self.__density

    @density.setter
    def density(self, value: float):
        """Set density"""
        self.__density = float(value)
