# This an autogenerated file
# 
# Generated with IrregularResponseAnalysis
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.irregularresponseanalysis import IrregularResponseAnalysisBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue
from .irregularmotionindicator import IrregularMotionIndicator
from .irregularwaveindicator import IrregularWaveIndicator
from .irregularwaveprocedure import IrregularWaveProcedure
from .lfmotiontimeseries import LFMotionTimeSeries
from .lowfrequencymotionindicator import LowFrequencyMotionIndicator
from .supportvesselmotionscalingitem import SupportVesselMotionScalingItem
from .wavetimeseries import WaveTimeSeries
from .wfmotiontimeseries import WFMotionTimeSeries

class IrregularResponseAnalysis(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    waveTimeSeriesFile : bool
         Wave time series read from file(default False)
    simulationLength : float
         Length of simulation(default 11000.0)
    timeStep : float
         Simulation time step(default 0.1)
    irrWaveIndicator : IrregularWaveIndicator
         Irregular wave indicator
    irrMotionIndicator : IrregularMotionIndicator
         Irregular motion indicator
    lowFrequencyMotionIndicator : LowFrequencyMotionIndicator
         Low frequency motion indicator
    simulationStartTime : float
         Time (in generated time series) that dynamic simulation will start from(default 0.0)
    motionScaling : bool
         Switch for scaling of terminal point motions(default False)
    supportVesselMotionScalingItems : List[SupportVesselMotionScalingItem]
    irregularWaveProcedure : IrregularWaveProcedure
    waveTimeSeries : WaveTimeSeries
    wfMotionTimeSeries : List[WFMotionTimeSeries]
    lfMotionTimeSeries : List[LFMotionTimeSeries]
    """

    def __init__(self , description="", waveTimeSeriesFile=False, simulationLength=11000.0, timeStep=0.1, irrWaveIndicator=IrregularWaveIndicator.NEW, irrMotionIndicator=IrregularMotionIndicator.STAT, lowFrequencyMotionIndicator=LowFrequencyMotionIndicator.NONE, simulationStartTime=0.0, motionScaling=False, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.waveTimeSeriesFile = waveTimeSeriesFile
        self.simulationLength = simulationLength
        self.timeStep = timeStep
        self.irrWaveIndicator = irrWaveIndicator
        self.irrMotionIndicator = irrMotionIndicator
        self.lowFrequencyMotionIndicator = lowFrequencyMotionIndicator
        self.simulationStartTime = simulationStartTime
        self.motionScaling = motionScaling
        self.supportVesselMotionScalingItems = list()
        self.irregularWaveProcedure = None
        self.waveTimeSeries = None
        self.wfMotionTimeSeries = list()
        self.lfMotionTimeSeries = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return IrregularResponseAnalysisBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def waveTimeSeriesFile(self) -> bool:
        """Wave time series read from file"""
        return self.__waveTimeSeriesFile

    @waveTimeSeriesFile.setter
    def waveTimeSeriesFile(self, value: bool):
        """Set waveTimeSeriesFile"""
        self.__waveTimeSeriesFile = bool(value)

    @property
    def simulationLength(self) -> float:
        """Length of simulation"""
        return self.__simulationLength

    @simulationLength.setter
    def simulationLength(self, value: float):
        """Set simulationLength"""
        self.__simulationLength = float(value)

    @property
    def timeStep(self) -> float:
        """Simulation time step"""
        return self.__timeStep

    @timeStep.setter
    def timeStep(self, value: float):
        """Set timeStep"""
        self.__timeStep = float(value)

    @property
    def irrWaveIndicator(self) -> IrregularWaveIndicator:
        """Irregular wave indicator"""
        return self.__irrWaveIndicator

    @irrWaveIndicator.setter
    def irrWaveIndicator(self, value: IrregularWaveIndicator):
        """Set irrWaveIndicator"""
        self.__irrWaveIndicator = value

    @property
    def irrMotionIndicator(self) -> IrregularMotionIndicator:
        """Irregular motion indicator"""
        return self.__irrMotionIndicator

    @irrMotionIndicator.setter
    def irrMotionIndicator(self, value: IrregularMotionIndicator):
        """Set irrMotionIndicator"""
        self.__irrMotionIndicator = value

    @property
    def lowFrequencyMotionIndicator(self) -> LowFrequencyMotionIndicator:
        """Low frequency motion indicator"""
        return self.__lowFrequencyMotionIndicator

    @lowFrequencyMotionIndicator.setter
    def lowFrequencyMotionIndicator(self, value: LowFrequencyMotionIndicator):
        """Set lowFrequencyMotionIndicator"""
        self.__lowFrequencyMotionIndicator = value

    @property
    def simulationStartTime(self) -> float:
        """Time (in generated time series) that dynamic simulation will start from"""
        return self.__simulationStartTime

    @simulationStartTime.setter
    def simulationStartTime(self, value: float):
        """Set simulationStartTime"""
        self.__simulationStartTime = float(value)

    @property
    def motionScaling(self) -> bool:
        """Switch for scaling of terminal point motions"""
        return self.__motionScaling

    @motionScaling.setter
    def motionScaling(self, value: bool):
        """Set motionScaling"""
        self.__motionScaling = bool(value)

    @property
    def supportVesselMotionScalingItems(self) -> List[SupportVesselMotionScalingItem]:
        """"""
        return self.__supportVesselMotionScalingItems

    @supportVesselMotionScalingItems.setter
    def supportVesselMotionScalingItems(self, value: List[SupportVesselMotionScalingItem]):
        """Set supportVesselMotionScalingItems"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__supportVesselMotionScalingItems = value

    @property
    def irregularWaveProcedure(self) -> IrregularWaveProcedure:
        """"""
        return self.__irregularWaveProcedure

    @irregularWaveProcedure.setter
    def irregularWaveProcedure(self, value: IrregularWaveProcedure):
        """Set irregularWaveProcedure"""
        self.__irregularWaveProcedure = value

    @property
    def waveTimeSeries(self) -> WaveTimeSeries:
        """"""
        return self.__waveTimeSeries

    @waveTimeSeries.setter
    def waveTimeSeries(self, value: WaveTimeSeries):
        """Set waveTimeSeries"""
        self.__waveTimeSeries = value

    @property
    def wfMotionTimeSeries(self) -> List[WFMotionTimeSeries]:
        """"""
        return self.__wfMotionTimeSeries

    @wfMotionTimeSeries.setter
    def wfMotionTimeSeries(self, value: List[WFMotionTimeSeries]):
        """Set wfMotionTimeSeries"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__wfMotionTimeSeries = value

    @property
    def lfMotionTimeSeries(self) -> List[LFMotionTimeSeries]:
        """"""
        return self.__lfMotionTimeSeries

    @lfMotionTimeSeries.setter
    def lfMotionTimeSeries(self, value: List[LFMotionTimeSeries]):
        """Set lfMotionTimeSeries"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__lfMotionTimeSeries = value
