# This an autogenerated file
# 
# Generated with MassSummary
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.masssummary import MassSummaryBlueprint
from typing import Dict
from ..sima import MOAO
from ..sima import ScriptableValue
from .masssummaryreference import MassSummaryReference
from .masssummarystep import MassSummaryStep
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from ..simo import SIMOBody
    from .arline import ARLine

class MassSummary(MOAO):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    calculateMassSummary : bool
         (default False)
    reference : MassSummaryReference
         load step where this mass is calculated in static analysis
    x : float
         X coordinate(default 0.0)
    y : float
         Y coordinate(default 0.0)
    z : float
         Z coordinate(default 0.0)
    rz : float
         Rotation about z-axis(default 0.0)
    body : SIMOBody
    includeAllLines : bool
         (default True)
    lines : List[ARLine]
    loadStep : MassSummaryStep
         load step where this mass is calculated in static analysis
    """

    def __init__(self , description="", calculateMassSummary=False, reference=MassSummaryReference.BODY, x=0.0, y=0.0, z=0.0, rz=0.0, includeAllLines=True, loadStep=MassSummaryStep.FINAL, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.calculateMassSummary = calculateMassSummary
        self.reference = reference
        self.x = x
        self.y = y
        self.z = z
        self.rz = rz
        self.body = None
        self.includeAllLines = includeAllLines
        self.lines = list()
        self.loadStep = loadStep
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return MassSummaryBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def calculateMassSummary(self) -> bool:
        """"""
        return self.__calculateMassSummary

    @calculateMassSummary.setter
    def calculateMassSummary(self, value: bool):
        """Set calculateMassSummary"""
        self.__calculateMassSummary = bool(value)

    @property
    def reference(self) -> MassSummaryReference:
        """load step where this mass is calculated in static analysis"""
        return self.__reference

    @reference.setter
    def reference(self, value: MassSummaryReference):
        """Set reference"""
        self.__reference = value

    @property
    def x(self) -> float:
        """X coordinate"""
        return self.__x

    @x.setter
    def x(self, value: float):
        """Set x"""
        self.__x = float(value)

    @property
    def y(self) -> float:
        """Y coordinate"""
        return self.__y

    @y.setter
    def y(self, value: float):
        """Set y"""
        self.__y = float(value)

    @property
    def z(self) -> float:
        """Z coordinate"""
        return self.__z

    @z.setter
    def z(self, value: float):
        """Set z"""
        self.__z = float(value)

    @property
    def rz(self) -> float:
        """Rotation about z-axis"""
        return self.__rz

    @rz.setter
    def rz(self, value: float):
        """Set rz"""
        self.__rz = float(value)

    @property
    def body(self) -> SIMOBody:
        """"""
        return self.__body

    @body.setter
    def body(self, value: SIMOBody):
        """Set body"""
        self.__body = value

    @property
    def includeAllLines(self) -> bool:
        """"""
        return self.__includeAllLines

    @includeAllLines.setter
    def includeAllLines(self, value: bool):
        """Set includeAllLines"""
        self.__includeAllLines = bool(value)

    @property
    def lines(self) -> List[ARLine]:
        """"""
        return self.__lines

    @lines.setter
    def lines(self, value: List[ARLine]):
        """Set lines"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__lines = value

    @property
    def loadStep(self) -> MassSummaryStep:
        """load step where this mass is calculated in static analysis"""
        return self.__loadStep

    @loadStep.setter
    def loadStep(self, value: MassSummaryStep):
        """Set loadStep"""
        self.__loadStep = value
