# This an autogenerated file
# 
# Generated with PisaSoilLayerProfile
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.pisasoillayerprofile import PisaSoilLayerProfileBlueprint
from typing import Dict
from ..sima import ScriptableValue
from .pisalineitem import PisaLineItem
from .pisasoillayer import PisaSoilLayer
from .soillayerprofile import SoilLayerProfile
from .toplevelsoilposition import TopLevelSoilPosition

class PisaSoilLayerProfile(SoilLayerProfile):
    """
    Keyword arguments
    -----------------
    description : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default None)
    topLevelSoilPosition : TopLevelSoilPosition
    offsetSeafloorToTopSoil : float
         Offset between seafloor and top of upper soil layer(default 0.0)
    soilLayers : List[PisaSoilLayer]
    embeddedLines : List[PisaLineItem]
    """

    def __init__(self , description="", topLevelSoilPosition=TopLevelSoilPosition.RELATIVE_TO_SEAFLOOR, offsetSeafloorToTopSoil=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.scriptableValues = list()
        self.name = None
        self.topLevelSoilPosition = topLevelSoilPosition
        self.offsetSeafloorToTopSoil = offsetSeafloorToTopSoil
        self.soilLayers = list()
        self.embeddedLines = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return PisaSoilLayerProfileBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def topLevelSoilPosition(self) -> TopLevelSoilPosition:
        """"""
        return self.__topLevelSoilPosition

    @topLevelSoilPosition.setter
    def topLevelSoilPosition(self, value: TopLevelSoilPosition):
        """Set topLevelSoilPosition"""
        self.__topLevelSoilPosition = value

    @property
    def offsetSeafloorToTopSoil(self) -> float:
        """Offset between seafloor and top of upper soil layer"""
        return self.__offsetSeafloorToTopSoil

    @offsetSeafloorToTopSoil.setter
    def offsetSeafloorToTopSoil(self, value: float):
        """Set offsetSeafloorToTopSoil"""
        self.__offsetSeafloorToTopSoil = float(value)

    @property
    def soilLayers(self) -> List[PisaSoilLayer]:
        """"""
        return self.__soilLayers

    @soilLayers.setter
    def soilLayers(self, value: List[PisaSoilLayer]):
        """Set soilLayers"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__soilLayers = value

    @property
    def embeddedLines(self) -> List[PisaLineItem]:
        """"""
        return self.__embeddedLines

    @embeddedLines.setter
    def embeddedLines(self, value: List[PisaLineItem]):
        """Set embeddedLines"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__embeddedLines = value
